VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaNNEECliente"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 116

Private fView As lfQuickView
Private TotalMercancia, TotalImpuesto
Private Selector As String
Private ipCliente As clsClientes

'--------------------------------------------------------------------------------------------------------------------
' Numero Fecha      Estado    Vendedor            Condicion    Operador Val. Mercancia     Impuestos      Valor Total
'--------------------------------------------------------------------------------------------------------------------
'0000000 99-99-9999 XXXXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX XXXXXXXX 999.999.999,99 99.999.999,99 9.999.999.999,99

Private Sub PasarTotal(iTitulo As String)
Dim sOut As String

    sOut = stFullLength(iTitulo, 72)
    sOut = sOut & FormatNumero(TotalMercancia, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(TotalImpuesto, Empresa.MascaraMonetarios, 13) & " "
    sOut = sOut & FormatNumero(TotalMercancia + TotalImpuesto, Empresa.MascaraMonetarios, 16)
    
    fView.Add sOut

End Sub

Private Sub PasarLinea(pNNEE As clsNNEE)
Dim sOut As String

    sOut = Format(pNNEE.Numero, "0000000") & " "
    sOut = sOut & stFullLength(Format(pNNEE.FechaRegistro, "Short Date"), 10) & " "
    sOut = sOut & stFullLength(pNNEE.ImagenEstado, 9) & " "
    sOut = sOut & stFullLength(pNNEE.CodigoVendedor, 20) & " "
    sOut = sOut & stFullLength(pNNEE.Condicion, 12) & " "
    sOut = sOut & stFullLength(pNNEE.Operador, 8) & " "
    sOut = sOut & FormatNumero(pNNEE.PrecioEfectivo, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(pNNEE.Impuesto1 + pNNEE.Impuesto2, Empresa.MascaraMonetarios, 13) & " "
    sOut = sOut & FormatNumero(pNNEE.Impuesto1 + pNNEE.Impuesto2 + pNNEE.PrecioEfectivo, Empresa.MascaraMonetarios, 16)
    
    fView.Add sOut

    TotalMercancia = TotalMercancia + pNNEE.PrecioEfectivo
    TotalImpuesto = TotalImpuesto + pNNEE.Impuesto1 + pNNEE.Impuesto2
    
End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Then
        PasarTotal "VAN"
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Notas de Entrega del Cliente " & ipCliente.Nombre & " (" & ipCliente.Codigo & ")", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add " Numero Fecha      Estado    Vendedor            Condicion    Operador Val. Mercancia     Impuestos      Valor Total"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        PasarTotal "VIENEN"
    End If

End Sub

'--------------------------------------------------------------------------------------------------------------------
' Numero Fecha      Estado    Vendedor            Condicion    Operador Val. Mercancia     Impuestos      Valor Total
'--------------------------------------------------------------------------------------------------------------------
'0000000 99-99-9999 XXXXXXXXX XXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX XXXXXXXX 999.999.999,99 99.999.999,99 9.999.999.999,99


Public Sub Go(pCliente As clsClientes)
Dim pNNEE As clsNNEE, cNNEE As clsNNEE
Dim nSelector As Integer

  Selector = InputBox("Escriba:" & vbCrLf & _
        " 'P' para listar slo las notas pendientes," & vbCrLf & _
        " 'E' para listar las notas despachadas," & vbCrLf & _
        " 'T' para listar todas las entregas," & vbCrLf & _
        " 'F' para listar las notas facturadas," & vbCrLf & _
        " 'A' para listar las notas anuladas," & vbCrLf & _
        "  cualquier otro valor para cancelar la emisin del listado", "Listado de Notas de Entrega", "P")
  
  Selector = left(UCase(Trim(Selector)), 1)
  Select Case Selector
  Case "P"
    nSelector = 0
  Case "F"
    nSelector = 1
  Case "A"
    nSelector = 2
  Case "E"
    nSelector = 3
  Case "T"
    nSelector = -1
  Case Else
    Exit Sub
  End Select
  
  Set ipCliente = pCliente
  Set pNNEE = New clsNNEE
  If pNNEE.IniciarIteradorCliente(pCliente.Codigo, nSelector) Then
  
    Set fView = New lfQuickView
    fView.SetReportWidth AnchoReporte
    fView.SetNotify Me
    Encabezado
    TotalMercancia = 0: TotalImpuesto = 0
    
    Do
      Set cNNEE = pNNEE.ProximaNotaIterador
      If Not (cNNEE Is Nothing) Then
        If fView.Linea > fView.LineasPagina - 6 Then
            Encabezado
        End If
        PasarLinea cNNEE
      End If
    Loop While Not (cNNEE Is Nothing)
    
    PasarTotal "TOTAL"
    
    ShowNonModal fView
    
    Unload fView
    Set fView = Nothing
  End If
  
  Set pNNEE = Nothing
  Set ipCliente = Nothing
  
End Sub


Public Sub ReportClicked(sLinea As String, nPos As String)
Dim pNNEE As clsNNEE

    Set pNNEE = New clsNNEE
    If pNNEE.Load(Val(Trim(left(sLinea, 9)))) Then
        pNNEE.Show
    End If
    Set pNNEE = Nothing

End Sub

