VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaMovsISPC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'Parametros locales:
Private f As lfQuickView, stCodigoActual As String
Private totDebC As Double, _
        totCredC As Double, _
        totDebGen As Double, _
        totCredGen As Double, _
        SaldoInicCR As Double, _
        SaldoInicDB As Double
Private stCodigoInicio As String, _
        stCodigoFinal As String, _
        mlAnhoInicio As Integer, _
        mlAnhoFinal As Integer, _
        nMesInicio As Integer, _
        nMesFinal As Integer, _
        TipoEntidad As String
Private instEntidad As Object

Private instanciador As clsInstanciadorEntidad
Private finic As Date, ffinal As Date
Private TipoLista As Boolean
Const AnchoReporte = 106
Const Formato = "#,###,###,###,##0.00"

Private Sub AddLineaTotal(Titulo As String, ByVal Debitos As Currency, ByVal Creditos As Currency)
Dim stOut As String
    stOut = stFullLength(Titulo, 62) & FormatNumero(Debitos, Formato, 20) & " " & FormatNumero(Creditos, Formato, 20)
    f.Add stOut
End Sub

Private Sub Encabezado()
Dim sOut As String
    
    If f.Pagina > 1 Or f.Linea > 1 Then
        If totDebC <> 0 Or totDebC <> 0 Then AddLineaTotal "VAN", totDebC, totCredC
        f.PageBreak
    End If
    
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add ""
    f.Add stMidAlign("Listado de movimientos por " & instanciador.NombreEntidadISPC(TipoEntidad, True), AnchoReporte)
    sOut = "Seleccin: "
    If stCodigoInicio = "" And stCodigoFinal <> "" Then
        sOut = sOut & "Hasta el cdigo  " & stCodigoFinal
    ElseIf stCodigoInicio <> "" And stCodigoFinal = "" Then
        sOut = sOut & "Desde el cdigo " & stCodigoInicio
    ElseIf stCodigoInicio = "" And stCodigoFinal = "" Then
        sOut = "Todos los " & instanciador.NombreEntidadISPC(TipoEntidad, True)
    Else
        sOut = "Del codigo  " & stCodigoInicio & " al codigo " & stCodigoFinal
    End If
    sOut = sOut & ". "
    sOut = stMidAlign(sOut, AnchoReporte)
    f.Add sOut
    
    sOut = "Entre " & NombreMes(nMesInicio) & " de " & Str(mlAnhoInicio) & " y " & NombreMes(nMesFinal) & " de " & Str(mlAnhoFinal)
    f.Add stMidAlign(sOut, AnchoReporte)

    f.Add stRightAlign("Pagina" & Str(f.Pagina), AnchoReporte)
    f.Add String(AnchoReporte, "-")
    f.Add "Fecha      Descripcion                                                        Debe                Haber"
    f.Add String(AnchoReporte, "-")
    If totDebC <> 0 Or totDebC <> 0 Then AddLineaTotal "VIENEN", totDebC, totCredC

End Sub

Private Sub Ruptura(stCodigo As String, stTipo As String, Optional ByVal Fecha As Date)
Dim sOut As String, SaldoInicial As clsSaldoEntidadPeriodo
Dim sNombreEntidad As String
Dim lvmTotC As Currency, lvmTotD As Currency

    If f.Linea >= f.LineasPagina - 4 Then Encabezado
    
    If stCodigoActual <> "" Then
        f.Add String(68, " ") & String(41, "-")
        sOut = "TOTAL " & instanciador.NombreEntidadISPC(TipoEntidad, False) & " " & stCodigoActual
        AddLineaTotal sOut, totDebC, totCredC
        f.Add String(68, " ") & String(41, "-")
        sOut = "BALANCE " & instanciador.NombreEntidadISPC(TipoEntidad, False) & " " & stCodigoActual
        lvmTotD = totDebC - totCredC
        lvmTotC = 0
        If lvmTotD < 0 Then
            lvmTotC = -lvmTotD
            lvmTotD = 0
        End If
        AddLineaTotal sOut, lvmTotD, lvmTotC

        f.Add ""
    End If
    
    totDebGen = totDebGen + totDebC
    totCredGen = totCredGen + totCredC
    totDebC = 0: totCredC = 0

    stCodigoActual = stCodigo
    If stCodigo = "" Then Exit Sub
    
    If f.Linea >= f.LineasPagina - 4 Then Encabezado
    
    Set instEntidad = instanciador.EntidadPersonaComercial(TipoEntidad, stCodigoActual)
    If instEntidad Is Nothing Then
        sNombreEntidad = "NO LOCALIZADO"
    Else
        sNombreEntidad = instEntidad.Nombre
    End If
    sOut = Format(instanciador.NombreEntidadISPC(TipoEntidad, False), ">") & ":" & sNombreEntidad & " (" & stCodigoActual & ")"
    f.Add sOut
    f.Add String(Len(sOut), "-")
    
    Set SaldoInicial = New clsSaldoEntidadPeriodo
    If SaldoInicial.Load(stCodigo, stTipo, Year(Fecha), Month(Fecha)) Then
        SaldoInicDB = SaldoInicial.SaldoInicial
        If SaldoInicDB < 0 Then
            SaldoInicCR = -SaldoInicDB
            SaldoInicDB = 0
        Else
            SaldoInicCR = 0
        End If

        If (SaldoInicCR > 0 Or SaldoInicDB > 0) Then
            sOut = stFullLength(Format(finic, "Short Date"), 10) & " "
            sOut = sOut & stFullLength("Saldo Inicial del Periodo", 50) & " " & FormatNumero(SaldoInicDB, Formato, 20) & " " & FormatNumero(SaldoInicCR, Formato, 20)
            f.Add sOut
        End If

        totDebC = totDebC + SaldoInicDB: totCredC = totCredC + SaldoInicCR
    End If
    Set SaldoInicial = Nothing

    sOut = ""

End Sub

Private Function Accion(arg As clsDetalleCuentaEntidad) As Integer
Dim stOut As String, sNombreEntidad As String
    If (arg.CodigoEntidad <> stCodigoActual) Then
        If stCodigoActual = "" Then
            Encabezado
        End If
        Ruptura arg.CodigoEntidad, arg.TipoEntidad, arg.Fecha
    End If
    If f.Linea > f.LineasPagina - 2 Then Encabezado
    
    stOut = stFullLength(Format(arg.Fecha, "Short Date"), 10) & " "
    stOut = stOut & stFullLength(arg.Descripcion, 50) & " " & FormatNumero(arg.Debe, Formato, 20) & " " & FormatNumero(arg.Haber, Formato, 20)
    f.Add stOut
    
    totDebC = totDebC + arg.Debe: totCredC = totCredC + arg.Haber
'-------------------------------------------------------------------------------------------------------
'Fecha      Descripcion                                                        Debe                Haber
'-------------------------------------------------------------------------------------------------------
'99/99/9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00
'*VAN                                                          #,###,###,###,##0.00 #,###,###,###,##0.00
'*VIENEN                                                       #,###,###,###,##0.00 #,###,###,###,##0.00
    Accion = 0
End Function

Private Function DefinirParametros(stTipoEntidad As String, stDesde As String, stHasta As String) As Boolean
Dim f As fselParmsListaMovsISPC
    
    Set f = New fselParmsListaMovsISPC
    
    f.SetInstanciador instanciador
    
    f.cbxTipoEntidad.Text = stTipoEntidad
    f.txCodigoInicial.Text = stDesde
    f.txCodigoFinal.Text = stHasta

    If stTipoEntidad <> "" Then
        Disable f.cbxTipoEntidad
        Disable f.txCodigoInicial
        Disable f.txCodigoFinal
    End If

    ShowNonModal f
    
    If Not f.Result Then
        DefinirParametros = False
    Else
        DefinirParametros = True
        stCodigoInicio = f.txCodigoInicial.Text
        stCodigoFinal = f.txCodigoFinal.Text
        mlAnhoInicio = ValOf(f.txAnhoInicio.Text)
        mlAnhoFinal = ValOf(f.txAnhoFinal.Text)
        nMesInicio = NumeroMes(f.cbxMesInicio.Text)
        nMesFinal = NumeroMes(f.cbxMesFinal.Text)
        TipoEntidad = f.cbxTipoEntidad.Text
    End If
    
    Unload f
    Set f = Nothing

End Function

Public Sub Generar(stTipoEntidad As String, stDesde As String, stHasta As String)
Dim rs As Recordset, stQuery As String
Dim r As Integer
Dim inst As clsDetalleCuentaEntidad
Dim lvmTotD As Currency, lvmTotC As Currency, sOut As String

    If Not DefinirParametros(stTipoEntidad, stDesde, stHasta) Then Exit Sub

    finic = BuildFecha(1, nMesInicio, mlAnhoInicio)
    ffinal = BuildFecha(DiasMes(nMesFinal, mlAnhoFinal), nMesFinal, mlAnhoFinal)

    stQuery = "SELECT * FROM DetallesCuentaEntidad WHERE "
    If stCodigoInicio <> "" Then stQuery = stQuery & "CodigoEntidad >= " & StringDB(stCodigoInicio) & " AND "
    If stCodigoFinal <> "" Then stQuery = stQuery & "CodigoEntidad <= " & StringDB(stCodigoFinal) & " AND "
    stQuery = stQuery & " Fecha >= " & lmdbHandle.FechaDB(finic) & " AND "
    stQuery = stQuery & " Fecha <= " & FechaDB(ffinal) & " AND "
    stQuery = stQuery & " TipoEntidad = " & StringDB(TipoEntidad) & " "
    stQuery = stQuery & " ORDER BY CodigoEntidad, Fecha, Correlativo"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(stQuery)
    Screen.MousePointer = vbDefault
    
    If Not rs.EOF Then
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.SetReportWidth AnchoReporte + 1
        f.Caption = "Lista de movimientos por " & instanciador.NombreEntidadISPC(TipoEntidad, False)
        totDebC = 0#: totCredC = 0#: totDebGen = 0#: totCredGen = 0#
        stCodigoActual = "": r = 0
    
        Set inst = New clsDetalleCuentaEntidad
        Do While Not rs.EOF And r = 0
           With inst
           .CodigoEntidad = rs.Fields("CodigoEntidad")
           .Correlativo = rs.Fields("Correlativo")
           .Debe = rs.Fields("Debe")
           .Descripcion = rs.Fields("Descripcion")
           .Documento = rs.Fields("Documento")
           .Fecha = rs.Fields("Fecha")
           .Haber = rs.Fields("Haber")
           .TipoEntidad = rs.Fields("TipoEntidad")
           End With
           r = Accion(inst)
           If Not r Then rs.MoveNext
        Loop
        Set inst = Nothing
        
        Screen.MousePointer = vbDefault
        
        If r = 0 Then
            Ruptura "", ""
            AddLineaTotal "TOTAL GENERAL", totDebGen, totCredGen
            sOut = "BALANCE " & instanciador.NombreEntidadISPC(TipoEntidad, False) & " " & stCodigoActual
            lvmTotD = totDebGen - totCredGen
            lvmTotC = 0
            If lvmTotD < 0 Then
                lvmTotC = -lvmTotD
                lvmTotD = 0
            End If
            AddLineaTotal "BALANCE TOTAL", lvmTotD, lvmTotC
            
            f.Add String(68, " ") & String(41, "=")
            f.Show 0
            While f.Visible: DoEvents: Wend
        End If
        Unload f
        Set f = Nothing
    End If

End Sub

Private Sub Class_Initialize()
    Set instanciador = New clsInstanciadorEntidad
End Sub

Private Sub Class_Terminate()
    Set instanciador = Nothing
End Sub
