VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaMovsCta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Listado de movimientos por cuenta."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Implements clsProcesadorDetalles

Dim bParametrosExternos As Boolean

'Parametros locales:
Private f As lfQuickView, stCodigoActual As String
Private totDebC As Double, _
        totCredC As Double, _
        totDebGen As Double, _
        totCredGen As Double
Private mstCuentaInicio As String, _
        mstCuentaFinal As String, _
        mlPeriodoInicio As Long, _
        mlPeriodoFinal As Long
Private instCuenta As clsCuenta, _
        instComprobante As clsComprobante
Private Saldo As Currency
Private TipoLista As Boolean
Const AnchoReporte = 130
Const Formato = "#,###,###,###,##0.00"

Private Sub AddLineaTotal(Titulo As String, Debitos As Double, Creditos As Double)
Dim stOut As String
    
    stOut = stFullLength(Titulo, 68) & FormatNumero(Debitos, Formato, 20) & " " & FormatNumero(Creditos, Formato, 20) & " " & FormatNumero(Debitos - Creditos, Formato, 20)
    f.Add stOut

End Sub

Private Sub Encabezado()
Dim sOut As String
    
    If totDebGen > 0 Or totCredGen > 0 Then
        If totDebC <> 0 Or totDebC <> 0 Then AddLineaTotal "VAN", totDebC, totCredC
        f.PageBreak
    End If
    
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add ""
    f.Add stMidAlign("Listado de movimientos por Cuenta", AnchoReporte)
    sOut = "Seleccin: "
    If mstCuentaInicio = "" And mstCuentaFinal <> "" Then
        sOut = sOut & "Hasta la cuenta " & mstCuentaFinal
    ElseIf mstCuentaInicio <> "" And mstCuentaFinal = "" Then
        sOut = sOut & "Desde la cuenta " & mstCuentaInicio
    ElseIf mstCuentaInicio = "" And mstCuentaFinal = "" Then
        sOut = "Todas las cuentas"
    Else
        sOut = "De la cuenta " & mstCuentaInicio & " a la cuenta " & mstCuentaFinal
    End If
    sOut = sOut & ". "
    sOut = stMidAlign(sOut & "Periodo: " & Str(mlPeriodoInicio) & " -" & Str(mlPeriodoFinal), AnchoReporte)
    
    f.Add sOut
    f.Add stRightAlign("Pagina" & Str(f.Pagina), AnchoReporte)
    f.Add String(AnchoReporte, "-")
    f.Add "Fecha      Comp. Descripcion                                                        Debe                Haber                Saldo"
    f.Add String(AnchoReporte, "-")
    
    If totDebC <> 0 Or totDebC <> 0 Then AddLineaTotal "VIENEN", totDebC, totCredC

End Sub

Private Sub Ruptura(stNuevaCuenta As String)
Dim sOut As String, pSaldo As clsSaldoCuentaPeriodo, pCuenta As clsCuenta

    If f.Linea >= f.LineasPagina - 3 Then Encabezado
    
    If stCodigoActual <> "" Then
        f.Add String(68, " ") & String(62, "-")
        sOut = "TOTAL CUENTA " & stCodigoActual
        AddLineaTotal sOut, totDebC, totCredC
        f.Add String(68, " ") & String(62, "-")
        totDebGen = totDebGen + totDebC
        totCredGen = totCredGen + totCredC
        totDebC = 0: totCredC = 0
    End If

    If stNuevaCuenta <> "" Then
    
        Set pCuenta = New clsCuenta
        If f.Linea > f.LineasPagina - 5 Then Encabezado
        If Not pCuenta.Load(stNuevaCuenta) Then
            Saldo = 0
            pCuenta.Titulo = "DESAPARECIDA!"
        End If
        sOut = "CUENTA: " & pCuenta.Titulo & " (" & stNuevaCuenta & ")"
        f.Add sOut
        f.Add String(Len(sOut), "-")
        
        sOut = String(17, " ")
        Set pSaldo = New clsSaldoCuentaPeriodo
        pSaldo.Load stNuevaCuenta, mPeriodos.AnhoPeriodo(mlPeriodoInicio), mPeriodos.PeriodoPeriodo(mlPeriodoInicio)
        Saldo = pSaldo.SaldoInicial
        sOut = sOut & stFullLength("Saldo inicial", 50) & String(43, " ") & FormatNumero(Saldo, Formato, 20)
        Set pSaldo = Nothing
        
        f.Add sOut

    End If

    stCodigoActual = stNuevaCuenta

End Sub

Private Sub Class_Initialize()
    
    bParametrosExternos = False

End Sub

Public Function clsProcesadorDetalles_Accion(arg As clsDetalles) As Integer
Dim stOut As String
    
    If (arg.Cuenta <> stCodigoActual) Then
        If stCodigoActual = "" Then
            Encabezado
        End If
        Ruptura arg.Cuenta
    End If
    
    If f.Linea > f.LineasPagina - 2 Then Encabezado
    instComprobante.Load arg.NumeroComprobante
    Saldo = Saldo + arg.Debe - arg.Haber
    stOut = stFullLength(Format(instComprobante.Fecha, "Short Date"), 10) & " " & Format(instComprobante.CorrelativoPeriodo, "00000") & " "
    stOut = stOut & stFullLength(arg.Descripcion, 50) & " " & FormatNumero(arg.Debe, Formato, 20) & " " & FormatNumero(arg.Haber, Formato, 20) & " "
    stOut = stOut & FormatNumero(Saldo, Formato, 20)
    f.Add stOut
    totDebC = totDebC + arg.Debe: totCredC = totCredC + arg.Haber
'-------------------------------------------------------------------------------------------------------------
'Fecha      Comp. Descripcion                                                        Debe                Haber
'-------------------------------------------------------------------------------------------------------------
'99/99/9999 00000 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00
'*VAN                                                                #,###,###,###,##0.00 #,###,###,###,##0.00
'*VIENEN                                                             #,###,###,###,##0.00 #,###,###,###,##0.00
    clsProcesadorDetalles_Accion = 0
End Function

Public Sub SetParametros( _
    sCuentaInicio As String, _
    sCuentaFinal As String, _
    lPeriodoInicio As Long, _
    lPeriodoFin As Long, _
    bTipoLista As Boolean)
    
    bParametrosExternos = True
    mstCuentaInicio = sCuentaInicio
    mstCuentaFinal = sCuentaFinal
    mlPeriodoInicio = lPeriodoInicio
    mlPeriodoFinal = lPeriodoFin
    TipoLista = bTipoLista

End Sub

Private Function DefinirParametros() As Boolean
Dim f As fselParmsListaMovsCta

    If bParametrosExternos Then
        DefinirParametros = True
        Exit Function
    End If

    Set f = New fselParmsListaMovsCta
    f.Show 0
    While f.Visible: DoEvents: Wend
    If f.txAnhoFinal.Text = "" Then
        DefinirParametros = False
    Else
        DefinirParametros = True
        mstCuentaInicio = f.acCodeBoxCuentaInicio.Text
        mstCuentaFinal = f.acCodeBoxCuentaFin.Text
        mlPeriodoInicio = f.RefInicio
        mlPeriodoFinal = f.RefFinal
        TipoLista = f.TipoLista
    End If
    Unload f
    Set f = Nothing
End Function

Public Sub Generar()
Attribute Generar.VB_Description = "Comando que activa la generacin del reporte. Todo el proceso se realiza dentro de la clase."
    
    If Not DefinirParametros Then Exit Sub
    
    If Not TipoLista Then   ' El requerimiento de "Listado de diario" fue una adicin.
                            ' Se implementa en el mdulo mListaDiario.bas
        GenerarListaDiario mstCuentaInicio, mstCuentaFinal, mlPeriodoInicio, mlPeriodoFinal
        Exit Sub
    
    End If
    
    Set f = New lfQuickView
    f.SetNotify Me
    f.SetReportWidth AnchoReporte + 1
    f.Caption = "Lista de movimientos por cuenta"
    totDebC = 0#: totCredC = 0#: totDebGen = 0#: totCredGen = 0#
    stCodigoActual = ""
    Set instComprobante = New clsComprobante
    Set instCuenta = New clsCuenta
    
    Screen.MousePointer = vbHourglass

    If AlmacenDetalles.IteradorMovimientosCuenta(mstCuentaInicio, mstCuentaFinal, mlPeriodoInicio, mlPeriodoFinal, Me) = 0 Then
        Ruptura ""
        AddLineaTotal "TOTAL GENERAL", totDebGen, totCredGen
        f.Add String(68, " ") & String(62, "=")
        Screen.MousePointer = vbDefault
        f.Show 0
        While f.Visible: DoEvents: Wend
    End If
    Screen.MousePointer = vbDefault
    Set instCuenta = Nothing
    Set instComprobante = Nothing
    Unload f
    Set f = Nothing
End Sub

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim sLocal As String, sFecha As String, dFecha As Date, lCorrelativo As Long, lPeriodo As Long
Dim pCuenta As clsCuenta, pComprobante As clsComprobante
Dim p As Long

    sLocal = Trim(sLinea)
    
    p = InStr(1, sLocal, "CUENTA:", vbTextCompare)
    If p > 0 And p < 3 Then
        sLocal = sExtractRightCode(sLocal)
        Set pCuenta = New clsCuenta
        If pCuenta.Load(sLocal) Then pCuenta.Show
        Set pCuenta = Nothing
        Exit Sub
    End If

    sFecha = Trim(Left(sLocal, 11))
    
    On Error GoTo Salete
    dFecha = CDate(sFecha)
    
    lPeriodo = Empresa.AnhoMes2Periodo(Year(dFecha), Month(dFecha))
    lCorrelativo = Val(Trim(Mid(sLocal, 11, 6)))
    
    Set pComprobante = New clsComprobante
    If pComprobante.LoadByRefPeriodo(lPeriodo, lCorrelativo) Then
        pComprobante.ViewPrint
    End If
    Set pComprobante = Nothing

    Exit Sub
'99/99/9999 00000 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #,###,###,###,##0.00 #,###,###,###,##0.00

Salete:

    Err.Clear

End Sub
