VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaMovsCaja"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Empresa (Center)
'Listado de Movimientos de Caja
'Entre el %s y el %s
'   
'Sesin Nro. 999999
'
' Emisin
'-----------------------------------------------------------------------------------------------------------
'Fecha      Numero   Operador Descripcion                                              DB                 CR
'-----------------------------------------------------------------------------------------------------------
'99-99-9999 00000000 XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999.999,99 999.999.999.999,99

Private Const AnchoReporte = 107
Private sTag As String
Private nOrden As Integer       ' 0: Operador, 1: Fecha, 2: Numero | ListaSesion -> Numero
Private sOperador As String     ' Se puede pedir para un operador (Orden <> Operador), o para TODOS
Private dtInicio As Date, dtFin As Date
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private totDeb As Currency
Private totCred As Currency
Private subTotDeb As Currency
Private subTotCred As Currency
Private bIsSesion As Boolean
Private SessionID As Long

' -------------------------------------
Private Sub Encabezado()
Dim sOut As String

  If fView.Linea > 1 Then
    WriteLineaDetalle "", "", sTag, "VAN", subTotDeb, subTotCred
    fView.PageBreak
  End If

  fView.Add ""
  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Listado de movimientos de caja"
  If bIsSesion Then
    sOut = "Sesion: " & Format(SessionID, "00000")
  Else
    sOut = "Entre el " & Format(dtInicio, "Short Date") & " y el " & Format(dtFin, "Short Date")
  End If
  fView.Add sOut, vbCenter
  fView.Add ""
  fView.Add LineJustify(AnchoReporte, "Emision: " & Format(Now, "General Date"), "Operador: " & UsuarioActivo.Codigo, "Pagina: " & Format(fView.Pagina, "000"))
  fView.Add String(AnchoReporte, "-")
  fView.Add "Fecha      Numero   Operador Descripcion                                              DB                 CR"
  fView.Add String(AnchoReporte, "-")
  
  If fView.Pagina > 1 Then
    WriteLineaDetalle "", "", sTag, "VIENEN", subTotDeb, subTotCred
  End If

End Sub

' -------------------------------------
Private Sub WriteLineaDetalle(sImgFecha As String, sImgNumero As String, sOperador As String, sDescripcion As String, ivmDebitos As Currency, ivmCreditos As Currency)
Dim sOut As String

  sOut = stFullLength(sImgFecha, 11)
  sOut = sOut & stFullLength(sImgNumero, 9)
  sOut = sOut & stFullLength(sOperador, 9)
  sOut = sOut & stFullLength(sDescripcion, 41)
  sOut = sOut & FormatNumero(ivmDebitos, Empresa.MascaraMonetarios, 18) & " "
  sOut = sOut & FormatNumero(ivmCreditos, Empresa.MascaraMonetarios, 18) & " "
  fView.Add sOut
    
End Sub

' -------------------------------------
Private Sub PasarLineaDatos(dtFecha As Date, lngNumero As Long, isOperador As String, sDescripcion As String, ivmDebitos As Currency, ivmCreditos As Currency)

  If nOrden = 0 Then
    If isOperador <> sTag Then
      Ruptura isOperador
    End If
  End If

  If fView.Linea > (fView.LineasPagina - 4) Then
    Encabezado
  End If

  WriteLineaDetalle Format(dtFecha, "Short Date"), Format(lngNumero, "00000000"), isOperador, sDescripcion, ivmDebitos, ivmCreditos
  totDeb = totDeb + ivmDebitos
  totCred = totCred + ivmCreditos
  subTotDeb = subTotDeb + ivmDebitos
  subTotCred = subTotCred + ivmCreditos
  
End Sub

' ----------------------------------------
Private Sub Ruptura(sNewTag As String)

  If nOrden <> 0 Then Exit Sub
  If sOperador <> "" Then Exit Sub

  If sTag <> "" Then
    WriteLineaDetalle "", "", sTag, "TOTAL OPERADOR " & sTag, subTotDeb, subTotCred
    If fView.Linea > fView.LineasPagina - 2 Then
      Encabezado
    End If
  End If
  subTotDeb = 0: subTotCred = 0
  sTag = sNewTag

End Sub

' ----------------------------------------
Public Sub Generar(Optional ByVal NumeroSesion As Long = 0)
Dim fParametros As frmParmsListaMC
Dim sQuery As String, rs As Recordset

  If NumeroSesion = 0 Then
    Set fParametros = New frmParmsListaMC
    ShowNonModal fParametros
    With fParametros
    If .bResult Then
      sOperador = .txCodigoOperador.Text
      dtInicio = .dtFechaInicial.Fecha
      dtFin = .dtFechaFinal.Fecha
      nOrden = .Orden
    Else
      NumeroSesion = -1
    End If
    End With
    Unload fParametros
    Set fParametros = Nothing
    If NumeroSesion < 0 Then
      Exit Sub
    End If
  Else
    bIsSesion = True
    SessionID = NumeroSesion
    nOrden = 2
  End If

  sQuery = "SELECT * FROM MovimientosCaja "
  If bIsSesion Then
    sQuery = sQuery & "WHERE Sesion = " & NumeroDB(SessionID) & " ORDER BY TransID"
  Else
    sQuery = sQuery & "WHERE Fecha BETWEEN " & FechaDB(dtInicio) & " AND " & FechaDB(dtFin)
    If sOperador <> "" Then
      sQuery = sQuery & " AND Operador = " & StringDB(sOperador)
    End If
    sQuery = sQuery & " ORDER BY "
    Select Case nOrden
    Case 0
      sQuery = sQuery & " Operador, TransID"
    Case 1
      sQuery = sQuery & " Fecha, TransID"
    Case 2
      sQuery = sQuery & " TransId"
    End Select
  End If

  Set rs = dbHandle.Execute(sQuery)
  
  If Not rs.EOF Then
    Set fView = New lfQuickView
    fView.SetReportWidth AnchoReporte
    sTag = ""
    Encabezado
    Do While Not rs.EOF
      PasarLineaDatos _
        GetDateFromVariant(rs.Fields("Fecha")), _
        GetNumeroFromVariant(rs.Fields("TransID")), _
        GetStringFromVariant(rs.Fields("Operador")), _
        GetStringFromVariant(rs.Fields("Descripcion")), _
        GetNumeroFromVariant(rs.Fields("Debitos")), _
        GetNumeroFromVariant(rs.Fields("Creditos"))
      rs.MoveNext
    Loop
    Ruptura ""
    WriteLineaDetalle "", "", sTag, "TOTAL", totDeb, totCred
    totDeb = totDeb - totCred: totCred = 0
    If totDeb < 0 Then
      totCred = -totDeb
      totDeb = 0
    End If
    WriteLineaDetalle "", "", sTag, "BALANCE", totDeb, totCred
    
    ShowNonModal fView
    Unload fView
    Set fView = Nothing
  End If
  
  rs.Close
  Set rs = Nothing

End Sub

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pMovCaja As CMovimientoCaja, nNumero As Long, sNumero As String

  sNumero = Mid(Trim(strReportLine), 12, 8)
  nNumero = Val(sNumero)
  Set pMovCaja = New CMovimientoCaja
  If pMovCaja.Load(nNumero) Then
    pMovCaja.Show
  End If
  Set pMovCaja = Nothing
  bProcessed = True
End Sub
