VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaMovItemInv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Implements clsIteradorMINVS

Private WithEvents destForm As lfQuickView
Attribute destForm.VB_VarHelpID = -1
Private fInicial As Date, fFinal As Date
Private Item As clsItemInventario

Private instanciador As clsInstanciadorEntidad
Private docAlmacen As clsComprobanteAlmacen

Private dblIn As Double, dblOut As Double

'--------------------------------------------------------------------------------------------------------
'FECHA      TIPO REFERENCIA           ALMACEN  DESCRIPCION                             ENTRADAS   SALIDAS
'--------------------------------------------------------------------------------------------------------
'99-99-9999 XXX  XXX-0000000000000000 XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999 9.999.999

Private Sub destForm_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pDoc As Object ' As DocumentoISPC (si la interfaz estuviera definida)
Dim sExtract As String, tDoc As String, sRefDoc As String
Dim pInstancer As clsInstanciadorEntidad

  bProcessed = True
  sExtract = Trim(Mid(Trim(strReportLine), 12, 25))
  tDoc = Trim(left(sExtract, 4))
  sRefDoc = right(sExtract, Len(sExtract) - 5)
  Set pInstancer = New clsInstanciadorEntidad
  Set pDoc = pInstancer.EntidadDOCUMENTOByRef(tDoc, sRefDoc)
  If Not pDoc Is Nothing Then
    pDoc.Show
    Set pDoc = Nothing
  End If
  Set pInstancer = Nothing

End Sub

Private Sub PrintLinea(stFecha As String, stTipoMov As String, stReferencia As String, stAlmacen As String, stDescripcion As String, dblDB As Double, dblCR As Double)
    destForm.Add stFullLength(stFecha, 10) & " " & stFullLength(stTipoMov, 3) & "  " & stFullLength(stReferencia, 20) & " " & stFullLength(stAlmacen, 8) & " " & stFullLength(stDescripcion, 38) & " " & FormatNumero(dblDB, Empresa.MascaraInventario, 12) & " " & FormatNumero(dblCR, Empresa.MascaraInventario, 12)
End Sub
'XXX  XXX-0000000000000000 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999,99 9.999.999,99

Private Sub Encabezado()
    
    If destForm.Linea > 1 Then
        PrintLinea "", "", "", "", "VAN...", dblIn, dblOut
        destForm.PageBreak
    End If
    destForm.Add ""
    destForm.Add Empresa.NombreEmpresa
    destForm.Add "LISTA DE MOVIMIENTOS DE ARTICULO DE INVENTARIO"
    destForm.Add "ARTICULO: " & Item.Descripcion & " (" & Item.Codigo & ")"
    destForm.Add "Entre el " & Format(fInicial, "Short Date") & " y el " & Format(fFinal, "Short Date")
    destForm.Add "Impresin: " & Format(Now, "General Date") & " OPERADOR: " & cUsuario.Codigo & "   Pgina:" & Str(destForm.Pagina)
    
    destForm.Add "--------------------------------------------------------------------------------------------------------------"
    destForm.Add "FECHA      TIPO REFERENCIA           ALMACEN  DESCRIPCION                                ENTRADAS      SALIDAS"
    destForm.Add "--------------------------------------------------------------------------------------------------------------"
    
    If destForm.Pagina > 1 Then
        PrintLinea "", "", "", "", "...VIENEN", dblIn, dblOut
    End If

End Sub


Public Function clsIteradorMINVS_Procesar(pInst As clsMINV) As Integer
Dim dblDB As Double, dblCR As Double, instDoc As Object, stRef As String, stDescripcion As String, stAlmacen As String

    If destForm.Linea + 2 > destForm.LineasPagina Then
        Encabezado
    End If
    
    If pInst.Cantidad < 0 Then
        dblCR = Abs(pInst.Cantidad)
        dblDB = 0
    Else
        dblCR = 0
        dblDB = pInst.Cantidad
    End If
    
' Esta secuencia de cdigo es candidata a convertirse
' en funcin o propiedad dentro de clsMINV...
' (Aunque hacerlo correctamente lo pondra el DOOOBLE de
' lento, que ya de por s lo es bastante)
    If Not docAlmacen.Load(pInst.NumeroDocumento) Then
        stRef = pInst.TipoMovimiento & Format(pInst.NumeroDocumento, "000000")
        stDescripcion = "ERR: DOC_NOT_FOUND"
        stAlmacen = "UNDEF!"
    Else
        stAlmacen = docAlmacen.Almacen
        Set instDoc = instanciador.EntidadDOCUMENTO(docAlmacen.TipoEntidadOrigen, docAlmacen.NumeroDocumentoOrigen)
        If instDoc Is Nothing Then
            stRef = pInst.TipoMovimiento & Format(pInst.NumeroDocumento, "000000")
            stDescripcion = "ERR: DOC_NOT_FOUND"
        Else
            stRef = instDoc.Referencia
            stDescripcion = instDoc.Descripcion
        End If
        Set instDoc = Nothing
    End If
' ... hasta aqu

    PrintLinea Format(pInst.FechaOperacion, "Short Date"), pInst.TipoMovimiento, stRef, stAlmacen, stDescripcion, dblDB, dblCR
    
    dblIn = dblIn + dblDB: dblOut = dblOut + dblCR
    
    clsIteradorMINVS_Procesar = 0
End Function

Public Sub ListarMinvs(pItem As clsItemInventario, finic As Date, fFin As Date)
Dim Saldo As clsSaldoEntidadPeriodo, refPeriodo As Long, dblSaldoInicial As Double

    Set destForm = New lfQuickView
    destForm.Caption = pItem.Descripcion & ": Lista detallada de movimientos."
    destForm.SetReportWidth 106
    fInicial = finic: fFinal = fFin
    refPeriodo = mPeriodos.refPeriodo(Year(fInicial), Month(fInicial))
    
    Set Item = pItem
    Set instanciador = New clsInstanciadorEntidad
    Set docAlmacen = New clsComprobanteAlmacen
    
    dblSaldoInicial = pItem.ExistenciaInicial(finic)
    Set Saldo = Nothing

    Encabezado

    PrintLinea "", "", "", "", "SALDO INICIAL DEL MES", dblSaldoInicial, 0
    dblIn = 0: dblOut = 0

    Screen.MousePointer = vbHourglass
    AlmacenMINVS.ProcesarDetalles Me, "CodigoItem = " & StringDB(Item.Codigo) & " AND FechaOperacion >= " & FechaDB(fInicial) & " AND FechaOperacion <= " & FechaDB(fFinal), "FechaOperacion, NumeroDocumento, Renglon"
    Screen.MousePointer = vbDefault

    PrintLinea "", "", "", "", "Totales del periodo", dblIn, dblOut
    PrintLinea "", "", "", "", "Saldo final", dblSaldoInicial + dblIn - dblOut, 0

'--------------------------------------------------------------------------------------------------------
'FECHA      TIPO REFERENCIA           ALMACEN  DESCRIPCION                             ENTRADAS   SALIDAS
'--------------------------------------------------------------------------------------------------------
'99-99-9999 XXX  XXX-0000000000000000 XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999 9.999.999
    Set docAlmacen = Nothing
    Set instanciador = Nothing
    Set Item = Nothing

    ShowNonModal destForm
    Unload destForm
    Set destForm = Nothing

End Sub

