VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaMovInv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 135

Dim WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Dim TotVentas As Currency, TotCompras As Currency, TotAjustes As Currency, TotInicial As Currency
Dim sTotVentas As Currency, sTotCompras As Currency, sTotAjustes As Currency, sTotInicial As Currency
Dim fInicial As Date, fFinal As Date
Dim Orden As Integer, Presentacion As Boolean, cLinea As String

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim pItemInv As clsItemInventario, sExtract As String
Dim f2 As lfSelectRangoFechas, fView As lfQuickView
  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 20))
  Set pItemInv = AlmacenItemsInventario.itemInventario(sExtract)
  If Not pItemInv Is Nothing Then
    Dim lMinvs As clsListaMovItemInv
    Set f2 = New lfSelectRangoFechas
    f2.dtFechaFinal.Fecha = fFinal
    f2.dtFechaInicial.Fecha = fInicial
    f2.Show 1
    If f2.Result Then
      Set lMinvs = New clsListaMovItemInv
      lMinvs.ListarMinvs pItemInv, f2.dtFechaInicial.Fecha, f2.dtFechaFinal.Fecha
      Set lMinvs = Nothing
    End If
    Unload f2
    Set f2 = Nothing
  End If
  Set pItemInv = Nothing

End Sub

'                                       Nombre de la Empresa
'                                 Resumen de Movimientos por Producto
'
'
'----------------------------------------------------------------------------------------------------------------------------------------
'Codigo Articulo      Descripcion                                 EX. INICIAL        COMPRAS         VENTAS        AJUSTES          SALDO
'----------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        If Orden = 3 And Presentacion Then
            PrintLinea "VAN", "SUB TOTAL DE LA LINEA", "", sTotInicial, sTotCompras, sTotVentas, sTotAjustes
        End If
        
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Resumen de movimientos por producto", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(fInicial, "Short Date") & " y el " & Format(fFinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emisin: " & Format(Now, "General Date") & " Operador: " & cUsuario.Codigo & "   Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo Articulo      Descripcion                                 EX. INICIAL        COMPRAS         VENTAS        AJUSTES          SALDO"
    fView.Add String(AnchoReporte, "-")

End Sub


Private Sub Ruptura(sNuevaLinea As String)

    If Not Presentacion Then Exit Sub   ' Slo se totalizan bolvares
    If Orden <> 3 Then Exit Sub         ' Solo se totaliza por lneas

    If fView.Linea > fView.LineasPagina - 3 Then Encabezado

    If sTotVentas <> 0 Or sTotCompras <> 0 Or sTotAjustes <> 0 Then
        PrintLinea "SUB-TOTAL", "TOTAL DE LA LINEA", cLinea, sTotInicial, sTotCompras, sTotVentas, sTotAjustes
    End If

    If sNuevaLinea <> "" Then
        If fView.Linea > fView.LineasPagina - 6 Then
            Encabezado
        Else
            fView.Add ""
        End If
    
        fView.Add "LINEA: " & mMain.Lineas.Nombre(sNuevaLinea) & " (" & sNuevaLinea & ")"
    End If

    sTotVentas = 0: sTotCompras = 0: sTotAjustes = 0: sTotInicial = 0
    cLinea = sNuevaLinea

End Sub


Private Sub PrintLinea(sItem As String, _
                     sDescItem As String, _
                     sLinea As String, _
                     vInicial As Currency, _
                     vCompras As Currency, _
                     vVentas As Currency, _
                     vAjustes As Currency)
Dim sOut As String, sFormato As String

    sOut = stFullLength(sItem, 21) & stFullLength(sDescItem, 41)
    If Presentacion Then sFormato = Empresa.MascaraMonetarios Else sFormato = Empresa.MascaraCantidades
    sOut = sOut & FormatNumero(vInicial, sFormato, 14) & " "
    sOut = sOut & FormatNumero(vCompras, sFormato, 14) & " "
    sOut = sOut & FormatNumero(vVentas, sFormato, 14) & " "
    sOut = sOut & FormatNumero(vAjustes, sFormato, 14) & " "
    sOut = sOut & FormatNumero(vInicial + vCompras + vVentas + vAjustes, sFormato, 14)

    fView.Add sOut
    
End Sub

Private Sub PasarLinea(sItem As String, _
                     sDescItem As String, _
                     sLinea As String, _
                     vInicial As Currency, _
                     vCompras As Currency, _
                     vVentas As Currency, _
                     vAjustes As Currency)
                     
    If sItem = "" Then Exit Sub

    If Orden = 3 Then
        If sLinea <> cLinea Then
            Ruptura sLinea
        End If
    End If
           
    If fView.Linea > fView.LineasPagina - 3 Then Encabezado
    PrintLinea sItem, sDescItem, sLinea, vInicial, vCompras, vVentas, vAjustes
    
    TotVentas = TotVentas + vVentas: TotCompras = TotCompras + vCompras: TotAjustes = TotAjustes + vAjustes: TotInicial = TotInicial + vInicial
    sTotVentas = sTotVentas + vVentas: sTotCompras = sTotCompras + vCompras: sTotAjustes = sTotAjustes + vAjustes: sTotInicial = sTotInicial + vInicial
    
End Sub

Public Sub Generar()
Dim sQuery As String, rs As Recordset
Dim f As frmFiltroMINVS, cDescripcion As String
Dim vCompras As Currency, vVentas As Currency, vAjustes As Currency
Dim pItem As clsItemInventario, lvmExInic As Currency

    Set f = New frmFiltroMINVS
    
    f.Show
    While f.Visible: DoEvents: Wend
    
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    Orden = f.Ordenamiento
    Presentacion = f.optUseValor.Value
    fInicial = f.ucSelectRango1.FechaInicial
    fFinal = f.ucSelectRango1.FechaFinal

    sQuery = "SELECT  D.CodigoItem, A.Descripcion, A.Linea, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'DVV'", "Entradas - Salidas", 0) & ") As DVV, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'DVC'", "Entradas - Salidas", 0) & ") As DVC, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'RCM'", "Entradas - Salidas", 0) & ") As RCM, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'FCT'", "Entradas - Salidas", 0) & ") As FCT, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'AJU'", "Entradas - Salidas", 0) & ") As AJU, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'SSN'", "Entradas - Salidas", 0) & ") As SSN, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'ZTR'", "Entradas - Salidas", 0) & ") As ZTR, "
    sQuery = sQuery & "SUM(" & dbexprBinSelect("TipoMovimiento", "'NDE'", "Entradas - Salidas", 0) & ") As NDE "
    sQuery = sQuery & "FROM DetallesMinv AS D, ItemsInventario AS A "
    sQuery = sQuery & "WHERE D.CodigoItem = a.Codigo "
    cDescripcion = Trim(f.FiltroSQL("A", "D"))
    If cDescripcion <> "" Then
        sQuery = sQuery & " AND " & cDescripcion
    End If
    sQuery = sQuery & " GROUP BY CodigoItem, Descripcion, Linea "

    Select Case Orden
    Case 1
        sQuery = sQuery & " ORDER BY CodigoItem"
    Case 2
        sQuery = sQuery & " ORDER BY Descripcion"
    Case 3
        sQuery = sQuery & " ORDER BY Linea"
    End Select

    Unload f
    Set f = Nothing

    Screen.MousePointer = vbHourglass
    
    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        fView.Caption = "Resumen de movimientos por producto"
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me

        cLinea = "***"
        
        Encabezado

        Do While Not rs.EOF
        
            DoEvents
            Set pItem = AlmacenItemsInventario.itemInventario(stGetStringFromVariant(rs!CodigoItem))
            lvmExInic = pItem.ExistenciaInicial(fInicial)
            If Presentacion Then lvmExInic = lvmExInic * pItem.CostoUnitario
            PasarLinea stGetStringFromVariant(rs!CodigoItem), stGetStringFromVariant(rs!Descripcion), stGetStringFromVariant(rs!Linea), lvmExInic, GetNumeroFromVariant(rs!rcm) + GetNumeroFromVariant(rs!DVC), GetNumeroFromVariant(rs!FCT) + GetNumeroFromVariant(rs!DVV) + GetNumeroFromVariant(rs!SSN) + GetNumeroFromVariant(rs!ZTR) + GetNumeroFromVariant(rs!NDE), GetNumeroFromVariant(rs!AJU)
            rs.MoveNext

        Loop
        
        Ruptura ""
        
        If Presentacion Then
            fView.Add ""
            PrintLinea "TOTAL", "TOTAL GENERAL", "", TotInicial, TotCompras, TotVentas, TotAjustes
        End If
        
        Screen.MousePointer = vbDefault
        
        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing

    End If

    Screen.MousePointer = vbDefault
    rs.Close
    Set rs = Nothing

End Sub

Public Sub ReportClicked(sLinea As String, nPos As Long)
Dim Codigo As String, pItem As clsItemInventario, pLista As clsListaDetArticulo

    Codigo = Trim(left(sLinea, 21))
    
    Set pItem = New clsItemInventario
    
    If pItem.Load(Codigo) Then
        If nPos <= 63 Then
            pItem.Show
        Else
            Set pLista = New clsListaDetArticulo
            pLista.Generar Codigo, fInicial, fFinal
            Set pLista = Nothing
        End If
    End If
    
    Set pItem = Nothing

End Sub

