VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaGeneralFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 113
Private srceFacturas As clsFiltroFacturas

Private doSortByVendedor As Boolean, doSortByCliente As Boolean
Private ControlTag As String
Private totVenta As Currency, TotIVA As Currency, totSaldo As Currency
Private TotVCli As Currency, TotIVACli As Currency, TotSaldoCli As Currency

'                                   Nombre de la Empresa
'                           Listado General de Facturas
'                        Entre el 99-99-9999 y el 99-99-9999
'Fecha de Emisin: 99.99.9999 a las hh:mm p.m.   OPERADOR: XXXXXXXX     Pgina: 1
'-----------------------------------------------------------------------------------------------------------------
'NUMERO      FECHA      CODIGO DEL CLIENTE   COD.VEND.          PRECIO     IMPUESTOS          TOTAL          SALDO
'-----------------------------------------------------------------------------------------------------------------
'DIR-0000000 99-99-9999 XXXXXXXXXXXXXXXXXXXX XXXXXXXXXX 999.999.999,99 99.999.999,99 999.999.999,99 999.999.999,99

Private Sub ImprimirLinea(f As lfQuickView, _
                            sNumero As String, _
                            sFecha As String, _
                            sCodCli As String, _
                            sCodVend As String, _
                            vmPrecio As Currency, _
                            vmImpuestos As Currency, _
                            vmSaldo As Currency)
Dim sOut As String

    sOut = stFullLength(sNumero, 11) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sCodCli, 20) & " "
    sOut = sOut & stFullLength(sCodVend, 10) & " "
    sOut = sOut & FormatNumero(vmPrecio, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmImpuestos, "##,###,##0.00", 13) & " "
    sOut = sOut & FormatNumero(vmPrecio + vmImpuestos, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmSaldo, "###,###,##0.00", 14)
    f.Add sOut

End Sub

Private Sub Ruptura(f As lfQuickView, sNewTag As String)

    If ControlTag = "" Then
        ControlTag = sNewTag
        Exit Sub
    End If

    ImprimirLinea f, "SUB-TOTAL", "", ControlTag, "", TotVCli, TotIVACli, TotSaldoCli
    
    If f.Linea + 3 >= f.LineasPagina Then
        Encabezado f
    Else
        f.Add ""
    End If

    TotVCli = 0: TotIVACli = 0: TotSaldoCli = 0
    ControlTag = sNewTag

End Sub

Private Sub Encabezado(f As lfQuickView)

    If totVenta > 0 Or TotVCli > 0 Then

        If TotVCli > 0 Then
            ImprimirLinea f, "VAN", "", "", "", TotVCli, TotIVACli, TotSaldoCli
        End If
        f.PageBreak

    End If

    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add stMidAlign("Listado de Facturas", AnchoReporte)
    f.Add stMidAlign("Entre el " + Format(srceFacturas.FechaInicial, "Short Date") + " y el " + Format(srceFacturas.FechaFinal, "Short Date"), AnchoReporte)
    f.Add ""
    f.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(f.Pagina)

    f.Add "-----------------------------------------------------------------------------------------------------------------"
    f.Add "NUMERO      FECHA      CODIGO DEL CLIENTE   COD.VEND.          PRECIO     IMPUESTOS          TOTAL          SALDO"
    f.Add "-----------------------------------------------------------------------------------------------------------------"

    If TotVCli > 0 Then
        ImprimirLinea f, "VIENEN", "", "", "", TotVCli, TotIVACli, TotSaldoCli
    End If

End Sub

Private Sub PasarLinea(f As lfQuickView, pFactura As clsFacturas)

    If doSortByCliente Then
        If pFactura.CodigoCliente <> ControlTag Then
            Ruptura f, pFactura.CodigoCliente
        End If
    ElseIf doSortByVendedor Then
        If pFactura.CodigoVendedor <> ControlTag Then
            Ruptura f, pFactura.CodigoVendedor
        End If
    End If
    
    If f.Linea + 2 > f.LineasPagina Then
        Encabezado f
    End If

    ImprimirLinea f, pFactura.Referencia, Format(pFactura.FechaTransaccion, "Short Date"), pFactura.CodigoCliente, pFactura.CodigoVendedor, pFactura.PrecioEfectivo, pFactura.Impuesto1 + pFactura.Impuesto2, pFactura.Saldo

    ' Acumula subtotal por segmento y total general.... es ms fcil, dado que la ruptura es condicional.
    TotVCli = TotVCli + pFactura.PrecioEfectivo
    TotIVACli = TotIVACli + pFactura.Impuesto1 + pFactura.Impuesto2
    TotSaldoCli = TotSaldoCli + pFactura.Saldo

    totVenta = totVenta + pFactura.PrecioEfectivo
    TotIVA = TotIVA + pFactura.Impuesto1 + pFactura.Impuesto2
    totSaldo = totSaldo + pFactura.Saldo

End Sub

Public Sub Generar()
Dim sSortParam As String
Dim pFactura As clsFacturas, f As lfQuickView

    Set srceFacturas = New clsFiltroFacturas
    
    doSortByVendedor = srceFacturas.sortByVendedor
    doSortByCliente = srceFacturas.sortByCliente
    
    Set pFactura = srceFacturas.ProximaFactura
    
    If Not pFactura Is Nothing Then
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.SetNotify Me
        f.SetReportWidth AnchoReporte
        f.Caption = "Listado General de Facturas, entre el " & Format(srceFacturas.FechaInicial, "Short Date") & " y el " & Format(srceFacturas.FechaFinal, "Short Date")
        
        ControlTag = ""
        totVenta = 0: TotIVA = 0: totSaldo = 0
        TotVCli = 0: TotIVACli = 0: TotSaldoCli = 0

        Encabezado f

        Do
            PasarLinea f, pFactura
            Set pFactura = srceFacturas.ProximaFactura
        Loop While Not pFactura Is Nothing

        If doSortByVendedor Or doSortByCliente Then
            Ruptura f, ""
        End If
        
        ImprimirLinea f, "TOTAL", "GENERAL", "", "", totVenta, TotIVA, totSaldo
        
        Screen.MousePointer = vbDefault
        f.Show

        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing

    End If

End Sub

Public Sub ReportClicked(sText As String, nPos As Long)
Dim f As frmConsultarFactura, sRefFact As String

    Select Case nPos
    
    Case 1 To 12
        sRefFact = left(sText, 12)
        sRefFact = Trim(sRefFact)
        ConsultarFactura sRefFact
    
    Case 25 To 45
        sRefFact = Mid(sText, 25, 20)
        sRefFact = Trim(sRefFact)
        ShowFIECliente sRefFact

    Case 46 To 55
        sRefFact = Mid(sText, 46, 10)
        sRefFact = Trim(sRefFact)
        ShowFIEVendedor sRefFact

    Case 101 To 115
        Dim pFactura As clsFacturas
        sRefFact = left(sText, 12)
        sRefFact = Trim(sRefFact)
        Set pFactura = New clsFacturas
        If pFactura.LoadByRefSerie(sRefFact) Then
          Dim pHistoria As CHistoriaPagosFactura
          Set pHistoria = New CHistoriaPagosFactura
          pHistoria.MostrarPagos pFactura
        End If
        Set pFactura = Nothing

    End Select

End Sub
