VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaGeneralCotizaciones"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 114
Private srceCotizaciones As clsFiltroCotizaciones

Private doSortByVendedor As Boolean, doSortByCliente As Boolean
Private ControlTag As String
Private totVenta As Currency, TotIVA As Currency, totSaldo As Currency
Private TotVCli As Currency, TotIVACli As Currency, TotSaldoCli As Currency

'                                   Nombre de la Empresa
'                           Listado General de Cotizaciones
'                        Entre el 99-99-9999 y el 99-99-9999
'Fecha de Emisin: 99.99.9999 a las hh:mm p.m.   OPERADOR: XXXXXXXX     Pgina: 1
'------------------------------------------------------------------------------------------------------------------
'NUMERO      FECHA      NOMBRE DEL CLIENTE                       COD.VEND.  ESTADO             PRECIO     IMPUESTOS
'------------------------------------------------------------------------------------------------------------------
'DIR-0000000 99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXX XXXXXXXXXX 999.999.999,99 99.999.999,99

Private Sub ImprimirLinea(f As lfQuickView, _
                            sNumero As String, _
                            sFecha As String, _
                            sNombre As String, _
                            sCodVend As String, _
                            sEstado As String, _
                            vmPrecio As Currency, _
                            vmImpuestos As Currency)
Dim sOut As String

    sOut = stFullLength(sNumero, 11) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sNombre, 40) & " "
    sOut = sOut & stFullLength(sCodVend, 10) & " "
    sOut = sOut & stFullLength(sEstado, 10) & " "
    sOut = sOut & FormatNumero(vmPrecio, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(vmImpuestos, "##,###,##0.00", 13) & " "
    sOut = sOut & FormatNumero(vmPrecio + vmImpuestos, "###,###,##0.00", 14) & " "
    f.Add sOut

End Sub

Private Sub Ruptura(f As lfQuickView, sNewTag As String)

    If ControlTag = "" Then
        ControlTag = sNewTag
        Exit Sub
    End If

    ImprimirLinea f, "SUB-TOTAL", "", ControlTag, "", "", TotVCli, TotIVACli
    
    If f.Linea + 3 >= f.LineasPagina Then
        Encabezado f
    Else
        f.Add ""
    End If

    TotVCli = 0: TotIVACli = 0
    ControlTag = sNewTag

End Sub

Private Sub Encabezado(f As lfQuickView)

    If totVenta > 0 Or TotVCli > 0 Then

        If TotVCli > 0 Then
            ImprimirLinea f, "VAN", "", "", "", "", TotVCli, TotIVACli
        End If
        f.PageBreak

    End If

    f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add stMidAlign("Listado de Cotizaciones", AnchoReporte)
    f.Add stMidAlign("Entre el " + Format(srceCotizaciones.FechaInicial, "Short Date") + " y el " + Format(srceCotizaciones.FechaFinal, "Short Date"), AnchoReporte)
    f.Add ""
    f.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(f.Pagina)

    f.Add String(AnchoReporte, "-")
    f.Add "NUMERO      FECHA      NOMBRE DEL CLIENTE                       COD.VEND.  ESTADO             PRECIO     IMPUESTOS"
    f.Add String(AnchoReporte, "-")

    If TotVCli > 0 Then
        ImprimirLinea f, "VIENEN", "", "", "", "", TotVCli, TotIVACli
    End If

End Sub

Private Sub PasarLinea(f As lfQuickView, pCotizacion As clsCotizacion)

    If doSortByCliente Then
        If pCotizacion.CodigoCliente <> ControlTag Then
            Ruptura f, pCotizacion.CodigoCliente
        End If
    ElseIf doSortByVendedor Then
        If pCotizacion.CodigoVendedor <> ControlTag Then
            Ruptura f, pCotizacion.CodigoVendedor
        End If
    End If
    
    If f.Linea + 2 > f.LineasPagina Then
        Encabezado f
    End If

    ImprimirLinea f, Format(pCotizacion.Numero, "00000000"), Format(pCotizacion.FechaTransaccion, "Short Date"), pCotizacion.NombreCliente, pCotizacion.CodigoVendedor, pCotizacion.ImagenEstado, pCotizacion.PrecioEfectivo, pCotizacion.Impuesto1

    ' Acumula subtotal por segmento y total general.... es ms fcil, dado que la ruptura es condicional.
    TotVCli = TotVCli + pCotizacion.PrecioEfectivo
    TotIVACli = TotIVACli + pCotizacion.Impuesto1

    totVenta = totVenta + pCotizacion.PrecioEfectivo
    TotIVA = TotIVA + pCotizacion.Impuesto1

End Sub

Public Sub Generar()
Dim sSortParam As String
Dim pCotizacion As clsCotizacion, f As lfQuickView

    Set srceCotizaciones = New clsFiltroCotizaciones
    
    doSortByVendedor = srceCotizaciones.sortByVendedor
    doSortByCliente = srceCotizaciones.sortByCliente
    
    Set pCotizacion = srceCotizaciones.ProximaCotizacion
    
    If Not pCotizacion Is Nothing Then
        Screen.MousePointer = vbHourglass
        Set f = New lfQuickView
        f.SetNotify Me
        f.SetReportWidth AnchoReporte
        f.Caption = "Listado General de Cotizaciones, entre el " & Format(srceCotizaciones.FechaInicial, "Short Date") & " y el " & Format(srceCotizaciones.FechaFinal, "Short Date")
        
        ControlTag = ""
        totVenta = 0: TotIVA = 0
        TotVCli = 0: TotIVACli = 0

        Encabezado f

        Do
            PasarLinea f, pCotizacion
            Set pCotizacion = srceCotizaciones.ProximaCotizacion
        Loop While Not pCotizacion Is Nothing

        If doSortByVendedor Or doSortByCliente Then
            Ruptura f, ""
        End If
        
        ImprimirLinea f, "TOTAL", "GENERAL", "", "", "", totVenta, TotIVA
        
        Screen.MousePointer = vbDefault
        f.Show

        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing

    End If

End Sub

Public Sub ReportClicked(sText As String, nPos As Long)
Dim sRefFact As String

    Select Case nPos
    
    Case 1 To 12
        Dim pCotizacion As clsCotizacion
        sRefFact = Left(sText, 12)
        sRefFact = Trim(sRefFact)
        Set pCotizacion = New clsCotizacion
        If pCotizacion.Load(Val(sRefFact)) Then
            pCotizacion.Show
        End If
        Set pCotizacion = Nothing
    End Select

End Sub

