VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaFacturasSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency
Private pSesion As clsSesionPOS

Private Sub EncabezadoListaFact(f As lfQuickView, isFactOrDev As Boolean)

    If f.Pagina > 1 Or f.Linea > 1 Then
        f.Add stFullLength("VAN", 15) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "#,###,##0.00", 12)
        f.PageBreak
    End If

    f.Add ""
    f.Add ""
    f.Add Empresa.NombreEmpresa
    f.Add ""
    If isFactOrDev Then
        f.Add "Relacin de facturas del turno"
    Else
        f.Add "Relacin de Anulaciones en el Turno"
    End If
    f.Add "Sesin: " & Str(pSesion.SessionID)
    f.Add "Operador: " & pSesion.usrID
    f.Add "Terminal:" & Str(pSesion.MachineID)
    f.Add "Fecha de inicio: " & Format(pSesion.Fecha, "General Date")
    f.Add "Emision del listado: " & Format(Now, "General Date")
    f.Add "Pgina:" & Str(f.Pagina)
    f.Add "---------------------------------------------------------"
    f.Add "Factura  Hora           Venta      Impuesto      Servicio"
    f.Add "---------------------------------------------------------"
          '000000  99:99  999.999.999,99  9.999.999,99  9.999.999,99
    If f.Pagina > 1 Then
        f.Add stFullLength("VIENEN", 15) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "#,###,##0.00", 12) & "  " & FormatNumero(SubTotal3, "#,###,##0.00", 12)
    End If

End Sub

Public Sub ListarFactOrDev(isFactOrDev As Boolean, f As lfQuickView, iSesion As clsSesionPOS)
Dim rs As Recordset
Dim Venta As Double, Impuesto As Double, Servicio As Currency, sOut As String
    
    Set pSesion = iSesion
    Set rs = dbHandle.Execute("SELECT * FROM " & IIf(isFactOrDev, "FacturasPOS", "AnulacionesPOS") & " WHERE " & IIf(isFactOrDev, "idSesion", "SessionID") & " =" & Str(pSesion.SessionID) & " ORDER BY NumeroTicket")
    With rs
    If Not .EOF Then
    
        EncabezadoListaFact f, isFactOrDev
        SubTotal1 = 0: SubTotal2 = 0
        
        Do While Not .EOF
            Venta = .Fields("MontoVenta")
            Impuesto = .Fields("Impuesto")
            Servicio = GetNumeroFromVariant(.Fields("Servicio"))
            sOut = Format(.Fields("NumeroTicket"), "000000") & "  " & Format(.Fields("Hora"), "Short Time") & "  " & FormatNumero(Venta, "###,###,##0.00", 14) & "  " & FormatNumero(Impuesto, "#,###,##0.00", 12) & "  " & FormatNumero(Servicio, "#,###,##0.00", 12)
            SubTotal1 = SubTotal1 + Venta
            SubTotal2 = SubTotal2 + Impuesto
            SubTotal3 = SubTotal3 + Servicio
            
            If f.Linea > f.LineasPagina - 2 Then
                EncabezadoListaFact f, isFactOrDev
            End If
            
            f.Add sOut
            .MoveNext
        Loop
        f.Add stFullLength("TOTAL", 15) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "#,###,##0.00", 12) & "  " & FormatNumero(SubTotal3, "#,###,##0.00", 12)
    End If
    End With
    
    rs.Close
    Set rs = Nothing
    
End Sub

Public Function ListarFacturas(ilngNumero As Long)
Dim f As lfQuickView

    Set f = New lfQuickView
    f.SetReportWidth 80
   
    Screen.MousePointer = vbHourglass
    Set pSesion = New clsSesionPOS
    If pSesion.Load(ilngNumero) Then ListarFactOrDev True, f, pSesion
    Set pSesion = Nothing
    Screen.MousePointer = vbDefault
    
    If f.Text1.Text <> "" Then
      ShowNonModal f
    End If

    Unload f
    Set f = Nothing

End Function

Public Function ListarAnulaciones(ilngNumero As Long)
Dim f As lfQuickView

    Set f = New lfQuickView
    f.SetReportWidth 80
   
    Screen.MousePointer = vbHourglass
    Set pSesion = New clsSesionPOS
    If pSesion.Load(ilngNumero) Then ListarFactOrDev False, f, pSesion
    Set pSesion = Nothing
    Screen.MousePointer = vbDefault
    
    If f.Text1.Text <> "" Then
      ShowNonModal f
    End If

    Unload f
    Set f = Nothing

End Function

