VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaFactVend"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 147
'---------------------------------------------------------------------------------------------------------------------------------------------------
'Fecha      Factura     Cliente                                  Codigo                     Precio Lista    Precio Efectivo % Desc       Comision ST
'---------------------------------------------------------------------------------------------------------------------------------------------------
'99-99-9999 XXX-9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999.999,99 999.999.999.999,99 999,99 999.999.999,99 XX

Private fView As lfQuickView
Private vTotPLista As Currency, totPVenta As Currency, totComis As Currency
Private sCodVend As String, sNombreVend As String
Private finic As Date, ffinal As Date

Private Sub WriteLinea(sFecha As String, sFactura As String, sNombreCliente As String, sCodigo As String, vPrecioLista As Currency, vPrecioEfectivo As Currency, vComision As Currency, sStatComis As String)
Dim sOut As String

    sOut = stFullLength(sFecha, 10) & " " & _
           stFullLength(sFactura, 11) & " " & _
           stFullLength(sNombreCliente, 40) & " " & _
           stFullLength(sCodigo, 20) & " " & _
           FormatNumero(vPrecioLista, Empresa.MascaraMonetarios, 18) & " " & _
           FormatNumero(vPrecioEfectivo, Empresa.MascaraMonetarios, 18) & " "

    sOut = sOut & _
           FormatNumero(lmProporciones.CalcPDescuento(vPrecioLista, vPrecioEfectivo), "##0.00", 6) & " " & _
           FormatNumero(vComision, Empresa.MascaraMonetarios, 14) & " " & _
           sStatComis

    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        WriteLinea "VAN", "", "", "", vTotPLista, totPVenta, totComis, ""
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Facturas del Vendedor " & sNombreVend, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Factura     Cliente                                  Codigo                     Precio Lista    Precio Efectivo % Desc       Comision ST"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", "", "", vTotPLista, totPVenta, totComis, ""
    End If

End Sub

Private Sub PasarLinea( _
            dFecha As String, _
            sSerie As String, _
            lCorrelativo As Long, _
            sNombreCliente As String, _
            sCodigo As String, _
            vPrecioLista As Currency, _
            vPrecioEfectivo As Currency, _
            vComision As Currency, _
            bStatComis As Boolean)

    If fView.Linea >= fView.LineasPagina - 2 Then
        Encabezado
    End If
    
    WriteLinea Format(dFecha, "Short Date"), _
               sSerie & "-" & Format(lCorrelativo, "0000000"), _
               sNombreCliente, _
               sCodigo, _
               vPrecioLista, _
               vPrecioEfectivo, _
               vComision, _
               IIf(bStatComis, "S", "No")

    vTotPLista = vTotPLista + vPrecioLista: totPVenta = totPVenta + vPrecioEfectivo: totComis = totComis + vComision

End Sub

Public Sub Generar(istCodVend As String, istNombreVend As String)
Dim fFechas As lfSelectRangoFechas, bResult As Boolean
Dim sQuery As String, rs As Recordset

    sCodVend = istCodVend: sNombreVend = istNombreVend

    Set fFechas = New lfSelectRangoFechas
    fFechas.Show 1
    
    bResult = fFechas.Result
    If bResult Then
        finic = fFechas.dtFechaInicial
        ffinal = fFechas.dtFechaFinal
    End If
    
    Unload fFechas
    Set fFechas = Nothing
    
    If Not bResult Then Exit Sub
    
    sQuery = "SELECT FechaTransaccion, Serie, Correlativo, NombreCliente, CodigoCliente, PrecioLista, PrecioEfectivo, Comision, ComisionAcreditada"
    sQuery = sQuery & " FROM facturas"
    sQuery = sQuery & " WHERE CodigoVendedor = " & StringDB(sCodVend) & " AND FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal)

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Lista de Facturas del Vendedor " & sCodVend
        fView.SetNotify Me

        Encabezado
        
        Do While Not rs.EOF
        
            PasarLinea rs!FechaTransaccion, rs!Serie, rs!Correlativo, rs!NombreCliente, rs!CodigoCliente, rs!PrecioLista, rs!PrecioEfectivo, rs!Comision, rs!ComisionAcreditada
            rs.MoveNext

        Loop
        
        WriteLinea "TOTAL", "", "", "", vTotPLista, totPVenta, totComis, ""
        fView.SetNotify Me

        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault

End Sub

Public Sub ReportClicked(sLinea As String, lPos As Long)
'Fecha      Factura     Cliente                                  Codigo                     Precio Lista    Precio Efectivo % Desc       Comision ST
'99-99-9999 XXX-9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 999.999.999.999,99 999.999.999.999,99 999,99 999.999.999,99 XX

End Sub
