VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaFactDevol"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 179
Private srceFacturas As clsFiltroFacturas

Private doSortByVendedor As Boolean, doSortByCliente As Boolean
Private ControlTag As String
Private totVenta As Currency, TotDescuento As Currency, TotDevol As Currency, TotIVAInicial As Currency, TotIVADescuento As Currency, TOTIvaDevol As Currency
Private SubTotVenta As Currency, SubTotDescuento As Currency, SubTotDevol As Currency, SubTotIVAInicial As Currency, SubTotIVADescuento As Currency, SubTOTIvaDevol As Currency

'                                   Nombre de la Empresa
'                           Listado General de Facturas
'                        Entre el 99-99-9999 y el 99-99-9999
'Fecha de Emisin: 99.99.9999 a las hh:mm p.m.   OPERADOR: XXXXXXXX     Pgina: 1
'-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'NUMERO      FECHA      CODIGO DEL CLIENTE     Precio Inicial     Devoluciones    Desctos. P.P.         P. Final      IVA Inicial   IVA Descontado       IVA Devol.        IVA Final
'-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'DIR-0000000 99-99-9999 XXXXXXXXXXXXXXXXXXXX 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99

Private Sub ImprimirLinea(f As lfQuickView, _
                            sNumero As String, _
                            sFecha As String, _
                            sCodCli As String, _
                            vmPrecioInicial As Currency, _
                            vmDevoluciones As Currency, _
                            vmDescuentos As Currency, _
                            vmImpuestos As Currency, _
                            vmImpuestoDevuelto As Currency, _
                            vmImpuestoAnulado As Currency)
Dim sOut As String, vmTot As Currency
'Precio Inicial   Devoluciones  Desctos. P.P.
'P.Final    IVA Inicial IVA Descontado
'IVA Devol.      IVA Final
  sOut = stFullLength(sNumero, 11) & " "
  sOut = sOut & stFullLength(sFecha, 10) & " "
  sOut = sOut & stFullLength(sCodCli, 20) & " "
  
  sOut = sOut & FormatNumero(vmPrecioInicial, "#,###,###,##0.00", 16) & " "
  sOut = sOut & FormatNumero(vmDevoluciones, "#,###,###,##0.00", 16) & " "
  sOut = sOut & FormatNumero(vmDescuentos, "#,###,###,##0.00", 16) & " "
  
  vmTot = vmPrecioInicial - (vmDevoluciones + vmDescuentos)
  sOut = sOut & FormatNumero(vmTot, "#,###,###,##0.00", 16) & " "
  
  sOut = sOut & FormatNumero(vmImpuestos, "#,###,###,##0.00", 16) & " "
  sOut = sOut & FormatNumero(vmImpuestoAnulado, "#,###,###,##0.00", 16) & " "
  sOut = sOut & FormatNumero(vmImpuestoDevuelto, "#,###,###,##0.00", 16) & " "
  
  vmTot = vmImpuestos - (vmImpuestoDevuelto + vmImpuestoAnulado)
  sOut = sOut & FormatNumero(vmTot, "#,###,###,##0.00", 16) & " "

  f.Add sOut
End Sub

Private Sub Ruptura(f As lfQuickView, sNewTag As String)

  If ControlTag = "" Then
    ControlTag = sNewTag
    Exit Sub
  End If
  
  ImprimirLinea f, "SUB-TOTAL", "", ControlTag, SubTotVenta, SubTotDevol, SubTotDescuento, SubTotIVAInicial, SubTOTIvaDevol, SubTotIVADescuento
  
  
  If f.Linea + 3 >= f.LineasPagina Then
    Encabezado f
  Else
    f.Add ""
  End If
  
  SubTotVenta = 0: SubTotDescuento = 0: SubTotDevol = 0
  SubTotIVAInicial = 0: SubTotIVADescuento = 0: SubTOTIvaDevol = 0
  
  ControlTag = sNewTag
  
End Sub

Private Sub Encabezado(f As lfQuickView)

  If totVenta > 0 Or SubTotVenta > 0 Then
  
    If SubTotVenta > 0 Then
      ImprimirLinea f, "VAN", "", ControlTag, SubTotVenta, SubTotDevol, SubTotDescuento, SubTotIVAInicial, SubTOTIvaDevol, SubTotIVADescuento
    End If
    f.PageBreak
  
  End If
  
  f.Add ""
  f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
  f.Add stMidAlign("Listado de Facturas", AnchoReporte)
  f.Add stMidAlign("(Devoluciones y Descuentos en Cobranzas)", AnchoReporte)
  f.Add stMidAlign("Entre el " + Format(srceFacturas.FechaInicial, "Short Date") + " y el " + Format(srceFacturas.FechaFinal, "Short Date"), AnchoReporte)
  f.Add ""
  f.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(f.Pagina)
  
  f.Add String(AnchoReporte, "-")
  f.Add "NUMERO      FECHA      CODIGO DEL CLIENTE     Precio Inicial     Devoluciones    Desctos. P.P.         P. Final      IVA Inicial   IVA Descontado       IVA Devol.        IVA Final"
  f.Add String(AnchoReporte, "-")
  
  If SubTotVenta > 0 Then
    ImprimirLinea f, "VIENEN", "", ControlTag, SubTotVenta, SubTotDevol, SubTotDescuento, SubTotIVAInicial, SubTOTIvaDevol, SubTotIVADescuento
  End If
  
End Sub

Private Sub PasarLinea(f As lfQuickView, pFactura As clsFacturas)

    If doSortByCliente Then
        If pFactura.CodigoCliente <> ControlTag Then
            Ruptura f, pFactura.CodigoCliente
        End If
    ElseIf doSortByVendedor Then
        If pFactura.CodigoVendedor <> ControlTag Then
            Ruptura f, pFactura.CodigoVendedor
        End If
    End If
    
    If f.Linea + 2 > f.LineasPagina Then
        Encabezado f
    End If

    ImprimirLinea f, pFactura.Referencia, Format(pFactura.FechaTransaccion, "Short Date"), pFactura.CodigoCliente, pFactura.PrecioEfectivo, pFactura.PrecioDevuelto, pFactura.DescuentosProntoPago, pFactura.Impuesto1 + pFactura.Impuesto2, pFactura.Impuesto1Devuelto + pFactura.Impuesto2Devuelto, pFactura.ImpuestoDescontado

    ' Acumula subtotal por segmento y total general.... es ms fcil, dado que la ruptura es condicional.
    
    totVenta = totVenta + pFactura.PrecioEfectivo
    TotDescuento = TotDescuento + pFactura.DescuentosProntoPago
    TotDevol = TotDevol + pFactura.PrecioDevuelto
    TotIVAInicial = TotIVAInicial + pFactura.Impuesto1 + pFactura.Impuesto2
    TotIVADescuento = TotIVADescuento + pFactura.ImpuestoDescontado
    TOTIvaDevol = TOTIvaDevol + pFactura.Impuesto1Devuelto + pFactura.Impuesto2Devuelto
    
    SubTotVenta = SubTotVenta + pFactura.PrecioEfectivo
    SubTotDescuento = SubTotDescuento + pFactura.DescuentosProntoPago
    SubTotDevol = SubTotDevol + pFactura.PrecioDevuelto
    SubTotIVAInicial = SubTotIVAInicial + pFactura.Impuesto1 + pFactura.Impuesto2
    SubTotIVADescuento = SubTotIVADescuento + pFactura.ImpuestoDescontado
    SubTOTIvaDevol = SubTOTIvaDevol + pFactura.Impuesto1Devuelto + pFactura.Impuesto2Devuelto

End Sub

Public Sub Generar()
Dim sSortParam As String
Dim pFactura As clsFacturas, f As lfQuickView

    Set srceFacturas = New clsFiltroFacturas
    
    doSortByVendedor = srceFacturas.sortByVendedor
    doSortByCliente = srceFacturas.sortByCliente

    Screen.MousePointer = vbHourglass
    Set pFactura = srceFacturas.ProximaFactura
    
    If Not pFactura Is Nothing Then
        Set f = New lfQuickView
        f.SetNotify Me
        f.SetReportWidth AnchoReporte
        f.Caption = "Listado General de Facturas, entre el " & Format(srceFacturas.FechaInicial, "Short Date") & " y el " & Format(srceFacturas.FechaFinal, "Short Date")
        
        ControlTag = ""
        totVenta = 0: TotDescuento = 0: TotDevol = 0: TotIVAInicial = 0: TotIVADescuento = 0: TOTIvaDevol = 0
        SubTotVenta = 0: SubTotDescuento = 0: SubTotDevol = 0: SubTotIVAInicial = 0: SubTotIVADescuento = 0: SubTOTIvaDevol = 0

        Encabezado f

        Do
            PasarLinea f, pFactura
            Set pFactura = srceFacturas.ProximaFactura
        Loop While Not pFactura Is Nothing

        If doSortByVendedor Or doSortByCliente Then
            Ruptura f, ""
        End If
        
        ImprimirLinea f, "TOTAL", "GENERAL", "", totVenta, TotDevol, TotDescuento, TotIVAInicial, TOTIvaDevol, TotIVADescuento

        Screen.MousePointer = vbDefault
        f.Show

        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing

    End If

    Screen.MousePointer = vbDefault

End Sub

Public Sub ReportClicked(sText As String, nPos As Long)
Dim f As frmConsultarFactura, sRefFact As String

    Select Case nPos
    
    Case 1 To 12
        sRefFact = left(sText, 12)
        sRefFact = Trim(sRefFact)
        ConsultarFactura sRefFact
    
    Case 25 To 45
        sRefFact = Mid(sText, 25, 20)
        sRefFact = Trim(sRefFact)
        ShowFIECliente sRefFact

    End Select

End Sub


