VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaFactCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoCronologico = 166, AnchoPorProveedor = 104

Dim WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Dim finic As Date, ffinal As Date
Dim AnchoReporte As Long, bPorProveedor As Boolean
Dim vmTotalCompras As Currency, vmTotalIVA As Currency, vmTotalSaldo As Currency
Dim vmSubTotC As Currency, vmSubTotIVA As Currency, vmSubTotSaldo As Currency
Dim ControlTag As String, sNombreTag As String

Private Sub Encabezado(isRuptura As Boolean)
    
    If fView.Linea > 1 Or fView.Pagina > 1 Then
        
        If bPorProveedor Then
            If Not isRuptura Then
                PrintLineaP "VAN", "", vmSubTotC, vmSubTotIVA, "", vmSubTotSaldo
            End If
        Else
            PrintLineaC "VAN", "", "", "", vmTotalCompras, vmTotalIVA, "", vmTotalSaldo
        End If
        
        fView.PageBreak
        
    End If

    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add stMidAlign("Listado General de Facturas de Compra", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    
    fView.Add String(AnchoReporte, "-")
    If bPorProveedor Then
        fView.Add "Factura              Fecha        Valor Compra       Impuesto          Total Condicion             Saldo"
    Else
        fView.Add "Factura              Nombre del Proveedor                     Cdigo Proveedor     Fecha        Valor Compra       Impuesto          Total Condicion             Saldo"
    End If
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
    
        If bPorProveedor Then
            If Not isRuptura Then
                fView.Add "PROVEEDOR: " & sNombreTag & "... (" & ControlTag & ")"
                PrintLineaP "VIENEN", "", vmSubTotC, vmSubTotIVA, "", vmSubTotSaldo
            End If
        Else
            PrintLineaC "VIENEN", "", "", "", vmTotalCompras, vmTotalIVA, "", vmTotalSaldo
        End If
    
    End If

End Sub

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------
'Factura              Nombre del Proveedor                     Cdigo Proveedor     Fecha        Valor Compra       Impuesto          Total Condicion             Saldo
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99 XXXXXXXXXXXX 999.999.999,99

Private Sub PrintLineaC(sRefFact As String, _
                        sNombreProv As String, _
                        sCodProv As String, _
                        sFecha As String, _
                        vmCompra As Currency, _
                        vmIVA As Currency, _
                        sCondicion As String, _
                        vmSaldo As Currency)
Dim sOut As String

    sOut = stFullLength(sRefFact, 20) & " "
    sOut = sOut & stFullLength(sNombreProv, 40) & " "
    sOut = sOut & stFullLength(sCodProv, 20) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & stFullLength(sCondicion, 12) & " "
    sOut = sOut & FormatNumero(vmSaldo, Empresa.MascaraMonetarios, 14)

    fView.Add sOut

End Sub

'--------------------------------------------------------------------------------------------------------
'Factura              Fecha        Valor Compra       Impuesto          Total Condicion             Saldo
'--------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99 XXXXXXXXXXXX 999.999.999,99

Private Sub PrintLineaP(sRefFact As String, sFecha As String, vmCompra As Currency, vmIVA As Currency, sCondicion As String, vmSaldo As Currency)
Dim sOut As String

    sOut = stFullLength(sRefFact, 20) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & stFullLength(sCondicion, 12) & " "
    sOut = sOut & FormatNumero(vmSaldo, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub

Private Sub Ruptura(sNewTag As String, sNewName As String)

    If ControlTag <> "" Then PrintLineaP "TOTAL PROVEEDOR", "", vmSubTotC, vmSubTotIVA, "", vmSubTotSaldo
    
    vmSubTotC = 0: vmSubTotIVA = 0: vmSubTotSaldo = 0
    
    If sNewTag = "" Then
        fView.Add ""
        Exit Sub
    End If

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    ControlTag = sNewTag
    sNombreTag = sNewName
    
    fView.Add "PROVEEDOR: " & sNombreTag & " (" & ControlTag & ")"

End Sub


Private Sub PasarLinea(CodigoProveedor As String, _
                       NombreProveedor As String, _
                       RefProveedor As String, _
                       FechaTransaccion As Date, _
                       ValorCompra As Currency, _
                       Impuesto As Currency, _
                       Condicion As String, _
                       Saldo As Currency)
                    
    If bPorProveedor Then
        If CodigoProveedor <> ControlTag Then
            Ruptura CodigoProveedor, NombreProveedor
        End If
    End If

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado False
    End If
    
    If bPorProveedor Then
        PrintLineaP CodigoProveedor & "-" & RefProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, _
            Impuesto, Condicion, Saldo
        vmSubTotC = vmSubTotC + ValorCompra
        vmSubTotIVA = vmSubTotIVA + Impuesto
        vmSubTotSaldo = vmSubTotSaldo + Saldo
    Else
        PrintLineaC CodigoProveedor & "-" & RefProveedor, NombreProveedor, CodigoProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, _
            Impuesto, Condicion, Saldo
    End If

    vmTotalCompras = vmTotalCompras + ValorCompra
    vmTotalIVA = vmTotalIVA + Impuesto
    vmTotalSaldo = vmTotalSaldo + Saldo

End Sub


'SELECT C.*
'FROM Compras AS C, Proveedores AS P
'WHERE C.FechaTransaccion BETWEEN #2000-01-01# AND #2000-08-10#
'AND       C.CodigoProveedor = P.Codigo
'ORDER BY C.FechaTransaccion, C.Numero;

Public Sub Generar()
Dim rs As Recordset, f As frmFiltroProveedores
Dim sQuery As String, sNext As String

    Set f = New frmFiltroProveedores
    f.SetInterval True
    f.Caption = "Listado de Facturas de Compra"
    ShowNonModal f
    
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    bPorProveedor = f.sortByProveedor
    finic = f.ucSelectRango1.FechaInicial
    ffinal = f.ucSelectRango1.FechaFinal

    sQuery = "SELECT C.* FROM Compras C, Proveedores P WHERE C.FechaTransaccion " & f.ClausulaRango
    sQuery = sQuery & " AND C.CodigoProveedor = P.Codigo"
    sNext = f.FiltroSQL("P")
    If sNext <> "" Then sQuery = sQuery & " AND " & sNext
    If bPorProveedor Then
        sQuery = sQuery & " ORDER BY C.CodigoProveedor, C.FechaTransaccion, C.Numero"
    Else
        sQuery = sQuery & " ORDER BY C.FechaTransaccion, C.Numero"
    End If
        
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    
    Unload f
    Set f = Nothing

    If Not rs.EOF Then
    
        If bPorProveedor Then
            AnchoReporte = AnchoPorProveedor
        Else
            AnchoReporte = AnchoCronologico
        End If

        Set fView = New lfQuickView
        fView.SetReportWidth (AnchoReporte)
        fView.Caption = "Listado General de Compras"
        fView.SetNotify Me

        vmTotalCompras = 0: vmTotalIVA = 0: vmTotalSaldo = 0
        vmSubTotC = 0: vmSubTotIVA = 0: vmSubTotSaldo = 0
        ControlTag = "": sNombreTag = ""

        Encabezado False
        
        Do While Not rs.EOF
        
            PasarLinea rs!CodigoProveedor, rs!NombreProveedor, rs!RefProveedor, rs!FechaTransaccion, rs!CostoMercancia, rs!Impuesto1 + rs!Impuesto2, rs!Condicion, rs!Saldo
            rs.MoveNext

        Loop
        
        If bPorProveedor Then
            Ruptura "", ""
            PrintLineaP "TOTAL", "", vmTotalCompras, vmTotalIVA, "", vmTotalSaldo
        Else
            PrintLineaC "TOTAL", "", "", "", vmTotalCompras, vmTotalIVA, "", vmTotalSaldo
        End If
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault
        
End Sub

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim strExtract As String
  
  bProcessed = True
  Select Case nLinePos
  Case 1 To 21
    Dim pRecibo As clsReciboMercancia
    Set pRecibo = New clsReciboMercancia
    strExtract = Trim(left(Trim(strReportLine), 20))
    If pRecibo.LoadByReferenciaISDOC(strExtract) Then
      pRecibo.Show
    End If
    Set pRecibo = Nothing
  Case Else
    Dim pProveedor As clsProveedores
    strExtract = Trim(Mid(Trim(strReportLine), 63, 20))
    Set pProveedor = AlmacenProveedores.Proveedor(strExtract)
    If Not pProveedor Is Nothing Then
      pProveedor.Show
      Set pProveedor = Nothing
    End If
  End Select

End Sub
