VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaExProdAlm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 65

'-----------------------------------------------------------------
'Almacen  Nombre del Almacen                            Existencia
'-----------------------------------------------------------------
'XXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,999

Private fView As lfQuickView
Private totUnits As Double, sCodProd As String, sDescProd As String
Private pItem As Object

Public Sub SetItem(Item As Object)
    
    Set pItem = Item
    sCodProd = pItem.Codigo
    sDescProd = pItem.Descripcion

End Sub

Private Sub WriteLinea(sCodAl As String, sNombreAl As String, dExistencia As Double)
    
    fView.Add stFullLength(sCodAl, 8) & " " & stFullLength(sNombreAl, 40) & " " & FormatNumero(dExistencia, Empresa.MascaraCantidades, 15)
    
End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Or fView.Pagina > 1 Then
        WriteLinea "VAN", "", totUnits
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de existencia por almacenes. Producto: " & sDescProd, AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Almacen  Nombre del Almacen                            Existencia"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", totUnits
        fView.PageBreak
    End If
    
End Sub

Private Sub PasarLinea(sCodAl As String, sNombreAl As String, dExistencia As Double)

    If fView.Linea >= fView.LineasPagina - 3 Then Encabezado
    
    WriteLinea sCodAl, sNombreAl, dExistencia
    
    totUnits = totUnits + dExistencia

End Sub

Public Sub Generar()
Dim pAlmacen As clsAlmacen

    If Almacenes.Count = 0 Then

        mAdvertencia "No tiene almacenes definidos"
        Exit Sub

    End If

    Set fView = New lfQuickView
    fView.Caption = "Listado de Existencias por almacn"

    Encabezado
    
    For Each pAlmacen In Almacenes
    
        PasarLinea pAlmacen.Codigo, pAlmacen.Descripcion, pItem.ExistenciaAlmacen(pAlmacen.Codigo)

    Next
    
    fView.Add ""
    WriteLinea "TOTAL", "", totUnits

    fView.Add ""
    WriteLinea "", "Existencia General (Mxima)", pItem.ExistenciaGeneral
    
    ShowNonModal fView

    Unload fView
    Set fView = Nothing

End Sub
