VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaEventosNotaEntrega"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Empresa
'Nota de Entrega N 99999999
'Relacin de Operaciones
'
'Emision: 99-99-9999
'Cliente: XXX...XXXX (XX...XXX)
'Valor Inicial: 9.999.999.999,99
'Facturado:     9.999.999.999,99
'Devuelto:      9.999.999.999,99
'Valor actual:  9.999.999.999,99
'
'Fecha del Reporte: 99-99-9999          Operador: XXXXXXXXXXX                                  Pgina 99
'-------------------------------------------------------------------------------------------------------
'Fecha      Descripcion                                                   Valor Doc Ref.Documento
'-------------------------------------------------------------------------------------------------------
'99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999.999,99 XXX XXXXXXXXXXXXXXXXXXXX

Private Const AnchoReporte = 103

Private pNota As clsNNEE
Private instanciador As clsInstanciadorEntidad
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1

Private Sub Encabezado(isFirst As Boolean)
Dim rs As Recordset
Dim vmFacturado As Currency, vmDevuelto As Currency

  If Not isFirst Then
    fView.PageBreak
  End If
  
  fView.Add ""
  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "Relacion de operaciones para la Nota de Entrega N " & Format(pNota.Numero, "0000000"), vbCenter
  fView.Add ""

  If isFirst Then
    Set rs = dbHandle.Execute("SELECT SUM(Valor + Impuesto1 + Impuesto2) As Monto FROM NNEESuplemento WHERE NumeroNota = " & NumeroDB(pNota.Numero) & " AND TipoDocRel = 'FCT'")
    vmFacturado = GetNumeroFromVariant(rs.Fields("Monto"))
    rs.Close
    Set rs = Nothing
    
    Set rs = dbHandle.Execute("SELECT SUM(Valor + Impuesto1 + Impuesto2) As Monto FROM NNEESuplemento WHERE NumeroNota = " & NumeroDB(pNota.Numero) & " AND TipoDocRel = 'AJU'")
    vmDevuelto = GetNumeroFromVariant(rs.Fields("Monto"))
    rs.Close
    Set rs = Nothing
    fView.Add "Valor Inicial: " & FormatNumero(pNota.PrecioEfectivo + pNota.Impuesto1 + pNota.Impuesto2, Empresa.MascaraMonetarios, 16)
    fView.Add "Facturado:     " & FormatNumero(vmFacturado, Empresa.MascaraMonetarios, 16)
    fView.Add "Devuelto:      " & FormatNumero(vmDevuelto, Empresa.MascaraMonetarios, 16)
    fView.Add "Valor Actual : " & FormatNumero(pNota.PrecioEfectivo + pNota.Impuesto1 + pNota.Impuesto2 - (vmFacturado + vmDevuelto), Empresa.MascaraMonetarios, 16)
    fView.Add ""
  End If

  fView.Add LineJustify(AnchoReporte, "Fecha del reporte: " & Format(Date, "Short Date"), "Operador: " & Format(UsuarioActivo.Codigo), "Pgina: " & fView.Pagina)
  fView.Add String(AnchoReporte, "-")
  fView.Add "Fecha      Descripcion                                                   Valor Doc Ref.Documento"
  fView.Add String(AnchoReporte, "-")
  
End Sub

Private Sub PasarLinea(dtFecha As Date, sDescripcion As String, vmMonto As Currency, sTipoDoc As String, lngNumDoc As Long)
Dim pDoc As Object, sOut As String

  If fView.Linea > fView.LineasPagina - 4 Then
    Encabezado False
  End If

  Set pDoc = instanciador.EntidadDOCUMENTO(sTipoDoc, lngNumDoc)
  sOut = stFullLength(Format(dtFecha, "Short Date"), 10) & " "
  sOut = sOut & stFullLength(sDescripcion, 51)
  sOut = sOut & FormatNumero(vmMonto, Empresa.MascaraMonetarios, 16) & " "
  sOut = sOut & stFullLength(sTipoDoc, 3) & " "
  If pDoc Is Nothing Then
    sOut = sOut & "ERR:" & Format(lngNumDoc, "00000000")
  Else
    sOut = sOut & pDoc.Referencia
  End If
  
  fView.Add sOut

End Sub

Public Sub Generar(ipNota As clsNNEE)
Dim rs As Recordset

  On Error GoTo ErrHandler

  Set pNota = ipNota
  Set rs = dbHandle.Execute("SELECT FechaTransaccion, Descripcion, (Impuesto1 + Impuesto2 + Valor) As Monto, TipoDocRel, NumeroDocRel FROM NNEESuplemento WHERE NumeroNota = " & NumeroDB(pNota.Numero) & " ORDER BY FechaTransaccion, Numero")
  If rs.EOF Then
    mAdvertencia "No hay eventos para la nota seleccionada"
  Else
    Set fView = New lfQuickView
    Set instanciador = New clsInstanciadorEntidad
    Encabezado True
    
    Do While Not rs.EOF
      PasarLinea GetDateFromVariant(rs.Fields("FechaTransaccion")), GetStringFromVariant(rs.Fields("Descripcion")), GetNumeroFromVariant(rs.Fields("Monto")), GetStringFromVariant(rs.Fields("TipoDocRel")), GetNumeroFromVariant(rs.Fields("NumeroDocRel"))
      rs.MoveNext
    Loop
    
    ShowNonModal fView
    Set instanciador = Nothing
  End If

ResumePoint:
  If Not fView Is Nothing Then
    Unload fView
    Set fView = Nothing
  End If
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  Set instanciador = Nothing
  Set pNota = Nothing
  Exit Sub

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsListaEventosNotaEntrega::Generar"
  Resume ResumePoint

End Sub

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sLinea As String, sRefDoc As String, sTipoDoc As String
Dim pDoc As Object

  sLinea = Trim(strReportLine)
  sTipoDoc = Trim(Mid(sLinea, 80, 3))
  sRefDoc = Trim(Mid(sLinea, 84, 20))
  Set pDoc = instanciador.EntidadDOCUMENTOByRef(sTipoDoc, sRefDoc)
  If Not pDoc Is Nothing Then pDoc.Show
'99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999.999,99 XXX XXXXXXXXXXXXXXXXXXXX
End Sub
