VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaEntregasItem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit


Private Const AnchoReporte = 130
Private TotalUnidades As Double, ValorTotal As Double
Private pItemVenta As clsItemVenta
Private fView As lfQuickView

'----------------------------------------------------------------------------------------------------------------------------------
'Nota    Fecha      Cliente                                      Cantidad Unidad     Precio Unit.      Valor Total         Unidades
'----------------------------------------------------------------------------------------------------------------------------------
'0000000 99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 9.999.999,99 XXXXXXXX 999.999.999,99 9.999.999.999,99 9.999.999.999,99

Private Sub PasarLinea(rs As Recordset)
Dim sOut As String

    sOut = Format(GetNumeroFromVariant(rs!Numero), "0000000") & " "
    sOut = sOut & stFullLength(Format(GetDateFromVariant(rs!FechaTransaccion), "Short Date"), 10) & " "
    sOut = sOut & stFullLength(GetStringFromVariant(rs!NombreCliente), 40) & " "
    sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!Cantidad), Empresa.MascaraCantidades, 12) & " "
    sOut = sOut & stFullLength(GetStringFromVariant(rs!Presentacion), 8) & " "
    sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!PrecioEfectivo), Empresa.MascaraPrecios, 14) & " "
    sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!PrecioEfectivo) * GetNumeroFromVariant(rs!Cantidad), Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(GetNumeroFromVariant(rs!Cantidad) * GetNumeroFromVariant(rs!FactorEmpaque), Empresa.MascaraCantidades, 16)
    
    TotalUnidades = TotalUnidades + GetNumeroFromVariant(rs!Cantidad) * GetNumeroFromVariant(rs!FactorEmpaque)
    ValorTotal = ValorTotal + GetNumeroFromVariant(rs!PrecioEfectivo) * GetNumeroFromVariant(rs!Cantidad)
    
    fView.Add sOut
    
End Sub

Private Sub PasarTotal(istrTitulo As String)
Dim sOut As String

    sOut = stFullLength(istrTitulo, 97)
    sOut = sOut & FormatNumero(ValorTotal, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(TotalUnidades, Empresa.MascaraCantidades, 16)
    
    fView.Add sOut

End Sub

Private Sub Encabezado()

    If fView.Linea > 1 Then
        PasarTotal "VAN"
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Unidades Entregadas", vbCenter
    fView.Add "Producto: " & pItemVenta.Descripcion & " (" & pItemVenta.Codigo & ")", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Nota    Fecha      Cliente                                      Cantidad Unidad     Precio Unit.      Valor Total         Unidades"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        PasarTotal "VIENEN"
    End If

End Sub

Public Sub Go(ipItemVenta As clsItemVenta)
Dim rs As Recordset, sqlQuery As String
    
    Set pItemVenta = ipItemVenta
    sqlQuery = "SELECT r.*, n.Numero, n.FechaTransaccion, n.NombreCliente FROM NNEEDetalles R, NNEE n WHERE r.CodigoItem = " & StringDB(pItemVenta.Codigo) & " AND r.NumeroDocumento = n.Numero AND n.Estado = 0"
    Set rs = dbHandle.Execute(sqlQuery)
    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me
        Encabezado
        
        Do While Not rs.EOF
            If fView.Linea > fView.LineasPagina - 5 Then
                Encabezado
            End If
            PasarLinea rs
            rs.MoveNext
        Loop
        
        PasarTotal "TOTAL"
    
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
    End If
    
    Set rs = Nothing
    Set pItemVenta = Nothing

End Sub
