VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaEgresosSesion"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private SubTotal1 As Currency, SubTotal2 As Currency, SubTotal3 As Currency
Private pSesion As clsSesionPOS

Private Sub EncabezadoListaRetiros(f As lfQuickView)
    
    If f.Pagina > 1 Or f.Linea > 1 Then
        f.Add stFullLength("VAN", 49) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "###,###,##0.00", 14)
        f.PageBreak
    End If
    
    f.Add ""
    f.Add ""
    f.Add Empresa.NombreEmpresa
    f.Add ""
    f.Add "Relacin de Egresos del turno"
    f.Add "Sesin: " & Str(pSesion.SessionID)
    f.Add "Operador: " & pSesion.usrID
    f.Add "Terminal:" & Str(pSesion.MachineID)
    f.Add "Fecha de inicio: " & Format(pSesion.Fecha, "General Date")
    f.Add "Emision del listado: " & Format(Now, "General Date")
    f.Add "Pgina:" & Str(f.Pagina)
    f.Add "-----------------------------------------------------------------------------"
    f.Add "Hora   Descripcion                                       Pagos        Retiros"
    f.Add "-----------------------------------------------------------------------------"
'          99:99  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  ###.###.##0,00  ###.###.##0,00
    If f.Pagina > 1 Then
        f.Add stFullLength("VIENEN", 49) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "###,###,##0.00", 14)
    End If

End Sub

Public Sub MostrarListaRetiros(iSesion As clsSesionPOS, f As lfQuickView)
Dim rs As Recordset
Dim Retiro As Double, Pago As Double, sOut As String
  Set pSesion = iSesion
  Set rs = dbHandle.Execute("SELECT * FROM RetirosPOS WHERE idSesion =" & Str(pSesion.SessionID))
  With rs
  If Not .EOF Then
    Screen.MousePointer = vbHourglass
    SubTotal1 = 0: SubTotal2 = 0
    EncabezadoListaRetiros f
    Do While Not .EOF
      If rs.Fields("Tipo") = 0 Then
        Retiro = .Fields("Monto")
        Pago = 0
      Else
        Retiro = 0
        Pago = .Fields("Monto")
      End If
      sOut = Format(.Fields("Hora"), "Short Time") & "  " & stFullLength(.Fields("Descripcion"), 40) & "  " & FormatNumero(Pago, "###,###,##0.00", 14) & "  " & FormatNumero(Retiro, "###,###,##0.00", 14)
      '           99:99  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  ###.###.##0,00  ###.###.##0,00
      If f.Linea > f.LineasPagina - 5 Then
        EncabezadoListaRetiros f
      End If
      f.Add sOut
      SubTotal1 = SubTotal1 + Pago
      SubTotal2 = SubTotal2 + Retiro
      .MoveNext
    Loop
    f.Add stFullLength("TOTAL", 49) & FormatNumero(SubTotal1, "###,###,##0.00", 14) & "  " & FormatNumero(SubTotal2, "###,###,##0.00", 14)
    Screen.MousePointer = vbDefault
  End If
  End With
  
  rs.Close
  Set rs = Nothing

End Sub

Public Sub ListarRetiros(ilngNumeroSesion As Long)
Dim f As lfQuickView

  Set pSesion = New clsSesionPOS
  If Not pSesion.Load(ilngNumeroSesion) Then
    Set pSesion = Nothing
    Exit Sub
  End If
  
  Set f = New lfQuickView
  f.Caption = "Retiros del turno" & Str(pSesion.SessionID)
  f.SetReportWidth 80
  
  MostrarListaRetiros pSesion, f
  If f.Text1.Text <> "" Then ShowNonModal f
  Unload f
  Set f = Nothing
  
  Set pSesion = Nothing

End Sub

