VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDocs"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 102

Private sTipoEntidad As String, ControlTag As String, sNombreTag As String
Private pInstancer As clsInstanciadorEntidad, fView As lfQuickView
Private factor As Currency
Private TotalSaldo As Currency, SubTotSaldo As Currency
Private TotalMonto As Currency, SubTotMonto As Currency

Public Sub SetEntidad(tEntidad As String)
    
    sTipoEntidad = tEntidad
    If tEntidad = "CLT" Then
        factor = 1
    Else
        factor = -1
    End If

End Sub

Private Sub Encabezado(isRuptura As Boolean)

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        If Not isRuptura Then
            AddLinea "VAN", "", "", SubTotMonto, SubTotSaldo
        End If
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de documentos pendientes por " & pInstancer.NombreEntidadISPC(sTipoEntidad, False), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Ref.Documento        Fecha      Descripcion                              Monto Original   Saldo Actual"
    fView.Add String(AnchoReporte, "-")

    If Not isRuptura Then
        If fView.Pagina > 1 Then
            fView.Add Format(pInstancer.NombreEntidadISPC(sTipoEntidad, False), ">") & ": " & sNombreTag & " (" & ControlTag & ")"
            AddLinea "VIENEN", "", "", SubTotMonto, SubTotSaldo
        End If
    End If
    
End Sub

Private Sub Ruptura(sNewCodigo As String)
Dim pNext As Object

    If ControlTag <> "" Then
        AddLinea "TOTAL " & Format(pInstancer.NombreEntidadISPC(sTipoEntidad, False), ">"), "", "", SubTotMonto, SubTotSaldo
    End If

    If sNewCodigo = "" Then Exit Sub

    If fView.Linea > fView.LineasPagina - 5 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    SubTotMonto = 0: SubTotSaldo = 0
    ControlTag = sNewCodigo
    
    Set pNext = pInstancer.EntidadPersonaComercial(sTipoEntidad, sNewCodigo)
    If pNext Is Nothing Then
        sNombreTag = "No encontrado"
        factor = IIf(sTipoEntidad = "CLT", 1, -1)
    Else
        sNombreTag = pNext.Nombre
        factor = pNext.FactorNormal
    End If
    Set pNext = Nothing
    
    fView.Add Format(pInstancer.NombreEntidadISPC(sTipoEntidad, False)) & ": " & sNombreTag & " (" & ControlTag & ")"

End Sub

'------------------------------------------------------------------------------------------------------
'Ref.Documento        Fecha      Descripcion                              Monto Original   Saldo Actual
'------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99

Private Sub AddLinea(sRefDoc As String, _
                     sFecha As String, _
                     sDescripcion As String, _
                     vmMonto As Currency, _
                     vmSaldo As Currency)
Dim sOut As String

    sOut = stFullLength(sRefDoc, 20) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sDescripcion, 40) & " "
    sOut = sOut & FormatNumero(vmMonto, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmSaldo, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub
                     
Private Sub PasarLinea(sCodigoEntidad As String, lNumDoc As Long, sTipoDoc As String, dFechaDoc As Date, vmMonto As Currency, vmSaldo As Currency)
Dim pDocumento As Object

    If sCodigoEntidad <> ControlTag Then
        Ruptura sCodigoEntidad
    End If
    
    If fView.Linea > fView.LineasPagina - 3 Then
        Encabezado False
    End If
    
    Set pDocumento = pInstancer.EntidadDOCUMENTO(sTipoDoc, lNumDoc)

    If Not pDocumento Is Nothing Then AddLinea pDocumento.Referencia, Format(dFechaDoc, "Short Date"), pDocumento.Concepto, vmMonto * factor, vmSaldo * factor
    
    TotalSaldo = TotalSaldo + vmSaldo * factor
    SubTotSaldo = SubTotSaldo + vmSaldo * factor
    TotalMonto = TotalMonto + vmMonto * factor
    SubTotMonto = SubTotMonto + vmMonto * factor

End Sub

Public Sub Generar()
Dim sQuery As String, rs As Recordset

    sQuery = "SELECT * FROM DocumentosISPC WHERE TipoEntidad = " & StringDB(sTipoEntidad) & " AND Saldo <> 0 ORDER BY CodigoEntidad, FechaDoc"
    
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    
    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        Set pInstancer = New clsInstanciadorEntidad

        fView.Caption = "Documentos pendientes por " & pInstancer.NombreEntidadISPC(sTipoEntidad, False)
        fView.SetNotify Me
        
        TotalSaldo = 0: SubTotSaldo = 0
        TotalMonto = 0: SubTotMonto = 0
        ControlTag = "": sNombreTag = ""
        
        Encabezado False
        
        Do While Not rs.EOF
        
            PasarLinea rs!CodigoEntidad, rs!numDoc, rs!TipoDoc, rs!FechaDoc, rs!Monto, rs!Saldo
            rs.MoveNext

        Loop
        
        Ruptura ""
        fView.Add ""
        AddLinea "TOTAL GENERAL", "", "", TotalMonto, TotalSaldo
        
        Screen.MousePointer = vbDefault
        
        Set pInstancer = Nothing

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    Screen.MousePointer = vbDefault

    rs.Close
    Set rs = Nothing

End Sub


'------------------------------------------------------------------------------------------------------
'Ref.Documento        Fecha      Descripcion                              Monto Original   Saldo Actual
'------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX 99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99

Public Sub ReportClicked(sLinea As String, lPos As Long)

    sLinea = Trim(sLinea)
    
    If (left(sLinea, 2) = "NC" Or left(sLinea, 2) = "ND") And _
       (Mid(sLinea, 3, 3) = "CLT" Or Mid(sLinea, 3, 3) = "PRV") Then
        
        Dim pNota As clsNotasDCCP
        Set pNota = New clsNotasDCCP
        sLinea = Trim(left(sLinea, 21))
        If pNota.LoadByReferenciaISDOC(sLinea) Then
            pNota.Show
        End If
        Set pNota = Nothing
    
    Else
        
        If sTipoEntidad = "CLT" Then
            If StrComp(left(sLinea, 7), "CLIENTE", vbTextCompare) = 0 Then
                Dim pCliente As clsClientes
                Set pCliente = New clsClientes
                If pCliente.Load(sExtractRightCode(sLinea)) Then
                    pCliente.Show
                End If
                Set pCliente = Nothing
            Else
                Dim pFactura As clsFacturas
                Set pFactura = New clsFacturas
                sLinea = Trim(left(sLinea, 21))
                If pFactura.LoadByReferenciaISDOC(sLinea) Then
                    pFactura.Show
                Else
                  Dim pFactPos As New clsFacturasPOS
                  If pFactPos.LoadByReferenciaISDOC(sLinea) Then
                    pFactPos.Show
                  End If
                End If
            End If
        Else
            If StrComp(left(sLinea, 9), "PROVEEDOR", vbTextCompare) = 0 Then
                Dim pProveedor As clsProveedores
                Set pProveedor = New clsProveedores
                If pProveedor.Load(sExtractRightCode(sLinea)) Then
                    pProveedor.Show
                End If
                Set pProveedor = Nothing
            Else
                Dim pRecibo As clsReciboMercancia
                Set pRecibo = New clsReciboMercancia
                sLinea = Trim(left(sLinea, 21))
                If pRecibo.LoadByReferenciaISDOC(sLinea) Then
                    pRecibo.Show
                End If
                Set pRecibo = Nothing
            End If
        End If
    
    End If

End Sub
