VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDiferidosBanco"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 120

'------------------------------------------------------------------------------------------------------------------------
'Ejecucin  Tipo Descripcion                              Referencia            Debitos         Creditos   Disponibilidad
'------------------------------------------------------------------------------------------------------------------------
'99-99-9999 CH   XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999999999999 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99

'07-09-2001      Disponibilidad Actual                    0000000000       3.412.931,15                      3.412.931,15
'10-09-2001 DP   Lote VISA TC: VISA                       0000109888         265.140,00                      3.678.071,15
'19-09-2001 CH   Comision sobre ventas                    0000215303                          132.500,00     3.545.571,15
'  10      1 2 3 TOTALES (40)                            1      12    1       16       1       16       1     16

Private TotalDebitos As Currency, TotalCreditos As Currency, Disponibilidad As Currency
Private pBanco As clsBancos
Private fView As lfQuickView

Private Sub Encabezado()

    If fView.Linea > 1 Then
        PasarTotalPagina "VAN"
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de Movimientos Diferidos", vbCenter
    fView.Add "BANCO: " & pBanco.Nombre & " (" & pBanco.Codigo & ")", vbCenter

    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    
    fView.Add String(AnchoReporte, "-")
    fView.Add "Ejecucin  Tipo Descripcion                              Referencia            Debitos         Creditos   Disponibilidad"
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
        PasarTotalPagina "VIENEN"
    End If

End Sub

Private Sub PasarLineaDisponibilidad()
Dim sOut As String

    Disponibilidad = pBanco.Disponibilidad
    sOut = stFullLength(Format(Date, "Short Date"), 16) & stFullLength("Disponibilidad Actual", 88) & FormatNumero(Disponibilidad, Empresa.MascaraMonetarios, 16)
    fView.Add sOut

End Sub

Private Sub PasarTotalPagina(istrVanVienen As String)
Dim sOut As String

    sOut = stFullLength(istrVanVienen, 70) & FormatNumero(TotalDebitos, Empresa.MascaraMonetarios, 16) & " "
    sOut = sOut & FormatNumero(TotalCreditos, Empresa.MascaraMonetarios, 16)
    If istrVanVienen <> "TOTAL" Then
        sOut = sOut & " " & FormatNumero(Disponibilidad, Empresa.MascaraMonetarios, 16)
    End If
    
    fView.Add sOut

End Sub

Private Sub PasarLineaDetalle(ByVal dtFechaMov As Date, ByVal iTipo As Integer, ByVal strDescripcion As String, ByVal strReferencia As String, ByVal vmMonto As Currency)
Dim sOut As String

    If fView.Linea > fView.LineasPagina - 5 Then
    
        Encabezado
    
    End If

    sOut = stFullLength(Format(dtFechaMov, "Short Date"), 10) & " "
    Select Case iTipo
    Case 0
        sOut = sOut & "CH   "
        TotalCreditos = TotalCreditos + vmMonto
        Disponibilidad = Disponibilidad - vmMonto
    Case 3
        sOut = sOut & "ND   "
        TotalCreditos = TotalCreditos + vmMonto
        Disponibilidad = Disponibilidad - vmMonto
    Case Else
        sOut = sOut & "DP   "
        TotalDebitos = TotalDebitos + vmMonto
        Disponibilidad = Disponibilidad + vmMonto
    End Select

    sOut = sOut & stFullLength(strDescripcion, 40) & " "
    sOut = sOut & stFullLength(strReferencia, 12) & " "

    If iTipo = 0 Or iTipo = 3 Then
        sOut = sOut & String(17, " ")
    End If
    
    sOut = sOut & FormatNumero(vmMonto, Empresa.MascaraMonetarios, 16) & " "

    If iTipo = 1 Then
        sOut = sOut & String(17, " ")
    End If

    sOut = sOut & FormatNumero(Disponibilidad, Empresa.MascaraMonetarios, 16)
    
    fView.Add sOut
    
End Sub


Public Sub Go(istrCodigoBanco As String)
Dim rs As Recordset

    Set pBanco = New clsBancos
    
    If pBanco.Load(istrCodigoBanco) Then
    
        Set rs = dbHandle.Execute("SELECT * FROM DiferidosBanco WHERE CodigoBanco = " & StringDB(pBanco.Codigo) & " ORDER BY FechaPresentacion ASC, TipoMovimiento DESC")
        If rs.EOF Then
            mAdvertencia "ListaDiferidosBanco: No hay datos para el reporte"
        Else
            Set fView = New lfQuickView
            fView.SetReportWidth AnchoReporte
            TotalDebitos = 0: TotalCreditos = 0
            Encabezado
            PasarLineaDisponibilidad
            Do While Not rs.EOF
                PasarLineaDetalle _
                    GetDateFromVariant(rs.Fields("FechaPresentacion")), _
                    GetNumeroFromVariant(rs.Fields("TipoMovimiento")), _
                    stGetStringFromVariant(rs.Fields("Descripcion")), _
                    stGetStringFromVariant(rs.Fields("RefBanco")), _
                    GetNumeroFromVariant(rs.Fields("MontoDiferido"))
                rs.MoveNext
            Loop
            PasarTotalPagina "TOTAL"
            
            ShowNonModal fView
            
            Unload fView
            Set fView = Nothing
        End If
        Set rs = Nothing
    
    End If
    
    Set pBanco = Nothing

End Sub
