VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDiariaZ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 132

' SELECT idTerminal, idCierre, qFacturas, PrimeraFactura, UltimaFactura, Gravable, Exento, Impuesto
' FROM CierresZ
' WHERE Apertura BETWEEN dtInicial AND dtFinal
' ORDER BY idTerminal, idCierre

' Sub totales por terminal
Private lstFacturas As Long, vmstGravable1 As Currency, vmstImpuesto1 As Currency, vmstGravable2 As Currency, vmstImpuesto2 As Currency, vmstExento As Currency
' Totales generales
Private ltFacturas As Long, vmtGravable1 As Currency, vmtImpuesto1 As Currency, vmtGravable2 As Currency, vmtImpuesto2 As Currency, vmtExento As Currency
Private fView As lfQuickView, dtInicial As Date, dtFinal As Date
Private dtTag As Date

'------------------------------------------------------------------------------------------------------------------------------------
'TermID Cierre Fecha Q.Fact   Desde  Hasta          Exento        Base VG    Impuesto VG         Base P     Impuesto P          Total
'------------------------------------------------------------------------------------------------------------------------------------
'99999  999999 99-99 999999 9999999 9999999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'                    999999                 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'12345678901234567890      12345678901234567

Private Sub Encabezado()
  If fView.Linea > 1 Then
    fView.PageBreak
  End If

  fView.Add ""
  fView.Add ""
  fView.Add Empresa.NombreEmpresa, vbCenter
  fView.Add "RIF: " & Empresa.RIF, vbCenter
  Dim i As Integer
  i = 0
  Do
    Dim sEnv As String
    sEnv = GetSetting("ClearLight", "General", "LineasLV" & Trim(i))
    If sEnv <> "" Then
      fView.Add sEnv, vbCenter
    Else
      Exit Do
    End If
    i = i + 1
  Loop
  fView.Add "Total de ventas POS por Da (Cierres Z)", vbCenter
  fView.Add "Entre el " & Format(dtInicial, "Short Date") & " y el " & Format(dtFinal, "Short Date"), vbCenter
  fView.Add ""
  fView.Add LineJustify(AnchoReporte, "Emision: " & Format(Now, "General Date"), "Operador: " & UsuarioActivo.Codigo & ".", "Pgina: " & Format(fView.Pagina, "0000"))
  fView.Add String(AnchoReporte, "-")
  fView.Add "TermID Cierre Fecha Q.Fact   Desde  Hasta          Exento " & stRightAlign(GetSetting("ClearLight", "General", "BaseVG", "Base VG"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "ImpuestoVG", "Impuesto VG"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "BaseTP", "Base TP"), 14) & " " & stRightAlign(GetSetting("ClearLight", "General", "ImpuestoTP", "Impuesto TP"), 14) & "          Total"
  fView.Add String(AnchoReporte, "-")
End Sub

'------------------------------------------------------------------------------------------------------------------------------------
'TermID Cierre Fecha Q.Fact   Desde  Hasta          Exento        Base VG    Impuesto VG         Base P     Impuesto P          Total
'------------------------------------------------------------------------------------------------------------------------------------
'99999  999999 99-99 999999 9999999 9999999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'                    999999                 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99
'12345678901234567890      12345678901234567
Private Sub LineaTotal(dtFecha As Date, tqFact As Long, tExento As Currency, tGravable1 As Currency, tImpuesto1 As Currency, tGravable2 As Currency, tImpuesto2 As Currency)
Dim sOut As String

    sOut = String(8, " ") & "TOTAL " & Format(dtFecha, "dd-mm") & " " & FormatNumero(tqFact, "#####0", 6) & String(17, " ")
    sOut = sOut & FormatNumero(tExento, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable1 + tImpuesto1 + tGravable2 + tImpuesto2 + tExento, Empresa.MascaraMonetarios, 14)
    fView.Add sOut

End Sub

Private Sub Ruptura(ByVal dtFecha As Date)
Dim orglTag As Date

    orglTag = dtTag
    If Year(orglTag) <> 1900 Then
        LineaTotal orglTag, lstFacturas, vmstExento, vmstGravable1, vmstImpuesto1, vmstGravable2, vmstImpuesto2
    End If

    dtTag = dtFecha
    ltFacturas = ltFacturas + lstFacturas: lstFacturas = 0
    vmtExento = vmtExento + vmstExento: vmstExento = 0
    vmtGravable1 = vmtGravable1 + vmstGravable1: vmstGravable1 = 0
    vmtGravable2 = vmtGravable2 + vmstGravable2: vmstGravable2 = 0
    
    vmtImpuesto1 = vmtImpuesto1 + vmstImpuesto1: vmstImpuesto1 = 0
    vmtImpuesto2 = vmtImpuesto2 + vmstImpuesto2: vmstImpuesto2 = 0

End Sub

Private Sub AddLinea( _
    ByVal lngTermID As Long, ByVal lngNumCierre As Long, ByVal dtFecha As Date, ByVal qFact As Long, _
    ByVal lngDesde As Long, ByVal lngHasta As Long, ByVal vmExento As Currency, _
    ByVal vmGravable1 As Currency, vmGravable2 As Currency, ByVal vmImpuesto1 As Currency, vmImpuesto2 As Currency)
Dim sOut As String

    If dtFecha <> dtTag Then Ruptura dtFecha

    If fView.Linea > fView.LineasPagina - 3 Then Encabezado

    sOut = Format(lngTermID, "00000") & "  " & Format(lngNumCierre, "000000") & " " & Format(dtFecha, "dd-mm") & " " & FormatNumero(qFact, "#####0", 6) & " "
    sOut = sOut & Format(lngDesde, "0000000") & " " & Format(lngHasta, "0000000") & " "
    sOut = sOut & FormatNumero(vmExento, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmGravable1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmImpuesto1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmGravable2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmImpuesto2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmGravable1 + vmGravable2 + vmExento + vmImpuesto1 + vmImpuesto2, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut
    
    lstFacturas = lstFacturas + qFact
    vmstGravable1 = vmstGravable1 + vmGravable1
    vmstGravable2 = vmstGravable2 + vmGravable2
    vmstImpuesto1 = vmstImpuesto1 + vmImpuesto1
    vmstImpuesto2 = vmstImpuesto2 + vmImpuesto2
    vmstExento = vmstExento + vmExento

End Sub

Private Sub LineaTotalG(sTitulo As String, tqFact As Long, tExento As Currency, tGravable1 As Currency, tImpuesto1 As Currency, tGravable2 As Currency, tImpuesto2 As Currency)
Dim sOut As String

    sOut = stFullLength(sTitulo, 19) & " " & FormatNumero(tqFact, "#####0", 6) & String(17, " ")
    sOut = sOut & FormatNumero(tExento, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto1, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tImpuesto2, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(tGravable1 + tImpuesto1 + tGravable2 + tImpuesto2 + tExento, Empresa.MascaraMonetarios, 14)
    fView.Add sOut

End Sub

Public Sub Generar(ByVal dtFechaInicial As Date, ByVal dtFechaFinal As Date)
Dim stQuery As String, rs As Recordset

    dtInicial = dtFechaInicial: dtFinal = dtFechaFinal
    
    stQuery = "SELECT Apertura, idTerminal, Numero, qFacturas, PrimeraFactura, UltimaFactura, Gravable1, Gravable2, Exento, Impuesto1, Impuesto2 "
    stQuery = stQuery & "FROM CierresZ WHERE Apertura BETWEEN " & FechaDB(dtFechaInicial) & " AND " & FechaDB(dtFechaFinal) & " "
    stQuery = stQuery & "ORDER BY Apertura, idTerminal"

    Set rs = dbHandle.Execute(stQuery)

    If Not rs.EOF Then

        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Totales de Cierres Diarios"
        fView.SetNotify Me

        dtTag = #1/1/1900#
        Encabezado
        
        With rs
        Do While Not .EOF

'idTerminal, idCierre, qFacturas, PrimeraFactura, UltmaFactura, Gravable, Exento, Impuesto
            AddLinea _
                GetNumeroFromVariant(.Fields("idTerminal")), _
                GetNumeroFromVariant(.Fields("Numero")), _
                GetDateFromVariant(.Fields("Apertura")), _
                GetNumeroFromVariant(.Fields("qFacturas")), _
                GetNumeroFromVariant(.Fields("PrimeraFactura")), _
                GetNumeroFromVariant(.Fields("UltimaFactura")), _
                GetNumeroFromVariant(.Fields("Exento")), _
                GetNumeroFromVariant(.Fields("Gravable1")), _
                GetNumeroFromVariant(.Fields("Gravable2")), _
                GetNumeroFromVariant(.Fields("Impuesto1")), _
                GetNumeroFromVariant(.Fields("Impuesto2"))

            rs.MoveNext
            
        Loop
        End With
        
        Ruptura Date
        LineaTotalG "TOT.GENERAL", ltFacturas, vmtExento, vmtGravable1, vmtImpuesto1, vmtGravable2, vmtImpuesto2

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If

    Set rs = Nothing

End Sub

Public Sub ReportClicked(stLinea As String, nPos As Long)
Dim lNumTerm As Long, lNumCierre As Long
Dim pResumen As clsResumenZ

    stLinea = Trim(stLinea)
    lNumTerm = Val(Mid(stLinea, 1, 5))
    If (lNumTerm = 0) Then Exit Sub
    lNumCierre = Val(Mid(stLinea, 8, 6))
    If (lNumCierre = 0) Then Exit Sub

    Set pResumen = New clsResumenZ
    pResumen.Generar lNumCierre, lNumTerm
    Set pResumen = Nothing

End Sub

