VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDevVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoCronologico = 138, AnchoPorCliente = 76

Dim fView As lfQuickView
Dim finic As Date, ffinal As Date
Dim AnchoReporte As Long, bPorCliente As Boolean
Dim vmTotalVentas As Currency, vmTotalIVA As Currency
Dim vmSubTotV As Currency, vmSubTotIVA As Currency
Dim ControlTag As String, sNombreTag As String

Private Sub Encabezado(isRuptura As Boolean)
    
    If fView.Linea > 1 Or fView.Pagina > 1 Then
        
        If bPorCliente Then
            If Not isRuptura Then
                PrintLineaP "VAN", "", "", vmSubTotV, vmSubTotIVA
            End If
        Else
            PrintLineaC "VAN", "", "", "", "", vmTotalVentas, vmTotalIVA
        End If
        
        fView.PageBreak
        
    End If

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado General de Devoluciones de Ventas", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    
    fView.Add String(AnchoReporte, "-")
    If bPorCliente Then
        fView.Add " Numero Factura         Fecha   Valor Devuelto       Impuesto          Total"
    Else
        fView.Add " Numero Nombre del Cliente                       Cdigo Cliente       Factura      Fecha      Valor Devuelto       Impuesto          Total"
    End If
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
    
        If bPorCliente Then
            If Not isRuptura Then
                fView.Add "CLIENTE: " & sNombreTag & "... (" & ControlTag & ")"
                PrintLineaP "VIENEN", "", "", vmSubTotV, vmSubTotIVA
            End If
        Else
            PrintLineaC "VIENEN", "", "", "", "", vmTotalVentas, vmTotalIVA
        End If
    
    End If

End Sub

'------------------------------------------------------------------------------------------------------------------------------------------
' Numero Nombre del Proveedor                     Cdigo Proveedor     Factura      Fecha      Valor Devuelto       Impuesto          Total
'------------------------------------------------------------------------------------------------------------------------------------------
'9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub PrintLineaC(Numero As Long, _
                        sRefFact As String, _
                        sNombreProv As String, _
                        sCodProv As String, _
                        sFecha As String, _
                        vmCompra As Currency, _
                        vmIVA As Currency)
Dim sOut As String

    If Numero Then
        sOut = Format(Numero, "0000000") & " "
    Else
        sOut = String(8, " ")
    End If

    sOut = sOut & stFullLength(sNombreProv, 40) & " "
    sOut = sOut & stFullLength(sCodProv, 20) & " "
    sOut = sOut & stFullLength(sRefFact, 12) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "

    fView.Add sOut

End Sub

'----------------------------------------------------------------------------
' Numero Factura         Fecha   Valor Devuelto       Impuesto          Total
'----------------------------------------------------------------------------
'9999999 XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub PrintLineaP(lNumero As Long, sRefFact As String, sFecha As String, vmCompra As Currency, vmIVA As Currency)
Dim sOut As String

    If lNumero Then
        sOut = Format(lNumero, "0000000") & " "
    Else
        sOut = String(8, " ")
    End If
    
    sOut = sOut & stFullLength(sRefFact, 12) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "
    
    fView.Add sOut

End Sub

Private Sub Ruptura(sNewTag As String, sNewName As String)

    If ControlTag <> "" Then PrintLineaP 0, "       TOTAL", "CLIENTE", vmSubTotV, vmSubTotIVA
    
    vmSubTotV = 0: vmSubTotIVA = 0
    
    If sNewTag = "" Then
        fView.Add ""
        Exit Sub
    End If

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    ControlTag = sNewTag
    sNombreTag = sNewName
    
    fView.Add "CLIENTE: " & sNombreTag & " (" & ControlTag & ")"

End Sub


Private Sub PasarLinea(NumeroDevolucion As Long, _
                       CodigoProveedor As String, _
                       NombreProveedor As String, _
                       FactProveedor As String, _
                       FechaTransaccion As Date, _
                       ValorCompra As Currency, _
                       Impuesto As Currency)
                    
    If bPorCliente Then
        If CodigoProveedor <> ControlTag Then
            Ruptura CodigoProveedor, NombreProveedor
        End If
    End If

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado False
    End If
    
    If bPorCliente Then
        
        PrintLineaP NumeroDevolucion, FactProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, Impuesto
        vmSubTotV = vmSubTotV + ValorCompra
        vmSubTotIVA = vmSubTotIVA + Impuesto
    
    Else
        
        PrintLineaC NumeroDevolucion, FactProveedor, NombreProveedor, CodigoProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, Impuesto
    
    End If

    vmTotalVentas = vmTotalVentas + ValorCompra
    vmTotalIVA = vmTotalIVA + Impuesto

End Sub


'SELECT C.*, P.Nombre
'FROM DevolucionesCompra AS C, Proveedores AS P
'WHERE C.FechaTransaccion BETWEEN #2000-01-01# AND #2000-08-10#
'AND       C.CodigoProveedor = P.Codigo
'ORDER BY C.FechaTransaccion, C.Numero;

Public Sub Generar()
Dim rs As Recordset, f As frmFiltroFacturas
Dim sQuery As String, sNext As String, pFactura As clsFacturas

    Set f = New frmFiltroFacturas
    
    f.Caption = "Listado de Devoluciones de Ventas"
    f.optSortByVendedor.Enabled = False
    f.DisableSelectVendedor
    
    ShowNonModal f
    
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    bPorCliente = (f.optSortByCliente.Value = True)
    finic = f.ucSelectRango1.FechaInicial
    ffinal = f.ucSelectRango1.FechaFinal

    sQuery = "SELECT D.* FROM DevolucionesVenta D, Clientes C WHERE D.CodigoCliente = C.Codigo AND D.FechaTransaccion BETWEEN " & FechaDB(f.ucSelectRango1.FechaInicial) & " AND " & FechaDB(f.ucSelectRango1.FechaFinal)
    
    sNext = f.ucCriteriosCliente1.FiltroSQL("C")
    If sNext <> "" Then sQuery = sQuery & " AND " & sNext
    
    sNext = Trim(f.txSeries.Text)
    If sNext <> "" Then sQuery = sQuery & " AND D.Serie IN (" & sNext & ")"

    If bPorCliente Then
        sQuery = sQuery & " ORDER BY D.CodigoCliente, D.FechaTransaccion, D.Numero"
    Else
        sQuery = sQuery & " ORDER BY D.FechaTransaccion, D.Numero"
    End If

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    
    Unload f
    Set f = Nothing

    If Not rs.EOF Then
    
        If bPorCliente Then
            AnchoReporte = AnchoPorCliente
        Else
            AnchoReporte = AnchoCronologico
        End If

        Set fView = New lfQuickView
        fView.SetReportWidth (AnchoReporte)
        fView.Caption = "Listado General de Devoluciones de Compras"
        fView.SetNotify Me

        vmTotalVentas = 0: vmTotalIVA = 0
        vmSubTotV = 0: vmSubTotIVA = 0
        ControlTag = "": sNombreTag = ""

        Encabezado False
        
        Set pFactura = New clsFacturas
        
        Do While Not rs.EOF
        
            If rs!NumeroFactura <> 0 Then
                If Not pFactura.Load(rs!NumeroFactura) Then
                    sNext = "iRef:" & Format(rs!NumeroFactura, "000000")
                Else
                    sNext = pFactura.Referencia
                End If
            Else
                sNext = ""
            End If
            
            PasarLinea rs!Numero, rs!CodigoCliente, rs!NombreCliente, sNext, rs!FechaTransaccion, rs!Valor, rs!Impuesto1 + rs!Impuesto2
            rs.MoveNext

        Loop
        
        Set pFactura = Nothing

        If bPorCliente Then
            Ruptura "", ""
            PrintLineaP 0, "       TOTAL", "GENERAL", vmTotalVentas, vmTotalIVA
        Else
            PrintLineaC 0, "", "TOTAL GENERAL", "", "", vmTotalVentas, vmTotalIVA
        End If
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault
        
End Sub

    Private Sub ShowCliente(sCodCli As String)
    Dim pCliente As clsClientes
    
        Set pCliente = New clsClientes
        If pCliente.Load(sCodCli) Then
            pCliente.Show
        End If
        Set pCliente = Nothing
    
    End Sub

    Private Sub ShowDevolucion(sNumero As String)
    Dim pDev As clsDevolucionVenta, lNumero As Long
    
        lNumero = Val(sNumero)
        Set pDev = New clsDevolucionVenta
        If pDev.Load(lNumero) Then
            pDev.Show
        End If
        Set pDev = Nothing

    End Sub

    Private Sub ShowFactura(sNumero As String)
    Dim pFact As clsFacturas
        
        Set pFact = New clsFacturas
        If pFact.LoadByReferenciaISDOC(sNumero) Then
            pFact.Show
        End If
        Set pFact = Nothing
        
        Exit Sub
    
    End Sub

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim sTemp As String, sLocal As String

    sTemp = Trim(sLinea)

    If left(sTemp, 8) = "CLIENTE:" Then
    
        ShowCliente sExtractRightCode(sTemp)

    Else
    
        If bPorCliente Then
'----------------------------------------------------------------------------
' Numero Factura         Fecha   Valor Devuelto       Impuesto          Total
'----------------------------------------------------------------------------
'9999999 XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99
            Select Case lPos
            
            Case 1 To 7
            
                sLocal = Trim(left(sTemp, 7))
                ShowDevolucion sLocal
            
            Case 9 To 20
            
                sLocal = Trim(Mid(sTemp, 9, 12))
                ShowFactura sLocal
            
            End Select
            
        Else
'------------------------------------------------------------------------------------------------------------------------------------------
' Numero Nombre del Proveedor                     Cdigo Proveedor     Factura      Fecha      Valor Devuelto       Impuesto          Total
'------------------------------------------------------------------------------------------------------------------------------------------
'9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99
            Select Case lPos
            
            Case 1 To 7
            
                sLocal = Trim(left(sTemp, 7))
                ShowDevolucion sLocal
            
            Case 9 To 69
            
                sLocal = Trim(Mid(sTemp, 50, 20))
                ShowCliente sLocal
                
            Case 71 To 84
            
                sLocal = Trim(Mid(sTemp, 71, 12))
                ShowFactura sLocal
            
            End Select
            
        End If
    
    End If


End Sub
