VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDevCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoCronologico = 138, AnchoPorProveedor = 76

Dim fView As lfQuickView
Dim finic As Date, ffinal As Date
Dim AnchoReporte As Long, bPorProveedor As Boolean
Dim vmTotalCompras As Currency, vmTotalIVA As Currency
Dim vmSubTotC As Currency, vmSubTotIVA As Currency
Dim ControlTag As String, sNombreTag As String

Private Sub Encabezado(isRuptura As Boolean)
    
    If fView.Linea > 1 Or fView.Pagina > 1 Then
        
        If bPorProveedor Then
            If Not isRuptura Then
                PrintLineaP "VAN", "", "", vmSubTotC, vmSubTotIVA
            End If
        Else
            PrintLineaC "VAN", "", "", "", "", vmTotalCompras, vmTotalIVA
        End If
        
        fView.PageBreak
        
    End If

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado General de Devoluciones de Compra", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    
    fView.Add String(AnchoReporte, "-")
    If bPorProveedor Then
        fView.Add " Numero Factura         Fecha   Valor Devuelto       Impuesto          Total"
    Else
        fView.Add " Numero Nombre del Proveedor                     Cdigo Proveedor     Factura      Fecha      Valor Devuelto       Impuesto          Total"
    End If
    fView.Add String(AnchoReporte, "-")
    
    If fView.Pagina > 1 Then
    
        If bPorProveedor Then
            If Not isRuptura Then
                fView.Add "PROVEEDOR: " & sNombreTag & "... (" & ControlTag & ")"
                PrintLineaP "VIENEN", "", "", vmSubTotC, vmSubTotIVA
            End If
        Else
            PrintLineaC "VIENEN", "", "", "", "", vmTotalCompras, vmTotalIVA
        End If
    
    End If

End Sub

'------------------------------------------------------------------------------------------------------------------------------------------
' Numero Nombre del Proveedor                     Cdigo Proveedor     Factura      Fecha      Valor Devuelto       Impuesto          Total
'------------------------------------------------------------------------------------------------------------------------------------------
'9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub PrintLineaC(Numero As Long, _
                        sRefFact As String, _
                        sNombreProv As String, _
                        sCodProv As String, _
                        sFecha As String, _
                        vmCompra As Currency, _
                        vmIVA As Currency)
Dim sOut As String

    If Numero Then
        sOut = Format(Numero, "0000000") & " "
    Else
        sOut = String(8, " ")
    End If

    sOut = sOut & stFullLength(sNombreProv, 40) & " "
    sOut = sOut & stFullLength(sCodProv, 20) & " "
    sOut = sOut & stFullLength(sRefFact, 12) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "

    fView.Add sOut

End Sub

'----------------------------------------------------------------------------
' Numero Factura         Fecha   Valor Devuelto       Impuesto          Total
'----------------------------------------------------------------------------
'9999999 XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub PrintLineaP(lNumero As Long, sRefFact As String, sFecha As String, vmCompra As Currency, vmIVA As Currency)
Dim sOut As String

    If lNumero Then
        sOut = Format(lNumero, "0000000") & " "
    Else
        sOut = String(8, " ")
    End If
    
    sOut = sOut & stFullLength(sRefFact, 12) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & FormatNumero(vmCompra, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmIVA, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vmCompra + vmIVA, Empresa.MascaraMonetarios, 14) & " "
    
    fView.Add sOut

End Sub

Private Sub Ruptura(sNewTag As String, sNewName As String)

    If ControlTag <> "" Then PrintLineaP 0, "       TOTAL", "PROVEEDOR", vmSubTotC, vmSubTotIVA
    
    vmSubTotC = 0: vmSubTotIVA = 0
    
    If sNewTag = "" Then
        fView.Add ""
        Exit Sub
    End If

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    ControlTag = sNewTag
    sNombreTag = sNewName
    
    fView.Add "PROVEEDOR: " & sNombreTag & " (" & ControlTag & ")"

End Sub


Private Sub PasarLinea(NumeroDevolucion As Long, _
                       CodigoProveedor As String, _
                       NombreProveedor As String, _
                       FactProveedor As String, _
                       FechaTransaccion As Date, _
                       ValorCompra As Currency, _
                       Impuesto As Currency)
                    
    If bPorProveedor Then
        If CodigoProveedor <> ControlTag Then
            Ruptura CodigoProveedor, NombreProveedor
        End If
    End If

    If fView.Linea > fView.LineasPagina - 2 Then
        Encabezado False
    End If
    
    If bPorProveedor Then
        
        PrintLineaP NumeroDevolucion, FactProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, Impuesto
        vmSubTotC = vmSubTotC + ValorCompra
        vmSubTotIVA = vmSubTotIVA + Impuesto
    
    Else
        
        PrintLineaC NumeroDevolucion, FactProveedor, NombreProveedor, CodigoProveedor, Format(FechaTransaccion, "Short Date"), ValorCompra, Impuesto
    
    End If

    vmTotalCompras = vmTotalCompras + ValorCompra
    vmTotalIVA = vmTotalIVA + Impuesto

End Sub


'SELECT C.*, P.Nombre
'FROM DevolucionesCompra AS C, Proveedores AS P
'WHERE C.FechaTransaccion BETWEEN #2000-01-01# AND #2000-08-10#
'AND       C.CodigoProveedor = P.Codigo
'ORDER BY C.FechaTransaccion, C.Numero;

Public Sub Generar()
Dim rs As Recordset, f As frmFiltroProveedores
Dim sQuery As String, sNext As String, pRecMerc As clsReciboMercancia

    Set f = New frmFiltroProveedores
    f.Caption = "Listado de Devoluciones de Compras"
    f.SetInterval True
    ShowNonModal f
    
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If

    bPorProveedor = f.sortByProveedor
    finic = f.ucSelectRango1.FechaInicial
    ffinal = f.ucSelectRango1.FechaFinal

    sQuery = "SELECT C.*, P.Nombre FROM DevolucionesCompra C, Proveedores P WHERE C.CodigoProveedor = P.Codigo AND C.FechaTransaccion " & f.ClausulaRango
    sNext = f.FiltroSQL("P")
    If sNext <> "" Then sQuery = sQuery & " AND " & sNext
    If bPorProveedor Then
        sQuery = sQuery & " ORDER BY C.CodigoProveedor, C.FechaTransaccion, C.Numero"
    Else
        sQuery = sQuery & " ORDER BY C.FechaTransaccion, C.Numero"
    End If
        
    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)
    
    Unload f
    Set f = Nothing

    If Not rs.EOF Then
    
        If bPorProveedor Then
            AnchoReporte = AnchoPorProveedor
        Else
            AnchoReporte = AnchoCronologico
        End If

        Set fView = New lfQuickView
        fView.SetReportWidth (AnchoReporte)
        fView.Caption = "Listado General de Devoluciones de Compras"
        fView.SetNotify Me

        vmTotalCompras = 0: vmTotalIVA = 0
        vmSubTotC = 0: vmSubTotIVA = 0
        ControlTag = "": sNombreTag = ""

        Encabezado False
        
        Set pRecMerc = New clsReciboMercancia
        
        Do While Not rs.EOF
        
            If rs!Factura <> 0 Then
                If Not pRecMerc.Load(rs!Factura) Then
                    pRecMerc.RefProveedor = ""
                End If
            Else
                pRecMerc.RefProveedor = ""
            End If
            
            PasarLinea rs!Numero, rs!CodigoProveedor, rs!Nombre, pRecMerc.RefProveedor, rs!FechaTransaccion, rs!ValorMercancia, rs!Impuesto1 + rs!Impuesto2
            rs.MoveNext

        Loop
        
        Set pRecMerc = Nothing

        If bPorProveedor Then
            Ruptura "", ""
            PrintLineaP 0, "       TOTAL", "GENERAL", vmTotalCompras, vmTotalIVA
        Else
            PrintLineaC 0, "", "TOTAL GENERAL", "", "", vmTotalCompras, vmTotalIVA
        End If
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault

End Sub

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim sLocal As String

    sLocal = Trim(sLinea)
    
    If left(sLocal, 10) = "PROVEEDOR:" Then
        
        sLocal = sExtractRightCode(sLinea)
        ShowProveedor sLocal

    Else
        
        If bPorProveedor Then
'----------------------------------------------------------------------------
' Numero Factura         Fecha   Valor Devuelto       Impuesto          Total
'----------------------------------------------------------------------------
'9999999 XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99
            Select Case lPos
            
            Case 1 To 7
            
                sLocal = Trim(left(sLocal, 7))
                ShowDevolucion sLocal
            
            Case 9 To 20
            
                sLocal = Trim(Mid(sLocal, 9, 12))
                ShowFactura sLocal, Trim(left(sLinea, 8))
            
            End Select
            
        Else
'------------------------------------------------------------------------------------------------------------------------------------------
' Numero Nombre del Proveedor                     Cdigo Proveedor     Factura      Fecha      Valor Devuelto       Impuesto          Total
'------------------------------------------------------------------------------------------------------------------------------------------
'9999999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 99-99-9999 999.999.999,99 999.999.999,99 999.999.999,99
            Select Case lPos
            
            Case 1 To 7
            
                sLocal = Trim(left(sLocal, 7))
                ShowDevolucion sLocal
            
            Case 9 To 69
            
                sLocal = Trim(Mid(sLocal, 50, 20))
                ShowProveedor sLocal
                
            Case 71 To 84
            
                sLocal = Trim(Mid(sLocal, 71, 12))
                ShowFactura sLocal, Trim(left(sLinea, 8))
            
            End Select
            
        End If
        
    End If
        
End Sub


    Private Sub ShowProveedor(sCodProv As String)
    Dim pProveedor As clsProveedores
    
        Set pProveedor = New clsProveedores
        If pProveedor.Load(sCodProv) Then
            pProveedor.Show
        End If
        Set pProveedor = Nothing
    
    End Sub

    Private Sub ShowDevolucion(sNumero As String)
    Dim pDev As clsDevolucionCompra, lNumero As Long
    
        lNumero = Val(sNumero)
        Set pDev = New clsDevolucionCompra
        If pDev.Load(lNumero) Then
            pDev.Show
        End If
        Set pDev = Nothing

    End Sub

    Private Sub ShowFactura(sNumero As String, sNumDev As String)
    Dim pFact As clsReciboMercancia, _
        pDev As clsDevolucionCompra
    
        On Error GoTo ErrHandler
        
        Set pDev = New clsDevolucionCompra
        If pDev.Load(Val(sNumDev)) Then
            sNumero = pDev.CodigoProveedor & "-" & sNumero
        End If
        Set pDev = Nothing

        Set pFact = New clsReciboMercancia
        If pFact.LoadByReferenciaISDOC(sNumero) Then
            pFact.Show
        End If
        Set pFact = Nothing
        
        Exit Sub
        
ErrHandler:
        
        Err.Clear
    
    End Sub

