VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaDetallesSerial"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' >>Empresa<<
'Listado de Movimientos Detallados
'Articulo: XXXXXXX (CCCCCC)
'SERIAL: ZZZZZZZZZZ
'
'Emisin: zxzxzxzxzxzxzxzzz. Operador: OOOOOOOO          Pgina: 9999
'--------------------------------------------------------------------
'Fecha      Referencia       Descripcion
'--------------------------------------------------------------------
'99-99-9999 XXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

Private Const AnchoReporte = 68
Private fView As lfQuickView
Private pItem As clsItemInventario
Private strSerial As String
Private pInstancer As clsInstanciadorEntidad

Private Sub Encabezado()

    If fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Relacin Detallada de Movimientos", vbCenter
    fView.Add "Articulo: " & pItem.Descripcion & " (" & pItem.Codigo & ")", vbCenter
    fView.Add "SERIAL: " & strSerial, vbCenter
    fView.Add ""
    fView.Add stFullLength("Emisin: " & Format(Now, "General Date") & ". OPERADOR: " & UsuarioActivo.Codigo, AnchoReporte - 12) & "Pgina: " & Format(fView.Pagina, "0000")
    fView.Add String(AnchoReporte, "-")
    fView.Add "Fecha      Referencia       Descripcion"
    fView.Add String(AnchoReporte, "-")

End Sub

Private Sub PasarLinea(ipDetalle As clsDetalleSerial)
Dim sOut As String, pDocumento As Object

    Set pDocumento = pInstancer.EntidadDOCUMENTO(ipDetalle.TipoDocumento, ipDetalle.NumeroDocumento)
    sOut = stFullLength(Format(ipDetalle.Fecha, "Short Date"), 11)
    If pDocumento Is Nothing Then
        sOut = sOut & stFullLength(ipDetalle.TipoDocumento & "-" & Format(ipDetalle.NumeroDocumento, "000000"), 16) & " "
        sOut = sOut & "DOCUMENTO NO LOCALIZADO"
    Else
        sOut = sOut & stFullLength(pDocumento.Referencia, 16) & " "
        sOut = sOut & pDocumento.Descripcion
    End If
    Set pDocumento = Nothing

    If fView.Linea > fView.LineasPagina - 2 Then Encabezado

    fView.Add sOut

End Sub

Public Sub Generar(ipItem As clsItemInventario, istrSerial As String)
Dim pSerial As clsSeriales, pDetalle As clsDetalleSerial

    Set pSerial = New clsSeriales
    If pSerial.Load(ipItem.Codigo, istrSerial) Then
        
        Set pItem = ipItem
        strSerial = istrSerial

        If pSerial.IniciarIteradorDetalles Then
        
            Set pInstancer = New clsInstanciadorEntidad
            Set fView = New lfQuickView
            fView.SetReportWidth AnchoReporte
            
            Encabezado
            Do
            
                Set pDetalle = pSerial.NextDetalle
                If Not pDetalle Is Nothing Then PasarLinea pDetalle
            
            Loop While Not pDetalle Is Nothing

            pSerial.EndIteradorDetalles
    
            ShowNonModal fView
            Unload fView
            Set fView = Nothing
            Set pInstancer = Nothing
        End If
    
    End If
    Set pSerial = Nothing

End Sub
