VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaDetEquipos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 126
Private fView As lfQuickView

'------------------------------------------------------------------------------------------------------------------------------
'Tipo     Serial           Propietario                         Falla                                    Recepcion  Estado
'------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXX XXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99-99-1999 XXXXXXXXXXXX

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado Detallado de Equipos en el Taller", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add String(AnchoReporte, "-")
    fView.Add "Tipo     Serial           Propietario                         Falla                                    Recepcion  Estado"
    fView.Add String(AnchoReporte, "-")

End Sub

Private Sub AddLinea(sTipo As String, sSerial As String, sPropietario As String, _
                    sFalla As String, sIngreso As String, sEstado As String)
Dim sOut As String

    sOut = stFullLength(sTipo, 8) & " " & stFullLength(sSerial, 16) & " " & stFullLength(sPropietario, 35)
    sOut = sOut & " " & stFullLength(sFalla, 40) & " " & stFullLength(sIngreso, 10) & " " & sEstado

    fView.Add sOut
End Sub

Public Sub Generar()
Dim pEquipo As clsEquipo, pCliente As clsClientes, pOrden As clsOrdenRWS, n As Integer
Dim vFalla As Variant, rs As Recordset, sNombreCliente As String, sFalla As String, sFecha As String

'SELECT E.TipoEquipo, E.Serial FROM rwsEquipos AS E WHERE E.Estado BETWEEN 1 AND 3

    Set rs = dbHandle.OpenRecordset("SELECT E.TipoEquipo, E.Serial FROM rwsEquipos AS E WHERE E.Estado BETWEEN 1 AND 3", dbOpenForwardOnly)
    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        Set pEquipo = New clsEquipo
        
        Encabezado
        
        Do While Not rs.EOF
        
            If pEquipo.Load(rs.Fields("TipoEquipo"), rs.Fields("Serial")) Then
                Set pOrden = pEquipo.UltimaOrden
                Set pCliente = pEquipo.Cliente
                
                If pCliente Is Nothing Then
                    sNombreCliente = "INVALIDO!!!"
                Else
                    sNombreCliente = pCliente.Nombre
                End If
                
                Set pCliente = Nothing
                
                If pOrden Is Nothing Then
                    sFalla = ""
                    sFecha = ""
                Else
                    sFalla = pOrden.Sintomas
                    sFecha = pOrden.FechaRecepcion
                End If
                
                Set pOrden = Nothing
                
                If sFalla = "" Then
                    ReDim vFalla(1 To 1)
                    vFalla(1) = ""
                Else
                    vFalla = Convert2Lines(sFalla, 40)
                End If
                
                If fView.Linea + UBound(vFalla) + 1 >= fView.LineasPagina Then
                    Encabezado
                End If
                
                AddLinea pEquipo.TipoEquipo, pEquipo.Serial, sNombreCliente, (vFalla(1)), sFecha, pEquipo.ImagenEstado
                For n = 2 To UBound(vFalla)
                    AddLinea "", "", "", (vFalla(n)), "", ""
                Next
            End If
            
            rs.MoveNext
        
        Loop
                
        ShowNonModal fView
    
        Unload fView
        Set fView = Nothing
        
        Set pEquipo = Nothing
    End If
    
    Set rs = Nothing

End Sub
                    

