VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaDetArticulo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const AnchoReporte = 126

Private fView As lfQuickView
Private finic As Date, ffinal As Date
Private sDescripcion As String, sCodigo As String
Private totCantidad As Double, TotValor As Currency

' Empresa
' Lista Detallada de Movimientos
' Articulo: XXXXX (CCCC)
' Entre el XXXXXXX y el XXXXXX
'
' Emision: ddddddd.   Operador: OOOOOOOOOO.    Pgina: ppp
'------------------------------------------------------------------------------------------------------------------------------
'Fecha      Doc Ref. Documento       Alm. Descripcion                                    Cantidad          Costo          Valor
'------------------------------------------------------------------------------------------------------------------------------
'99-99-9999 XXX XXXXXXXXXXXXXXXXXXXX XXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        PrintLinea "VAN", "", "", "", "", totCantidad, 0, TotValor
        fView.PageBreak
    End If

    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado Detallado de Movimientos de Inventario", AnchoReporte)
    fView.Add stMidAlign("Articulo: " & sDescripcion & " (" & sCodigo & ")", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
    fView.Add "------------------------------------------------------------------------------------------------------------------------------"
    fView.Add "Fecha      Doc Ref. Documento       Alm. Descripcion                                    Cantidad          Costo          Valor"
    fView.Add "------------------------------------------------------------------------------------------------------------------------------"
    
    If fView.Pagina > 1 Then
        PrintLinea "VIENEN", "", "", "", "", totCantidad, 0, TotValor
    End If

End Sub

Private Sub PrintLinea(sFecha As String, sTDoc As String, sRefDoc As String, sAlmacen As String, sDescripcion As String, dCantidad As Double, dCosto As Currency, dTotal As Currency)
Dim sOut As String

    sOut = stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sTDoc, 3) & " "
    sOut = sOut & stFullLength(sRefDoc, 20) & " "
    sOut = sOut & stFullLength(sAlmacen, 4) & " "
    sOut = sOut & stFullLength(sDescripcion, 40) & " "
    sOut = sOut & FormatNumero(dCantidad, Empresa.MascaraCantidades, 14) & " "
    sOut = sOut & FormatNumero(dCosto, Empresa.MascaraPrecios, 14) & " "
    sOut = sOut & FormatNumero(dTotal, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut

End Sub

Private Sub PasarLinea(dFecha As Date, sTipoMovimiento As String, dEntradas As Double, dSalidas As Double, vmCostoU As Currency, sAlmacen As String, lNumDocumento As Long, sDescripcionDetalle As String)
Dim pInstancer As clsInstanciadorEntidad, pObjeto As Object
Dim sDescripcion As String, sRefDoc As String

    Set pInstancer = New clsInstanciadorEntidad
    Set pObjeto = pInstancer.EntidadDOCUMENTO(sTipoMovimiento, lNumDocumento)
    
    If pObjeto Is Nothing Then
        sDescripcion = sDescripcionDetalle
        sRefDoc = sTipoMovimiento & "????"
    Else
        sDescripcion = pObjeto.Descripcion
        sRefDoc = pObjeto.Referencia
    End If

    If fView.Linea > fView.LineasPagina - 2 Then Encabezado

    PrintLinea Format(dFecha, "Short Date"), sTipoMovimiento, sRefDoc, sAlmacen, sDescripcion, (dEntradas - dSalidas), vmCostoU, (dEntradas - dSalidas) * vmCostoU

    totCantidad = totCantidad + dEntradas - dSalidas
    TotValor = TotValor + (dEntradas - dSalidas) * vmCostoU

End Sub

Public Sub Generar(sCodProd As String, fDesde As Date, fHasta As Date)
Dim rs As Recordset, sQuery As String, pItem As clsItemInventario

    Set pItem = New clsItemInventario
    If Not pItem.Load(sCodProd) Then
        sDescripcion = "ARTICULO NO ENCONTRADO"
    Else
        sDescripcion = pItem.Descripcion
    End If
    Set pItem = Nothing

    sCodigo = sCodProd
    finic = fDesde: ffinal = fHasta
    
    sQuery = "SELECT D.*, C.Almacen, C.NumeroDocumentoOrigen, C.Descripcion FROM DetallesMINV D, ComprobantesAlmacen C WHERE D.CodigoItem = " & StringDB(sCodProd) & " AND D.FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " AND D.NumeroDocumento = C.Numero"
    
    Screen.MousePointer = vbHourglass

    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        fView.Caption = "Lista detallada de movimientos de inventario"
        fView.SetReportWidth AnchoReporte
        
        Encabezado
        
        Do While Not rs.EOF

            PasarLinea rs!FechaOperacion, rs!TipoMovimiento, rs!Entradas, rs!Salidas, rs!Costo, rs!Almacen, rs!NumeroDocumentoOrigen, rs!Descripcion
            rs.MoveNext
            
        Loop
        
        PrintLinea "TOTAL", "", "", "", "", totCantidad, 0, TotValor

        Screen.MousePointer = vbDefault

        fView.Show
        
        While fView.Visible: DoEvents: Wend
        
        Unload fView
        Set fView = Nothing
    
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault

End Sub
