VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaDespachosOrden"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 106
Private lpOrden As clsOrdenesCompra
Private fView As lfQuickView

'Empresa
'Lista de Entregas Realizadas
'Cotizacion/Pedido N 9999999
'Cliente: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'
'Emision: XXXXXXXXXXXXXXXX. Operador: XCXXXXXXXX.    Pgina: 999
'----------------------------------------------------------------------------------------------------------
'Codigo del Producto  Descripcion                             Precio Unitario        Pedidas      Recibidas
'----------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999,99
'                                      --------------------------------------------------------------------
'                                      DOC-00000000 99-99-9999 999.999.999,99                999.999.999,99
'                                      DOC-00000000 99-99-9999 999.999.999,99                999.999.999,99

Private Sub Encabezado()

    If fView.Linea > 1 Then fView.PageBreak

    fView.Add ""
    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Orden de Compra No. " & Format(lpOrden.Numero, "0000000"), vbCenter
    fView.Add "Proveedor: " & lpOrden.NombreProveedor, vbCenter
    
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".    Pgina: " & fView.Pagina
    fView.Add String(AnchoReporte, "-")
    fView.Add "Codigo del Producto  Descripcion                             Precio Unitario        Pedidas      Recibidas    "
    fView.Add String(AnchoReporte, "-")

End Sub

Private Sub PasarRenglon(pRenglon As clsDetalleOrdenCompra)
Dim colEntregas As Collection, pEntrega As clsDetalleEntregaOC
Dim sOut As String

    Set colEntregas = pRenglon.Entregas
    If fView.Linea + colEntregas.Count + 2 >= fView.LineasPagina Then Encabezado
    sOut = stFullLength(pRenglon.CodigoItem, 20) & " "
    sOut = sOut & stFullLength(pRenglon.Descripcion, 40) & " "
    sOut = sOut & FormatNumero(pRenglon.PrecioRequerido, Empresa.MascaraPrecios, 14) & " "
    sOut = sOut & FormatNumero(pRenglon.Cantidad, Empresa.MascaraCantidades, 14) & " "
    sOut = sOut & FormatNumero(pRenglon.Recibidas, Empresa.MascaraCantidades, 14)
    fView.Add sOut

    If colEntregas.Count > 0 Then
    Dim pInstancer As clsInstanciadorEntidad
    Dim pDocumento As Object
    
        Set pInstancer = New clsInstanciadorEntidad

        sOut = String(38, " ") & String(68, "-")
        fView.Add sOut
        For Each pEntrega In colEntregas
        
            Set pDocumento = pInstancer.EntidadDOCUMENTO(pEntrega.TipoDocumento, pEntrega.NumeroDocumento)
            If Not pDocumento Is Nothing Then
                sOut = String(38, " ")
                sOut = sOut & stFullLength(pDocumento.Referencia, 13)
                sOut = sOut & stFullLength(Format(pDocumento.FechaTransaccion, "Short Date"), 11)
                sOut = sOut & FormatNumero(pEntrega.PrecioUnitario, Empresa.MascaraPrecios, 14) & String(16, " ")
                sOut = sOut & FormatNumero(pEntrega.Cantidad, Empresa.MascaraCantidades, 14)
                fView.Add sOut
            End If
    
        Next
    
        Set pInstancer = Nothing
        fView.Add ""

    End If

End Sub

Public Sub SetOrden(pOrden As clsOrdenesCompra)
Dim pDetalle As clsDetalleOrdenCompra

    Set lpOrden = pOrden
    Set fView = New lfQuickView
    Encabezado
    For Each pDetalle In lpOrden.Detalles
        PasarRenglon pDetalle
    Next
    
    ShowNonModal fView
    Unload fView
    Set fView = Nothing
    
    Set lpOrden = Nothing

End Sub

