VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListaCotizacionesCliente"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private fView As lfQuickView
Private sCodCli As String, sNombreCli As String

Private Const AnchoReporte = 81

'Empresa.
'Listado de Cotizaciones
'Cliente: XXXXXXXXXXXXXXXXXX
'Emision: 99-99-9999.  Operador: XXXXXXXX.       Pgina: 999
'----------------------------------------------------------------------------------
'Numero  Fecha      Monto Cotizado Estado     Vend.  Notas
'----------------------------------------------------------------------------------
'0000000 99-99-9999 999.999.999,99 SATISFECHA 999    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
'                                  APROBADA
'                                  EN PROCESO
'                                  INICIAL

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
    
        fView.PageBreak
    
    End If

    fView.Add ""
    fView.Add ""

    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Listado de cotizaciones"
    fView.Add "Cliente: " & sNombreCli
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".       Pgina: " & fView.Pagina
    fView.Add String(AnchoReporte, "-")
    fView.Add "Numero  Fecha      Monto Cotizado Estado     Vend.  Notas"
    fView.Add String(AnchoReporte, "-")
    
    
End Sub

Private Sub PasarCotizacion(pCotizacion As clsCotizacion)
Dim sOutString As String, vComents As Variant
Dim i As Integer, nComments As Integer

    With pCotizacion
    
    vComents = Convert2Lines(pCotizacion.Notas, 40)

    sOutString = Format(.Numero, "0000000") & " "
    sOutString = sOutString & stFullLength(Format(pCotizacion.FechaTransaccion, "Short Date"), 10) & " "
    sOutString = sOutString & FormatNumero(.PrecioEfectivo, Empresa.MascaraMonetarios, 14) & " "
    sOutString = sOutString & stFullLength(.ImagenEstado, 10) & " "
    On Error Resume Next
    sOutString = sOutString & vComents(1)
    If Err.Number <> 0 Then
        Err.Clear
        nComments = 0
    Else
        nComments = UBound(vComents)
    End If
    End With

    If fView.Linea > fView.LineasPagina - nComments - 1 Then
        Encabezado
    End If

    fView.Add sOutString
    
    For i = 2 To nComments
    
        sOutString = String(37, " ") & vComents(i)
        fView.Add sOutString
    
    Next

End Sub

Public Sub Go(istrCodCli As String, istrNombreCli As String)
Dim pCotizacion As clsCotizacion, colCots As Collection

    Set pCotizacion = New clsCotizacion
    Set colCots = pCotizacion.CotizacionesCliente(istrCodCli)
    
    If colCots.Count Then
    
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        sCodCli = istrCodCli
        sNombreCli = istrNombreCli
        
        fView.SetNotify Me
        
        Encabezado
        For Each pCotizacion In colCots
        
            PasarCotizacion pCotizacion
    
        Next

        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If
    
    Set colCots = Nothing
    Set pCotizacion = Nothing

End Sub

Public Sub ReportClicked(istrTexto As String, nPos As Long)
Dim lng As Long, fView As frmViewCotizacion

    lng = Val(Trim(Left(istrTexto, 8)))
    If lng <= 0 Then Exit Sub

    Set fView = New frmViewCotizacion
    If fView.SetCotizacion(lng) Then
        ShowNonModal fView
    End If
    
    Unload fView
    Set fView = Nothing

End Sub
