VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaCliVend"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
'NombreCliente, CodigoCliente, pLista, pVenta, DescuentosPP, SaldoActual, qFact
'"SELECT NombreCliente, CodigoCliente, SUM(PrecioLista) AS pLista, SUM(PrecioEfectivo) AS pVenta, SUM(DescuentosProntoPago) AS DescuentosPP, SUM(Saldo) AS SaldoActual, Count(Numero) AS qFact
'" FROM Facturas
'" WHERE CodigoVendedor = paramCodVend
'" AND FechaTransaccion BETWEEN paramFINIC AND paramFFINAL
'" GROUP BY NombreCliente, CodigoCliente
'" ORDER BY NombreCliente, CodigoCliente;

Private Const AnchoReporte = 143

Private fView As lfQuickView
Private totVentaLista As Currency, totVentaEfectiva As Currency, totDescuentos As Currency, totSaldo As Currency
Private sCodVend As String, sNombreVend As String
Private finic As Date, ffinal As Date

'-----------------------------------------------------------------------------------------------------------------------------------------------
'Nombre del Cliente                       Cdigo               Q.Fac.   Precio Lista   Precio Venta  Desctos. P.P.     Venta Neta   Saldo Actual
'-----------------------------------------------------------------------------------------------------------------------------------------------
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 99.999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99

Private Sub WriteLinea( _
                    sNombreCli As String, _
                    sCodCli As String, _
                    lQFact As Long, _
                    vPrecioLista As Currency, _
                    vPrecioVenta As Currency, _
                    vDescuentos As Currency, _
                    vSaldo As Currency)
Dim sOut As String

    sOut = stFullLength(sNombreCli, 40) & " " & stFullLength(sCodCli, 20) & " " & FormatNumero(lQFact, "##,##0", 6) & " "
    sOut = sOut & FormatNumero(vPrecioLista, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vPrecioVenta, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vDescuentos, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vPrecioVenta - vDescuentos, Empresa.MascaraMonetarios, 14) & " "
    sOut = sOut & FormatNumero(vSaldo, Empresa.MascaraMonetarios, 14)
    
    fView.Add sOut
    
End Sub

Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        WriteLinea "VAN", "", 0, totVentaLista, totVentaEfectiva, totDescuentos, totSaldo
        fView.PageBreak
    End If
    
    fView.Add ""
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Venta por Clientes del Vendedor " & sNombreVend, AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & "    Operador: " & UsuarioActivo.Codigo & ".    Pgina:" & Str(fView.Pagina)

    fView.Add String(AnchoReporte, "-")
    fView.Add "Nombre del Cliente                       Cdigo               Q.Fac.   Precio Lista   Precio Venta  Desctos. P.P.     Venta Neta   Saldo Actual"
    fView.Add String(AnchoReporte, "-")

    If fView.Pagina > 1 Then
        WriteLinea "VIENEN", "", 0, totVentaLista, totVentaEfectiva, totDescuentos, totSaldo
    End If

End Sub

Private Sub PasarLinea( _
            NombreCliente As String, _
            CodigoCliente As String, _
            pLista As Currency, _
            pVenta As Currency, _
            DescuentosPP As Currency, _
            SaldoActual As Currency, _
            qFact As Long)
    
    If fView.Linea >= fView.LineasPagina - 2 Then
        Encabezado
    End If

    WriteLinea NombreCliente, CodigoCliente, qFact, pLista, pVenta, DescuentosPP, SaldoActual

    totVentaLista = totVentaLista + pLista
    totVentaEfectiva = totVentaEfectiva + pVenta
    totDescuentos = totDescuentos + DescuentosPP
    totSaldo = totSaldo + SaldoActual

End Sub

Public Sub Generar(istCodVend As String, istNombreVend As String)
Dim fFechas As lfSelectRangoFechas, bResult As Boolean
Dim sQuery As String, rs As Recordset

    sCodVend = istCodVend: sNombreVend = istNombreVend

    Set fFechas = New lfSelectRangoFechas
    fFechas.Show 1
    
    bResult = fFechas.Result
    If bResult Then
        finic = fFechas.dtFechaInicial
        ffinal = fFechas.dtFechaFinal
    End If
    
    Unload fFechas
    Set fFechas = Nothing
    
    If Not bResult Then Exit Sub
    

'NombreCliente, CodigoCliente, pLista, pVenta, DescuentosPP, SaldoActual, qFact
    sQuery = "SELECT NombreCliente, CodigoCliente, SUM(PrecioLista) AS pLista, SUM(PrecioEfectivo) AS pVenta, SUM(DescuentosProntoPago) AS DescuentosPP, SUM(Saldo) AS SaldoActual, Count(Numero) AS qFact"
    sQuery = sQuery & " FROM Facturas"
    sQuery = sQuery & " WHERE CodigoVendedor = " & StringDB(sCodVend)
    sQuery = sQuery & " AND FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal)
    sQuery = sQuery & " GROUP BY NombreCliente, CodigoCliente"
    sQuery = sQuery & " ORDER BY NombreCliente, CodigoCliente"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Productos vendidos por " & sNombreVend

        Encabezado
        
        Do While Not rs.EOF
            
            PasarLinea rs!NombreCliente, rs!CodigoCliente, rs!pLista, rs!pVenta, rs!DescuentosPP, rs!SaldoActual, rs!qFact
            rs.MoveNext

        Loop
        
        WriteLinea "TOTAL", "", 0, totVentaLista, totVentaEfectiva, totDescuentos, totSaldo
        fView.SetNotify Me

        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing

    Screen.MousePointer = vbDefault

End Sub

'Nombre del Cliente                       Cdigo               Q.Fac.   Precio Lista   Precio Venta  Desctos. P.P.     Venta Neta   Saldo Actual
'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXX 99.999 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99 999.999.999,99

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim sCodigo As String, pCliente As clsClientes

    sCodigo = Trim(sLinea)
    sCodigo = Mid(sCodigo, 42, 20)
    sCodigo = Trim(sCodigo)

    Set pCliente = New clsClientes
    If pCliente.Load(sCodigo) Then pCliente.Show
    Set pCliente = Nothing

End Sub
