VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaCatCtas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const AnchoReporte = 67
'-------------------------------------------------------------------
'Cuenta                     Descripcin
'-------------------------------------------------------------------
'12345678901234567890123456 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

Dim WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1

Private Sub Encabezado()
    
    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""

    fView.Add Empresa.NombreEmpresa, vbCenter
    fView.Add "Catlogo de Cuentas", vbCenter
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina

    fView.Add String(AnchoReporte, "-")
    fView.Add "Cuenta                     Descripcin"
    fView.Add String(AnchoReporte, "-")

End Sub

Private Sub PasarLinea(stCodigo As String, stDescripcion As String)
Dim sOut As String, sTemp As String

    sTemp = Space$(NivelCuenta(stCodigo) - 1) & stCodigo
    sOut = stFullLength(sTemp, 27) & stDescripcion

    If fView.Linea + 1 >= fView.LineasPagina Then
        Encabezado
    End If
    
    fView.Add sOut

End Sub

Public Sub Generar()
Dim rs As Recordset

    Set rs = dbHandle.Execute("SELECT Codigo, Titulo FROM Cuentas order by Codigo")
    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Catlogo de Cuentas"
        Encabezado
        Do While Not rs.EOF
            PasarLinea rs.Fields("Codigo"), rs.Fields("Titulo")
            rs.MoveNext
        Loop
        ShowNonModal fView
        Unload fView
        Set fView = Nothing
    End If
    Set rs = Nothing

End Sub

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sExtract As String, pCuenta As clsCuenta

  bProcessed = True
  sExtract = Trim(left(Trim(strReportLine), 26))
  Set pCuenta = AlmacenCuentas.Cuenta(sExtract)
  If Not pCuenta Is Nothing Then
    pCuenta.Show
    Set pCuenta = Nothing
  End If
End Sub
