VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaAntigCXC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'SELECT C.Nombre, D.*
'FROM DocumentosISPC AS D, Clientes AS C
'Where D.TipoEntidad = "CLT" And Saldo <> 0
'AND C.Codigo = D.CodigoEntidad
'[AND] <FiltroCliente>
'ORDER BY Nombre, FechaDoc;

Private Const AnchoReporte = 154

Private fView As lfQuickView
Private TotalMonto As Currency, TotalSaldo As Currency, TotalesAntiguedad(0 To 4) As Currency
Private SubTMonto As Currency, SubTSaldo As Currency, SubTAntiguedad(0 To 4) As Currency
Private ControlTag As String, TagName As String
Private rs As Recordset, pDoc As clsDocumentosISPC

Private Sub Encabezado(isRuptura As Boolean)
Dim sOut As String

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Reporte de Antigedad de las Acreencias", AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
    
    fView.Add String(AnchoReporte, "-")
    fView.Add "DOC Referencia                Fecha            Monto            Saldo       Por Vencer      1 - 30 Dias     31 - 60 Dias     61 - 90 Dias   Ms de 90 Das"
    fView.Add String(AnchoReporte, "-")

    If Not isRuptura Then
        sOut = "CLIENTE: "
        sOut = sOut & TagName & " (" & ControlTag & ")"
        fView.Add sOut
    End If

End Sub

Private Sub PrintLinea(sTDoc As String, _
                       sRef As String, _
                       sFecha As String, _
                       vmMonto As Currency, _
                       vmSaldo As Currency, _
                       vmAntiguedad As Variant)
Dim sOut As String, i As Integer

    sOut = stFullLength(sTDoc, 4)
    sOut = sOut & stFullLength(sRef, 21)
    sOut = sOut & stFullLength(sFecha, 11)
    sOut = sOut & FormatNumero(vmMonto, "#,###,###,##0.00", 16) & " "
    sOut = sOut & FormatNumero(vmSaldo, "#,###,###,##0.00", 16)
    For i = 0 To 4
        sOut = sOut & " " & FormatNumero(vmAntiguedad(i), "#,###,###,##0.00", 16)
    Next
    
    fView.Add sOut

End Sub

Private Sub Ruptura()
Dim sOut As String, i As Integer

    If ControlTag <> "" Then
        PrintLinea "", "TOTAL CLIENTE", "", SubTMonto, SubTSaldo, SubTAntiguedad
    End If

    ControlTag = pDoc.CodigoEntidad
    If ControlTag <> "" Then
        TagName = stGetStringFromVariant(rs.Fields("Nombre"))
    Else
        TagName = "EOF"
    End If

    SubTMonto = 0: SubTSaldo = 0
    For i = 0 To 4: SubTAntiguedad(i) = 0: Next

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    If ControlTag <> "" Then
        fView.Add "CLIENTE: " & TagName & " (" & ControlTag & ")"
    End If

End Sub

Private Sub PasarLinea()
Dim vmArray(0 To 4) As Currency, i As Integer, pObject As Object

    pDoc.Maduracion Date, 1, vmArray
    If pDoc.CodigoEntidad <> ControlTag Then Ruptura
    
    SubTMonto = SubTMonto + pDoc.Monto: TotalMonto = TotalMonto + pDoc.Monto
    SubTSaldo = SubTSaldo + pDoc.Saldo: TotalSaldo = TotalSaldo + pDoc.Saldo
    
    For i = 0 To 4
        SubTAntiguedad(i) = SubTAntiguedad(i) + vmArray(i)
        TotalesAntiguedad(i) = TotalesAntiguedad(i) + vmArray(i)
    Next

    If fView.Linea > fView.LineasPagina - 1 Then Encabezado False
    
    Set pObject = pDoc.Documento
    
    If pObject Is Nothing Then
        PrintLinea pDoc.TipoDocumento, pDoc.TipoDocumento & "-" & Format(pDoc.NumeroDocumento, "000000"), Format(pDoc.FechaDoc, "Short Date"), pDoc.Monto, pDoc.Saldo, vmArray
    Else
        PrintLinea pDoc.TipoDocumento, pObject.Referencia, Format(pDoc.FechaDoc, "Short Date"), pDoc.Monto, pDoc.Saldo, vmArray
    End If

    Set pObject = Nothing
    
End Sub

'----------------------------------------------------------------------------------------------------------------------------------------------------------
'DOC Referencia                Fecha            Monto            Saldo       Por Vencer      1 - 30 Dias     31 - 60 Dias     61 - 90 Dias   Ms de 90 Das
'----------------------------------------------------------------------------------------------------------------------------------------------------------
'CLIENTE: XXXXXXXXX (XXXXXXXX)
'XXX XXXXXXXXXXXXXXXXXXXX 99-99-9999 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99
'    TOTAL                           9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99 9.999.999.999,99

Public Sub Generar()
Dim sQuery As String, sCondCli As String
Dim bResult As Boolean
Dim i As Integer, f As frmFiltroClientes

    sCondCli = ""
    Set f = New frmFiltroClientes
    f.Show
    Do While f.Visible: DoEvents: Loop
    bResult = f.Result
    If bResult Then sCondCli = Trim(f.FiltroSQL("C"))
    Unload f
    Set f = Nothing

    If Not bResult Then Exit Sub

    sQuery = "SELECT C.Nombre, D.* "
    sQuery = sQuery & "FROM DocumentosISPC AS D, Clientes AS C "
    sQuery = sQuery & "WHERE D.TipoEntidad = 'CLT' And Saldo <> 0 "
    sQuery = sQuery & "AND C.Codigo = D.CodigoEntidad "
    If sCondCli <> "" Then
        sQuery = sQuery & " AND " & sCondCli
    End If
    sQuery = sQuery & " ORDER BY Nombre, FechaDoc"

    Screen.MousePointer = vbHourglass

    Set rs = dbHandle.Execute(sQuery)
    
    If Not rs.EOF Then
        
        Set pDoc = New clsDocumentosISPC
        Set fView = New lfQuickView
        fView.Caption = "Antigedad de las Acreencias"
        fView.SetReportWidth AnchoReporte
        fView.SetNotify Me

        Encabezado True

        Do
            AlmacenDocumentosISPC.LoadInstance pDoc, rs
            PasarLinea
            rs.MoveNext
        Loop While Not rs.EOF
        
        pDoc.CodigoEntidad = ""
        
        Ruptura
        PrintLinea "", "TOTAL GENERAL", "", TotalMonto, TotalSaldo, TotalesAntiguedad

        Screen.MousePointer = vbDefault

        fView.Show
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
        
        Set pDoc = Nothing
    
    End If
    
    rs.Close
    Set rs = Nothing
    Screen.MousePointer = vbDefault
    
End Sub

Public Sub ReportClicked(sLinea As String, lClickPos As Long)
Dim sPalabra As String, pDocumento As Object, pInst As clsInstanciadorEntidad
Dim pCliente As clsClientes

    If InStr(1, sLinea, "CLIENTE:") Then
        sPalabra = sExtractRightCode(sLinea)
        Set pCliente = New clsClientes
        If pCliente.Load(sPalabra) Then
            pCliente.Show
        End If
        Set pCliente = Nothing
        
        Exit Sub
    End If

    Set pInst = New clsInstanciadorEntidad

    sLinea = Trim(sLinea)
    sPalabra = left(sLinea, 3)
    If pInst.ValidarTipoISDOC(sPalabra) Then
        Dim sRefDoc As String
        
        sRefDoc = Trim(Mid(sLinea, 5, 20))

        Set pDocumento = pInst.EntidadDOCUMENTOByRef(sPalabra, sRefDoc)
        
        If Not pDocumento Is Nothing Then
            pDocumento.Show
        End If
        
        Set pDocumento = Nothing
    End If
    
    Set pInst = Nothing

End Sub
