VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsListaAjustes"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'-------------------------------------------------------------------------------------------------------------
'Numero Fecha      Referencia           Descripcion                              Almacn                 Valor
'-------------------------------------------------------------------------------------------------------------
'000000 99-99-9999 XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXX 9.999.999.999,99

Private Const AnchoReporte = 102

Private fView As lfQuickView, finic As Date, ffinal As Date, vmTotal As Currency

Private Sub PrintLine(sNumero As String, _
                      sFecha As String, _
                      sRef As String, _
                      sDesc As String, _
                      sAlmacen As String, _
                      vmValor As Currency)
Dim sOut As String

    sOut = stFullLength(sNumero, 6) & " "
    sOut = sOut & stFullLength(sFecha, 10) & " "
    sOut = sOut & stFullLength(sRef, 20) & " "
    sOut = sOut & stFullLength(sDesc, 40) & " "
    sOut = sOut & stFullLength(sAlmacen, 12) & " "
    sOut = sOut & FormatNumero(vmValor, Empresa.MascaraMonetarios, 18)
    
    fView.Add sOut

End Sub
Private Sub Encabezado()

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        PrintLine "VAN", "", "", "", "", vmTotal
        fView.PageBreak
    End If
    
    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign("Listado de Ajustes del Inventario", AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(finic, "Short Date") & " y el " & Format(ffinal, "Short Date"), AnchoReporte)
    fView.Add ""
    
    fView.Add "---------------------------------------------------------------------------------------------------------------"
    fView.Add "Numero Fecha      Contrapartida        Descripcion                              Almacn                   Valor"
    fView.Add "---------------------------------------------------------------------------------------------------------------"
    
    If fView.Pagina > 1 Then
        PrintLine "VAN", "", "", "", "", vmTotal
    End If

End Sub

Private Sub PasarLinea(lNumero As Long, dFecha As Date, srefAjuste As String, sDescripcion As String, sAlmacen As String, vmValor As Currency)

    If fView.Linea > fView.LineasPagina - 2 Then Encabezado
    
    PrintLine Format(lNumero, "000000"), Format(dFecha, "Short Date"), srefAjuste, sDescripcion, sAlmacen, vmValor
    
    vmTotal = vmTotal + vmValor
    
End Sub

Public Sub Generar()
Dim f As lfSelectRangoFechas, sQuery As String, rs As Recordset

    Set f = New lfSelectRangoFechas
    ShowNonModal f
    If Not f.Result Then
        Unload f
        Set f = Nothing
        Exit Sub
    End If
    
    finic = f.dtFechaInicial.Fecha
    ffinal = f.dtFechaFinal.Fecha
    
    Unload f
    Set f = Nothing
    
    sQuery = "SELECT Numero, FechaTransaccion, Contrapartida, Descripcion, Almacen, Valor FROM Ajustes "
    sQuery = sQuery & "WHERE FechaTransaccion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & " "
    sQuery = sQuery & "ORDER BY Numero"

    Screen.MousePointer = vbHourglass
    Set rs = dbHandle.Execute(sQuery)

    If Not rs.EOF Then
    
        Set fView = New lfQuickView
        fView.SetReportWidth AnchoReporte
        fView.Caption = "Listado de Ajustes de Inventario"
        fView.SetNotify Me
        
        vmTotal = 0
        
        Encabezado
        
        Do While Not rs.EOF
        
            PasarLinea rs!Numero, rs!FechaTransaccion, stGetStringFromVariant(rs!Contrapartida), rs!Descripcion, rs!Almacen, rs!Valor
            rs.MoveNext
        
        Loop
        
        PrintLine "TOTAL", "", "", "", "", vmTotal
        
        Screen.MousePointer = vbDefault
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing
        
    End If
    
    rs.Close
    Set rs = Nothing

    Screen.MousePointer = vbDefault

End Sub

Public Sub ReportClicked(sLinea As String, lPos As Long)
Dim sTemp As String

    sTemp = Trim(sLinea)
    
    Select Case lPos
    
    Case 1 To 7
        Dim pAjuste As clsAjuste, lNumero As Long
        sTemp = Trim(left(sTemp, 7))
        lNumero = Val(sTemp)
        If lNumero Then
            Set pAjuste = New clsAjuste
            If pAjuste.Load(lNumero) Then
                pAjuste.Show
            End If
            Set pAjuste = Nothing
        End If
    
    Case 19 To 38
        Dim pCuenta As clsCuenta
        
        sTemp = Trim(Mid(sTemp, 19, 20))
        Set pCuenta = New clsCuenta
        If pCuenta.Load(sTemp) Then
            pCuenta.Show
        End If
        Set pCuenta = Nothing

    End Select
        

End Sub
