VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsListCompItemProv"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit


Private Const AnchoReporte = 110

Private ControlTag As String, DescTag As String
Private pFiltro As clsFiltroProvArt
Private WithEvents fView As lfQuickView
Attribute fView.VB_VarHelpID = -1
Private titleSent As Boolean
Private SubTotal As Currency, Total As Currency
Private SubCantidad As Double, totCantidad As Double

'Nombre de la Empresa
'Ventas por Cliente y Producto | Producto y Cliente
'Entre el XXXXXXXXXX y el XXXXXXXXXX

'Fecha de Emision: XXXXXXXXXX. Operador: XXXXXXXXXX.     Pgina: 999
'-------------------------------------------------------------------------------------------------------------
'CODIGO ARTICULO      DESCRIPCION                                     PRECIO       UNIDADES              TOTAL
'CODIGO PROVEEDOR     NOMBRE                                          PRECIO       UNIDADES              TOTAL
'-------------------------------------------------------------------------------------------------------------
'CLIENTE: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX (XXXXXXXX)
'PRODUCTO: XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX (XXXXXXX)
'XXXXXXXXXXXXXXXXXXXX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 999.999.999,99 999.999.999,99 999.999.999.999,99
'TOTAL CLIENTE        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                               999.999.999.999,99
'TOTAL PRODUCTO       XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                               999.999.999.999,99
'TOTAL GENERAL                                                                              999.999.999.999,99

Private Sub fView_ReportClicked(bProcessed As Boolean, ByVal strReportLine As String, ByVal nLinePos As Long)
Dim sExtract As String

  bProcessed = True
  If InStr(1, strReportLine, "PROVEEDOR", vbTextCompare) <> 0 Then
    sExtract = sExtractRightCode(Trim(strReportLine))
    If (sExtract <> "") Then
      Dim pProveedor As clsProveedores
      Set pProveedor = AlmacenProveedores.Proveedor(sExtract)
      If Not pProveedor Is Nothing Then
        pProveedor.Show
        Set pProveedor = Nothing
      End If
    End If
  Else
    Dim pItemInv As clsItemInventario
    sExtract = Trim(Left(Trim(strReportLine), 20))
    Set pItemInv = AlmacenItemsInventario.itemInventario(sExtract)
    If Not pItemInv Is Nothing Then
      pItemInv.Show
      Set pItemInv = Nothing
    End If
  End If

End Sub

Private Sub Encabezado(isRuptura As Boolean)
Dim sOut As String

    If fView.Pagina > 1 Or fView.Linea > 1 Then
        fView.PageBreak
    End If

    fView.Add ""

    fView.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    fView.Add stMidAlign(IIf(pFiltro.sortByProveedor, "Compras de Articulos por Proveedor", "Compras a Proveedores por Articulo"), AnchoReporte)
    fView.Add stMidAlign("Entre el " & Format(pFiltro.FechaInicial, "Short Date") & " y el " & Format(pFiltro.FechaFinal, "Short Date"), AnchoReporte)
    fView.Add ""
    fView.Add "Emision: " & Format(Now, "General Date") & ". Operador: " & UsuarioActivo.Codigo & ".     Pgina: " & fView.Pagina
    
    fView.Add String(AnchoReporte, "-")
    If pFiltro.sortByProveedor Then
        fView.Add "CODIGO ARTICULO      DESCRIPCION                                      PRECIO       UNIDADES              TOTAL"
    Else
        fView.Add "CODIGO PROVEEDOR     NOMBRE                                           PRECIO       UNIDADES              TOTAL"
    End If
    
    fView.Add String(AnchoReporte, "-")

    If Not isRuptura Then
        sOut = IIf(pFiltro.sortByProveedor, "PROVEEDOR: ", "PRODUCTO: ")
        sOut = sOut & DescTag & " (" & ControlTag & ")"
        fView.Add sOut
    End If

End Sub

Private Sub PrintLinea(sCodigo As String, sDescripcion As String, ByVal vmPrecio As Currency, ByVal dCantidad As Double, ByVal vmTotal As Currency)
Dim sOut As String

    sOut = stFullLength(sCodigo, 20) & " "
    sOut = sOut & stFullLength(sDescripcion, 40) & " "
    sOut = sOut & FormatNumero(vmPrecio, "###,###,##0.00", 14) & " "
    sOut = sOut & FormatNumero(dCantidad, Empresa.MascaraCantidades, 14) & " "
    sOut = sOut & FormatNumero(vmTotal, "###,###,###,##0.00", 18)
    
    fView.Add sOut

End Sub

Private Sub Ruptura()
Dim sOut As String

    If ControlTag <> "" Then
        PrintLinea IIf(pFiltro.sortByProveedor, "TOTAL PROVEEDOR", "TOTAL ARTICULO"), DescTag, 0, SubCantidad, SubTotal
    End If

    ControlTag = IIf(pFiltro.sortByProveedor, pFiltro.CodigoProveedor, pFiltro.CodigoItem)
    DescTag = IIf(pFiltro.sortByProveedor, pFiltro.NombreProveedor, pFiltro.Descripcion)
    SubTotal = 0: SubCantidad = 0

    If fView.Linea > fView.LineasPagina - 4 Then
        Encabezado True
    Else
        fView.Add ""
    End If
    
    If ControlTag <> "" Then
        fView.Add IIf(pFiltro.sortByProveedor, "PROVEEDOR: ", "PRODUCTO: ") & DescTag & " (" & ControlTag & ")"
    End If

End Sub

Private Sub AddLinea(sCodCli As String, sNombreCli As String, sCodProd As String, sNombreProd As String, ByVal vmPrecio As Currency, ByVal dUnidades As Double)
Dim sCodigo As String, sDescripcion As String
    
    If pFiltro.sortByProveedor Then
        If sCodCli <> ControlTag Then Ruptura
        sCodigo = sCodProd
        sDescripcion = sNombreProd
    Else
        If sCodProd <> ControlTag Then Ruptura
        sCodigo = sCodCli
        sDescripcion = sNombreCli
    End If

    If (fView.Linea + 4 >= fView.LineasPagina) Then
        Encabezado False    ' i.e. no es encabezado "de ruptura"
    End If

    PrintLinea sCodigo, sDescripcion, vmPrecio, dUnidades, vmPrecio * dUnidades

    SubTotal = SubTotal + vmPrecio * dUnidades
    Total = Total + vmPrecio * dUnidades
    SubCantidad = SubCantidad + dUnidades
    totCantidad = totCantidad + dUnidades
    
End Sub

Public Sub Generar()

    Set pFiltro = New clsFiltroProvArt

    If pFiltro.ProximoItem Then
    
        Screen.MousePointer = vbHourglass
        Set fView = New lfQuickView
        fView.Caption = IIf(pFiltro.sortByProveedor, "Compras de Articulos por Proveedor", "Compras a Proveedores por Articulo")
        fView.SetReportWidth AnchoReporte

        ControlTag = "": DescTag = ""
        SubTotal = 0: Total = 0
        SubCantidad = 0: totCantidad = 0
        
        Encabezado True

        Do
            AddLinea pFiltro.CodigoProveedor, pFiltro.NombreProveedor, pFiltro.CodigoItem, pFiltro.Descripcion, pFiltro.ValorTotal / pFiltro.Cantidad, pFiltro.Cantidad
        Loop While pFiltro.ProximoItem

        Ruptura
        PrintLinea "TOTAL", "Total General", 0, totCantidad, Total
    
        Screen.MousePointer = vbDefault
        fView.Show
        While fView.Visible: DoEvents: Wend
        Unload fView
        Set fView = Nothing
    
    End If

    Set pFiltro = Nothing

End Sub

