VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLibroVentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Fecha As Date
Public Factura As String
Public Documento As String
Public Cliente As String
Public RIF As String
Public MontoBruto As Currency
Public Exento As Currency
Public Gravable1 As Currency
Public Gravable2 As Currency
Public Porcentaje1 As Double
Public Porcentaje2 As Double
Public MontoRetencion1 As Currency
Public MontoRetencion2 As Currency

Public Sub IniciarProceso( _
            dFecha As Date, _
            sFactura As String, _
            sCliente As String, _
            Optional sDocumento As String = "")
Dim lCliente As clsClientes

  Fecha = dFecha
  Factura = sFactura
  Cliente = sCliente
  Documento = sDocumento

  Set lCliente = New clsClientes
  If lCliente.Load(sCliente) Then
    RIF = lCliente.RIF
  End If
  Set lCliente = Nothing
  
  If RIF = "" Then RIF = "<NIL>"
  
End Sub

Public Sub AnotarDetalleDevolucion(pDetalle As clsDetallesDevolucionVenta)
Dim pItemV As clsItemVenta, PorcentajeImpuesto As Double

  If pDetalle.CodigoItemVenta = "" Then Exit Sub
  Set pItemV = New clsItemVenta
  
  If Not pItemV.Load(pDetalle.CodigoItemVenta) Then
    Err.Raise 10001, "clsLibroVentas.AnotarDetalleDevolucion", "Artculo no encontrado"
    Set pItemV = Nothing
    Exit Sub
  End If
  
  PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItemV.TipoImpuesto1)
  Me.MontoBruto = Me.MontoBruto - pDetalle.Valor * (1# + PorcentajeImpuesto / 100#)
  Me.Porcentaje1 = TiposImpuesto.ValorActualImpuesto("IV1")
  Me.Porcentaje2 = TiposImpuesto.ValorActualImpuesto("IV2")
  Select Case UCase(pItemV.TipoImpuesto1)
  Case "IV1"
    Me.Gravable1 = Me.Gravable1 - pDetalle.Valor
    Me.MontoRetencion1 = Me.MontoRetencion1 - pDetalle.Valor * PorcentajeImpuesto / 100#
  Case "IV2"
    Me.Gravable2 = Me.Gravable2 - pDetalle.Valor
    Me.MontoRetencion2 = Me.MontoRetencion2 - pDetalle.Valor * PorcentajeImpuesto / 100#
  Case "EXE", "EX"
    Me.Exento = Me.Exento - pDetalle.Valor
  End Select

End Sub

Public Sub AnotarDetalle(pDetalle As clsDetallesFactura)
Dim pItemV As clsItemVenta, PorcentajeImpuesto As Double

  If pDetalle.CodigoItem = "" Then Exit Sub
  Set pItemV = New clsItemVenta
  If Not pItemV.Load(pDetalle.CodigoItem) Then
    Err.Raise 10001, "clsLibroVentas.AnotarDetalleDevolucion", "Articulo no encontrado"
    Set pItemV = Nothing
    Exit Sub
  End If
  
  PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItemV.TipoImpuesto1)
  Me.MontoBruto = Me.MontoBruto + pDetalle.PrecioEfectivo * (1# + PorcentajeImpuesto / 100#)
  Me.Porcentaje1 = TiposImpuesto.ValorActualImpuesto("IV1")
  Me.Porcentaje2 = TiposImpuesto.ValorActualImpuesto("IV2")
  Select Case UCase(pItemV.TipoImpuesto1)
  Case "IV1"
    Me.Gravable1 = Me.Gravable1 + pDetalle.PrecioEfectivo
    Me.MontoRetencion1 = Me.MontoRetencion1 + pDetalle.PrecioEfectivo * PorcentajeImpuesto / 100#
  Case "IV2"
    Me.Gravable2 = Me.Gravable2 + pDetalle.PrecioEfectivo
    Me.MontoRetencion2 = Me.MontoRetencion2 + pDetalle.PrecioEfectivo * PorcentajeImpuesto / 100#
  Case "EXE", "EX"
    Me.Exento = Me.Exento + pDetalle.PrecioEfectivo
  End Select

End Sub

Public Sub TerminarProceso(cvMontoOverride As Currency)
Dim sQuery As String

  MontoRetencion1 = Gravable1 / 100 * Porcentaje1
  MontoRetencion2 = Gravable2 / 100 * Porcentaje2
  
  If cvMontoOverride <> 0 Then
    If MontoRetencion1 + MontoRetencion2 = 0 Then
      MontoRetencion1 = cvMontoOverride
    Else
      MontoRetencion1 = (MontoRetencion1 * cvMontoOverride) / (MontoRetencion1 + MontoRetencion2)
      MontoRetencion2 = (MontoRetencion2 * cvMontoOverride) / (MontoRetencion1 + MontoRetencion2)
    End If
  End If

  sQuery = "INSERT INTO LibroVentas (Fecha, Factura, Documento, Cliente, RIF, MontoBruto, Exento, Gravable1, Porcentaje1, MontoRetencion1, Gravable2, Porcentaje2, MontoRetencion2) VALUES ("
  sQuery = sQuery & FechaDB(Fecha) & ", "
  sQuery = sQuery & StringDB(Factura) & ", "
  sQuery = sQuery & StringDB(Documento) & ", "
  sQuery = sQuery & StringDB(Cliente) & ", "
  sQuery = sQuery & StringDB(RIF) & ","
  sQuery = sQuery & Str(MontoBruto) & ","
  sQuery = sQuery & Str(Exento) & ","
  sQuery = sQuery & Str(Gravable1) & ","
  sQuery = sQuery & Str(Porcentaje1) & ","
  sQuery = sQuery & Str(MontoRetencion1) & ","
  sQuery = sQuery & Str(Gravable2) & ","
  sQuery = sQuery & Str(Porcentaje2) & ","
  sQuery = sQuery & Str(MontoRetencion2) & ")"
  
  dbHandle.Execute sQuery
  
End Sub

