VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLibroCompras"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Fecha As Date
Public Factura As String
Public Proveedor As String
Public NombreProveedor As String
Public RIF As String
Public MontoBruto As Currency
Public Exento As Currency
Public Gravable1 As Currency
Public Porcentaje1 As Double
Public MontoRetencion1 As Currency
Public Gravable2 As Currency
Public Porcentaje2 As Double
Public MontoRetencion2 As Currency
Public NumeroControl As Long

Public Sub IniciarProceso( _
            dFecha As Date, _
            sFactura As String, _
            sProveedor As String, _
            sNombreProveedor As String, _
            sRif As String, _
            lNumeroControl As Long)

  Fecha = dFecha
  Factura = sFactura
  Proveedor = sProveedor
  NumeroControl = lNumeroControl
  NombreProveedor = sNombreProveedor
  RIF = sRif
      
  If RIF = "" Then RIF = "<NIL>"
  
End Sub

Public Sub SetData2(vExento As Currency, vGravable1 As Currency, dPorcentaje1 As Double, vRetencion1 As Currency, vGravable2 As Currency, dPorcentaje2 As Double, vRetencion2 As Currency)
  With Me
  .Exento = vExento
  .Porcentaje1 = dPorcentaje1
  .Porcentaje2 = dPorcentaje2
  .Gravable1 = vGravable1
  .Gravable2 = vGravable2
  .MontoRetencion1 = vRetencion1
  .MontoRetencion2 = vRetencion2
  .MontoBruto = .Exento + .Gravable1 + .Gravable2 + .MontoRetencion1 + .MontoRetencion2
  End With
End Sub

Public Sub SetData(vExento As Currency, vGravable As Currency, dPorcentaje As Double, vRetencion As Currency)
' Todos (salvo Porcentaje) son negativos en las devoluciones...
Dim s As String
  s = TiposImpuesto.CodigoDesdePorcentaje(dPorcentaje)
  With Me
  Porcentaje1 = TiposImpuesto.ValorActualImpuesto("IV1")
  Porcentaje2 = TiposImpuesto.ValorActualImpuesto("IV2")
  .Exento = .Exento + vExento
  .MontoBruto = .MontoBruto + vExento + vGravable + vRetencion
  Select Case s
  Case "IV1"
  .Gravable1 = .Gravable1 + vGravable
  .MontoRetencion1 = .MontoRetencion1 + vRetencion
  Case "IV2"
  .Gravable2 = .Gravable2 + vGravable
  .MontoRetencion2 = .MontoRetencion2 + vRetencion
  End Select
  End With
End Sub

Public Sub AnotarDetalleDevolucion(pDetalle As clsDetallesDevolucionCompra)
Dim pItemI As clsItemInventario, PorcentajeImpuesto As Double

  Set pItemI = AlmacenItemsInventario.itemInventario(pDetalle.CodigoItem)
  If pItemI Is Nothing Then
    Err.Raise 10001, "clsLibroCompras.AnotarDetalleDevolucion", "AnotarDetalle fuera de Contexto"
    Set pItemI = Nothing
    Exit Sub
  End If
  
  PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItemI.claseImpuesto1)
  Me.MontoBruto = Me.MontoBruto - pDetalle.Costo * (1# + PorcentajeImpuesto / 100#)
  Me.Porcentaje1 = TiposImpuesto.ValorActualImpuesto("IV1")
  Me.Porcentaje2 = TiposImpuesto.ValorActualImpuesto("IV2")
  Select Case UCase(pItemI.TipoImpuesto(1))
  Case "IV1"
    Me.Gravable1 = Me.Gravable1 - pDetalle.Costo
    Me.MontoRetencion1 = Me.MontoRetencion1 - pDetalle.Costo * PorcentajeImpuesto / 100#
  Case "IV2"
    Me.Gravable2 = Me.Gravable2 - pDetalle.Costo
    Me.MontoRetencion2 = Me.MontoRetencion2 - pDetalle.Costo * PorcentajeImpuesto / 100#
  Case "EXE"
    Me.Exento = Me.Exento - pDetalle.Costo
  End Select

End Sub

Public Sub AnotarDetalle(pDetalle As clsDetallesCompra)
Dim PorcentajeImpuesto As Double, pItem As clsItemInventario

  With pDetalle
  Set pItem = AlmacenItemsInventario.itemInventario(pDetalle.CodigoItem)
  If pItem Is Nothing Then Exit Sub
  PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(pItem.TipoImpuesto(1))
  Me.MontoBruto = Me.MontoBruto + .ValorTotal * (1 + PorcentajeImpuesto / 100#)
  Me.Porcentaje1 = TiposImpuesto.ValorActualImpuesto("IV1")
  Me.Porcentaje2 = TiposImpuesto.ValorActualImpuesto("IV2")
  Select Case UCase(pItem.TipoImpuesto(1))
  Case "IV1"
    Me.Gravable1 = Me.Gravable1 + .ValorTotal
    Me.MontoRetencion1 = Me.MontoRetencion1 + .ValorTotal / 100 * PorcentajeImpuesto
  Case "IV2"
    Me.Gravable2 = Me.Gravable2 + .ValorTotal
    Me.MontoRetencion2 = Me.MontoRetencion2 + .ValorTotal / 100 * PorcentajeImpuesto
  Case "EXE"
    Me.Exento = Me.Exento + .ValorTotal
  End Select
  End With
  
End Sub

Public Sub TerminarProceso(Optional vmImpuestoExterno As Variant)
Dim sQuery As String

  If Not IsMissing(vmImpuestoExterno) Then
    If MontoRetencion1 + MontoRetencion2 = 0 Then
      MontoRetencion1 = vmImpuestoExterno
    Else
      MontoRetencion1 = (MontoRetencion1 * vmImpuestoExterno) / (MontoRetencion1 + MontoRetencion2)
      If MontoRetencion1 + MontoRetencion2 <> 0 Then
        MontoRetencion2 = (MontoRetencion2 * vmImpuestoExterno) / (MontoRetencion1 + MontoRetencion2)
      Else
        MontoRetencion2 = 0
      End If
    End If
  End If
  
  MontoBruto = Exento + Gravable1 + MontoRetencion1 + Gravable2 + MontoRetencion2
  sQuery = "INSERT INTO LibroCompras (Fecha, Factura, Proveedor, NombreProveedor, RIF, MontoBruto, Exento, Gravable1, Porcentaje1, MontoRetencion1, Gravable2, Porcentaje2, MontoRetencion2) VALUES ("
  sQuery = sQuery & FechaDB(Fecha) & ", "
  sQuery = sQuery & StringDB(Factura) & ", "
  sQuery = sQuery & StringDB(Proveedor) & ", "
  sQuery = sQuery & StringDB(NombreProveedor) & ", "
  sQuery = sQuery & StringDB(RIF) & ","
  sQuery = sQuery & Str(MontoBruto) & ","
  sQuery = sQuery & Str(Exento) & ","
  sQuery = sQuery & Str(Gravable1) & ","
  sQuery = sQuery & Str(Porcentaje1) & ","
  sQuery = sQuery & Str(MontoRetencion1) & ","
  sQuery = sQuery & Str(Gravable2) & ","
  sQuery = sQuery & Str(Porcentaje2) & ","
  sQuery = sQuery & Str(MontoRetencion2) & ")"

  dbHandle.Execute sQuery

End Sub

Public Sub AbortarProceso()

End Sub

