VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsItemVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Codigo As String
Public Linea As String
Public Descripcion As String
Public CuentaIngreso As String
Public CuentaDevolucion As String
Public CuentaCosto As String
Public Precio1 As Currency
Public Precio2 As Currency
Public Precio3 As Currency
Public Precio4 As Currency
Public TipoImpuesto1 As String
Public TipoImpuesto2 As String
Public CostoStandard As Currency
Public PComis1 As Double
Public PComis2 As Double
Public PComis3 As Double
Public Presentacion As String
Public CantidadPresentacion As Double
Public Unidad As String
Public NumeroPLU As Long
Public PrecioIndexado As Integer
Public ImageFile As String
Public Ubicacion As String
Public Grupo As String

Public Function CuentaIngresoVentas() As String
Dim s As String
  s = Me.CuentaIngreso
  If s = "" Then s = Empresa.CuentaGeneralVentas
  CuentaIngresoVentas = s
End Function

Public Property Get NombreTabla() As String
  NombreTabla = "ItemsVenta"
End Property

Public Property Get Nombre() As String
  Nombre = Descripcion
End Property


Public Function UsaSeriales() As Boolean
Dim pComponente As clsComponenteItemVenta, pItemInv As clsItemInventario

    For Each pComponente In Me.Composicion
    
        Set pItemInv = AlmacenItemsInventario.itemInventario(pComponente.CodigoItemInventario)
        If Not pItemInv Is Nothing Then
            If pItemInv.UsaSeriales Then
                UsaSeriales = True
                Exit Function
            End If
        End If
        Set pItemInv = Nothing

    Next
    
    UsaSeriales = False

End Function

Public Property Get TipoEntidad() As String

    TipoEntidad = "ITV"

End Property

Public Function CodigoFromPLU(ByVal ilngNumPLU As Long) As String
Dim rs As Recordset, strRet As String

    If ilngNumPLU = 0 Then
        CodigoFromPLU = ""
        Exit Function
    End If

    Set rs = dbHandle.Execute("SELECT Codigo FROM itemsVenta WHERE NumeroPLU = " & NumeroDB(ilngNumPLU))
    If rs.EOF Then
        strRet = ""
    Else
        strRet = rs.Fields("Codigo")
    End If
    Set rs = Nothing
    CodigoFromPLU = strRet

End Function

Public Function ValidarCodigo(stiCodigo As String) As Boolean
    ValidarCodigo = AlmacenItemsVenta.Validar(stiCodigo)
End Function

Public Function Load(Codigo As String) As Boolean
Dim retVal As Boolean
Static lastRead As Single
  If Me.Codigo <> Codigo Or Abs(Timer - lastRead) < 0.2 Then
    Me.Codigo = Codigo
    retVal = AlmacenItemsVenta.Load(Codigo, Me)
    lastRead = Timer
    Load = retVal
  Else
    Load = True
  End If
End Function

Public Function Eliminar() As Boolean
Dim pAtributo As clsAtributoEntidad
Dim ppc As clsPreciosCompetencia

    Eliminar = AlmacenItemsVenta.Eliminar(Me.Codigo)
    If Eliminar Then
      Set pAtributo = New clsAtributoEntidad
      pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
      Set pAtributo = Nothing
      Set ppc = New clsPreciosCompetencia
      ppc.ActualizarPreciosCompetencia Me.Codigo, New Collection
      Set ppc = Nothing
    End If

End Function

Public Function CreateNew(colAlternos As Collection, colComposicion As Collection, colPreciosCompetencia As Collection) As Boolean
Dim bResult As Boolean, ppc As clsPreciosCompetencia
    bResult = AlmacenItemsVenta.Add(Me, colAlternos, colComposicion)
    If bResult Then
      Set ppc = New clsPreciosCompetencia
      ppc.ActualizarPreciosCompetencia Me.Codigo, colPreciosCompetencia
      Set ppc = Nothing
    End If
    ExecuteScript "postNuevoProducto.vbs", Me, False
    CreateNew = bResult
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenItemsVenta.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenItemsVenta.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenItemsVenta.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function CalcularCostoComponentes(colComponentes As Collection) As Currency
Dim itemInv As clsItemInventario, cComponente As clsComponenteItemVenta
Dim vmAcumulador As Currency
    
    If colComponentes.Count = 0 Then
        CalcularCostoComponentes = 0@
        Exit Function
    End If
    Set itemInv = New clsItemInventario
    vmAcumulador = 0
    For Each cComponente In colComponentes
        If itemInv.Load(cComponente.CodigoItemInventario) Then
            vmAcumulador = vmAcumulador + (itemInv.CostoUnitario * cComponente.Cantidad)
        Else
            ReportarError False, ERR_ITEM_NOT_FOUND, "Item inventario no localizado:" & cComponente.CodigoItemInventario, "ItemVenta.CalcularCostoComponentes"
            Set itemInv = Nothing
            CalcularCostoComponentes = 0@
            Exit Function
        End If
    Next
    Set itemInv = Nothing
    CalcularCostoComponentes = vmAcumulador
End Function

Public Function ActualizarDescriptivos(Descripcion As String, _
                    Linea As String, Impuesto1 As String, Impuesto2 As String, _
                    ByVal Precio1 As Currency, ByVal Precio2 As Currency, ByVal Precio3 As Currency, ByVal Precio4 As Currency, _
                    ByVal CostoStandard As Currency, _
                    CuentaIngreso As String, CuentaDevolucion As String, CuentaCosto As String, _
                    ByVal PComis1 As Double, ByVal PComis2 As Double, ByVal PComis3 As Double, _
                    Presentacion As String, Unidad As String, ByVal CantidadPresentacion As Double, _
                    ByVal lngNumeroPLU As Long, ByVal inPrecioIndexado As Integer, _
                    colAlternos As Collection, colComposicion As Collection, _
                    sImageFile As String, colPreciosCompetencia As Collection, _
                    sUbicacion As String, sGrupo As String) As Boolean
Dim bRetVal As Boolean
    bRetVal = AlmacenItemsVenta.ActualizarDescriptivos(Me.Codigo, Descripcion, Linea, _
                Impuesto1, Impuesto2, Precio1, Precio2, Precio3, Precio4, _
                CostoStandard, _
                CuentaIngreso, CuentaDevolucion, CuentaCosto, _
                PComis1, PComis2, PComis3, _
                Presentacion, Unidad, CantidadPresentacion, _
                lngNumeroPLU, inPrecioIndexado, _
                colAlternos, colComposicion, _
                sImageFile, sUbicacion, sGrupo)
Dim ppc As clsPreciosCompetencia

    If bRetVal Then
      Set ppc = New clsPreciosCompetencia
      ppc.ActualizarPreciosCompetencia Me.Codigo, colPreciosCompetencia
      Set ppc = Nothing
      With Me
      .CostoStandard = .CalcularCostoComponentes(colComposicion)
      If .CostoStandard = 0 Then
          .CostoStandard = CostoStandard
      ElseIf .CostoStandard <> CostoStandard Then
          Me.ActualizarCosto False
      End If
      .CuentaCosto = CuentaCosto
      .CuentaDevolucion = CuentaDevolucion
      .CuentaIngreso = CuentaIngreso
      .Descripcion = Descripcion
      .Linea = Linea
      .Precio1 = Precio1
      .Precio2 = Precio2
      .Precio3 = Precio3
      .Precio4 = Precio4
      .PComis1 = PComis1
      .PComis2 = PComis2
      .PComis3 = PComis3
      .Presentacion = Presentacion
      .Unidad = Unidad
      .TipoImpuesto1 = Impuesto1
      .TipoImpuesto2 = Impuesto2
      .CantidadPresentacion = CantidadPresentacion
      .NumeroPLU = lngNumeroPLU
      .PrecioIndexado = inPrecioIndexado
      End With
    End If
    ExecuteScript "postEditProducto.vbs", Me, False
    ActualizarDescriptivos = bRetVal
End Function

Public Function SetComponente(sCodigo As String) As Boolean
Dim bRetVal As Boolean, col As Collection, iComponente As clsComponenteItemVenta
Dim pItemInv As clsItemInventario

    On Error GoTo ErrHandler

    Set pItemInv = New clsItemInventario
    If Not pItemInv.Load(sCodigo) Then
        LogException "ERROR: item de inventario " & sCodigo & " no localizado en ItemVenta::SetComponente, para itemVenta " & Me.Codigo
        Set pItemInv = Nothing
        SetComponente = False
        Exit Function
    End If

    Set iComponente = New clsComponenteItemVenta
    iComponente.Cantidad = 1
    iComponente.CodigoItemInventario = sCodigo
    iComponente.CodigoItemVenta = Me.Codigo
    Set col = New Collection
    col.Add iComponente
    
    bRetVal = AlmacenComposiciones.ActualizarComposicion(Codigo, col)

    If bRetVal Then
        Me.CostoStandard = pItemInv.CostoUnitario
        dbHandle.Execute "UPDATE ItemsVenta SET CostoStandard = " & NumeroDB(Me.CostoStandard) & " WHERE Codigo = " & StringDB(Me.Codigo)
    End If
    
ResumePoint:

    Set col = Nothing
    Set iComponente = Nothing
    Set pItemInv = Nothing
    SetComponente = bRetVal
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "itemsVenta::SetComponente"
    bRetVal = False
    Resume ResumePoint
    
End Function

Public Function Alternos() As Collection
    Set Alternos = AlmacenAlternos.AlternosItem(Me.Codigo)
End Function

Public Function Composicion() As Collection
    Set Composicion = AlmacenComposiciones.ComponentesItem(Me.Codigo)
End Function

Public Function ExistenciaGeneral() As Double
Dim Componentes As Collection, pComponente As clsComponenteItemVenta
Dim pItemInventario As clsItemInventario
Dim dMax As Double, dThis As Double

  Set Componentes = Composicion
  If Componentes Is Nothing Then
    Set Componentes = Nothing
    ExistenciaGeneral = HIGH_VALUE
    Exit Function
  End If
  
  dMax = HIGH_VALUE
  Set pItemInventario = New clsItemInventario
  For Each pComponente In Componentes
    If pComponente.Cantidad Then
      If Not pItemInventario.Load(pComponente.CodigoItemInventario) Then
        dMax = 0
        Exit For
      End If
      
      dThis = pItemInventario.Disponibilidad / pComponente.Cantidad
      If dThis < dMax Then dMax = dThis
    End If
  Next
  Set pItemInventario = Nothing
  
  Set Componentes = Nothing
  If dMax < 0 Then dMax = 0
  ExistenciaGeneral = dMax

End Function

Public Function ExistenciaAlmacen(sAlmacen As String) As Double
Dim Componentes As Collection, pComponente As clsComponenteItemVenta
Dim pItemInventario As clsItemInventario
Dim dMax As Double, dThis As Double

  Set Componentes = Composicion
  If Componentes Is Nothing Then
    Set Componentes = Nothing
    ExistenciaAlmacen = HIGH_VALUE
    Exit Function
  End If
  
  dMax = HIGH_VALUE
  Set pItemInventario = New clsItemInventario
  For Each pComponente In Componentes
    If pComponente.Cantidad > 0 Then
      If Not pItemInventario.Load(pComponente.CodigoItemInventario) Then
        dMax = 0
        Exit For
      End If
      dThis = pItemInventario.DisponibilidadAlmacen(sAlmacen) / pComponente.Cantidad
      If dThis < dMax Then dMax = dThis
    End If
  Next
  
  Set pItemInventario = Nothing
  
  Set Componentes = Nothing
  
  ExistenciaAlmacen = dMax

End Function

Public Function ActualizarCosto(indexar As Boolean) As Boolean
    ActualizarCosto = AlmacenItemsVenta.ActualizarCosto(Me, indexar)
End Function

' Accesores

Public Property Get Precio(index As Integer) As Currency
Dim retVal As Currency, factor As Currency
    
    If Me.PrecioIndexado Then factor = Empresa.TipoCambio Else factor = 1
    
    Select Case index
    Case 1
        retVal = Me.Precio1
    Case 2
        retVal = Me.Precio2
    Case 3
        retVal = Me.Precio3
    Case 4
        retVal = Me.Precio4
    End Select
    
    Precio = retVal * factor

End Property

Public Property Let Precio(index As Integer, vmPrecio As Currency)
Dim retVal As Currency, factor As Currency
    
    If index < 1 Or index > 4 Then
        Err.Raise 5, "clsItemVenta", "Argumento Invalido"
        Exit Property
    End If

    If Me.PrecioIndexado Then factor = Empresa.TipoCambio Else factor = 1
    
    retVal = vmPrecio / factor
    Select Case index
    Case 1
        Me.Precio1 = retVal
    Case 2
        Me.Precio2 = retVal
    Case 3
        Me.Precio3 = retVal
    Case 4
        Me.Precio4 = retVal
    End Select
    
    dbHandle.Execute "UPDATE itemsVenta set Precio" & index & " = " & NumeroDB(retVal) & " WHERE Codigo = " & StringDB(Me.Codigo)

End Property

Public Function PrecioNeto(index As Integer) As Currency
Dim vmPrecio As Currency

    vmPrecio = TiposImpuesto.PrecioNeto(Precio(index), Me.TipoImpuesto1, Me.TipoImpuesto2)
    PrecioNeto = vmPrecio

End Function

Public Function PrecioConIVA(nIndex As Integer) As Currency
Dim lPrecio As Currency

  lPrecio = TiposImpuesto.PrecioNeto(Precio(nIndex), Me.TipoImpuesto1, Me.TipoImpuesto2)
  lPrecio = lPrecio * (1# + Me.PorcentajeImpuesto(1) / 100#) * (1# + Me.PorcentajeImpuesto(2) / 100)
  PrecioConIVA = lPrecio

End Function

Public Function PorcentajeImpuesto(nImpuesto As Integer) As Double
    
    PorcentajeImpuesto = TiposImpuesto.ValorActualImpuesto(Me.TipoImpuesto(nImpuesto))

End Function

Public Function TipoImpuesto(index As Integer) As String
Dim retVal As String
    Select Case index
    Case 1
        retVal = Me.TipoImpuesto1
    Case 2
        retVal = Me.TipoImpuesto2
    End Select
    TipoImpuesto = retVal
End Function

Public Sub RedondearPrecioImpuesto(ByVal inIndicePrecio As Integer, ovmPrecioUnitario As Currency, ovmValorImpuesto As Currency)
Dim vmPrecio As Currency
Dim vmImpuesto As Currency
Dim vTotal As Currency

    vmPrecio = Me.Precio(inIndicePrecio)
    vmPrecio = TiposImpuesto.PrecioNeto(CDbl(vmPrecio), Me.TipoImpuesto1, Me.TipoImpuesto2)
    vmImpuesto = vmPrecio / 100# * TiposImpuesto.ValorActualImpuesto(Me.TipoImpuesto1)
    vTotal = Int(vmPrecio + vmImpuesto + 0.5)
    vmPrecio = Int(vTotal - vmImpuesto + 0.5)
    vmImpuesto = vTotal - vmPrecio
    
    ovmPrecioUnitario = vmPrecio
    ovmValorImpuesto = vmImpuesto

End Sub

Public Function PrecioPresentacion(index As Integer, iPresentacion As String) As Currency
Dim retVal As Currency
  retVal = Precio(index)
  If StrComp(iPresentacion, Unidad, vbTextCompare) <> 0 Then
    retVal = retVal * FactorPresentacion(iPresentacion)
  End If
  PrecioPresentacion = retVal
End Function

Public Sub FillComboUnidad(cbx As ComboBox)
Dim stOrg As String, rs As Recordset
  stOrg = cbx.Text
  cbx.Clear
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT DISTINCT Codigo FROM Unidades")
  Do While Not rs.EOF
    cbx.AddItem rs.Fields("Codigo")
    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing

ResumePoint:
  cbx.Text = stOrg
  Exit Sub

ErrHandler:
  Err.Clear
  Resume ResumePoint
End Sub

Public Sub FillComboPresentacion(cbx As ComboBox)
Dim stOrg As String, rs As Recordset
  stOrg = cbx.Text
  cbx.Clear
  cbx.AddItem Me.Unidad
  cbx.AddItem Me.Presentacion
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT DISTINCT Codigo FROM Empaques WHERE Codigo <> " & StringDB(Me.Presentacion))
  Do While Not rs.EOF
    cbx.AddItem rs.Fields("Codigo")
    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing

ResumePoint:
  cbx.Text = stOrg
  Exit Sub

ErrHandler:
  Err.Clear
  Resume ResumePoint
End Sub

Public Function FactorPresentacion(stUnidad As String) As Double
Dim stTemp As String, dRetVal As Double
  stTemp = Trim(Format(stUnidad, ">"))
  If (StrComp(stTemp, Me.Unidad, vbTextCompare) = 0) Or stTemp = "" Then
    dRetVal = 1#
  ElseIf StrComp(stTemp, Me.Presentacion, vbTextCompare) = 0 Then
    dRetVal = Me.CantidadPresentacion
  Else
    Dim rs As Recordset
    On Error Resume Next
    Set rs = dbHandle.Execute("SELECT * FROM Empaques WHERE Codigo = " & StringDB(Trim(stUnidad)))
    If Err.Number <> 0 Then
      dRetVal = 0
    Else
      If rs.EOF Then
        dRetVal = 0
      Else
        dRetVal = GetNumeroFromVariant(rs.Fields("Factor"))
      End If
      rs.Close
      Set rs = Nothing
    End If
  End If
  FactorPresentacion = dRetVal
End Function

Public Function Razon(stDestUnit As String, stOrigUnit As String) As Double
  If StrComp(stDestUnit, stOrigUnit, vbTextCompare) = 0 Then
    Razon = 1
    Exit Function
  End If
  Razon = FactorPresentacion(stDestUnit) / FactorPresentacion(stOrigUnit)
End Function

Public Function ValidarPresentacion(starg As String) As Boolean
  ValidarPresentacion = (FactorPresentacion(starg) <> 0)
End Function

Public Function CheckDisponibilidad(ByVal Cantidad As Double, Almacen As String, interactivo As Boolean) As Boolean
Dim colComposicion As Collection, itemInv As clsItemInventario, instComposicion As clsComponenteItemVenta
Dim isOk As Boolean, Disponibilidad As Double, Requeridas As Double

    isOk = True
    Set colComposicion = Me.Composicion
    Set itemInv = New clsItemInventario
    For Each instComposicion In colComposicion
        If itemInv.Load(instComposicion.CodigoItemInventario) Then
            If Almacen = "" Then
                Disponibilidad = itemInv.Existencia
            Else
                Disponibilidad = itemInv.ExistenciaAlmacen(Almacen)
            End If
            Requeridas = Cantidad * instComposicion.Cantidad
            If Requeridas > Disponibilidad Then
                If interactivo Then mAdvertencia "Slo estn disponibles" & Str(Disponibilidad) & " unidades del artculo " & itemInv.Codigo
                isOk = False
                Exit For
            End If
        End If
    Next
    CheckDisponibilidad = isOk
End Function

' Acciones

Public Function DescargarInventario(Almacen As clsAlmacen, dblCantidadEfectiva As Double, instComprobante As clsBufferComprobante) As Boolean
Dim colComposicion As Collection, nextComponente As clsComponenteItemVenta
Dim isOk As Boolean
    Set colComposicion = Me.Composicion
    isOk = True
    For Each nextComponente In colComposicion
        isOk = Almacen.RegistrarMINV(nextComponente.CodigoItemInventario, -(dblCantidadEfectiva * nextComponente.Cantidad), 0#)
        If Not isOk Then Exit For
    Next
    Set colComposicion = Nothing
    DescargarInventario = isOk
End Function

Public Sub Show()
Dim f As FIEItemVenta

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_PRODUCTOS) Then Exit Sub
    Set f = New FIEItemVenta
    f.SetCodigo Me.Codigo
    On Error Resume Next
    f.Show
    If Err.Number Then
      mAdvertencia "No se puede mostrar la forma desde na forma modal"
    Else
      f.SetContexto 1
    End If
    On Error GoTo 0
    
    While f.Visible: DoEvents: Wend
    
    Unload f
    Set f = Nothing

End Sub

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean

    bRetVal = True

    Select Case sVarId
    
    Case "PRECIO1"
        vRetBuffer = Me.Precio(1)
        sRetString = FormatNumero(Me.Precio(1), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
    Case "PRECIO2"
        vRetBuffer = Me.Precio(2)
        sRetString = FormatNumero(Me.Precio(2), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
    Case "PRECIO3"
        vRetBuffer = Me.Precio(3)
        sRetString = FormatNumero(Me.Precio(3), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
    Case "PRECIO4"
        vRetBuffer = Me.Precio(4)
        sRetString = FormatNumero(Me.Precio(4), Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios))
    Case "LINEA"
        vRetBuffer = Me.Linea
        sRetString = Me.Linea
    Case "CANTIDAD_EMPAQUE"
        vRetBuffer = Me.CantidadPresentacion
        sRetString = FormatNumero(Me.CantidadPresentacion, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))
    Case "TIPOIMPUESTO1"
        vRetBuffer = Me.TipoImpuesto1
        sRetString = Me.TipoImpuesto1
    Case "TIPOIMPUESTO2"
        vRetBuffer = Me.TipoImpuesto2
        sRetString = Me.TipoImpuesto2
    Case Else
        vRetBuffer = ValorAtributo(sVarId)
        If Not IsEmpty(vRetBuffer) Then
          sRetString = vRetBuffer
        Else
          bRetVal = False
        End If
    End Select

    EvalVar = bRetVal
        
End Function

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

Public Function PreciosCompetencia() As Collection
Dim ppc As clsPreciosCompetencia, pRetCol As Collection

  Set ppc = New clsPreciosCompetencia
  Set pRetCol = ppc.PreciosCompetencia(Me.Codigo)
  Set ppc = Nothing
  Set PreciosCompetencia = pRetCol
End Function

Public Function CambiarCodigo(sNuevoCodigo As String) As Boolean
Dim sQuery As String, isOk As Boolean

  On Error GoTo ErrHandler
  StartTransaction
  isOk = True
  ' Comunes
  sQuery = "UPDATE ItemsVenta SET Codigo = " & StringDB(sNuevoCodigo) & " WHERE Codigo = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  
  sQuery = "UPDATE Atributos SET  CodigoEntidad = " & StringDB(sNuevoCodigo) & " WHERE CodigoEntidad = " & StringDB(Me.Codigo) & " AND TipoEntidad = 'ITV'"
  dbHandle.Execute sQuery
  
  If ExisteTabla(dbHandle, "mnuItems") Then
    sQuery = "UPDATE mnuItems SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo) & " AND isTerminal = 1"
    dbHandle.Execute sQuery
  End If
  
  If ExisteTabla(dbHandle, "mesasItems") Then
    sQuery = "UPDATE mesasItems SET Codigo = " & StringDB(sNuevoCodigo) & " WHERE Codigo = " & StringDB(Me.Codigo)
    dbHandle.Execute sQuery
  End If
  
  If ExisteTabla(dbHandle, "tmpResumenPOS") Then
    sQuery = "UPDATE tmpResumenPOS SET Producto = " & StringDB(sNuevoCodigo) & " WHERE Producto = " & StringDB(Me.Codigo)
    dbHandle.Execute sQuery
  End If
  
  sQuery = "UPDATE AlternosItemVenta SET CodigoItemVenta  = " & StringDB(sNuevoCodigo) & " WHERE CodigoItemVenta = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  
  sQuery = "UPDATE AlternosItemVenta SET CodigoItemVenta  = " & StringDB(sNuevoCodigo) & " WHERE CodigoItemVenta = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE BarraItemsPagina SET Codigo = " & StringDB(sNuevoCodigo) & " WHERE Codigo = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE ComposicionItemsVenta SET CodigoItemVenta = " & StringDB(sNuevoCodigo) & " WHERE CodigoItemVenta = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE CotizacionesDetalles SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE CotizacionesEntregas SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE DetallesDevolucionVenta SET CodigoItemVenta = " & StringDB(sNuevoCodigo) & " WHERE CodigoItemVenta = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE DetallesFactura SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE DetallesItemVenta SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE HotKeys SET Normal = " & StringDB(sNuevoCodigo) & " WHERE Normal = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE NNEEDetalles SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE RenglonesCuentaPOS SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE RenglonesFacturaPOS SET Producto = " & StringDB(sNuevoCodigo) & " WHERE Producto = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE RenglonesSesion SET CodigoItem = " & StringDB(sNuevoCodigo) & " WHERE CodigoItem = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  sQuery = "UPDATE rwsDetallesOrden SET CodigoProducto = " & StringDB(sNuevoCodigo) & " WHERE CodigoProducto = " & StringDB(Me.Codigo)
  dbHandle.Execute sQuery
  
  Me.Codigo = sNuevoCodigo
  CommitTransaction

ResumePoint:
  CambiarCodigo = isOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  isOk = False
  AbortTransaction
  ReportarError False, nErrN, sErrD, "clsItemVenta::CambiarCodigo"
  Resume ResumePoint

End Function

Public Function PrecioMinimo() As Currency
  Dim retVal As Currency, factor As Currency
  retVal = Precio1
  If Precio2 < retVal Then retVal = Precio2
  If Precio3 < retVal Then retVal = Precio3
  If Precio4 < retVal Then retVal = Precio4
  If Me.PrecioIndexado Then factor = Empresa.TipoCambio Else factor = 1
  PrecioMinimo = retVal * factor
End Function

Public Function PrecioMaximo() As Currency
  Dim retVal As Currency, factor As Currency
  retVal = Precio1
  If Precio2 > retVal Then retVal = Precio2
  If Precio3 > retVal Then retVal = Precio3
  If Precio4 > retVal Then retVal = Precio4
  If Me.PrecioIndexado Then factor = Empresa.TipoCambio Else factor = 1
  PrecioMaximo = retVal * factor
End Function

Public Function PrecioMaximoMN() As Currency
Dim vmMax As Currency
  vmMax = Me.PrecioMaximo
  If Me.PrecioIndexado Then
    vmMax = vmMax * Empresa.TipoCambio
  End If
  PrecioMaximoMN = vmMax
End Function

Public Function PrecioMinimoMN() As Currency
Dim vmMin As Currency
  vmMin = Me.PrecioMinimo
  If Me.PrecioIndexado Then
    vmMin = vmMin * Empresa.TipoCambio
  End If
  PrecioMinimoMN = vmMin
End Function

Public Function IndicePrecioMin() As Integer
Dim i As Integer, j As Integer
  j = 1
  For i = 2 To 4
    If Me.Precio(i) < Me.Precio(j) Then
      i = j
    End If
  Next
  IndicePrecioMin = j
End Function

Public Function IndicePrecioMax() As Integer
Dim i As Integer, j As Integer
  j = 1
  For i = 2 To 4
    If Me.Precio(i) > Me.Precio(j) Then
      i = j
    End If
  Next
  IndicePrecioMax = j
End Function

