VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsItemMenu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Dependencias:
' AlmacenItemsVenta
'   ItemsVenta (late binding)

Public ownerMenu As String
Public Posicion As Integer
Public isTerminal As Integer
Public CodigoItem As String     ' isTerminal ? Se refiere a un PRODUCTO : Se Refiere a un Men
Public Imagen As String         ' Referencia a un archivo de imgenes
Public nColor As Long
Public Descripcion As String

Public ToolTipText As String

Private nIterador As Integer

Private BufferMenus As Collection
Private CurrentMenu As Collection

Public Function isMenu(sID As String) As Boolean
Dim i As Integer, rs As Recordset

  Set rs = dbHandle.Execute("SELECT Count(CodigoItem) AS q FROM mnuItems WHERE ownerMenu = " & StringDB(sID))
  If rs.EOF Then
    i = 0
  Else
    i = GetNumeroFromVariant(rs.Fields("q"))
  End If
  rs.Close
  Set rs = Nothing
  isMenu = (i > 0)

End Function

Public Function MenuIDS() As Variant
Dim v() As Variant, rs As Recordset

  ReDim v(0)
  Set rs = dbHandle.Execute("SELECT DISTINCT ownerMenu FROM mnuItems ORDER BY ownerMenu")
  Do While Not rs.EOF
    ReDim Preserve v(UBound(v) + 1)
    v(UBound(v)) = rs.Fields("ownerMenu")
    rs.MoveNext
  Loop
  Set rs = Nothing
  MenuIDS = v

End Function

Private Function SetCurrentMenu(istrMenuID As String) As Boolean
Dim bRetVal As Boolean, sQuery As String, pItem As clsItemMenu
Dim rsIterador As Recordset
  On Error GoTo ErrHandler
  bRetVal = True
  Set CurrentMenu = BufferMenus.item(istrMenuID)
ResumePoint:
  SetCurrentMenu = bRetVal
  Exit Function

ErrHandler:
  If Err.Number = 5 Then
    Err.Clear
    On Error GoTo 0
    Set CurrentMenu = New Collection
    sQuery = "SELECT * FROM mnuItems WHERE ownerMenu = " & StringDB(istrMenuID) & " ORDER BY Posicion"
    Set rsIterador = dbHandle.Execute(sQuery)
    Do While Not rsIterador.EOF
      Set pItem = New clsItemMenu
      LoadInstance rsIterador, pItem
      CurrentMenu.Add pItem
      rsIterador.MoveNext
    Loop
    Set rsIterador = Nothing
    
    BufferMenus.Add CurrentMenu, istrMenuID
    Resume ResumePoint
  End If
  
  ReportarError True, Err.Number, Err.Descripcion, "clsItemMenu::SetCurrentMenu"
  Err.Clear
  bRetVal = False
  Resume ResumePoint

End Function

Public Sub LoadInstance(rs As Recordset, Optional pDest As clsItemMenu = Nothing)
Dim lpDest As clsItemMenu
Dim Producto As Object

    If pDest Is Nothing Then
        Set lpDest = Me
    Else
        Set lpDest = pDest
    End If

    With rs
    lpDest.ownerMenu = GetStringFromVariant(.Fields("ownerMenu"))
    lpDest.Posicion = GetNumeroFromVariant(.Fields("Posicion"))
    lpDest.isTerminal = GetNumeroFromVariant(rs.Fields("isTerminal"))
    lpDest.CodigoItem = GetStringFromVariant(.Fields("CodigoItem"))
    On Error Resume Next
    lpDest.Imagen = GetStringFromVariant(.Fields("Imagen"))
    If Err.Number Then
      lpDest.Imagen = ""
      Err.Clear
    End If
    On Error Resume Next
    lpDest.nColor = GetNumeroFromVariant(.Fields("Color"))
    If Err.Number Then
      Err.Clear
      lpDest.nColor = vbButtonFace
    End If
    If lpDest.nColor = 0 Then lpDest.nColor = vbButtonFace
    lpDest.Descripcion = GetStringFromVariant(.Fields("Descripcion"))
    
    Set Producto = AlmacenItemsVenta.ItemVenta(lpDest.CodigoItem)
    If (lpDest.isTerminal And lpDest.Descripcion = "") Then ' = TIM_ITEMVENTA Or lpDest.tipoItem = TIM_COMBO) Then
      If Producto Is Nothing Then
          lpDest.Descripcion = "Referencia invlida: " & lpDest.CodigoItem
      Else
          lpDest.Descripcion = Producto.Descripcion
      End If
    End If
    If Not Producto Is Nothing Then
      lpDest.ToolTipText = Producto.Descripcion
    End If
    
    Set Producto = Nothing
    End With

End Sub

Public Property Get Picture() As IPictureDisp
Dim sFileName As String

    If Imagen = "" Then
      Set Picture = Nothing
      Exit Property
    End If
  
      sFileName = BuildDataPath("Imagenes\" & Imagen, AppName)
    If Dir(sFileName) <> "" Then
      Set Picture = LoadPicture(sFileName)
    Else
      Set Picture = Nothing
    End If

End Property

Public Function IniciarIteradorMenu(Optional istrCodigoMenu As String = "\") As Boolean
Dim isOk As Boolean, sQuery As String

  isOk = SetCurrentMenu(istrCodigoMenu)
  If Not isOk Then
    Set CurrentMenu = Nothing
    isOk = False
  Else
    nIterador = 0
  End If
  IniciarIteradorMenu = isOk
End Function

Public Function NextItem() As clsItemMenu
Dim pRetVal As clsItemMenu

  If CurrentMenu Is Nothing Then
    Set pRetVal = Nothing
  Else
    nIterador = nIterador + 1
    If nIterador > CurrentMenu.Count Then
        Set pRetVal = Nothing
        Set CurrentMenu = Nothing
    Else
        Set pRetVal = CurrentMenu.item(nIterador)
    End If
  End If
  
  Set NextItem = pRetVal

End Function

Private Sub Class_Initialize()
  Set BufferMenus = New Collection
End Sub

Private Sub Class_Terminate()
  Set BufferMenus = Nothing
End Sub



