VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsItemInventario"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Codigo As String
Public Descripcion As String
Public Linea As String
Public m_CuentaActivo As String
Public CuentaCosto As String        ' No va!
Public CostoPromedio As Currency
Public UltimoCosto As Currency
Public claseImpuesto1 As String
Public ClaseImpuesto2 As String
Public Existencia As Double
Public Asignadas As Double
Public EnTransito As Double         ' Existencias "Off Almacen"
Public ExistenciaMinima As Double
Public ExistenciaMaxima As Double
Public FechaUltimaCompra As Date
Public UltimoProveedor As String
Public PrecioUltimaCompra As Currency
Public NombreUnidad As String
Public NombreEmpaque As String
Public CantidadEmpaque As Double
Public UsaSeriales As Integer
Public Grupo As String

Public TipoEntidad As String

Public Property Get NombreTabla() As String
  NombreTabla = "ItemsInventario"
End Property

Public Property Get Nombre() As String
  Nombre = Descripcion
End Property

Public Property Let CuentaActivo(sNewCuenta As String)
    If sNewCuenta = Empresa.CuentaGeneralInventario Then
        m_CuentaActivo = ""
    Else
        m_CuentaActivo = sNewCuenta
    End If
End Property

Public Property Get CuentaActivo() As String
Dim sRetVal As String

    sRetVal = m_CuentaActivo
    If sRetVal = "" Then
        sRetVal = Empresa.CuentaGeneralInventario
    End If
    CuentaActivo = sRetVal

End Property

'---------------------------------------------------------------------------------------
' Procedure : Composicion
' DateTime  : 14/08/03 22:17
' Author    : Leonardo Azpurua
' Purpose   : Composicion fue agregada para permitir el tratamiento uniforme de los
'             articulos de inventario y de los productos y servicios, con el fin de
'             poder unificar la edicin de seriales.
'             La Composicion de los ItemsInventario contiene slo una referencia al
'             mismo item
'---------------------------------------------------------------------------------------
Public Property Get Composicion() As Collection
Dim stCopia As String, retCol As Collection
Dim inst As clsComponenteItemVenta, rs As Recordset
    Set rs = dbHandle.Execute("SELECT * FROM ComposicionItemsInventario WHERE CodigoItemVenta = " & StringDB(Me.Codigo))
    Set retCol = New Collection
    Do While Not rs.EOF
        Set inst = New clsComponenteItemVenta
        inst.CodigoItemInventario = rs.Fields("CodigoItemInventario")
        inst.CodigoItemVenta = rs.Fields("CodigoItemVenta")
        inst.Cantidad = rs.Fields("Cantidad")
        retCol.Add inst, inst.CodigoItemInventario
        rs.MoveNext
    Loop
    rs.Close
    Set rs = Nothing
    If retCol.Count = 0 Then
      Set inst = New clsComponenteItemVenta
      With inst
      .Cantidad = 1
      .CodigoItemInventario = Me.Codigo
      .CodigoItemVenta = Me.Codigo
      End With
      retCol.Add inst, inst.CodigoItemInventario
    End If
    Set Composicion = retCol
End Property

Public Property Set Composicion(newComposicion As Collection)
Dim sQuery As String, inst As clsComponenteItemVenta

  StartTransaction
  On Error GoTo ErrHandler

  sQuery = "DELETE FROM ComposicionItemsInventario WHERE CodigoItemVenta = " & StringDB(Me.Codigo) & ";"
  dbHandle.Execute sQuery
  For Each inst In newComposicion
    sQuery = "INSERT INTO ComposicionItemsInventario (CodigoItemVenta, CodigoItemInventario, Cantidad) SELECT "
    sQuery = sQuery & StringDB(Me.Codigo) & ", "
    sQuery = sQuery & StringDB(inst.CodigoItemInventario) & ", "
    sQuery = sQuery & NumeroDB(inst.Cantidad) & ";"
    dbHandle.Execute sQuery
  Next

  Dim rs As Recordset, vmCostoPromedio As Currency, vmUltimoCosto As Currency
  sQuery = "SELECT SUM(CostoPromedio * Cantidad) As CP, SUM(UltimoCosto * Cantidad) As UC "
  sQuery = sQuery & "FROM itemsInventario I, ComposicionItemsInventario C "
  sQuery = sQuery & "WHERE I.Codigo = C.CodigoItemInventario AND C.CodigoItemVenta = " & StringDB(Me.Codigo)
  ' WHERE I.Codigo = C.CodigoItemInventario AND C.CodigoItemVenta = '261001';

  Set rs = dbHandle.Execute(sQuery)
  If Not rs.EOF Then
    vmCostoPromedio = GetNumeroFromVariant(rs.Fields("CP"))
    vmUltimoCosto = GetNumeroFromVariant(rs.Fields("UC"))
    Me.ActualizarCostos vmCostoPromedio, vmUltimoCosto, "", Empresa.indexarPrecios, Empresa.FactorRedondeoPrecios
  End If
  rs.Close: Set rs = Nothing

  CommitTransaction
ResumePoint:
  Exit Property

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  AbortTransaction
  Err.Clear
  ReportarError False, nErrN, sErrD, "clsItemInventario::SetComposicion"
  Resume ResumePoint
End Property

Public Function CostoUnitario() As Currency
    CostoUnitario = IIf(Empresa.valoracionInventario, Me.UltimoCosto, Me.CostoPromedio)
End Function

Public Function ValidarCodigo(stiCodigo As String) As Boolean
Attribute ValidarCodigo.VB_Description = "Preuba"

    ValidarCodigo = AlmacenItemsInventario.Validar(stiCodigo)

End Function

Public Function Load(ByVal Codigo As String) As Boolean
Dim retVal As Boolean, bIsUpdate As Boolean
    
'    bIsUpdate = Me.Codigo = Codigo
'    Me.Codigo = Codigo
    retVal = AlmacenItemsInventario.Load(Codigo, Me)

'    If retVal And Not bIsUpdate Then
'      Dim rs As Recordset, vmCostoPromedio As Currency, vmUltimoCosto As Currency, sQuery As String
'      sQuery = "SELECT SUM(CostoPromedio * Cantidad) As CP, SUM(UltimoCosto * Cantidad) As UC "
'      sQuery = sQuery & "FROM itemsInventario I, ComposicionItemsInventario C "
'      sQuery = sQuery & "WHERE I.Codigo = C.CodigoItemInventario AND C.CodigoItemVenta = " & StringDB(Me.Codigo)
'      ' WHERE I.Codigo = C.CodigoItemInventario AND C.CodigoItemVenta = '261001';
'
'      Set rs = dbHandle.Execute(sQuery)
'      If Not rs.EOF Then
'        vmCostoPromedio = GetNumeroFromVariant(rs.Fields("CP"))
'        vmUltimoCosto = GetNumeroFromVariant(rs.Fields("UC"))
'        If vmCostoPromedio <> Me.CostoPromedio Or vmUltimoCosto <> Me.UltimoCosto Then
'          Me.ActualizarCostos vmCostoPromedio, vmUltimoCosto, "", Empresa.indexarPrecios, Empresa.FactorRedondeoPrecios
'        End If
'      End If
'      rs.Close: Set rs = Nothing
'    End If
    Load = retVal

End Function

Public Function Eliminar() As Boolean
Dim bRetVal As Boolean, pAtributo As clsAtributoEntidad

  bRetVal = AlmacenItemsInventario.Eliminar(Codigo)
  If bRetVal Then
    Set pAtributo = New clsAtributoEntidad
    pAtributo.DeleteAtributosEntidad Me.TipoEntidad, Me.Codigo
    Set pAtributo = Nothing
  End If

  Eliminar = bRetVal

End Function

Public Function CreateNew() As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenItemsInventario.Add(Me)
  If bRetVal Then Me.Load (Me.Codigo)
  ExecuteScript "postNuevoArticulo.vbs", Me, False
  CreateNew = bRetVal
End Function

Public Function LoadAnterior() As Boolean
    LoadAnterior = AlmacenItemsInventario.LoadAnterior(Me)
End Function

Public Function LoadSiguiente() As Boolean
    LoadSiguiente = AlmacenItemsInventario.LoadSiguiente(Me)
End Function

Public Function Refresh() As Boolean
Dim retVal As Boolean
    retVal = AlmacenItemsInventario.Load(Me.Codigo, Me)
    Refresh = retVal
End Function

Public Function ActualizarDescriptivos( _
            Descripcion As String, _
            Linea As String, _
            claseImpuesto1 As String, _
            Unidad As String, _
            Empaque As String, _
            CantidadEmpaque As Double, _
            CuentaActivo As String, _
            ByVal ExMin As Double, _
            ByVal ExMax As Double, _
            ByVal inUsaSeriales As Integer, _
            inGrupo As String) As Boolean
Dim retVal As Boolean
  retVal = AlmacenItemsInventario.ActualizarDescriptivos(Me, Descripcion, Linea, claseImpuesto1, Unidad, Empaque, CantidadEmpaque, CuentaActivo, ExMin, ExMax, inUsaSeriales, inGrupo)
  If retVal Then Me.Load (Me.Codigo)
  ExecuteScript "postEditarArticulo.vbs", Me, False
  ActualizarDescriptivos = retVal
End Function

Public Function ActualizarCostos(ByVal NuevoCP As Double, ByVal nuevoUC As Double, ByVal Contrapartida As String, ByVal indexarPrecios As Boolean, ByVal Redondeo As Double) As Boolean
Dim bRetVal As Boolean
  bRetVal = AlmacenItemsInventario.ActualizarCostos(Me, NuevoCP, nuevoUC, Contrapartida, indexarPrecios, Redondeo)
  ActualizarCostos = bRetVal
End Function

Public Function RegistrarVariacionExistencia(dblVariacion As Double, dblCosto As Double, Fecha As Date) As Boolean
Dim isOk As Boolean
  isOk = AlmacenItemsInventario.RegistrarVariacionExistencia(Me, dblVariacion, dblCosto)
  If isOk Then
    AlmacenSaldosEntidad.RegistrarVariacion Me.Codigo, Me.TipoEntidad, mPeriodos.refPeriodo(Year(Fecha), Month(Fecha)), dblVariacion, False
  End If
  RegistrarVariacionExistencia = isOk
End Function

Public Function RegistrarCompra(stProveedor As String, dtFecha As Date, vmCostoUnitario As Currency, dblCantidad As Double, indexarPrecios As Boolean) As Boolean
Dim NuevoCP As Currency

  If vmCostoUnitario = 0 Then
    RegistrarCompra = True
    Exit Function
  End If

  If (dtFecha >= Me.FechaUltimaCompra) Then
    Me.PrecioUltimaCompra = vmCostoUnitario
    Me.FechaUltimaCompra = dtFecha
    Me.UltimoProveedor = stProveedor
    If Not AlmacenItemsInventario.ActualizarUltimaCompra(Me) Then
      RegistrarCompra = False
      Exit Function
    End If
  End If

  If Me.ExistenciaFisica >= 0.001 Then
    NuevoCP = (Me.CostoPromedio * Me.ExistenciaFisica + vmCostoUnitario * dblCantidad) / (Me.ExistenciaFisica + dblCantidad)
  Else
    NuevoCP = vmCostoUnitario
  End If
  
  If Not ActualizarCostos(NuevoCP, vmCostoUnitario, "", Empresa.indexarPrecios, Empresa.FactorRedondeoPrecios) Then
    RegistrarCompra = False
    Exit Function
  End If
  
  RegistrarCompra = True
  Exit Function

End Function


' Accesores...

Public Function TipoImpuesto(index As Integer) As String
Dim retVal As String
    Select Case index
    Case 1
        retVal = Me.claseImpuesto1
    Case 2
        retVal = Me.ClaseImpuesto2
    End Select
    TipoImpuesto = retVal
End Function

Public Function ExistenciaFisica() As Double
    
    ExistenciaFisica = Existencia - EnTransito

End Function

Public Function Disponibilidad() As Double
    
    Disponibilidad = Existencia - (Asignadas + EnTransito)

End Function

Public Function ExistenciaAlmacen(Almacen As String) As Double
Dim instExUbic As clsExistenciaUbicacion
    
    Set instExUbic = New clsExistenciaUbicacion
    ExistenciaAlmacen = instExUbic.Existencia(Me.Codigo, Almacen, 0)
    Set instExUbic = Nothing

End Function

Public Function ExistenciaGeneral() As Double

    ExistenciaGeneral = Me.ExistenciaFisica

End Function

Public Function DisponibilidadAlmacen(Almacen As String) As Double
Dim instExUbic As clsExistenciaUbicacion
    Set instExUbic = New clsExistenciaUbicacion
    DisponibilidadAlmacen = instExUbic.Disponibilidad(Me.Codigo, Almacen, 0)
    Set instExUbic = Nothing
End Function

Public Function ValidarPresentacion(starg As String) As Boolean
  ValidarPresentacion = (FactorPresentacion(starg) <> 0)
End Function

Public Function FactorPresentacion(stUnidad As String) As Double
Dim stTemp As String, dRetVal As Double

  stTemp = Trim(Format(stUnidad, ">"))
  If (StrComp(stTemp, NombreUnidad, vbTextCompare) = 0) Or stTemp = "" Then
    dRetVal = 1#
  ElseIf StrComp(stTemp, Me.NombreEmpaque, vbTextCompare) = 0 Then
    dRetVal = Me.CantidadEmpaque
  Else
    Dim rs As Recordset
    On Error Resume Next
    Set rs = dbHandle.Execute("SELECT * FROM Empaques WHERE Codigo = " & StringDB(Trim(stUnidad)))
    If Err.Number <> 0 Then
      dRetVal = 0
    Else
      If rs.EOF Then
        dRetVal = 0
      Else
        dRetVal = GetNumeroFromVariant(rs.Fields("Factor"))
      End If
      rs.Close
      Set rs = Nothing
    End If
  End If
  FactorPresentacion = dRetVal
End Function

Public Sub FillCombo(cbx As ComboBox)
Dim stOrg As String, rs As Recordset
  stOrg = cbx.Text
  cbx.Clear
  cbx.AddItem Me.NombreUnidad
  cbx.AddItem Me.NombreEmpaque
  On Error GoTo ErrHandler
  Set rs = dbHandle.Execute("SELECT DISTINCT Codigo FROM Empaques WHERE Codigo <> " & StringDB(Me.NombreEmpaque))
  Do While Not rs.EOF
    cbx.AddItem rs.Fields("Codigo")
    rs.MoveNext
  Loop
  rs.Close
  Set rs = Nothing

ResumePoint:
  cbx.Text = stOrg
  Exit Sub

ErrHandler:
  Err.Clear
  Resume ResumePoint
End Sub

Private Sub Class_Initialize()
    
    TipoEntidad = "INV"

End Sub

Public Function Razon(stDestUnit As String, stOrigUnit As String) As Double
  If StrComp(stDestUnit, stOrigUnit, vbTextCompare) = 0 Then
    Razon = 1
    Exit Function
  End If
  
  If StrComp(stDestUnit, "UNIDAD", vbTextCompare) = 0 Then
    Razon = 1 / Me.CantidadEmpaque
  Else
    Razon = Me.CantidadEmpaque
  End If
End Function

Public Sub Show()
Dim f As FIEItemInventario

    If Not EstaAutorizado(UsuarioActivo.Codigo, OPEN_FIE_INVENTARIO) Then Exit Sub
    
    Set f = New FIEItemInventario
    f.SetCodigo Me.Codigo
    On Error Resume Next
    f.Show
    If Err.Number Then
      mAdvertencia "No se puede mostrar la forma desde na forma modal"
    Else
      f.SetContexto 1
    End If
    On Error GoTo 0
    
    While f.Visible: DoEvents: Wend
    
    Unload f
    Set f = Nothing

End Sub

Public Function ItemVenta() As clsItemVenta
Dim pItemVenta As clsItemVenta

    Set pItemVenta = AlmacenItemsVenta.ItemVenta(Me.Codigo)
    Set ItemVenta = pItemVenta

End Function

Public Property Get PrecioNeto(index As Integer) As Currency
Dim pItem As clsItemVenta, vmRetVal As Currency
  Set pItem = ItemVenta
  If pItem Is Nothing Then
    vmRetVal = 0
  Else
    vmRetVal = pItem.Precio(index)
  End If
  Set pItem = Nothing
  PrecioNeto = vmRetVal
End Property

Public Property Get Precio(index As Integer) As Currency
Dim pItem As clsItemVenta, vmRetVal As Currency

    Set pItem = ItemVenta
    If pItem Is Nothing Then
        vmRetVal = 0
    Else
        vmRetVal = pItem.Precio(index)
        If DoIncluirIVA Then
            vmRetVal = vmRetVal * (1# + pItem.PorcentajeImpuesto(1) / 100)
        End If
    End If
    Set pItem = Nothing
    
    Precio = vmRetVal

End Property

Public Property Let Precio(index As Integer, vmPrecio As Currency)
Dim pItem As clsItemVenta, vmRetVal As Currency, dblFactor As Double

    Set pItem = ItemVenta
    If Not pItem Is Nothing Then
        vmRetVal = vmPrecio
        If DoIncluirIVA Then
            vmRetVal = vmRetVal / (1# + pItem.PorcentajeImpuesto(1) / 100)
        End If
        pItem.Precio(index) = vmRetVal
    End If
    Set pItem = Nothing

End Property

Public Function ExistenciaInicial(dtFecha As Date) As Double
Dim pSaldo As clsSaldoEntidadPeriodo, Periodo As Long, dRetVal
Dim rs As Recordset, finic As Date, ffinal As Date, sQuery As String

  Set pSaldo = New clsSaldoEntidadPeriodo
  If Not pSaldo.Load(Me.Codigo, Me.TipoEntidad, Year(dtFecha), Month(dtFecha)) Then
    dRetVal = 0
  Else
    dRetVal = pSaldo.SaldoInicial ' + pSaldo.Debitos - pSaldo.Creditos
  End If
  
  finic = DateSerial(Year(dtFecha), Month(dtFecha), 1)
  ffinal = dtFecha - 1

  If ffinal >= finic Then
    sQuery = "SELECT SUM(Entradas) As Debitos, SUM(Salidas) as Creditos FROM DetallesMINV "
    sQuery = sQuery & "WHERE CodigoItem = " & StringDB(Me.Codigo) & " "
    sQuery = sQuery & "AND FechaOperacion BETWEEN " & FechaDB(finic) & " AND " & FechaDB(ffinal) & ";"
    
    Set rs = dbHandle.Execute(sQuery)
    If Not rs.EOF Then
      dRetVal = dRetVal + GetNumeroFromVariant(rs.Fields("Debitos")) - GetNumeroFromVariant(rs.Fields("Creditos"))
    End If
    Set rs = Nothing
  End If
  
  ExistenciaInicial = dRetVal

End Function

Public Function TieneAtributo(sAtributo, Optional sValor) As Boolean
Dim pAtributo As New clsAtributoEntidad
  If IsMissing(sValor) Then
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
  Else
    TieneAtributo = pAtributo.TieneAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor)
  End If
End Function

Public Function ValorAtributo(sAtributo)
Dim pAtributo As New clsAtributoEntidad
  ValorAtributo = pAtributo.ValAtributo(Me.TipoEntidad, Me.Codigo, CStr(sAtributo))
End Function

Public Function Atributos(Optional sAtributo As String = "")
Dim pAtributo As New clsAtributoEntidad
  Set Atributos = pAtributo.Atributos(Me.TipoEntidad, Me.Codigo, sAtributo)
End Function

Public Sub SetValorAtributo(sAtributo, sValor)
Dim pAtributo As New clsAtributoEntidad
  pAtributo.SetValorAtributo Me.TipoEntidad, Me.Codigo, CStr(sAtributo), sValor
End Sub

