VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsInstanciadorEntidad"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Function Entidad(stTipo As String, stCodigo As String) As Object
Dim objResult As Object

  Set objResult = EntidadPersonaComercial(stTipo, stCodigo)
  If objResult Is Nothing Then
    Set objResult = EntidadITEM(stTipo, stCodigo)
  End If
  
  Set Entidad = objResult

End Function

' EntidadPersonaComercial es una "Persona Natural o Jurdica" con la cual
' se mantiene cualquier tipo de relacin contable. As of 18-1-2000,
' se reduce a Clientes, Proveedores, Vendedores y Bancos, aunque
' podra ampliarse con Empleados y cualquier otro tipo de
' Deudor/Acreedor.
Function EntidadPersonaComercial(stTipo As String, stCodigo As String) As Object
Dim objResult As Object
    
  Select Case stTipo
  Case "CLT"
    Set objResult = New clsClientes
#If IsNotMain = 0 Then
  Case "PRV"
    Set objResult = New clsProveedores
  Case "VND"
    Set objResult = New clsVendedores
  Case "BCO"
    Set objResult = New clsBancos
#End If
  Case Else
    On Error Resume Next
    Set objResult = pScriptPOS.Eval("GetEntidad(""" & stTipo & """)")
    If Err.Number Then
      Err.Clear
      Set objResult = Nothing
    End If
  End Select
  
  If Not objResult Is Nothing Then
    If objResult.TipoEntidad <> stTipo Then
      ReportarError False, ERR_INCONSISTENT, "Discrepancia: stTipo=" & stTipo & "Entidad.Tipo=" & objResult.TipoEntidad, "clsEntidad.EntidadPNJ"
      Set EntidadPersonaComercial = Nothing
      Exit Function
    End If
        
    If Not objResult.Load(stCodigo) Then
      Set objResult = Nothing
    End If
  End If
  Set EntidadPersonaComercial = objResult

End Function

Public Function CreateRef(stTipo As String) As Object
Dim objResult As Object

#If IsNotMain = 0 Then
  Select Case stTipo
  Case "CLT"
    Set objResult = New clsClientes
  Case "PRV"
    Set objResult = New clsProveedores
  Case "VND"
    Set objResult = New clsVendedores
  Case "BCO"
    Set objResult = New clsBancos
  Case Else
    If mScriptExecute.ExisteProcedimiento(pScriptPOS, "GetEntidad") Then
      Set objResult = pScriptPOS.Eval("GetEntidad(""" & stTipo & """)")
        If Err.Number Then
        Err.Clear
        Set objResult = Nothing
      End If
    End If
  End Select
  
  If Not objResult Is Nothing Then
    If objResult.TipoEntidad <> stTipo Then
      ReportarError False, ERR_INCONSISTENT, "Discrepancia: stTipo=" & stTipo & "Entidad.Tipo=" & objResult.TipoEntidad, "clsEntidad.CreateRef"
      Set CreateRef = Nothing
      Exit Function
    End If
  End If
#Else
  Set objResult = Nothing
#End If
    
  Set CreateRef = objResult

End Function

' EntidadDOCUMENTO es un documento de algn tipo.
Function EntidadDOCUMENTO(stTipo As String, lngNumero As Long) As Object
Dim objResult As Object
    
  Select Case stTipo

#If IsNotMain = 0 Then
  Case "AJU"
    Set objResult = New clsAjuste
  Case "RCM"
    Set objResult = New clsReciboMercancia
  Case "DVC"
    Set objResult = New clsDevolucionCompra
  Case "COT"
    Set objResult = New clsCotizacion
  Case "SSN"
    Set objResult = New clsSesionPOS
  Case "ZTR"
    Set objResult = New clsCierreZ
  Case "POS"
    Set objResult = New clsFacturasPOS
  Case "NDE"
    Set objResult = New clsNNEE
  Case "MVC"
    Set objResult = New CMovimientoCaja
  Case "CCG"
    Set objResult = New clsComprobante
  Case "AJT"
    Set objResult = New CAjusteTemporal
#End If
#If IsNotMain2 = 0 Then
  Case "FCT"
    Set objResult = New clsFacturas
  Case "NDC"
    Set objResult = New clsNotasDCCP
  Case "DVV"
    Set objResult = New clsDevolucionVenta
  Case "MVB"
    Set objResult = New clsMovimientoBanco
  Case "ODC"
    Set objResult = New clsOrdenesCompra
  Case "TRI"
    Set objResult = New clsTransferencia
#End If
  Case Else
    On Error Resume Next
    Set objResult = pScriptPOS.Eval("GetDocumento(""" & stTipo & """)")
    If Err.Number Then
      Err.Clear
      Set objResult = Nothing
    End If
  End Select
  
  If Not objResult Is Nothing Then
    If Not objResult.Load(lngNumero) Then
      Set objResult = Nothing
    End If
  End If

  Set EntidadDOCUMENTO = objResult

End Function

' EntidadDOCUMENTOByRef es un documento de algn tipo.
Function EntidadDOCUMENTOByRef(stTipo As String, stRef As String) As Object
Dim objResult As Object
    
  On Error GoTo ErrHandler
#If IsNotMain = 0 Then
  Select Case stTipo
  Case "FCT"
    Set objResult = New clsFacturas
  Case "AJU"
    Set objResult = New clsAjuste
  Case "AJT"
    Set objResult = New CAjusteTemporal
  Case "RCM"
    Set objResult = New clsReciboMercancia
  Case "NDC"
    Set objResult = New clsNotasDCCP
  Case "DVV"
    Set objResult = New clsDevolucionVenta
  Case "DVC"
    Set objResult = New clsDevolucionCompra
  Case "COT"
    Set objResult = New clsCotizacion
  Case "POS"
    Set objResult = New clsFacturasPOS
  Case "SSN"
    Set objResult = New clsSesionPOS
  Case "ZTR"
    Set objResult = New clsCierreZ
  Case "NDE"
    Set objResult = New clsNNEE
  Case Else
    On Error Resume Next
    Set objResult = pScriptPOS.Eval("GetDocumento(""" & stTipo & """)")
    If Err.Number Then
      Err.Clear
      Set objResult = Nothing
    End If
  End Select
    
  If Not objResult Is Nothing Then
    If Not objResult.LoadByReferenciaISDOC(stRef) Then
      Set objResult = Nothing
    End If
  End If
#Else
  Set objResult = Nothing
#End If

ResumePoint:
  Set EntidadDOCUMENTOByRef = objResult
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "ISDOC::InstanciadorEntidad::EntidadDocumentoByRef"
  Set objResult = Nothing
  Err.Clear
  Resume ResumePoint
End Function

Public Function ValidarTipoISDOC(sTipo As String) As Boolean

    If InStr(1, "FCT*AJU*RCM*NDC*COT*AJT*POS*ZTR*SSN", sTipo) Then
        ValidarTipoISDOC = True
    Else
        ValidarTipoISDOC = False
    End If

End Function


' EntidadITEM se refiere a un objeto de la clase itemXXX (itemVenta o itemInventario).
' Es equivalente a EntidadPersonaComercial (de hecho, podra implementarse
' extendiendo los casos considerados all), pero se consider conveniente establecer
' una FUERTE diferencia semntica.

' Rev. 16-8-2002: Se implementa <Entidad>, como una manera de acceder a uno u otro de los tipos

Function EntidadITEM(stTipo As String, stCodigo As String) As Object
Dim objResult As Object
    
  Select Case stTipo
  Case "INV"
    Set objResult = New clsItemInventario
  Case "ITV"
    Set objResult = New clsItemVenta
  Case Else
  On Error Resume Next
    Set objResult = pScriptPOS.Eval("GetItem(""" & stTipo & """)")
    If Err.Number Then
      Err.Clear
      Set objResult = Nothing
    End If
  End Select
  
  If Not objResult Is Nothing Then
    If Not objResult.Load(stCodigo) Then
      Set objResult = Nothing
    End If
  End If

  Set EntidadITEM = objResult

End Function

Function NombreEntidadISPC(stTipo As String, bPlural As Boolean) As String
Dim stResult As String

    Select Case stTipo
    Case "CLT"
      stResult = "Cliente"
      If bPlural Then stResult = stResult & "s"
    Case "PRV"
      stResult = "Proveedor"
      If bPlural Then stResult = stResult & "es"
    Case "VND"
      stResult = "Vendedor"
      If bPlural Then stResult = stResult & "es"
    Case "BCO"
      stResult = "Banco"
      If bPlural Then stResult = stResult & "s"
    Case "ITV"
      stResult = "Producto"
      If bPlural Then stResult = stResult & "s"
    Case "INV"
      stResult = "Artculo"
      If bPlural Then stResult = stResult & "s"
    Case Else
        stResult = "INVALIDO: " & stTipo
    End Select

    NombreEntidadISPC = stResult
End Function

Sub SetCodeBoxData(stTipo As String, pBox As ucCodeBox)
  With pBox
  Select Case stTipo
  Case "CLT"
    .Titulo = "Clientes"
    .NombreTabla = "Clientes"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Nombre"
  Case "PRV"
    .Titulo = "Proveedores"
    .NombreTabla = "Proveedores"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Nombre"
  Case "VND"
    .Titulo = "Vendedores"
    .NombreTabla = "Vendedores"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Nombre"
  Case "BCO"
    .Titulo = "Bancos"
    .NombreTabla = "Bancos"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Nombre"
  Case "ITV"
    .Titulo = "Productos"
    .NombreTabla = "ItemsVenta"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Descripcion"
  Case "INV"
    .Titulo = "Articulos"
    .NombreTabla = "ItemsInventario"
    .NombreCodigo = "Codigo"
    .NombreDescriptor = "Descripcion"
  Case Else
    .Enabled = False
    .Text = "" & stTipo & "??"
  End Select
  End With

End Sub

Public Sub FillComboTiposEntidad(cbxDest As ComboBox)
Dim orgTxt As String
  orgTxt = cbxDest.Text
  cbxDest.Clear
  cbxDest.AddItem "Banco (BCO)"
  cbxDest.AddItem "Cliente (CLT)"
  cbxDest.AddItem "Proveedor (PRV)"
  cbxDest.AddItem "Vendedor (VND)"
  cbxDest.Text = orgTxt
End Sub

Public Function VerificarTipoEntidad(stTest As String) As Boolean
    
  stTest = Trim(Format(stTest, ">"))
  If stTest = "BCO" _
  Or stTest = "CLT" _
  Or stTest = "PRV" _
  Or stTest = "VND" Then
    VerificarTipoEntidad = True
  Else
    VerificarTipoEntidad = False
  End If

End Function
