VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsIndeseables"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public ID As Long
Public Nombre As String
Public Motivo As String

Public Sub LoadInstance(rs As Recordset, Optional ipDest As clsIndeseables = Nothing)
Dim pDest As clsIndeseables

  Set pDest = ipDest
  If pDest Is Nothing Then Set pDest = Me
  With pDest
  .ID = GetNumeroFromVariant(rs.Fields("ID"))
  .Nombre = GetStringFromVariant(rs.Fields("Nombre"))
  .Motivo = GetStringFromVariant(rs.Fields("Motivo"))
  End With

End Sub

Public Function Load(lID As Long) As Boolean
Dim rs As Recordset, bIsOk As Boolean

  On Error GoTo ErrHandler
  
  Set rs = dbHandle.OpenRecordset("SELECT * FROM Indeseables WHERE ID = " & NumeroDB(lID) & ";")
  If rs.EOF Then
    bIsOk = False
  Else
    bIsOk = True
    LoadInstance rs
  End If

ResumePoint:
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  Load = bIsOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsIndeseables::Load"
  bIsOk = False
  Resume ResumePoint

End Function

Public Function LoadByNombre(sNombre As String) As Boolean
Dim rs As Recordset, bIsOk As Boolean

  On Error GoTo ErrHandler
  
  Set rs = dbHandle.OpenRecordset("SELECT * FROM Indeseables WHERE Nombre = " & StringDB(sNombre) & ";")
  If rs.EOF Then
    bIsOk = False
  Else
    bIsOk = True
    LoadInstance rs
  End If
ResumePoint:
  If Not rs Is Nothing Then
    rs.Close
    Set rs = Nothing
  End If
  LoadByNombre = bIsOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsIndeseables::LoadByNombre"
  bIsOk = False
  Resume ResumePoint
End Function

Public Function Eliminar() As Boolean
Dim bIsOk As Boolean
  On Error GoTo ErrHandler
  bIsOk = True
  dbHandle.Execute "DELETE FROM Indeseables WHERE id = " & NumeroDB(Me.ID) & ";", dbFailOnError
ResumePoint:
  On Error GoTo 0
  Eliminar = bIsOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long

  sErrD = Err.Description: nErrN = Err.Number
  bIsOk = False
  ReportarError False, nErrN, sErrD, "clsIndeseables::Eliminar"
  Resume ResumePoint
End Function

Public Function Actualizar(sNombre As String, sMotivo As String) As Boolean
Dim bIsOk As Boolean, sQuery As String

  On Error GoTo ErrHandler
  bIsOk = True
  sQuery = "UPDATE Indeseables SET Nombre = " & StringDB(sNombre) & ", Motivo = " & StringDB(sMotivo) & " WHERE ID = " & NumeroDB(Me.ID) & ";"
  dbHandle.Execute sQuery
  If dbHandle.RecordsAffected = 0 Then
    sQuery = "INSERT INTO Indeseables (Nombre, Motivo) VALUES (" & StringDB(sNombre) & ", " & StringDB(sMotivo) & ");"
    dbHandle.Execute sQuery
    Dim rs As Recordset
    Set rs = dbHandle.OpenRecordset("SELECT @@Identity AS Numero")
    Me.ID = rs.Fields("Numero")
    rs.Close
    Set rs = Nothing
  End If
  Me.Nombre = sNombre
  Me.Motivo = sMotivo

ResumePoint:
  On Error GoTo 0
  Actualizar = bIsOk
  Exit Function

ErrHandler:
Dim sErrD As String, nErrN As Long
  sErrD = Err.Description: nErrN = Err.Number
  ReportarError False, nErrN, sErrD, "clsIndeseables::Actualizar"
  bIsOk = False
  Resume ResumePoint
End Function

Public Sub Iterar(sInicio As String, sDestList As ListBox)
Dim rs As Recordset

  Set rs = dbHandle.OpenRecordset("SELECT ID, Nombre FROM Indeseables WHERE Nombre LIKE '" & sInicio & "*'")
  With sDestList
  .Clear
  Do While Not rs.EOF
    sDestList.AddItem rs.Fields("Nombre")
    sDestList.ItemData(sDestList.NewIndex) = rs.Fields("ID")
    rs.MoveNext
  Loop
  End With
  rs.Close
  Set rs = Nothing

End Sub
