VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsGanPerEmpresa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Clase para producir los listados de ganancias y prdidas a nivel de empresas."
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
' Especfico BCV...
Private SaldoOrBalance As Boolean
Private Nivel As Integer
Private PeriodoInicial As Long, PeriodoFinal As Long
Const AnchoReporte = 112

Public Function DefinirParametros() As Boolean
Dim f As fselParmsGanPer
    Nivel = 3
    Set f = New fselParmsGanPer
    f.Show
    While f.Visible: DoEvents: Wend
    PeriodoInicial = f.RefInicio
    PeriodoFinal = f.RefFinal
    Unload f
    Set f = Nothing
    DefinirParametros = (PeriodoInicial <> 0)
End Function

'...XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX #.###.###.###.##0,00 #.###.###.###.##0,00 #.###.###.###.##0,00
Private Sub Encabezado(f As lfQuickView)
Dim isFirst As Boolean, stTitulo As String, Mes As Integer

    isFirst = (f.Pagina <= 1)
    If Not isFirst Then f.PageBreak
    f.Add "": f.Add ""
    f.Add stMidAlign(Empresa.NombreEmpresa, AnchoReporte)
    f.Add ""
    f.Add stMidAlign("Estado General de Ganancias y Perdidas", AnchoReporte)
    stTitulo = "Del 1 de "
    Mes = Empresa.MesPeriodo(PeriodoInicial)
    stTitulo = stTitulo & NombreMes(Mes) & " de" & Str(Empresa.AnhoCalendarioFromPeriodo(PeriodoInicial)) & " al "
    Mes = Empresa.MesPeriodo(PeriodoFinal)
    stTitulo = stTitulo & Str(DiasMes(Mes, Empresa.AnhoCalendarioFromPeriodo(PeriodoFinal))) & " de " & NombreMes(Mes) & " de" & Str(Empresa.AnhoCalendarioFromPeriodo(PeriodoFinal))
    f.Add stMidAlign(stTitulo, AnchoReporte)
    f.Add ""
    f.Add String(AnchoReporte, "-")
End Sub

Private Function Balance(codigoCuenta As String) As Double
Dim col As New Collection, instSaldo As clsSaldoCuentaPeriodo, RetVal As Double
    AlmacenSaldos.LlenarSaldosCuenta codigoCuenta, PeriodoInicial, PeriodoFinal, col
    RetVal = 0
    For Each instSaldo In col
        RetVal = RetVal + instSaldo.Balance
    Next
    Set col = Nothing
    Balance = RetVal
End Function

Private Sub PasarLinea(Titulo As String, Valor As Double, Nivel As Integer, f As lfQuickView)
Dim OutStringT As String, OutStringV As String
    OutStringT = ""
    If Nivel > 1 Then OutStringT = String(Nivel - 1, " ")
    OutStringT = OutStringT & Titulo
    OutStringT = stFullLength(OutStringT, 48)
    If Nivel < 3 Then OutStringV = OutStringV & String(21 * (3 - Nivel), " ")
    OutStringV = OutStringV & FormatNumero(Valor, "#,###,###,###,##0.00", 21)
    f.Add OutStringT & OutStringV
End Sub

Public Sub Generar()
Dim f As lfQuickView
Dim colCuentas As Collection, colPrefijos As Collection
Dim instPrefijo As clsPrefijo, instCuenta As clsCuenta
Dim Valor As Double, TotIngresos As Double, TotEgresos As Double
Dim stOut As String, Nivel As Integer

    Set colPrefijos = New Collection
    AlmacenPrefijos.FillCollectionByFuncion colPrefijos

    If colPrefijos.Count = 0 Then
        mAdvertencia "Error en carga de prefijos"
        Set colPrefijos = Nothing
        Exit Sub
    End If

    If DefinirParametros Then
        Set f = New lfQuickView
        f.SetReportWidth AnchoReporte + 1
        Encabezado f
        
        f.Add "INGRESOS"
        f.Add "--------"
        For Each instPrefijo In colPrefijos
            If instPrefijo.Funcion = 4 Then  ' Ingresos
                Set colCuentas = New Collection
                AlmacenCuentas.LlenarColeccionCuentasPrefijo instPrefijo.Codigo, colCuentas
                For Each instCuenta In colCuentas
                    Nivel = instCuenta.Nivel
                    If Nivel <= 3 Then
                        Valor = -(Balance(instCuenta.Codigo))
'                        If (PeriodoPeriodo(PeriodoInicial) = 1 Or PeriodoPeriodo(PeriodoInicial) = 7) Then Valor = Valor - instCuenta.SaldoInicialPeriodo(AnhoPeriodo(PeriodoInicial), PeriodoPeriodo(PeriodoInicial))
                        If Abs(Valor) >= 0.1 Or Nivel < 3 Then
                            If f.Linea > f.LineasPagina - 3 Then Encabezado f
                            PasarLinea instCuenta.Titulo, Valor, Nivel, f
                            If (Nivel = 1) Then TotIngresos = TotIngresos + Valor
                        End If
                    End If
                Next
                Set colCuentas = Nothing
            End If
            
            If instPrefijo.Funcion = 5 Then
                If Abs(TotEgresos) = 0 Then  ' Slo pasa con la primera cuenta de egresos...
                    If f.Linea > f.LineasPagina - 2 Then Encabezado f
                    f.Add String(90, " ") & String(21, "-")
                    stOut = stFullLength("TOTAL INGRESOS", 90)
                    stOut = stOut & stRightAlign(Format(TotIngresos, "#,###,###,###,##0.00"), 21)
                    f.Add stOut
                    f.Add String(90, " ") & String(21, "-")
                    If f.Linea > f.LineasPagina - 10 Then Encabezado f
                    f.Add ""
                    f.Add "EGRESOS"
                    f.Add "-------"
                End If
                
                Set colCuentas = New Collection
                AlmacenCuentas.LlenarColeccionCuentasPrefijo instPrefijo.Codigo, colCuentas
                For Each instCuenta In colCuentas
                    Nivel = instCuenta.Nivel
                    If Nivel <= 3 Then
                        Valor = Balance(instCuenta.Codigo)
'                        If (PeriodoPeriodo(PeriodoInicial) = 1 Or PeriodoPeriodo(PeriodoInicial) = 7) Then Valor = Valor + instCuenta.SaldoInicialPeriodo(AnhoPeriodo(PeriodoInicial), PeriodoPeriodo(PeriodoInicial))
                        If Abs(Valor) >= 0.1 Or Nivel > 3 Then
                            If f.Linea > f.LineasPagina - 2 Then Encabezado f
                            PasarLinea instCuenta.Titulo, Valor, Nivel, f
                            If (Nivel = 1) Then TotEgresos = TotEgresos + Valor
                        End If
                    End If
                Next
                Set colCuentas = Nothing
            End If
        Next
        
        f.Add String(90, " ") & String(21, "-")
        stOut = stFullLength("TOTAL EGRESOS", 90)
        stOut = stOut & stRightAlign(Format(TotEgresos, "#,###,###,###,##0.00"), 21)
        f.Add stOut
        f.Add String(90, " ") & String(21, "-")
        stOut = stFullLength("TOTAL DE GANANCIA O PERDIDA", 90)
        stOut = stOut & stRightAlign(Format(TotIngresos - TotEgresos, "#,###,###,###,##0.00"), 21)
        f.Add stOut
        f.Add String(90, " ") & String(21, "=")
        
        f.Show
        
        While f.Visible: DoEvents: Wend
        Unload f
        Set f = Nothing
    End If
    Set colPrefijos = Nothing
End Sub

