VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFacturasPOS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
    
Public Numero As Long
Public machID As Long
Public NumeroTicket As Long
Public usrID As String
Public SesionID As Long
Public Hora As Date
Public MontoVenta As Currency
Public Impuesto As Currency
Public Servicio As Currency
Public Vendedor As String
Public Personas As Integer
Public Cuenta As Long
Public CodigoCliente As String

Private NextDetalle As Integer

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Property Get Descripcion() As String
  Descripcion = "Factura POS " & Format(machID, "000") & "-" & Format(NumeroTicket, "0000000")
End Property

Public Property Get Referencia() As String
  Referencia = Format(machID, "000") & "-" & Format(NumeroTicket, "0000000")
End Property

Public Property Get Concepto() As String
  Concepto = Descripcion
End Property

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim idMaquina As Long, numTicket As Long
Dim pos As Integer
  pos = InStr(1, sRef, "-")
  If pos = 0 Then
    LoadByReferenciaISDOC = False
    Exit Function
  End If
  idMaquina = Val(left(sRef, pos - 1))
  numTicket = Val(right(sRef, Len(sRef) - pos))
  LoadByReferenciaISDOC = Cargar(numTicket, idMaquina)
End Function

Public Sub Show()
  Dim f As New fViewFactPOS
  f.ShowFactura Me
End Sub

Public Sub SetCliente(CodigoCliente)
Dim s As String
  s = "UPDATE FacturasPOS SET Cliente = " & StringDB(CStr(CodigoCliente)) & " WHERE Numero = " & NumeroDB(Me.Numero)
  dbHandle.Execute s
End Sub

Public Property Get TipoEntidad() As String
  TipoEntidad = "POS"
End Property

Public Function AddFactura(lNumTicket As Long, lIdSesion As Long, stIDusuario As String, idMaquina As Long, iImpuesto As Currency, iMontoVenta As Currency, iServicio As Currency, Vendedor As String, Personas As Integer, Cuenta As Long, Optional sCliente As String = "") As Boolean
Dim rs As Recordset, s As String
'   Report "clsFacturasPOS.AddFactura. Sesion=" & lIdSesion & ". Impuesto=" & iImpuesto & ". MontoVenta=" & iMontoVenta
  
  s = "INSERT INTO FacturasPOS (IDMaquina, NumeroTicket, idSesion, idUSuario, Hora, MontoVenta, Impuesto, Servicio, Vendedor, Personas, Cuenta, Cliente) "
  s = s & "VALUES ("
  s = s & NumeroDB(idMaquina) & ", "
  s = s & NumeroDB(lNumTicket) & ", "
  s = s & NumeroDB(lIdSesion) & ", "
  s = s & StringDB(stIDusuario) & ", "
  s = s & TimeDateDB(Now) & ", "
  s = s & NumeroDB(iMontoVenta) & ", "
  s = s & NumeroDB(iImpuesto) & ", "
  s = s & NumeroDB(iServicio) & ", "
  s = s & StringDB(Vendedor) & ", "
  s = s & NumeroDB(Personas) & ", "
  s = s & NumeroDB(Cuenta) & ", "
  s = s & StringDB(sCliente) & ");"
  dbHandle.Execute s
  
  Set rs = dbHandle.Execute("SELECT @@IDENTITY as Ultimo")
  Me.Numero = GetNumeroFromVariant(rs.Fields("Ultimo"))
  mMachineID.UltimoNumeroFactura = Me.Numero
  rs.Close
  Set rs = Nothing
  
  NextDetalle = 1
  AddFactura = True

End Function

Public Function AddDetalle(lNumTicket As Long, stCodigoItem As String, dblCantidad As Double, vmPrecioUnitario As Currency, dblPorcentajeImpuesto As Double, Optional ByVal stUsuario As String = "") As Boolean
Dim s As String

  s = "INSERT INTO RenglonesFacturaPOS (idMaquina, numeroTicket, numeroLinea, Producto, Cantidad, PrecioUnitario, PorcentajeImpuesto, Usuario) "
  s = s & "VALUES (" & NumeroDB(MachineID) & ", "
  s = s & NumeroDB(lNumTicket) & ", "
  s = s & NumeroDB(NextDetalle) & ", "
  s = s & StringDB(stCodigoItem) & ", "
  s = s & NumeroDB(dblCantidad) & ", "
  s = s & NumeroDB(vmPrecioUnitario) & ", "
  s = s & NumeroDB(dblPorcentajeImpuesto) & ", "
  s = s & StringDB(stUsuario) & ");"
  
  dbHandle.Execute s
  NextDetalle = NextDetalle + 1
  AddDetalle = True

End Function

Public Function NombreArchivoFormato() As String
  NombreArchivoFormato = BuildDataPath("formatoPOS.txt", AppName)
End Function

Public Sub LoadInstance(pInstance As clsFacturasPOS, rs As Recordset)
  With rs
  pInstance.Numero = .Fields("Numero")
  pInstance.machID = .Fields("idMaquina")
  pInstance.NumeroTicket = .Fields("NumeroTicket")
  pInstance.usrID = .Fields("idUsuario")
  pInstance.SesionID = .Fields("idSesion")
  pInstance.Hora = .Fields("Hora")
  pInstance.MontoVenta = .Fields("MontoVenta")
  pInstance.Servicio = .Fields("Servicio")
  pInstance.Impuesto = .Fields("Impuesto")
  pInstance.Vendedor = .Fields("Vendedor")
  pInstance.Personas = .Fields("Personas")
  pInstance.Cuenta = .Fields("Cuenta")
  On Error Resume Next
  pInstance.CodigoCliente = GetStringFromVariant(.Fields("Cliente"))
  End With
End Sub

Public Function Cargar(lNumeroTicket As Long, lNumeroCaja As Long) As Boolean
Dim rs As Recordset, isOk As Boolean
  isOk = True
  Set rs = dbHandle.Execute("SELECT * FROM FacturasPOS WHERE idMaquina = " & lNumeroCaja & " AND NumeroTicket = " & lNumeroTicket)
  If rs.EOF Then
    isOk = False
  Else
    LoadInstance Me, rs
  End If
  Set rs = Nothing
  Cargar = isOk
End Function

Public Function Load(Numero As Long) As Boolean
Dim rs As Recordset, isOk As Boolean
  isOk = True
  Set rs = dbHandle.Execute("SELECT * FROM FacturasPOS WHERE Numero = " & NumeroDB(Numero))
  If rs.EOF Then
    isOk = False
  Else
    LoadInstance Me, rs
  End If
  Set rs = Nothing
  Load = isOk
End Function

Public Sub DisplayToTextBox(pText As TextBox)
Dim stOut As String, sqlQuery As String
Dim MontoImpuesto As Currency, _
    Total As Currency, _
    PrecioTotal As Currency
'Dim cFormato As CFormatoDocumento
Dim colDetalles As Collection
Dim pDetalle As clsRenglonSesion
Dim sParte1 As String, sParte2 As String
Dim n As Integer

  sParte1 = Empresa.NombreEmpresa: sParte2 = ""
  
  If Len(sParte1) > 39 Then
    n = 20
    Do While Mid(sParte1, n, 1) <> " " And n < Len(sParte1)
      n = n + 1
    Loop
    
    If (n = Len(sParte1)) Then n = 20
    sParte2 = Trim(right(sParte1, Len(sParte1) - n))
    sParte1 = Trim(left(sParte1, n))
  End If
  
  If Not Me.Cargar(Me.NumeroTicket, Me.machID) Then
    mAdvertencia "Error (clsFacturasPOS::ImprimirTicket)" & vbCrLf & "No puedo encontrar la factura POS requerida"
    Exit Sub
  End If
  
  MontoImpuesto = Impuesto
  
  Total = MontoVenta + MontoImpuesto + Servicio
  
  On Error GoTo ErrHandler
  pText.SelText = ""
  
  pText.SelText = stMidAlign(sParte1, 39) & vbCrLf
  If sParte2 <> "" Then pText.SelText = (stMidAlign(sParte2, 39)) & vbCrLf
  
  pText.SelText = "RIF " & Empresa.RIF & vbCrLf
  pText.SelText = "                  Factura: " & Format(Me.NumeroTicket, "000000") & vbCrLf
  pText.SelText = "                  " & Empresa.Ciudad & ", " & Format(Me.Hora, "Short Date") & vbCrLf
  pText.SelText = "CAJA" & Str(Me.machID) & vbCrLf
  pText.SelText = "--------------------------------------" & vbCrLf
  pText.SelText = "Codigo      Cantidad   Precio    TOTAL" & vbCrLf
  pText.SelText = "Descripcion" & vbCrLf
  pText.SelText = "--------------------------------------" & vbCrLf
  '       XXXXXXXXXXXX9 0.999, 9999.999, 99999.999, 99
  
  Set colDetalles = Me.Detalles
  For Each pDetalle In colDetalles
    With pDetalle
    
    PrecioTotal = .PrecioTotal
    stOut = stFullLength(.CodigoItem, 12)
    stOut = stOut & FormatNumero(.Cantidad, "#,##0.00", 8)
    stOut = stOut & FormatNumero(.PrecioUnitario, "##,##0.00", 9)
    stOut = stOut & FormatNumero(PrecioTotal, "##,##0.00", 9)
    pText.SelText = stOut & vbCrLf
    pText.SelText = .Descripcion & vbCrLf
    
    End With
  Next
  
  Set colDetalles = Nothing
  
  pText.SelText = "--------------------------------------" & vbCrLf
  '       XXXXXXXXXXXX9 0.999, 9999.999, 9999.999, 99
  pText.SelText = "              TOTAL         " & FormatNumero(MontoVenta, "###,##0.00", 10) & vbCrLf
  If MontoImpuesto > 0 Then
      pText.SelText = "              I.V.A.        " & FormatNumero(MontoImpuesto, "###,##0.00", 10) & vbCrLf
  End If
  
  If Me.Servicio > 0 Then
      pText.SelText = "              Servicio      " & FormatNumero(Me.Servicio, "###,##0.00", 10) & vbCrLf
  End If
  
  pText.SelText = "               A pagar      " & FormatNumero(Total, "###,##0.00", 10) & vbCrLf
  
  Exit Sub
  
ErrHandler:
  ReportarError False, Err.Number, Err.Description, "clsFacturasPOS::ImprimirTicket"
  Err.Clear

End Sub

Public Sub ImprimirComandas()
Dim PrintersComanda() As String, sNombrePrinter As String
Dim DatosComanda() As Collection, n As Integer, m As Integer
Dim pDetalle As clsRenglonSesion, xDetalle As clsRenglonSesion
Dim pItemVenta As clsItemVenta

    ReDim PrintersComanda(0)
    ReDim DatosComanda(0)

    Set pItemVenta = New clsItemVenta

    For Each pDetalle In Detalles

        If pItemVenta.Load(pDetalle.CodigoItem) Then

            If pItemVenta.Linea <> "" Then

                sNombrePrinter = GetSetting("ClearLight", "Comandas", pItemVenta.Linea, "")

                If sNombrePrinter <> "" Then

                    For n = 1 To UBound(PrintersComanda)

                        If PrintersComanda(n) = sNombrePrinter Then Exit For

                    Next

                    If n > UBound(PrintersComanda) Then

                        ReDim Preserve PrintersComanda(UBound(PrintersComanda) + 1)
                        ReDim Preserve DatosComanda(UBound(DatosComanda) + 1)

                        PrintersComanda(UBound(PrintersComanda)) = sNombrePrinter
                        Set DatosComanda(UBound(DatosComanda)) = New Collection

                    End If

                    For m = 1 To DatosComanda(n).Count

                        Set xDetalle = DatosComanda(n).item(n)
                        If xDetalle.CodigoItem = pDetalle.CodigoItem Then
                            xDetalle.Cantidad = xDetalle.Cantidad + pDetalle.Cantidad
                            Exit For
                        End If

                    Next

                    If m > DatosComanda(n).Count Then
                        DatosComanda(n).Add pDetalle
                    End If

                End If

            End If

        End If
    Next

    For n = 1 To UBound(PrintersComanda)

        SetPrinter (PrintersComanda(n))
        OpenLinePrinter

        LPrint stMidAlign("COMANDA", 39)

        LPrint ""
        LPrint "Operador: " & UsuarioActivo.Codigo
        LPrint "Factura  : " & Format(Me.NumeroTicket, "000000")
        LPrint ""
        For m = 1 To DatosComanda(n).Count

            Set xDetalle = DatosComanda(n).item(m)
            LPrint stFullLength(xDetalle.Descripcion, 30) & " " & FormatNumero(xDetalle.Cantidad, "##0", 8)

        Next

        LPrint ""
        LPrint ""
        LPrint ""
        LPrint ""
        LPrint ""
        LPrint ""
        LPrint "."

        CloseLinePrinter
    Next

    Set xDetalle = Nothing

End Sub

Public Sub ImprimirTicket(lNumeroTicket As Long, lNumeroCaja As Long, isOnLine As Boolean)
Dim sSub As String, sFileName As String

  Me.Cargar lNumeroTicket, lNumeroCaja
  If pScript Is Nothing Then Exit Sub
  sFileName = IIf(isOnLine, "FactPOSImprimir.vbs", "FactPOSImprimirOffLine.vbs")
  If LoadScriptFile(sFileName, pScript, True) Then
    pScript.AddObject "Factura", Me
    pScript.AddObject "Producto", New clsItemVenta
    pScript.AddObject "Impresora", New CLinePrinter
    On Error GoTo ErrHandler
    pScript.Run "ImprimirTicket"
    pScript.Reset
  Else  ' No est definido el script de impresin...
    Dim pImpresorFP As CImpresorFactPOS
    Set pImpresorFP = New CImpresorFactPOS
    pImpresorFP.Go Me, isOnLine, New CLinePrinter, New clsItemVenta
    Set pImpresorFP = Nothing
  End If

  If GetSetting(AppName, "General", "ComandasAlCierre", "NO") = "SI" Then
    ImprimirComandas
  End If

ResumePoint:
  Exit Sub

ErrHandler:
Dim ErrN As Long, ErrD As String
  ErrN = Err.Number: ErrD = Err.Description
  If pScript.Error.Number Then
    mAdvertencia "ERROR en archivo de script:" & pScript.Error.Description & vbCrLf & "Linea: " & pScript.Error.Line & vbCrLf & "Texto: " & pScript.Error.Text
  Else
    ReportarError False, ErrN, ErrD, "clsFacturasPOS::ImprimirTicket"
  End If
  Err.Clear
  Resume ResumePoint

End Sub

Public Function idSesion(lNumTicket As Long, lMachineId As Long) As Long
Dim rsFacturas As Recordset, lRetVal As Long

  Set rsFacturas = dbHandle.Execute("SELECT idSesion FROM FacturasPOS WHERE idMaquina = " & NumeroDB(lMachineId) & " AND NumeroTicket = " & NumeroDB(lNumTicket) & ";")
  With rsFacturas
  If Not .EOF Then
    lRetVal = .Fields("idSesion")
  Else
    lRetVal = 0
  End If
  .Close
  End With
  Set rsFacturas = Nothing

  idSesion = lRetVal

End Function

Public Sub AnularFactura(lNumeroTicket As Long, lMachineId As Long)
Dim rs As Recordset, sqlCommand As String
  sqlCommand = "UPDATE FacturasPOS SET MontoVenta = 0, Impuesto = 0, Servicio = 0 WHERE idMaquina =" & Str(lMachineId) & " AND NumeroTicket =" & Str(lNumeroTicket)
  dbHandle.Execute sqlCommand
  sqlCommand = "DELETE FROM RenglonesFacturaPOS WHERE NumeroTicket =" & Str(lNumeroTicket) & " AND idMaquina =" & Str(lMachineId)
  dbHandle.Execute sqlCommand
End Sub

Public Function Detalles() As Collection
Dim sqlQuery As String, _
    rsDetalles As Recordset, _
    retCol As Collection, _
    pRenglon As clsRenglonSesion, _
    pItem As clsItemVenta

  sqlQuery = "SELECT * FROM RenglonesFacturaPOS "
  sqlQuery = sqlQuery & "WHERE RenglonesFacturaPOS.idMaquina =" & Str(Me.machID) & " AND RenglonesFacturaPOS.numeroTicket =" & Str(Me.NumeroTicket) & " "
  sqlQuery = sqlQuery & "ORDER BY RenglonesFacturaPOS.numeroLinea"

  Set retCol = New Collection
  Set rsDetalles = dbHandle.Execute(sqlQuery)
  With rsDetalles
    Do While Not .EOF
      Set pRenglon = New clsRenglonSesion
      pRenglon.CodigoItem = .Fields("Producto")
      pRenglon.Cantidad = .Fields("Cantidad")
      pRenglon.PrecioUnitario = .Fields("PrecioUnitario")
      pRenglon.PorcentajeImpuesto = .Fields("PorcentajeImpuesto")
      pRenglon.Usuario = GetStringFromVariant(.Fields("Usuario"))
      Set pItem = AlmacenItemsVenta.ItemVenta(pRenglon.CodigoItem)
      pRenglon.PrecioTotal
      If pItem Is Nothing Then
        pRenglon.PrecioLista = pRenglon.PrecioUnitario
      Else
        If left(pItem.Codigo, 1) = "0" And Len(pItem.Codigo) = 3 Then
          pRenglon.PrecioLista = pRenglon.PrecioUnitario
        Else
          pRenglon.PrecioLista = pItem.Precio(nPrecioStandard)
        End If
      End If
      pRenglon.PrecioTotal
      retCol.Add pRenglon
      .MoveNext
    Loop
  End With
  
  rsDetalles.Close
  Set rsDetalles = Nothing
  Set Detalles = retCol
  Set retCol = Nothing
End Function
    
Public Function Monto(lNumTicket As Long, MachineID As Long) As Currency
Dim rs As Recordset, vmRetVal As Currency

    Set rs = dbHandle.Execute("SELECT MontoVenta FROM FacturasPos WHERE idMaquina =" & Str(MachineID) & " AND NumeroTicket =" & Str(lNumTicket))
    
    If rs.EOF Then
        vmRetVal = 0@
    Else
        vmRetVal = rs.Fields("MontoVenta")
    End If
    rs.Close
    Set rs = Nothing
    
    Monto = vmRetVal
End Function
    
Public Function ValorImpuesto(lNumTicket As Long, MachineID As Long) As Currency
Dim rs As Recordset, vmRetVal As Currency

    Set rs = dbHandle.Execute("SELECT Impuesto FROM FacturasPos WHERE idMaquina =" & Str(MachineID) & " AND NumeroTicket =" & Str(lNumTicket))
    
    If rs.EOF Then
        vmRetVal = 0@
    Else
        vmRetVal = rs.Fields("Impuesto")
    End If
    rs.Close
    Set rs = Nothing

    ValorImpuesto = vmRetVal
End Function

Public Function ValorServicio(lNumTicket As Long, MachineID As Long) As Currency
Dim rs As Recordset, vmRetVal As Currency

    Set rs = dbHandle.Execute("SELECT Servicio FROM FacturasPos WHERE idMaquina =" & Str(MachineID) & " AND NumeroTicket =" & Str(lNumTicket))
    
    If rs.EOF Then
        vmRetVal = 0@
    Else
        vmRetVal = rs.Fields("Servicio")
    End If
    rs.Close
    Set rs = Nothing

    ValorServicio = vmRetVal
End Function

Public Function PrecioLista() As Currency
Dim colDetalles As Collection, vAcum As Currency
Dim pRenglon As clsRenglonSesion

    Set colDetalles = Me.Detalles
    For Each pRenglon In colDetalles
        vAcum = pRenglon.PrecioLista * pRenglon.Cantidad
    Next
    PrecioLista = vAcum

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, pCuenta As clsCuentasPOS, vM1 As Currency, VM2 As Currency

    bRetVal = True

    Select Case Trim(UCase(sVarId))
    
    Case "NUMERO"
        vRetBuffer = Me.NumeroTicket
        sRetString = Format(Me.NumeroTicket, "000000")
    
    Case "FECHA"
        vRetBuffer = Me.Hora
        sRetString = Format(Me.Hora, "Short Date")
    
    Case "CUENTA", "MESA"
        Set pCuenta = New clsCuentasPOS
        vRetBuffer = pCuenta.Imagen(Me.Cuenta)
        sRetString = vRetBuffer
        Set pCuenta = Nothing

    Case "HORA"
        vRetBuffer = Me.Hora
        sRetString = Format(Me.Hora, "Short Time")

    Case "IMPUESTO", "IVA"
        vRetBuffer = Me.Impuesto
        sRetString = Format(Me.Impuesto, Empresa.MascaraMonetarios)

    Case "MONTO", "VALORVENTA"
        vRetBuffer = Me.MontoVenta
        sRetString = Format(Me.MontoVenta, Empresa.MascaraMonetarios)

    Case "PERSONAS"
        vRetBuffer = Me.Personas
        sRetString = Str(Me.Personas)

    Case "SERVICIO", "PORCENTAJE"
        vRetBuffer = Me.Servicio
        sRetString = Format(Me.Servicio, Empresa.MascaraMonetarios)

    Case "OPERADOR", "USUARIO"
        vRetBuffer = Me.usrID
        sRetString = vRetBuffer
        
    Case "VENDEDOR", "MESONERO"
        vRetBuffer = Me.Vendedor
        sRetString = vRetBuffer

    Case "PRECIOLISTA"
        vRetBuffer = Me.PrecioLista
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "TAPAGAR"
        vRetBuffer = Me.MontoVenta + Me.Impuesto + Me.Servicio
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
        
    Case "DESCUENTO"
        vM1 = Me.PrecioLista
        VM2 = vM1 - Me.MontoVenta
        vRetBuffer = VM2
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "PORCENTAJE_DESCUENTO", "PDESC", "PDESCUENTO", "PORCENTAJEDESCUENTO"
        vM1 = Me.PrecioLista
        VM2 = vM1 - Me.MontoVenta
        VM2 = VM2 * 100 / vM1
        vRetBuffer = VM2
        sRetString = Format(vRetBuffer, "#0.00")

    Case "MONTOCONIVA"
        vRetBuffer = Me.MontoVenta + Me.Impuesto
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "RECIBIDO", "MONTORECIBIDO"
        vRetBuffer = mMain.Vuelto + Me.MontoVenta + Me.Impuesto + Me.Servicio
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)

    Case "VUELTO", "CAMBIO"
        vRetBuffer = mMain.Vuelto
        sRetString = Format(vRetBuffer, Empresa.MascaraMonetarios)
    
    Case Else
        Dim sTemp As String
        bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sTemp)
        If bRetVal Then sRetString = sTemp
        EvalVar = bRetVal
        Exit Function

    End Select

    EvalVar = True

End Function

Public Function VarValue(ivVarId As Variant) As Variant
Dim sVarId As String, bIsValid As Boolean, sRetString As String, vRetBuffer As Variant

    bIsValid = EvalVar(UCase(Trim(ivVarId)), vRetBuffer, sRetString)
    If Not bIsValid Then
        vRetBuffer = ivVarId & ":REF.INVALIDA"
    End If
    
    VarValue = vRetBuffer

End Function
