VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFacturas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long                       ' Numero del documento
Public FechaRegistro As Date                ' Fecha de registro de la factura
Public FechaTransaccion As Date             ' Fecha de la transaccin
Public Operador As String                   ' Codigo del operador que cre la factura
Public Serie As String                      ' Codigo de "serie" (empresa, centro) de la factura
Public Correlativo As Long                  ' Numero correlativo | serie
Public ExtRef As String                     ' Referencia "externa" (puede usarse para Numero de Control, etctera)
Public CodigoCliente As String              ' Cdigo del cliente
Public NombreCliente As String              ' Nombre del cliente
Public CodigoVendedor As String             ' Cdigo del Vendedor
Public EstadoDespacho As StatDespacho       ' v. enum
Public PrecioLista As Double                ' Valor de la factura a precio de Lista
Public PrecioVenta As Double                ' Valor de la factura a precio de venta
Public PrecioEfectivo As Double
Public Impuesto1 As Double                  ' Impuesto retenido 1 (IVA)
Public Impuesto2 As Double                  ' Impuesto retenido 2 (??)
Public IndiceReferencia As Integer          ' Indice (selector) del precio de referencia
Public IndiceVenta As Integer               ' Selector del precio de venta
Public Descuento1 As Double                 ' Porcentaje del primer descuento global
Public Descuento2 As Double                 ' Porcentaje del segundo descuento global
Public Costo As Long                        ' Costo total de la factura
Public SituacionAdministrativa As StatAdmin ' v. enum
Public Condicion As String                  ' Cdigo de la condicion de venta
Public DescuentosProntoPago As Double       ' Descuentos concedidos por pronto pago (monto acumulado)
Public Comision As Double                   ' Monto de la comision por venta
Public ComisionAcreditada As Boolean        ' Si se cambia de comision por cobrana a comision por venta, no se quiere duplicar el credito de la comision
Public DireccionEntrega As String           ' Direccin de la Entrega
Public Notas As String                      ' Notas y comentarios
Public PrecioDevuelto As Double             ' Mercancia devuelta a Precio de Venta
Public CostoDevuelto As Double              ' Costo de la Mercanca devuelta
Public Saldo As Double                      ' Saldo Actual de la Factura
Public Impuesto1Devuelto As Currency
Public Impuesto2Devuelto As Currency

Private inProcess As Boolean
Private lAlmacen As String
Private lTransporte As String
Private lDoAdmin As Boolean
Public NextDetalle As Integer

Public pEvaluadorVariable As CExpEvalDocVenta

Public instComprobante As clsBufferComprobante

' **********************************************
' Funciones y mtodos y miembros Standard ISDOC:
' **********************************************
Public TipoEntidad As String                ' Idntificacin para ISDOC

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Descripcion() As String
  Descripcion = NombreCliente
End Function

Public Function Load(Numero As Long) As Boolean
  Load = AlmacenFacturas.Load(Me, Numero)
End Function

Public Function Referencia() As String
  Referencia = Serie & "-" & Format(Correlativo, "000000")
End Function

Public Function Concepto() As String
Dim stRetVal As String
  Concepto = "FACTURA " & Me.Referencia
End Function

Public Function NombreArchivoFormato() As String
Dim sKey As String

  If Me.CodigoCliente <> Empresa.CodigoClienteMostrador Then
    sKey = BuildDataPath("FormatoFactura.txt", AppName)
  Else
    sKey = BuildDataPath("FormatoEventual.txt", AppName)
  End If
  
  NombreArchivoFormato = DeterminarFormato("FormatoFactura", "FormatosFactura", sKey, Me)
  
End Function

Public Function Detalles() As Collection
Dim colRetVal As Collection
    
  Set colRetVal = New Collection
  AlmacenDetallesFactura.FillCollection Me.Numero, colRetVal
  Set Detalles = colRetVal

End Function

Public Function ValorImpuesto(CodigoImpuesto) As Currency
Dim det As clsDetallesFactura
Dim retVal As Currency, tasa As Double
  retVal = 0: tasa = TiposImpuesto.ValorActualImpuesto(CStr(CodigoImpuesto))
  For Each det In Detalles
    Dim Item As clsItemVenta
    Set Item = AlmacenItemsVenta.ItemVenta(det.CodigoItem)
    If Not Item Is Nothing Then
      If Item.TipoImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.PrecioEfectivo * tasa / 100
      End If
    End If
  Next
  ValorImpuesto = retVal
End Function

Public Function BaseGravable(CodigoImpuesto) As Currency
Dim det As clsDetallesFactura
Dim retVal As Currency
  retVal = 0
  For Each det In Detalles
    Dim Item As clsItemVenta
    Set Item = AlmacenItemsVenta.ItemVenta(det.CodigoItem)
    If Not Item Is Nothing Then
      If Item.TipoImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.PrecioEfectivo
      End If
    End If
  Next
  BaseGravable = retVal
End Function


Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evFactura.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean

    EvalVar = Me.pEvaluadorVariable.EvalVar(sVarId, vRetBuffer, sRetString, Me)

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

' LoadByRef recibe una "referencia" completa a un documento ISDOC,
' y carga los datos correspondientes en <Me>
' Devuelve True si existe una factura con la referencia recibida
Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
    
    LoadByReferenciaISDOC = LoadByRefSerie(sRef)

End Function

' Show (ISDOC) causa que el documento se presente en una forma de
' consulta...
Public Sub Show()
#If IsNotMain = 0 Then
Dim f As frmConsultarFactura

    Set f = New frmConsultarFactura
    f.SetFactura Me.Numero
    f.Show
    While f.Visible: DoEvents: Wend
    Unload f
    Set f = Nothing
#End If
End Sub

' Se presenta y/o imprime el documento
Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

Public Function NotificarDescuento(vmMontoDescuento As Currency, pComprobante As clsBufferComprobante, dtFechaDescuento As Date) As Boolean
Dim vmVariacionImpuesto As Currency, tImpuesto As clsTiposImpuesto, vmDescuentoNeto As Currency, PorcentajeDescuento As Double
Dim vmAcumImpuesto As Currency, pDetalle As clsDetallesFactura
Dim bRebajarComision As Boolean

  bRebajarComision = CBool(Val(GetSetting(AppName, "General", "RebajarComisionDescuento", "0")))
  
  If bRebajarComision Then
    Dim ComisionOriginal As Currency, Reduccion As Currency
    ComisionOriginal = Me.Comision / (1 - DescuentosProntoPago / (Me.PrecioEfectivo + Me.Impuesto1 + Me.Impuesto2))
    If ComisionOriginal > 0 Then
      Reduccion = ComisionOriginal * (vmMontoDescuento / (Me.PrecioEfectivo + Me.Impuesto1 + Me.Impuesto2))
      If Me.ComisionAcreditada Then
        Dim cDetalle As New clsDetalleCuentaEntidad
        cDetalle.Add 0, Me.CodigoVendedor, "VND", dtFechaDescuento, "Descuento en factura " & Me.Referencia, Reduccion, pComprobante
        pComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Rev. comis. desc. factura " & Me.Referencia, 0, Reduccion
      Else
        Me.Comision = Me.Comision - Reduccion
        dbHandle.Execute "UPDATE Facturas SET Comision = " & NumeroDB(Me.Comision) & " WHERE Numero = " & NumeroDB(Me.Numero)
      End If
    End If
  End If

  vmDescuentoNeto = vmMontoDescuento
  Me.DescuentosProntoPago = Me.DescuentosProntoPago + vmMontoDescuento

  If CBool(GetSetting("ClearLight", "General", "DescuentosAfectanIVA", "-1")) Then
    vmVariacionImpuesto = ((Me.Impuesto2 + Me.Impuesto1) / (Me.PrecioEfectivo + Me.Impuesto1 + Me.Impuesto2)) * vmMontoDescuento
    If vmVariacionImpuesto >= 1 Then
        pComprobante.AddDetalle Empresa.CuentaImpuesto2, "Descuento en factura " & Me.Referencia, vmVariacionImpuesto, 0
        Me.DescuentosProntoPago = Me.DescuentosProntoPago - vmVariacionImpuesto
        vmDescuentoNeto = vmDescuentoNeto - vmVariacionImpuesto
    End If
  
    PorcentajeDescuento = vmMontoDescuento / (Me.PrecioEfectivo + Me.Impuesto1 + Me.Impuesto2) * 100
'    Set pLibroV = New clsLibroVentas
'    With pLibroV
'    .IniciarProceso dtFechaDescuento, Me.Referencia, Me.CodigoCliente, "Dcto.Pronto Pago " & Format(PorcentajeDescuento, "##0.00") & "%"
'    For Each pDetalle In Me.Detalles
'      pDetalle.PrecioEfectivo = -(pDetalle.PrecioEfectivo / 100 * PorcentajeDescuento)
'      pDetalle.PrecioVenta = -(pDetalle.PrecioVenta / 100 * PorcentajeDescuento)
'      .AnotarDetalle pDetalle
'    Next
'    .TerminarProceso 0
'    If .MontoRetencion1 + .MontoRetencion2 <> 0 Then
'      pComprobante.AddDetalle Empresa.CuentaImpuesto1, "Descuento en factura " & Me.Referencia, Abs(.MontoRetencion1 + .MontoRetencion2), 0
'    End If
'    pComprobante.AddDetalle Empresa.CuentaDescuentosCobranza, "", vmDescuentoNeto - Abs(.MontoRetencion1 + .MontoRetencion2), 0
'    End With
  Else
    pComprobante.AddDetalle Empresa.CuentaDescuentosCobranza, "", vmDescuentoNeto, 0
  End If
  NotificarDescuento = AlmacenFacturas.NotificarDescuento(Me.Numero, vmDescuentoNeto)
  
End Function

Public Function ImpuestoDescontado() As Currency
  If Me.PrecioEfectivo <> 0 Then
    ImpuestoDescontado = (Impuesto1 + Impuesto2) * (Me.DescuentosProntoPago / Me.PrecioEfectivo)
  Else
    ImpuestoDescontado = 0
  End If
End Function

' **************************************************************
' ************ END ISDOC
' **************************************************************

Public Function Almacen() As String
Dim pCompAlmacen As clsComprobanteAlmacen
Dim sRetVal As String

  Set pCompAlmacen = New clsComprobanteAlmacen
  If Not pCompAlmacen.GetByDocumento(Me.TipoEntidad, Me.Numero) Then
    sRetVal = ""
  Else
    sRetVal = pCompAlmacen.Almacen
  End If
  Set pCompAlmacen = Nothing
  
  Almacen = sRetVal
End Function

' Funciones y metodos propios (o definidos a nivel de aplicacin)

Public Function NetoAjustadoDetalle(pDetalle As clsDetallesFactura) As Currency
' Devuelve el precio unitario NETO de un detalle.
Dim vmRetVal As Currency
    vmRetVal = pDetalle.PrecioEfectivo * (1 - Me.DescuentosProntoPago / Me.PrecioEfectivo) / pDetalle.Cantidad
    NetoAjustadoDetalle = vmRetVal
End Function

Public Sub Blank(FechaFactura As Date)
    Numero = 0                              ' Significa que la factura es NUEVA.
    FechaRegistro = Date
    FechaTransaccion = FechaFactura
    Operador = UsuarioActivo.Codigo
    Serie = ""
    Correlativo = 0
    ExtRef = ""
    CodigoCliente = ""
    NombreCliente = ""
    CodigoVendedor = ""
    EstadoDespacho = SD_FACTURA_ABIERTA
    PrecioLista = 0#
    PrecioVenta = 0#
    Impuesto1 = 0#
    Impuesto2 = 0#
    IndiceReferencia = 1
    IndiceVenta = 1
    Descuento1 = 0#
    Descuento2 = 0#
    Costo = 0#
    SituacionAdministrativa = SA_FACTURA_ABIERTA
    Condicion = ""
    DescuentosProntoPago = 0#
    Comision = 0#
    DireccionEntrega = ""
    Notas = ""
    PrecioDevuelto = 0#
    CostoDevuelto = 0#
    Saldo = 0#
End Sub

Public Function LoadBySerie(Serie As String, Correlativo As Long) As Boolean
    LoadBySerie = AlmacenFacturas.LoadBySerie(Me, Serie, Correlativo)
End Function

Public Function LoadByRefSerie(stRef As String) As Boolean
Dim stSerie As String, stResto As String, lNumero As Long, i As Integer, bRetVal As Boolean
    
    i = InStr(1, stRef, "-", vbTextCompare)
    If i <= 1 Then
        LoadByRefSerie = False
        Exit Function
    End If
    
    stSerie = left(stRef, i - 1)
    If Series.Item(stSerie) Is Nothing Then
        LoadByRefSerie = False
        Exit Function
    End If

    stResto = right(stRef, Len(stRef) - i)
    lNumero = Val(stResto)
    
    If lNumero = 0 Then
        LoadByRefSerie = False
        Exit Function
    End If

    bRetVal = LoadBySerie(stSerie, lNumero)
    
    LoadByRefSerie = bRetVal

End Function

Public Function LoadByReferencia(ref As String) As Boolean
    
    LoadByReferencia = AlmacenFacturas.LoadByReferencia(Me, ref)

End Function

' -------------------------------------------------------------
' REGLAS DE NEGOCIO:
' -------------------------------------------------------------
' 1.- Se debe evitar el proceso administrativo de la factura, hasta que esta haya
' sido entregada al cliente
' 2.- Se debe evitar demorar el proceso administrativo de una factura, una vez esta
' haya sido entregada al cliente
Public Function SupervisarConsistenciaOperacion(bDoAdmin As Boolean, nStatDespacho As StatDespacho) As Boolean
    
    If bDoAdmin And nStatDespacho <> SD_FACTURA_ENTREGADA Then ' No coformidad con regla 1
        
        mAdvertencia "Temporalmente no est permitido separar la entrega del proceso administrativo"
        SupervisarConsistenciaOperacion = False
        Exit Function

'        mAdvertencia "Supervisar Consistencia de la Operacin:" & Chr(13) & _
'                     "No es conveniente realizar el proceso administrativo" & Chr(13) & _
'                     "de una factura antes de su entrega."
'        If VerificarUsuario("Autorizar proceso administrativo") < 4 Then
'            SupervisarConsistenciaOperacion = False
'            Exit Function
'        End If
    End If
    
    If nStatDespacho = SD_FACTURA_ENTREGADA And Not bDoAdmin Then ' No conformidad con la regla 2
        
        mAdvertencia "Temporalmente no est permitido separar la entrega del proceso administrativo"
        SupervisarConsistenciaOperacion = False
        Exit Function
        
'        mAdvertencia "Supervisar Consistencia de la Operacin:" & Chr(13) & _
'                     "No es conveniente demorar el proceso administrativo" & Chr(13) & _
'                     "de una factura entregada."
'        If VerificarUsuario("Autorizar diferimiento del proceso") < 4 Then
'            SupervisarConsistenciaOperacion = False
'            Exit Function
'        End If
    End If
    
    SupervisarConsistenciaOperacion = True
End Function

' Determina si una factura es modificable...
' Eventualmente, deber ser ampliada para determinar el TIPO
' de modificaciones que la factura podr aceptar.
Public Function Modificable(interactivo As Boolean) As Boolean
  If SituacionAdministrativa = SA_FACTURA_ANULADA Then
    If interactivo Then mAdvertencia "La factura est anulada"
    Modificable = False
    Exit Function
  End If
    
  If SituacionAdministrativa <> SA_FACTURA_ABIERTA Then
    If interactivo Then mAdvertencia "La factura fue procesada administrativamente"
    Modificable = False
    Exit Function
  End If
  
  If Me.EstadoDespacho = SD_FACTURA_ENTREGADA Then
    If interactivo Then mAdvertencia "La factura fue entregada... No se podr modificar."
    Modificable = False
    Exit Function
  End If
  
  Modificable = True
End Function

' Verifica los valores introducidos por el usuario
Public Function ErrorValidacion() As Integer
Dim errCode As Long
    
  errCode = 0
  
  If Me.CodigoCliente = "" Then
    mAdvertencia "Debe indicar el cdigo de un cliente"
    errCode = 1
  End If
  
  If Me.CodigoVendedor = "" Then
    mAdvertencia "Debe llenar el cdigo del vendedor"
    errCode = 2
  End If
  
  If Not Condiciones.ValidarCondicion(Me.Condicion) Then
    mAdvertencia "Condicin invlida"
    errCode = 3
  End If
  
  ErrorValidacion = errCode

End Function


' -------------------------------------------------------------
' PROCESO:
' -------------------------------------------------------------

' --------- Funciones PRIVADAS ---------------------

Private Function ProcesarEfectosAdministrativos(Optional f As lfProgresoOperacion = Nothing, Optional DocFis As CDocumentoFiscal = Nothing) As Boolean
Dim instCliente As clsClientes, _
    instDocumento As clsDocumentosISPC, _
    instDetalle As clsDetalleCuentaEntidad, _
    instCondicion As clsCondicion, _
    instVendedor As clsVendedores
Dim misDetalles As Collection, _
    cDetalle As clsDetallesFactura, _
    Componentes As Collection
Dim Valor As Currency, Cuenta As String, lComision As Currency
Dim ItemVenta As clsItemVenta

  If Not f Is Nothing Then
    f.Caption = "Proceso administrativo de la factura"
    f.ProgressBar1.value = 0
    f.lblPercent.Caption = "0%"
  End If

  Set instCliente = New clsClientes
  If Not instCliente.Load(Me.CodigoCliente) Then
    ReportarError False, ERR_ITEM_NOT_FOUND, "Cliente no localizado: " & Me.CodigoCliente, "Factura.ProcesarEfectosAdministrativos"
    ProcesarEfectosAdministrativos = False
    Set instCliente = Nothing
    Exit Function
  End If
  
  Set instVendedor = New clsVendedores
  If Not instVendedor.Load(Me.CodigoVendedor) Then
    Me.CodigoVendedor = "ADMIN"
  End If
  
' 1.- Calculo del ingreso por ventas
  Set misDetalles = Me.Detalles
  Set ItemVenta = New clsItemVenta
  lComision = 0@
  For Each cDetalle In misDetalles
      
    If Not f Is Nothing Then
      f.NextPoint
      If f.doBreak Then Exit For
    End If
    If cDetalle.CodigoItem <> "" Then
      If Not ItemVenta.Load(cDetalle.CodigoItem) Then
        ReportarError False, ERR_ITEM_NOT_FOUND, "Producto no localizado: " & cDetalle.CodigoItem, "Factura.ProcesarEfectosAdministrativos"
        ProcesarEfectosAdministrativos = False
        Exit Function
      End If

' Acumula los ingresos en la cuenta correspondiente (responsabilidad de instComprobante)
    
      Cuenta = ItemVenta.CuentaIngreso
      If Cuenta = "" Then Cuenta = instCliente.CuentaIngresos
      If Cuenta = "" Then Cuenta = Series.Item(Me.Serie).CuentaIngreso
      If Cuenta = "" Then
        If Me.Condicion <> "CONTADO" Then
          Set instCondicion = Condiciones.Item(Me.Condicion)
          Cuenta = instCondicion.CuentaIngreso
        End If
      End If
      If Cuenta = "" Then Cuenta = Empresa.CuentaGeneralVentas
      Valor = cDetalle.PrecioEfectivo
      instComprobante.AddDetalle Cuenta, "Ingreso por Ventas, Fc. " & Me.Referencia, 0#, Valor

' Acumula la comisin correspondiente
      If Not instVendedor.NoCobraComision Then
        Select Case instVendedor.TipoComisionVenta
        Case 1
          lComision = lComision + cDetalle.PrecioEfectivo * ItemVenta.PComis1 / 100#
        Case 2
          lComision = lComision + cDetalle.PrecioEfectivo * ItemVenta.PComis2 / 100#
        Case 3
          lComision = lComision + cDetalle.PrecioEfectivo * ItemVenta.PComis3 / 100#
        End Select
      End If
    End If

  Next
  Set ItemVenta = Nothing
  Set misDetalles = Nothing
  
' 2.- Actualiza la comisin de la factura...
  If Not instVendedor.NoCobraComision Then
    Me.Comision = lComision
    If Empresa.AcreditarComision Or Condicion = "CONTADO" Then
      If lComision > 0.1 Then
        instComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Comis. en factura " & Me.Referencia & ", Vend. " & Me.CodigoVendedor, lComision, 0
        Set instDetalle = New clsDetalleCuentaEntidad
        instDetalle.Add 0, Me.CodigoVendedor, instVendedor.TipoEntidad, Me.FechaTransaccion, stFullLength(Me.Referencia & Me.NombreCliente, 50), -lComision, instComprobante
        Set instDetalle = Nothing
      End If
      Me.ComisionAcreditada = True
    Else
      Me.ComisionAcreditada = False
    End If
  Else
    Me.Comision = 0
    Me.ComisionAcreditada = True
  End If

' 3.- Registro contable del Impuesto

  If Me.Impuesto2 > 0.01 Then instComprobante.AddDetalle Empresa.CuentaImpuesto2, "Impuesto retenido en Factura " & Me.Referencia, 0#, Me.Impuesto2

' 4.- Actualizacion de la cuenta del Cliente (a travs de un documento ISPC)
  
  If Me.Condicion <> "CONTADO" Then
    Set instDocumento = New clsDocumentosISPC
    instDocumento.CreateNewDoc instCliente.TipoEntidad, Me.CodigoCliente, Me.Numero, "FCT", Me.FechaTransaccion, Me.PrecioEfectivo + Me.Impuesto1 + Me.Impuesto2, "Factura " & Me.Referencia, instComprobante
    instDocumento.AplicarCondicion Me.Condicion
    If Not DocFis Is Nothing Then
      If DocFis.Retencion <> 0 Then
        Dim det As New clsDetalleCuentaEntidad
        det.Add instDocumento.Numero, instCliente.Codigo, instCliente.TipoEntidad, Me.FechaTransaccion, "Retencion de IVA ", -Abs(DocFis.Retencion), instComprobante
      End If
    End If
    Set instDocumento = Nothing
  End If
      
' 5.- Actualizar fecha de ultima venta al cliente

  instCliente.SetFechaVenta Me.FechaTransaccion

  Set instCliente = Nothing
  Set instVendedor = Nothing

  If Me.Condicion <> "CONTADO" Then
    Me.SituacionAdministrativa = SA_FACTURA_PENDIENTE
  Else
    Me.SituacionAdministrativa = SA_FACTURA_CANCELADA
  End If
  
  ProcesarEfectosAdministrativos = True

End Function

Private Function EmitirOrdenDespacho(Optional f As lfProgresoOperacion = Nothing) As Boolean
  EmitirOrdenDespacho = True
End Function

Private Function AsignarMercanciaTransporte(Optional f As lfProgresoOperacion = Nothing) As Boolean
  AsignarMercanciaTransporte = True
End Function

Public Function AcumularCostoInventario(Optional f As lfProgresoOperacion = Nothing) As Boolean
Dim misDetalles As Collection, cDetalle As clsDetallesFactura
Dim cItemVenta As clsItemVenta
Dim Componentes As Collection, cComponente As clsComponenteItemVenta
'Dim cItemInventario As clsItemInventario
Dim Cuenta As String, Valor As Double

  If Not f Is Nothing Then
    f.ProgressBar1.value = 0
    f.Caption = "Actualizando costo del inventario"
  End If
  Set misDetalles = Me.Detalles
  Set cItemVenta = New clsItemVenta
'    Set cItemInventario = New clsItemInventario

  For Each cDetalle In misDetalles
    If Not f Is Nothing Then f.NextPoint
    If cDetalle.CodigoItem <> "" Then
      cItemVenta.Load cDetalle.CodigoItem
      Set Componentes = cItemVenta.Composicion
      If Componentes.Count <> 0 Then   ' Si es un item compuesto por inventario
        Valor = cItemVenta.CostoStandard * cDetalle.Cantidad * cDetalle.FactorEmpaque
        Cuenta = cItemVenta.CuentaCosto
        If Cuenta = "" Then Cuenta = Empresa.CuentaGeneralCosto
        If Cuenta = "" Then
          instComprobante.SetError
          Exit For
        End If
        instComprobante.AddDetalle Cuenta, "Costo de mercancia,  Fact. " & Me.Referencia, Valor, 0#
      End If
      Set Componentes = Nothing
      If instComprobante.isError Then Exit For
    End If
  Next
  If Not f Is Nothing Then f.ProgressBar1.value = f.ProgressBar1.max

'    Set cItemInventario = Nothing
  Set cItemVenta = Nothing
  Set misDetalles = Nothing

  AcumularCostoInventario = True

End Function

Private Function RebajarMercancia(Optional f As lfProgresoOperacion = Nothing) As Boolean
Dim instAlmacen As clsAlmacen, col As Collection
Dim instDetFact As clsDetallesFactura, instItemVenta As clsItemVenta
Dim isOk As Boolean, NumCompAlmacen As Long

  Set instAlmacen = Almacenes.Item(lAlmacen)
  If instAlmacen Is Nothing Then
    ReportarError False, ERR_ITEM_NOT_FOUND, "Almacen no localizado: " & lAlmacen, "Factura.RebajarMercancia"
    RebajarMercancia = False
  End If
  Set instItemVenta = New clsItemVenta
  
  isOk = instAlmacen.StartComprobante(Me.FechaTransaccion, Me.TipoEntidad, Me.Numero, 0, "Entrega directa de la factura " & Me.Referencia)
  If isOk Then
    Set col = Me.Detalles
    For Each instDetFact In col
      If instDetFact.CodigoItem <> "" Then
        If Not instItemVenta.Load(instDetFact.CodigoItem) Then
          ReportarError False, ERR_ITEM_NOT_FOUND, "itemVenta no localizado: " & instDetFact.CodigoItem, "Factura.RebajarMercancia"
          isOk = False
          Exit For
        End If
        isOk = instItemVenta.DescargarInventario(instAlmacen, instDetFact.CantidadEfectiva, instComprobante)
        If Not isOk Then Exit For
      End If
    Next
  End If
  
  If isOk Then
    instAlmacen.CerrarComprobante instComprobante
  End If
  
  Set instItemVenta = Nothing
  Set instAlmacen = Nothing
  If isOk Then isOk = AcumularCostoInventario(f)  ' Necesaria porque la factura mueve inventario contra Costo de las Ventas ...
  RebajarMercancia = isOk                             ' ... en transacciones ms sencillas (compras, ajustes), es prescindible
End Function

Private Function ActualizarDetallesItemVenta(Optional fProgress As lfProgresoOperacion = Nothing) As Boolean
Dim bResult As Boolean
Dim colDetalles As Collection, instDetalleFactura As clsDetallesFactura, instDetalleItem As clsDetalleItemVenta
  bResult = True
  
  If Not fProgress Is Nothing Then
    fProgress.ProgressBar1.value = 0
    fProgress.Caption = "Actualizar estadsticas por producto"
  End If
  Set instDetalleItem = New clsDetalleItemVenta
  Set colDetalles = Me.Detalles
  
  Me.Costo = 0
  For Each instDetalleFactura In colDetalles
    If Not fProgress Is Nothing Then fProgress.NextPoint
    If instDetalleFactura.CodigoItem <> "" Then
      instDetalleItem.CodigoCliente = Me.CodigoCliente
      instDetalleItem.CodigoVendedor = Me.CodigoVendedor
      instDetalleItem.CodigoItem = instDetalleFactura.CodigoItem
      instDetalleItem.Cantidad = instDetalleFactura.CantidadEfectiva
      instDetalleItem.NumeroFactura = Me.Numero
      instDetalleItem.FechaOperacion = Me.FechaTransaccion
      instDetalleItem.PrecioReferencia = instDetalleFactura.PrecioLista / instDetalleFactura.FactorEmpaque
      instDetalleItem.PrecioVenta = instDetalleFactura.PrecioEfectivo / (instDetalleFactura.FactorEmpaque * instDetalleFactura.Cantidad)
      instDetalleItem.Serie = Me.Serie
      instDetalleItem.CostoStandard = instDetalleFactura.CostoUnitario
      Me.Costo = Me.Costo + instDetalleItem.Cantidad * instDetalleItem.CostoStandard
      If Not AlmacenDetallesItemVenta.Add(instDetalleItem) Then
        bResult = False
        Exit For
      End If
    End If
  Next
  
  dbHandle.Execute "UPDATE Facturas SET Costo = " & NumeroDB(Me.Costo) & " WHERE Numero = " & NumeroDB(Me.Numero)
  
  Set colDetalles = Nothing
  Set instDetalleItem = Nothing
  If Not fProgress Is Nothing Then fProgress.ProgressBar1.value = fProgress.ProgressBar1.max
  ActualizarDetallesItemVenta = True

End Function

' ---------- PROCESO: Interfaz con la aplicacin: ------------

' Permite agregar una lnea desde afuera al comprobante... Inicialmente para contrpartida CAJA en POS

Public Function AddLineaComprobante(stCuenta As String, stDescripcion As String, ByVal Debitos As Double, ByVal Creditos As Double) As Boolean
  If Not inProcess Then
    AddLineaComprobante = False
  Else
    AddLineaComprobante = instComprobante.AddDetalle(stCuenta, stDescripcion, Debitos, Creditos)
  End If
End Function

Public Function StartProcess(TipoProceso As StatDespacho, doAdmin As Boolean, Almacen As String, Transporte As String) As Boolean
Dim bProcessStarted As Boolean, lOrgNumero As Long
Dim lCliente As clsClientes, cVendedor As clsVendedores
    
  If ErrorValidacion Then
    Err.Raise 1001, "clsFacturas::StartProcess", "Datos Invlidos"
    Exit Function
  End If

  lOrgNumero = Me.Numero

  Me.EstadoDespacho = TipoProceso
  Me.Comision = 0#
  Me.Costo = 0#
  Me.CostoDevuelto = 0#
  Me.DescuentosProntoPago = 0#
  Me.FechaRegistro = Date
  Me.Operador = UsuarioActivo.Codigo
  Me.PrecioDevuelto = 0#
  Me.PrecioEfectivo = 0#
  Me.PrecioLista = 0#
  Me.PrecioVenta = 0#
  Me.Saldo = 0#
  Me.SituacionAdministrativa = SA_FACTURA_ABIERTA
  
  lAlmacen = Almacen
  lTransporte = Transporte
  lDoAdmin = doAdmin

  Set lCliente = AlmacenClientes.Cliente(Me.CodigoCliente)
  If (lCliente Is Nothing) Then
    inProcess = False
    Err.Raise 10001, "clsFacturas::StartProcess", "No existe el cliente " & Me.CodigoCliente
    StartProcess = False
    Exit Function
  End If
  Set lCliente = Nothing

  Set cVendedor = AlmacenVendedores.Vendedor(Me.CodigoVendedor)
  If cVendedor Is Nothing Then
    inProcess = False
    Err.Raise 10001, "clsFacturas::StartProcess", "No existe el vendedor " & Me.CodigoVendedor
    StartProcess = False
    Exit Function
  End If
  Set cVendedor = Nothing

  bProcessStarted = AlmacenFacturas.StartProcess(Me)

  If bProcessStarted Then
    If lOrgNumero Then  ' Resetear cualuier efecto anterior de la factura...
      AlmacenDetallesItemVenta.KillDetallesFactura lOrgNumero
      AlmacenDetallesFactura.KillDetallesFactura lOrgNumero
    End If
    NextDetalle = 1
    Set instComprobante = New clsBufferComprobante
    instComprobante.StartComprobante Me.FechaTransaccion, Me.TipoEntidad & Me.Referencia, Me.NombreCliente
    
'    If lDoAdmin Then
'      Set pLibroVentas = New clsLibroVentas
'      pLibroVentas.IniciarProceso Me.FechaTransaccion, Me.Referencia, Me.CodigoCliente
'    End If

  Else
    inProcess = False
  End If

  StartProcess = bProcessStarted

End Function

Public Function AddDetalle(CodigoItemV As String, _
                Descripcion As String, _
                Presentacion As String, _
                Cantidad As Double, _
                PrecioLista As Double, _
                PrecioVenta As Double, _
                Optional FormProgreso As lfProgresoOperacion = Nothing) As Boolean
Dim instDetalle As clsDetallesFactura, instItemVenta As clsItemVenta
Dim dPrecioTotal As Double, dFactorDescuento As Double

  If Not FormProgreso Is Nothing Then
    FormProgreso.NextPoint
  End If
  
    If CodigoItemV <> "" Then
        Set instItemVenta = New clsItemVenta
        If Not instItemVenta.Load(CodigoItemV) Then
            If Not FormProgreso Is Nothing Then
              FormProgreso.ShowException "No encontr el producto " & CodigoItemV, True
              If FormProgreso.doBreak Then
                Set instItemVenta = Nothing
                AddDetalle = False
                Exit Function
              End If
            Else
              Err.Raise 10001, "clsFacturas::AddDetalle", "Item " & CodigoItemV & " no localizado"
              AddDetalle = False
              Exit Function
            End If
        End If
    End If

    Set instDetalle = New clsDetallesFactura

    instDetalle.NumeroDocumento = Me.Numero
    instDetalle.Renglon = NextDetalle: NextDetalle = NextDetalle + 1
    instDetalle.CodigoItem = CodigoItemV
    instDetalle.Descripcion = Descripcion
    If CodigoItemV <> "" Then
      instDetalle.Presentacion = Presentacion
      instDetalle.FactorEmpaque = instItemVenta.FactorPresentacion(Presentacion)
      If instDetalle.FactorEmpaque = 0 Then instDetalle.FactorEmpaque = 1
      instDetalle.Cantidad = Cantidad
      instDetalle.PrecioLista = PrecioLista
      instDetalle.PrecioVenta = PrecioVenta   ' Anterior a aplicacin de descuentos e impuestos
  
      dPrecioTotal = Cantidad * PrecioVenta
  
      instDetalle.PrecioEfectivo = dPrecioTotal * (1# - ValorDescuentosSucesivos(Me.Descuento1, Me.Descuento2) / 100#)
      instDetalle.PrecioEfectivo = TiposImpuesto.PrecioNeto(instDetalle.PrecioEfectivo, instItemVenta.TipoImpuesto1, instItemVenta.TipoImpuesto2)
      instDetalle.Impuesto1 = instDetalle.PrecioEfectivo * TiposImpuesto.ValorActualImpuesto(instItemVenta.TipoImpuesto1) / 100#
      instDetalle.Impuesto2 = instDetalle.PrecioEfectivo * TiposImpuesto.ValorActualImpuesto(instItemVenta.TipoImpuesto2) / 100#
      instDetalle.CostoUnitario = instItemVenta.CostoStandard
  
      Me.PrecioLista = Me.PrecioLista + PrecioLista * Cantidad
      Me.PrecioVenta = Me.PrecioVenta + PrecioVenta * Cantidad
      Me.PrecioEfectivo = Me.PrecioEfectivo + instDetalle.PrecioEfectivo
      'Me.Impuesto1 = Me.Impuesto1 + instDetalle.Impuesto1    ' Overriden en frmDefinirProcesoFactura
      'Me.Impuesto2 = Me.Impuesto2 + instDetalle.Impuesto2    ' Not used
    End If

    AddDetalle = AlmacenDetallesFactura.Add(instDetalle)
    
'    If lDoAdmin Then pLibroVentas.AnotarDetalle instDetalle
    
    Set instDetalle = Nothing
    Set instItemVenta = Nothing

End Function

Public Sub EndProcess(doPrint As Boolean, Optional fProgress As lfProgresoOperacion = Nothing, Optional DocFis As CDocumentoFiscal = Nothing)
    
  If Not ActualizarDetallesItemVenta(fProgress) Then
    AbortProcess
    Exit Sub
  End If
  
  Select Case Me.EstadoDespacho
  Case SD_FACTURA_ENTREGADA       ' Activar salida de despacho de almacen
    If Not RebajarMercancia(fProgress) Then
      AbortProcess
      Exit Sub
    End If
  Case SD_FACTURA_PROCESO
    If Not EmitirOrdenDespacho(fProgress) Then
      AbortProcess
      Exit Sub
    End If
  Case SD_FACTURA_TRANSITO
    If Not AsignarMercanciaTransporte(fProgress) Then
      AbortProcess
      Exit Sub
    End If
  End Select
  
  If lDoAdmin Then
    
    If Not ProcesarEfectosAdministrativos(fProgress, DocFis) Then
      AbortProcess
      Exit Sub
    End If
    If Not DocFis Is Nothing Then
      DocFis.NombreEntidad = Me.NombreCliente
      DocFis.NumeroDoc = Me.Numero
      DocFis.Referencia = Me.Referencia
      DocFis.FillComprobante Empresa, instComprobante
      DocFis.Grabar New CFactoria
    End If
  End If

  AlmacenFacturas.EndProcess Me
  If doPrint Then SubmitDoc Me
  
  inProcess = False
  
End Sub

Public Sub AbortProcess()
  If inProcess Then
    Set instComprobante = Nothing
    AlmacenFacturas.AbortProcess
  End If
  inProcess = False
End Sub

Private Sub Class_Initialize()
  inProcess = False
  TipoEntidad = "FCT"
  Set pEvaluadorVariable = New CExpEvalDocVenta
End Sub

Public Function RegistrarVariacion(vmMonto As Currency, pComprobante As clsBufferComprobante) As Boolean
Dim instDetalle As clsDetalleCuentaEntidad
  If Not AlmacenFacturas.RegistrarVariacion(Me, vmMonto) Then
    RegistrarVariacion = False
    Exit Function
  End If

  Me.Saldo = Me.Saldo + vmMonto

  If Me.Saldo > 0.1 Then
    RegistrarVariacion = True
    Exit Function
  End If

  If Me.ComisionAcreditada Then
    RegistrarVariacion = True
    Exit Function
  End If

  If Me.Comision < 0.1 Then
    RegistrarVariacion = True
    Exit Function
  End If

  pComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Comis. en factura " & Me.Referencia & ", Vend. " & Me.CodigoVendedor, Me.Comision, 0
  Set instDetalle = New clsDetalleCuentaEntidad
  instDetalle.Add 0, Me.CodigoVendedor, "VND", Me.FechaTransaccion, stFullLength(Me.Referencia & Me.NombreCliente, 50), -Me.Comision, pComprobante
  AlmacenFacturas.SetAcreditada Me.Numero
  Set instDetalle = Nothing

  RegistrarVariacion = True

End Function

' Actualizaciones por Devolucion

Public Function AddImpuestosDevueltos(vmImpuesto1 As Currency, vmImpuesto2 As Currency) As Boolean
Dim sQuery As String, isOk As Boolean

  On Error GoTo ErrHandler
  Me.Impuesto1Devuelto = Me.Impuesto1Devuelto + vmImpuesto1
  Me.Impuesto2Devuelto = Me.Impuesto2Devuelto + vmImpuesto2
  
  sQuery = "UPDATE Facturas SET Impuesto1Devuelto = Impuesto1Devuelto + " & NumeroDB(vmImpuesto1) & ", Impuesto2Devuelto = Impuesto2Devuelto + " & NumeroDB(vmImpuesto2) & " WHERE Numero =" & NumeroDB(Me.Numero)
  isOk = True
  dbHandle.Execute sQuery

ResumePoint:
  AddImpuestosDevueltos = isOk
  Exit Function

ErrHandler:
  ReportarError False, Err.Number, Err.Description, "Facturas.AddImpuestosDevueltos"
  isOk = False
  Err.Clear
  Resume ResumePoint

End Function


Public Function AddCostoDevuelto(vmCostoDev As Currency) As Boolean
Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler
    Me.CostoDevuelto = Me.CostoDevuelto + vmCostoDev
    sQuery = "UPDATE Facturas SET CostoDevuelto = CostoDevuelto + " & NumeroDB(vmCostoDev) & " WHERE Numero =" & NumeroDB(Me.Numero)
    isOk = True
    dbHandle.Execute sQuery

ResumePoint:
    AddCostoDevuelto = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Facturas.AddCostoDevuelto"
    isOk = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function AddPrecioDevuelto(vmPrecioDev As Currency) As Boolean
Dim sqlStr As String, isOk As Boolean

    On Error GoTo ErrHandler
    Me.PrecioDevuelto = Me.PrecioDevuelto + vmPrecioDev
    sqlStr = "UPDATE Facturas SET PrecioDevuelto = PrecioDevuelto +" & NumeroDB(vmPrecioDev) & " WHERE Numero =" & NumeroDB(Me.Numero)
    isOk = True
    dbHandle.Execute sqlStr

ResumePoint:
    AddPrecioDevuelto = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Facturas.AddPrecioDevuelto"
    isOk = False
    Err.Clear
    Resume ResumePoint

End Function

Public Function AnotarItemDevuelto(lngRenglon As Long, dblCantidad As Double) As Boolean
Dim sqlQuery As String, isOk As Boolean, rs As Recordset, dDevueltas As Double

    isOk = True
    sqlQuery = "UPDATE DetallesFactura SET Devueltas = Devueltas +" & NumeroDB(dblCantidad) & " WHERE NumeroDocumento=" & NumeroDB(Me.Numero) & " AND Renglon = " & NumeroDB(lngRenglon)
    On Error GoTo ErrHandler
    dbHandle.Execute sqlQuery

ResumePoint:
    AnotarItemDevuelto = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "Facturas.AnotarItemDevuelto"
    isOk = False
    Err.Clear
    Resume ResumePoint

End Function

' SaldoItem: Cantidad (en unidades absolutas) de unidades eectivas (vendidas - devueltas)
'            vendidas del item stCodigoItem
Public Function SaldoItem(stCodigoItem As String) As Double
Dim rs As Recordset, sqlQuery As String, dblRetVal As Double

    sqlQuery = "SELECT * FROM DetallesFactura WHERE NumeroDocumento =" & NumeroDB(Me.Numero) & " CodigoItem = " & StringDB(stCodigoItem)
    Set rs = dbHandle.Execute(sqlQuery)
    If rs.EOF Then
        dblRetVal = 0
    Else
        dblRetVal = (rs.Fields("Cantidad") - rs.Fields("Devueltas")) * rs.Fields("FactorEmpaque")
    End If
    rs.Close
    Set rs = Nothing
    
    SaldoItem = dblRetVal

End Function

Public Function DetalleItem(ByVal Renglon As Long) As clsDetallesFactura
Dim rs As Recordset, sqlQuery As String, pDetalle As clsDetallesFactura

    sqlQuery = "SELECT * FROM DetallesFactura WHERE NumeroDocumento =" & NumeroDB(Me.Numero) & " AND Renglon =" & NumeroDB(Renglon)
    Set rs = dbHandle.Execute(sqlQuery)
    If rs.EOF Then
        Set pDetalle = Nothing
    Else
        Set pDetalle = New clsDetallesFactura
        AlmacenDetallesFactura.LoadInstance pDetalle, rs
    End If
    rs.Close
    Set rs = Nothing

    Set DetalleItem = pDetalle

End Function

Private Sub Class_Terminate()

    Set pEvaluadorVariable = Nothing

End Sub

Public Sub UpdateNotas(istrText As String)

    On Error GoTo ErrHandler
    Me.Notas = istrText
    dbHandle.Execute "UPDATE Facturas SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
    Exit Sub

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsFacturas::UpdateNotas"
    Err.Clear

End Sub

Public Sub SetDespachada()

    Me.EstadoDespacho = SD_FACTURA_ENTREGADA
    dbHandle.Execute "UPDATE Facturas SET EstadoDespacho = " & NumeroDB(Me.EstadoDespacho) & " WHERE Numero = " & NumeroDB(Me.Numero)

End Sub
