VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsExportadorVentas"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const COL_CODIGO = 1, _
                COL_DESCRIPCION = 2, _
                COL_PRECIO = 3, _
                COL_CANTIDAD = 4, _
                COL_VENTA = 5, _
                COL_IMPUESTO = 6, _
                COL_TOTAL = 7

Public Sub Exportalas(pSesion As clsSesionPOS)
Dim theApp As Excel.Application
Dim ws As Excel.Worksheet, wb As Excel.Workbook
Dim nextRow As Long
Dim rs As Recordset

    On Error GoTo ErrHandler

    Screen.MousePointer = vbHourglass

    Set theApp = New Excel.Application
    
    If Dir("C:\Mis Documentos\Resumen.xls") = "" Then
        Set wb = theApp.Workbooks.Add
    Else
        Set wb = theApp.Workbooks.Open("C:\Mis Documentos\Resumen.xls")
    End If

    theApp.Visible = False
    Set ws = theApp.Worksheets.Add(after:=Worksheets(Worksheets.Count))
    With ws.Cells(1, 1)
        .Value = "OPERADOR"
        .Font.Bold = True
    End With
    ws.Cells(1, 2).Value = pSesion.usrID
    
    With ws.Cells(2, 1)
        .Value = "CIERRE: "
        .Font.Bold = True
    End With
    ws.Cells(2, 2).Value = Format(Now, "dd-mm-yy hh:mm")
    
    With ws.Cells(3, 1)
        .Value = "TERMINAL:"
        .Font.Bold = True
    End With
    ws.Cells(3, 2).Value = pSesion.MachineID

    With ws.Cells(4, 1)
        .Value = "Fact.inicial:"
        .Font.Bold = True
    End With
    ws.Cells(4, 2).Value = pSesion.NumeroPrimeraFactura
    
    With ws.Cells(4, 4)
        .Value = "Fact. Final:"
        .Font.Bold = True
    End With
    ws.Cells(4, 5).Value = pSesion.NumeroUltimaFactura
    
    With ws.Cells(4, 6)
        .Value = "Q. Facturas:"
        .Font.Bold = True
    End With
    ws.Cells(4, 7).Value = pSesion.FacturasRealizadas

    With ws.Cells(6, COL_CODIGO)
        .Value = "PRODUCTO"
        .Font.Bold = True
    End With
    ws.Columns(COL_CODIGO).HorizontalAlignment = xlHAlignLeft
    
    ws.Columns(COL_DESCRIPCION).ColumnWidth = 40
    With ws.Cells(6, COL_DESCRIPCION)
        .Value = "DESCRIPCION"
        .Font.Bold = True
    End With

    ws.Columns(COL_PRECIO).HorizontalAlignment = xlHAlignRight
    With ws.Cells(6, COL_PRECIO)
        .Value = "PRECIO"
        .Font.Bold = True
    End With
    
    ws.Columns(COL_CANTIDAD).HorizontalAlignment = xlHAlignRight
    With ws.Cells(6, COL_CANTIDAD)
        .Value = "CANTIDAD"
        .Font.Bold = True
    End With

    ws.Columns(COL_VENTA).HorizontalAlignment = xlHAlignRight
    With ws.Cells(6, COL_VENTA)
        .Value = "VENTA"
        .Font.Bold = True
    End With
    
    ws.Columns(COL_IMPUESTO).HorizontalAlignment = xlHAlignRight
    With ws.Cells(6, COL_IMPUESTO)
        .Value = "I.V.A."
        .Font.Bold = True
    End With
    
    ws.Columns(COL_TOTAL).HorizontalAlignment = xlHAlignRight
    With ws.Cells(6, COL_TOTAL)
        .Value = "TOTAL"
        .Font.Bold = True
    End With

    nextRow = 7

    Set rs = dbHandle.OpenRecordset("SELECT A.*, I.Descripcion FROM AcumularSesionPOS AS A, itemsVenta AS I WHERE A.SesionID = " & NumeroDB(pSesion.SessionID) & " AND I.Codigo = A.CodigoProducto ORDER BY I.Descripcion", dbOpenForwardOnly)
    Do While Not rs.EOF
    
        With ws
        .Cells(nextRow, COL_CODIGO).Value = rs.Fields("CodigoProducto")
        .Cells(nextRow, COL_DESCRIPCION).Value = rs.Fields("Descripcion")
        .Cells(nextRow, COL_PRECIO).Value = rs.Fields("Precio")
        .Cells(nextRow, COL_CANTIDAD).Value = rs.Fields("Cantidad")
        .Cells(nextRow, COL_VENTA).Value = rs.Fields("Precio") * rs.Fields("Cantidad")
        .Cells(nextRow, COL_IMPUESTO).Value = rs.Fields("Precio") * rs.Fields("Cantidad") * rs.Fields("PorcentajeImpuesto") / 100
        .Cells(nextRow, COL_TOTAL).Value = .Cells(nextRow, COL_VENTA).Value + .Cells(nextRow, COL_IMPUESTO).Value
        End With
        nextRow = nextRow + 1
        rs.MoveNext

    Loop

    Set rs = Nothing

    If Dir("C:\Mis Documentos\resumen.xls") = "" Then
        wb.SaveAs filename:="C:\Mis Documentos\Resumen.xls"
    Else
        wb.Save
    End If

    theApp.Quit
    Screen.MousePointer = vbDefault

    Exit Sub

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsExportadorVentas::Exportalas"
    Err.Clear
    Screen.MousePointer = vbDefault

End Sub
