VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsEquipo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const ANCHO_REPORTE = 119

Public TipoEquipo As String
Public Serial As String
Public Propietario As String
Public Notas As String
Public Estado As enmEstadosEquipo
Public Saldo As Currency

Public Function EnDeposito() As Boolean
Dim bEnDeposito As Boolean

  Select Case Estado
  Case NUEVO, ENTREGADO
    bEnDeposito = False
  Case Else
    bEnDeposito = True
  End Select
  
  EnDeposito = bEnDeposito
End Function

Public Function Referencia() As String

    Referencia = TipoEquipo & "-" & Serial

End Function

Public Function ImagenEstado() As String
Dim s As String

    Select Case Estado
    Case NUEVO
        s = "NUEVO"
    Case Recibido
        s = "RECIBIDO"
    Case ASIGNADO
        s = "ASIGNADO"
    Case REPARADO
        s = "REPARADO"
    Case ENTREGADO
        s = "ENTREGADO"
    End Select

    ImagenEstado = s

End Function

Private Sub LoadInstance(pDest As clsEquipo, rs As Recordset)

    With pDest
    .Estado = GetNumeroFromVariant(rs.Fields("Estado"))
    .Notas = stGetStringFromVariant(rs.Fields("Notas"))
    .Propietario = stGetStringFromVariant(rs.Fields("Propietario"))
    .Saldo = GetNumeroFromVariant(rs.Fields("Saldo"))
    .Serial = stGetStringFromVariant(rs.Fields("Serial"))
    .TipoEquipo = stGetStringFromVariant(rs.Fields("TipoEquipo"))
    End With

End Sub

Private Function RegistrarNuevoEquipo(sTipo As String, sSerial As String) As Boolean
Dim frmEquipo As FIEEquipos

    If Not Confirmar("Registar nuevo equipo") Then
        RegistrarNuevoEquipo = False
        Exit Function
    End If

    Set frmEquipo = New FIEEquipos
    frmEquipo.SetData sTipo, sSerial
    frmEquipo.SetContexto 3
    
    If Not frmEquipo.Visible Then frmEquipo.Show
    While frmEquipo.Visible: DoEvents: Wend
    Unload frmEquipo
    Set frmEquipo = Nothing
    
    RegistrarNuevoEquipo = Me.Load(sTipo, sSerial)

End Function

Public Function Validar(sTipo As String, sSerial As String) As Boolean
Dim pEquipo As clsEquipo, rs As Recordset
Dim sQuery As String, isOk As Boolean

    sQuery = "SELECT TipoEquipo FROM rwsEquipos WHERE TipoEquipo = " & StringDB(sTipo) & " AND Serial = " & StringDB(sSerial)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    isOk = Not rs.EOF
    Set rs = Nothing

    If Not isOk Then
        Validar = RegistrarNuevoEquipo(sTipo, sSerial)
    Else
        Validar = True
    End If

End Function

Public Function LoadBySerial(sSerial As String) As Boolean
Dim sQuery As String, isOk As Boolean, rs As Recordset

    sQuery = "SELECT Count(TipoEquipo) AS q FROM rwsEquipos WHERE Serial = " & StringDB(sSerial)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    isOk = True
    If rs.Fields("q") <> 1 Then isOk = False
    Set rs = Nothing
    
    If Not isOk Then
        LoadBySerial = False
        Exit Function
    End If

    sQuery = "SELECT * FROM rwsEquipos WHERE Serial = " & StringDB(sSerial)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        isOk = True
        LoadInstance Me, rs
    Else
        isOk = False
    End If
    
    Set rs = Nothing
    
    LoadBySerial = isOk

End Function

Public Function Load(sTipo As String, sSerial As String) As Boolean
Dim sQuery As String, isOk As Boolean, rs As Recordset

    sQuery = "SELECT * FROM rwsEquipos WHERE TipoEquipo = " & StringDB(sTipo) & " AND Serial = " & StringDB(sSerial)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If Not rs.EOF Then
        isOk = True
        LoadInstance Me, rs
    Else
        isOk = False
    End If
    
    Set rs = Nothing
    
    Load = isOk

End Function

Public Function ActualizarDescriptivos(sPropietario As String, sNotas As String) As Boolean
Dim isOk As Boolean, sQuery As String

    sQuery = "UPDATE rwsEquipos SET Propietario = " & StringDB(sPropietario) & ", Notas = " & StringDB(sNotas) & " WHERE TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial = " & StringDB(Me.Serial)
    isOk = True
    On Error GoTo ErrHandler
    dbHandle.Execute sQuery, dbFailOnError

    Me.Propietario = sPropietario
    Me.Notas = sNotas

ResumePoint:
    ActualizarDescriptivos = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsEquipo::ActualizarDescriptivos"
    Resume ResumePoint

End Function

Public Function CreateNew() As Boolean
' Quien llame a esta funcin debe haber asignado los valores correctos a los
' diferentes campos del registro
' Los campos requeridos son: TipoEquipo, Serial, Propietario y Notas, ya que
' inicialmente Estado = NUEVO y Saldo = 0.0
' Generalmente slo es llamada desde la FIE
Dim sQuery As String, isOk As Boolean

    isOk = True
    On Error GoTo ErrHandler
    sQuery = "INSERT INTO rwsEquipos (TipoEquipo, Serial, Propietario, Notas) VALUES (" & StringDB(Me.TipoEquipo) & ", " & StringDB(Me.Serial) & ", " & StringDB(Me.Propietario) & ", " & StringDB(Me.Notas) & ")"

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    CreateNew = isOk
    Exit Function

ErrHandler:
    isOk = False
    ReportarError False, Err.Number, Err.Description, "clsEquipos::CreateNew"
    Resume ResumePoint

End Function

Public Function LoadSiguiente() As Boolean
Dim sQuery As String, isOk As Boolean, rs As Recordset

    sQuery = "SELECT TOP 1 * FROM rwsEquipos WHERE (TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial > " & StringDB(Me.Serial) & ") OR (TipoEquipo > " & StringDB(Me.TipoEquipo) & ") ORDER BY TipoEquipo ASC, Serial ASC"
    isOk = True
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        isOk = False
    Else
        LoadInstance Me, rs
    End If
    
ResumePoint:
    Set rs = Nothing
    LoadSiguiente = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsEquipo::LoadSiguiente"
    isOk = False
    Resume ResumePoint

End Function

Public Function LoadAnterior() As Boolean
Dim sQuery As String, isOk As Boolean, rs As Recordset

    sQuery = "SELECT TOP 1 * FROM rwsEquipos WHERE (TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial < " & StringDB(Me.Serial) & ") OR (TipoEquipo < " & StringDB(Me.TipoEquipo) & ") ORDER BY TipoEquipo DESC, Serial DESC"
    isOk = True
    On Error GoTo ErrHandler
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        isOk = False
    Else
        LoadInstance Me, rs
    End If
    
ResumePoint:
    Set rs = Nothing
    LoadAnterior = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsEquipo::LoadAnterior"
    isOk = False
    Resume ResumePoint

End Function

Public Function Eliminar() As Boolean
Dim isOk As Boolean, sQuery As String

    On Error GoTo ErrHandler
    isOk = True
    sQuery = "DELETE * FROM rwsEquipos WHERE TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial = " & StringDB(Me.Serial)

    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:

    Eliminar = isOk
    Exit Function

ErrHandler:

    ReportarError False, Err.Number, Err.Description, "clsEquipos::Eliminar"
    isOk = False
    Resume ResumePoint

End Function

Public Function NombrePropietario() As String
Dim pCliente As clsClientes

    Set pCliente = New clsClientes
    If Not pCliente.Load(Propietario) Then
        NombrePropietario = "INVALIDO"
    Else
        NombrePropietario = pCliente.Nombre
    End If
    Set pCliente = Nothing

End Function

Public Function FechaUltimaReparacion() As Date
Dim sQuery As String, rs As Recordset, dtFecha As Date

    sQuery = "SELECT Max(FechaRecepcion) as Fecha FROM rwsOrdenesTrabajo WHERE TipoEquipo =" & StringDB(Me.TipoEquipo) & " AND Serial = " & StringDB(Me.Serial)
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    dtFecha = GetDateFromVariant(rs.Fields("Fecha"))
    Set rs = Nothing
    
    FechaUltimaReparacion = dtFecha

End Function

Public Function SetEstado(sTipoEquipo As String, sSerial As String, nuevoEstado As enmEstadosEquipo) As Boolean
Dim sQuery As String, isOk As Boolean

    On Error GoTo ErrHandler

    isOk = True

    If Not Me.Load(sTipoEquipo, sSerial) Then
        mAdvertencia "ERROR Equipo no encontrado en SetEstado"
        SetEstado = False
        Exit Function
    End If

    Me.Estado = nuevoEstado

    sQuery = "UPDATE rwsEquipos SET Estado = " & Str(nuevoEstado) & " WHERE TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND Serial = " & StringDB(Me.Serial)
    dbHandle.Execute sQuery, dbFailOnError

ResumePoint:
    SetEstado = isOk
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "clsEquipo::SetEstado"
    isOk = False
    Resume ResumePoint

End Function

'    Empresa....
'  Lista de Reparaciones Efectuadas
' Equipo: TTTTT-SSSSSS. Propietario: XXXX.....
'
'Emision: ddddd dd de mmmmmm de yyyy.    Operador: XXXXXXX.   Pgina: ppp
'-----------------------------------------------------------------------------------------------------------------------
' Orden   Fecha    Sintoma                               Tcnico   Factura            Valor      Impuesto          Total
'-----------------------------------------------------------------------------------------------------------------------
'000000 99-99-9999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX XXXXXXXX DIR-000000 999.999.999,99 99.999.999,99 999.999.999,99
    Private Sub WriteLinea(fView As lfQuickView, sNumeroOrden As String, sFecha As String, sSintoma As String, sTecnico As String, sFactura As String, vValor As Currency, vImpuesto As Currency)
    Dim sOut As String

        sOut = stFullLength(sNumeroOrden, 7) & " " & stFullLength(sFecha, 10) & " " & stFullLength(sSintoma, 37) & " " & stFullLength(sTecnico, 8) & " " & stFullLength(sFactura, 10) & " "
        sOut = sOut & FormatNumero(vValor, Empresa.MascaraMonetarios, 14) & " " & FormatNumero(vImpuesto, Empresa.MascaraMonetarios, 13) & FormatNumero(vValor + vImpuesto, Empresa.MascaraMonetarios, 14)
        fView.Add sOut

    End Sub

    Private Sub EncabezadoLR(fView As lfQuickView)
    Dim pCliente As clsClientes, sNombre As String
    
        Set pCliente = New clsClientes
        If pCliente.Load(Me.Propietario) Then
            sNombre = pCliente.Nombre
        Else
            sNombre = "CLIENTE NO LOCALIZADO:" & Me.Propietario
        End If
        Set pCliente = Nothing

        If fView.Pagina > 1 Or fView.Linea > 1 Then
            fView.PageBreak
        End If
        fView.Add ""
        fView.Add Empresa.NombreEmpresa, vbCenter
        fView.Add "Lista de Reparaciones Efectuadas", vbCenter
        fView.Add "Equipo: " & Me.Referencia & ". Propietario: " & sNombre, vbCenter
        fView.Add ""
        fView.Add "Emision: " & Format(Now, "General Date") & ".  Operador: " & UsuarioActivo.Codigo & ".        Pgina:" & Str(fView.Pagina)
        fView.Add String(ANCHO_REPORTE, "-")
        fView.Add " Orden   Fecha    Sintoma                               Tcnico   Factura            Valor      Impuesto          Total"
        fView.Add String(ANCHO_REPORTE, "-")

    End Sub

Public Sub ListarReparaciones()
Dim rs As Recordset, sQuery As String, fView As lfQuickView
Dim lNumeroOrden As String, dtFecha As Date
Dim sSintoma As String, sTecnico As String
Dim sSerie As String, lCorrelativo As Long
Dim vValor As Currency, vImpuesto As Currency
Dim vSintomas As Variant, i As Integer
Dim sxString As String

    sQuery = "SELECT O.Numero, O.FechaRecepcion, O.Sintomas, O.Tecnico, F.Serie, F.Correlativo, F.PrecioEfectivo, F.Impuesto1"
    sQuery = sQuery & " FROM rwsOrdenesTrabajo AS O LEFT JOIN Facturas AS F ON O.Factura = F.Numero"
    sQuery = sQuery & " WHERE O.TipoEquipo = " & StringDB(Me.TipoEquipo) & " AND O.Serial = " & StringDB(Me.Serial)
    
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)

    If Not rs.EOF Then
        Set fView = New lfQuickView
        fView.SetReportWidth ANCHO_REPORTE

        EncabezadoLR fView

        With rs
        Do While Not .EOF

            lNumeroOrden = GetNumeroFromVariant(.Fields("Numero"))
            dtFecha = GetDateFromVariant(.Fields("FechaRecepcion"))
            sSintoma = stGetStringFromVariant(.Fields("Sintomas"))
            sTecnico = stGetStringFromVariant(.Fields("Tecnico"))
            sSerie = stGetStringFromVariant(.Fields("Serie"))
            lCorrelativo = GetNumeroFromVariant(.Fields("Correlativo"))
            vValor = GetNumeroFromVariant(.Fields("PrecioEfectivo"))
            vImpuesto = GetNumeroFromVariant(.Fields("Impuesto1"))
            
            vSintomas = Convert2Lines(sSintoma, 37)

            i = UBound(vSintomas)

            If fView.Linea + i - 2 > fView.LineasPagina Then
                EncabezadoLR fView
            End If

            If lCorrelativo > 0 Then
                sxString = sSerie & "-" & Format(lCorrelativo, "000000")
            Else
                sxString = ""
            End If
            
            WriteLinea fView, Format(lNumeroOrden, "000000"), Format(dtFecha, "Short Date"), (vSintomas(1)), sTecnico, sxString, vValor, vImpuesto
    
            For i = 2 To UBound(vSintomas)
                WriteLinea fView, "", "", (vSintomas(i)), "", "", 0, 0
            Next
            
            .MoveNext

        Loop
        End With
        
        fView.SetNotify Me
        ShowNonModal fView
        
        Unload fView
        Set fView = Nothing

    End If

    Set rsHandle = Nothing

End Sub

Public Function UltimaOrden() As clsOrdenRWS
Dim pOrden As clsOrdenRWS
Dim rs As Recordset
Dim sQuery As String, lNumero As Long

    sQuery = "SELECT Numero FROM rwsOrdenesTrabajo O WHERE O.TipoEquipo = " & StringDB(TipoEquipo) & " AND O.Serial = " & StringDB(Serial) & " AND O.Numero IN (Select Max(Numero) FROM rwsOrdenesTrabajo WHERE TipoEquipo = " & StringDB(TipoEquipo) & " AND Serial = " & StringDB(Serial) & ")"
    Set rs = dbHandle.OpenRecordset(sQuery, dbOpenForwardOnly)
    If rs.EOF Then
        lNumero = 0
    Else
        lNumero = GetNumeroFromVariant(rs.Fields("Numero"))
    End If
    Set rs = Nothing
    
    If Numero = 0 Then
        Set pOrden = Nothing
    Else
        Set pOrden = New clsOrdenRWS
        If Not pOrden.Load(lNumero) Then Set pOrden = Nothing
    End If
    
    Set UltimaOrden = pOrden

End Function

Public Sub ReportClicked(sLinea As String, ByVal nPos As Long)
Dim sImagenNumero As String, lNumero As Long
Dim pOrden As clsOrdenRWS

    sImagenNumero = Trim(Left(sLinea, 7))
    lNumero = Val(sImagenNumero)
    If (lNumero = 0) Then Exit Sub
    Set pOrden = New clsOrdenRWS
    If pOrden.Load(lNumero) Then pOrden.Show
    Set pOrden = Nothing

End Sub

Public Function Cliente() As clsClientes
Dim pCliente As clsClientes

    Set pCliente = New clsClientes
    If Not pCliente.Load(Me.Propietario) Then
        Set pCliente = Nothing
    End If
    
    Set Cliente = pCliente

End Function
