VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsParametrosEmpresa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Adems de implementar la estructura de datos globales de la empresa,
' se aprovecha esta unidad para declarar otra cantidad de tipos globales
' (enumeraciones, etctera), debido a su caracter ubicuo.

Public Enum StatAdmin
    SA_FACTURA_ABIERTA = 0
    SA_FACTURA_PENDIENTE = 1    ' Requiere consistencia con la Orden de Despacho / Guia Transporte
    SA_FACTURA_CANCELADA = 2    ' No se puede modificar
    SA_FACTURA_ANULADA = 3      ' Requiere reactivacin ( a status 0)
End Enum

Public Enum StatDespacho
    SD_FACTURA_ABIERTA = 0      ' No ha producido efecto en el inventario
    SD_FACTURA_PROCESO = 1      ' En fase de acopio (se emiti una orden de despacho)
    SD_FACTURA_TRANSITO = 2     ' Fue entregada al transporte..
    SD_FACTURA_ENTREGADA = 3    ' Fue entregada al cliente...
    SD_FACTURA_ANULADA = 4      ' Fue anulada...
End Enum

Public NombreEmpresa As String
Public RIF As String
Public NIT As String
Public Direccion As String
Public Telefono As String
Public FormatoSaldos As String
Public MascaraPrecios As String
Public MascaraMonetarios As String
Public MascaraInventario As String
Public MascaraCantidades As String
Public FactorRedondeoPrecios As Double
Public DefaultImpuesto1 As String
Public DefaultImpuesto2 As String
Public PrecioIncluyeImpuesto1 As Boolean
Public PrecioIncluyeImpuesto2 As Boolean
Public CodigoClienteMostrador As String
Public MesInicioAnho As Integer
Public AnhoActual As Integer
Public PeriodoActual As Integer
Public FormatoCodigos As String
Public CuentaGanPer As String
Public Separador As String
Public AcreditarComision As Boolean
Public PComisVenta1 As Double
Public PComisVenta2 As Double
Public PComisVenta3 As Double
Public PComisCobranza1 As Double
Public PComisCobranza2 As Double
Public PComisCobranza3 As Double
Public indexarPrecios As Integer ' 0: No indexar, 1: Indexar sobre CostoPromedio, 2: Indexar sobre ultimo costo
Public valoracionInventario As Integer ' 0: Sobre costo promedio, 1: Sobre ultimo costo
Private TitulosPrecio(1 To 4) As String
Public NombreImpuesto1 As String
Public NombreImpuesto2 As String
Public CuentaGeneralVentas As String        ' Ingresos por ventas no especificados
Public CuentaGeneralInventario As String    ' Activos en inventario, no especificados
Public CuentaGeneralDeudas As String        ' Pasivos generales, no especificados
Public CuentaGeneralAcreencias As String    ' Acreencias (cxc) en general
Public CuentaGeneralBancos As String        ' Activo en bancos, no especificado
Public CuentaGeneralCosto As String         ' Costo de ventas, no especificado
Public CuentaGeneralDevoluciones As String  ' Devoluciones de ventas, no especificadas
Public CuentaPasivoComisiones As String     ' Pasivo: Comisiones por pagar
Public CuentaGastosComisiones As String     ' Egresos por comisiones
Public CuentaImpuesto1 As String
Public CuentaImpuesto2 As String
Public CuentaCaja As String
Public ProximaMaquina As Long
Public InicioVigenciaIDB As Date
Public FinVigenciaIDB As Date
Public PorcentajeIDB As Double
Public CuentaGastosIDB As String
Public CuentaISLRAnticipado As String
Public CuentaEgresosComisionTC As String
Public TipoInventarioEnCurso As Integer
Public AlmacenInventarioFisico As String
Public CuentaDescuentosCobranza As String
Public CuentaDescuentosPagos As String
Public CuentaMercanciaDanhada As String
Public CuentaISLRRetenido As String

Public dblLimiteRedondeo As Double

Private rsHandle As Recordset
Private qAperturas As Integer

Public Sub Abrir()
On Error GoTo ErrHandler
    If qAperturas = 0 Then
        Set rsHandle = dbHandle.Execute("SELECT * FROM ParametrosEmpresa")
    End If
    rsHandle.MoveFirst
    LoadInstance rsHandle
    qAperturas = qAperturas + 1
    Exit Sub
ErrHandler:
    ReportarError True, Err.Number, Err.Description, "ParametrosEmpresa.Abrir"
    End
End Sub

Public Sub Cerrar()
    If qAperturas = 0 Then Exit Sub
    qAperturas = qAperturas - 1
    If qAperturas = 0 Then
        rsHandle.Close
        Set rsHandle = Nothing
    End If
End Sub

Private Sub LoadInstance(rsHandle As Recordset)
    With rsHandle
    NombreEmpresa = .Fields("NombreEmpresa")
    RIF = stGetStringFromVariant(.Fields("RIF"))
    NIT = stGetStringFromVariant(.Fields("NIT"))
    Direccion = stGetStringFromVariant(.Fields("Direccion"))
    Telefono = stGetStringFromVariant(.Fields("Telefono"))
    FormatoSaldos = .Fields("FormatoSaldos")
    MascaraPrecios = .Fields("MascaraPrecios")
    MascaraMonetarios = .Fields("MascaraMonetarios")
    MascaraInventario = .Fields("MascaraInventario")
    MascaraCantidades = .Fields("MascaraCantidades")
    FactorRedondeoPrecios = .Fields("FactorRedondeoPrecios")
    DefaultImpuesto1 = .Fields("DefaultImpuesto1")
    DefaultImpuesto2 = .Fields("DefaultImpuesto2")
    PrecioIncluyeImpuesto1 = .Fields("PrecioIncluyeImpuesto1")
    PrecioIncluyeImpuesto2 = .Fields("PrecioIncluyeImpuesto2")
    CodigoClienteMostrador = .Fields("CodigoClienteMostrador")
    MesInicioAnho = .Fields("MesInicioAnho")
    AnhoActual = .Fields("AnhoActual")
    PeriodoActual = .Fields("PeriodoActual")
    FormatoCodigos = .Fields("FormatoCodigos")
    CuentaGanPer = .Fields("CuentaGanPer")
    Separador = .Fields("Separador")
    AcreditarComision = .Fields("AcreditarComision")
    PComisVenta1 = .Fields("PComisVenta1")
    PComisVenta2 = .Fields("PComisVenta2")
    PComisVenta3 = .Fields("PComisVenta3")
    PComisCobranza1 = .Fields("PComisCobranza1")
    PComisCobranza2 = .Fields("PComisCobranza2")
    PComisCobranza3 = .Fields("PComisCobranza3")
    indexarPrecios = .Fields("IndexarPrecios")
    valoracionInventario = .Fields("valoracionInventario")
    TitulosPrecio(1) = .Fields("TituloPrecio1")
    TitulosPrecio(2) = .Fields("TituloPrecio2")
    TitulosPrecio(3) = .Fields("TituloPrecio3")
    TitulosPrecio(4) = .Fields("TituloPrecio4")
    NombreImpuesto1 = .Fields("NombreImpuesto1")
    NombreImpuesto2 = .Fields("NombreImpuesto2")
    CuentaGeneralVentas = stGetStringFromVariant(.Fields("CuentaGeneralVentas"))
    CuentaGeneralInventario = stGetStringFromVariant(.Fields("CuentaGeneralInventario"))
    CuentaGeneralDeudas = stGetStringFromVariant(.Fields("CuentaGeneralDeudas"))
    CuentaGeneralAcreencias = stGetStringFromVariant(.Fields("CuentaGeneralAcreencias"))
    CuentaGeneralBancos = stGetStringFromVariant(.Fields("CuentaGeneralBancos"))
    CuentaGeneralCosto = stGetStringFromVariant(.Fields("CuentaGeneralCosto"))
    CuentaGeneralDevoluciones = stGetStringFromVariant(.Fields("CuentaGeneralDevoluciones"))
    CuentaPasivoComisiones = stGetStringFromVariant(.Fields("CuentaPasivoComisiones"))
    CuentaGastosComisiones = stGetStringFromVariant(.Fields("CuentaGastosComisiones"))
    CuentaImpuesto1 = stGetStringFromVariant(.Fields("CuentaImpuesto1"))
    CuentaImpuesto2 = stGetStringFromVariant(.Fields("CuentaImpuesto2"))
    CuentaCaja = stGetStringFromVariant(.Fields("CuentaCaja"))
    ProximaMaquina = .Fields("ProximaMaquina")
    InicioVigenciaIDB = .Fields("InicioVigenciaIDB")
    FinVigenciaIDB = .Fields("FinVigenciaIDB")
    PorcentajeIDB = .Fields("PorcentajeIDB")
    CuentaGastosIDB = stGetStringFromVariant(.Fields("CuentaGastosIDB"))
    CuentaISLRAnticipado = stGetStringFromVariant(.Fields("CuentaISLRAnticipado"))
    CuentaEgresosComisionTC = stGetStringFromVariant(.Fields("CuentaEgresosComisionTC"))
    TipoInventarioEnCurso = .Fields("TipoInventarioEnCurso")
    AlmacenInventarioFisico = stGetStringFromVariant(.Fields("AlmacenInventarioFisico"))
    CuentaDescuentosCobranza = stGetStringFromVariant(.Fields("CuentaDescuentosCobranza"))
    CuentaDescuentosPagos = stGetStringFromVariant(.Fields("CuentaDescuentosPagos"))
    CuentaMercanciaDanhada = stGetStringFromVariant(.Fields("CuentaMercanciaDanhada"))
    CuentaISLRRetenido = stGetStringFromVariant(.Fields("CuentaISLRRetenido"))

    End With
End Sub

Public Function ComisionCobranza(ndx As Integer) As Double
    
    Select Case ndx
    Case 1
        ComisionCobranza = Me.PComisCobranza1
    Case 2
        ComisionCobranza = Me.PComisCobranza2
    Case 3
        ComisionCobranza = Me.PComisCobranza3
    Case Else
        ComisionCobranza = 0
    End Select

End Function

' ------------------------------------------------------------------
' Funciones para la conversion de Fechas y Perodos en funcin de la
' empresa:

Public Function PeriodoCurso() As Long  ' Se usa para hacer comparaciones
Dim anho As Long
    anho = Me.AnhoActual
    PeriodoCurso = anho * 100 + Me.PeriodoActual
End Function

Function refPeriodoActual() As Long
Dim anho As Long
    anho = Me.AnhoActual
    refPeriodoActual = (anho * 100) + Me.PeriodoActual
End Function

Function Mes2Periodo(ByVal Mes As Integer) As Integer
Dim temp As Integer
    temp = Mes - Me.MesInicioAnho + 1
    If temp <= 0 Then temp = temp + 12
    Mes2Periodo = temp
End Function

Function Periodo2Mes(ByVal periodo As Integer) As Integer
Dim p As Integer
    p = periodo - 1
    p = p + Me.MesInicioAnho
    If p > 12 Then p = p - 12
    Periodo2Mes = p
End Function

Function MesActual() As Integer
    MesActual = Periodo2Mes(Me.PeriodoActual)
End Function

Public Function MesPeriodo(ByVal arg As Long) As Byte
    arg = arg Mod 100
    MesPeriodo = Me.Periodo2Mes(arg)
End Function

Function AnhoMes2Periodo(ByVal anho As Integer, ByVal Mes As Integer) As Long
Dim nPer As Integer
    nPer = Me.Mes2Periodo(Mes)
    If (nPer > Mes) Then anho = anho - 1
    AnhoMes2Periodo = refPeriodo(anho, nPer)
End Function

Function Fecha2RefPeriodo(Fecha As Date) As Long
Dim AnhoPer As Integer, Mes As Integer
    AnhoPer = Year(Fecha): Mes = Month(Fecha)
    Fecha2RefPeriodo = Me.AnhoMes2Periodo(AnhoPer, Mes)
End Function

Function AnhoCalendarioActual() As Integer
Dim anho As Integer, Mes As Integer
    anho = AnhoActual: Mes = PeriodoActual
    If (Mes + MesInicioAnho - 1) > 12 Then anho = anho + 1
    AnhoCalendarioActual = anho
End Function

Function AnhoCalendarioFromPeriodo(refPeriodo As Long) As Integer
Dim anho As Integer, Mes As Integer
    anho = AnhoPeriodo(refPeriodo)
    Mes = PeriodoPeriodo(refPeriodo)
    If (Mes + MesInicioAnho - 1) > 12 Then anho = anho + 1
    AnhoCalendarioFromPeriodo = anho
End Function

Private Sub Class_Initialize()
  dblLimiteRedondeo = Val(GetSetting(AppName, "General", "RedondeoFacturacion", "0"))
  Abrir
  Cerrar
End Sub

Public Function RegistrarMaquina() As Long
Dim rs As Recordset, newID As Long, lNumeroMaquina As Long, lProximaFactura As Long
Dim isOk As Boolean

    On Error GoTo ErrHandler
    If VerificarUsuario("Registrar Equipo") >= 5 Then
        Do
            isOk = True
            lNumeroMaquina = Val(InputBox("Numero del Termina:", "Registro de nueva caja", Me.ProximaMaquina))
            If lNumeroMaquina > 0 Then
                Set rs = dbHandle.Execute("SELECT * FROM CorrelativosMaquina WHERE Maquina = " & NumeroDB(lNumeroMaquina))
                If Not rs.EOF Then
                    mAdvertencia "Ese nmero ya ha sido asignado"
                    isOk = False
                End If
                rs.Close
                Set rs = Nothing
            End If
        Loop While Not isOk
        
        If lNumeroMaquina <= 0 Then
            newID = 0
        Else
            lProximaFactura = Val(InputBox("Numero de la primera factura (POS) a emitir en esta caja:", "Registro de nueva caja", "1"))
            If (lProximaFactura <= 0) Then
                newID = 0
            Else
                If lNumeroMaquina >= Me.ProximaMaquina Then
                    dbHandle.Execute "UPDATE ParametrosEmpresa SET ProximaMaquina = " & NumeroDB(lNumeroMaquina + 1)
                End If
                newID = lNumeroMaquina
                dbHandle.Execute "INSERT INTO CorrelativosMaquina (Maquina, ProximaFactura) SELECT " & NumeroDB(newID) & " ," & NumeroDB(lProximaFactura)
                SaveSetting VSLIB.AppName, "General", "MachineID", newID
            End If
        End If
    Else
        newID = 0
    End If

ResumePoint:
    RegistrarMaquina = newID
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "ParametrosEmpresa.RegistrarMaquina"
    Err.Clear
    newID = 0
    Resume ResumePoint
End Function

