VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsParametrosEmpresa"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' Adems de implementar la estructura de datos globales de la empresa,
' se aprovecha esta unidad para declarar otra cantidad de tipos globales
' (enumeraciones, etctera), debido a su caracter ubicuo.

Public Enum StatAdmin
    SA_FACTURA_ABIERTA = 0
    SA_FACTURA_PENDIENTE = 1    ' Requiere consistencia con la Orden de Despacho / Guia Transporte
    SA_FACTURA_CANCELADA = 2    ' No se puede modificar
    SA_FACTURA_ANULADA = 3      ' Requiere reactivacin ( a status 0)
End Enum

Public Enum StatDespacho
    SD_FACTURA_ABIERTA = 0      ' No ha producido efecto en el inventario
    SD_FACTURA_PROCESO = 1      ' En fase de acopio (se emiti una orden de despacho)
    SD_FACTURA_TRANSITO = 2     ' Fue entregada al transporte..
    SD_FACTURA_ENTREGADA = 3    ' Fue entregada al cliente...
    SD_FACTURA_ANULADA = 4      ' Fue anulada...
End Enum

Public NombreEmpresa As String
Public RIF As String
Public NIT As String
Public Direccion As String
Public Telefono As String
Public FormatoSaldos As String
Public MascaraPrecios As String
Public MascaraMonetarios As String
Public MascaraInventario As String
Public MascaraCantidades As String
Public FactorRedondeoPrecios As Double
Public DefaultImpuesto1 As String
Public DefaultImpuesto2 As String
Public PrecioIncluyeImpuesto1 As Boolean
Public PrecioIncluyeImpuesto2 As Boolean
Public CodigoClienteMostrador As String
Public MesInicioAnho As Integer
Public AnhoActual As Integer
Public PeriodoActual As Integer
Public FormatoCodigos As String
Public CuentaGanPer As String
Public Separador As String
Public AcreditarComision As Boolean
Public PComisVenta1 As Double
Public PComisVenta2 As Double
Public PComisVenta3 As Double
Public PComisCobranza1 As Double
Public PComisCobranza2 As Double
Public PComisCobranza3 As Double
Public indexarPrecios As Integer ' 0: No indexar, 1: Indexar sobre CostoPromedio, 2: Indexar sobre ultimo costo
Public valoracionInventario As Integer ' 0: Sobre costo promedio, 1: Sobre ultimo costo
Private TitulosPrecio(1 To 4) As String
Public NombreImpuesto1 As String
Public NombreImpuesto2 As String
Public CuentaGeneralVentas As String        ' Ingresos por ventas no especificados
Public CuentaGeneralInventario As String    ' Activos en inventario, no especificados
Public CuentaGeneralDeudas As String        ' Pasivos generales, no especificados
Public CuentaGeneralAcreencias As String    ' Acreencias (cxc) en general
Public CuentaGeneralBancos As String        ' Activo en bancos, no especificado
Public CuentaGeneralCosto As String         ' Costo de ventas, no especificado
Public CuentaGeneralDevoluciones As String  ' Devoluciones de ventas, no especificadas
Public CuentaPasivoComisiones As String     ' Pasivo: Comisiones por pagar
Public CuentaGastosComisiones As String     ' Egresos por comisiones
Public CuentaImpuesto1 As String
Public CuentaImpuesto2 As String
Public CuentaCaja As String
Public ProximaMaquina As Long
Public InicioVigenciaIDB As Date
Public FinVigenciaIDB As Date
Public PorcentajeIDB As Double
Public CuentaGastosIDB As String
Public CuentaISLRAnticipado As String
Public CuentaEgresosComisionTC As String
Public TipoInventarioEnCurso As Integer
Public AlmacenInventarioFisico As String
Public CuentaDescuentosCobranza As String
Public CuentaDescuentosPagos As String
Public CuentaMercanciaDanhada As String
Public CuentaISLRRetenido As String
Public Ciudad As String
Public CuentaServicio As String
Public ClaveActivacion As String
Private mTipoCambio As Currency
Public CuentaMercanciaTransito As String  ' Cuenta "saco" para cargar el valor de la mercanca entregada a clientes

Public ContribuyenteEspecial As Boolean
Public PorcentajeRetencionIVACE As Double
Public ValorActualUT As Currency

Public dblLimiteRedondeo As Double

Public isKeyOk As Boolean
Private qAperturas As Integer

Public Function MachineID() As Long
  MachineID = mMachineID.MachineID
End Function

Public Property Get TipoCambio() As Currency
  If mTipoCambio = 0 Then
    mTipoCambio = 1
  End If
  TipoCambio = mTipoCambio
End Property

Public Property Let TipoCambio(vmTipo As Currency)
  mTipoCambio = vmTipo
  If mTipoCambio = 0 Then mTipoCambio = 1
End Property

Public Sub Abrir()
Dim rsHandle As Recordset
On Error GoTo ErrHandler
    Set rsHandle = dbHandle.Execute("SELECT * FROM ParametrosEmpresa")
    LoadInstance rsHandle
    rsHandle.Close
    Exit Sub
ErrHandler:
    If Err.Number = 3021 Then
      mAdvertencia "Est intentando trabajar con los datos de una empresa no definida" & vbCrLf & "Por fevor, ejecute 'CrearEmpresa' e intntelo de nuevo"
      Err.Clear
      End
    Else
      ReportarError True, Err.Number, Err.Description, "ParametrosEmpresa.Abrir"
      End
    End If
End Sub

Public Sub Cerrar()
End Sub

Public Function DecimalesCantidades() As Integer
Dim pPD As Integer

  pPD = InStr(1, Me.MascaraCantidades, ".")
  If pPD > 0 Then
    pPD = Len(Me.MascaraCantidades) - pPD
  End If
  DecimalesCantidades = pPD

End Function

Private Sub LoadInstance(rsHandle As Recordset)
    With rsHandle
    NombreEmpresa = .Fields("NombreEmpresa")
    RIF = stGetStringFromVariant(.Fields("RIF"))
    NIT = stGetStringFromVariant(.Fields("NIT"))
    Direccion = stGetStringFromVariant(.Fields("Direccion"))
    Telefono = stGetStringFromVariant(.Fields("Telefono"))
    FormatoSaldos = .Fields("FormatoSaldos")
    MascaraPrecios = .Fields("MascaraPrecios")
    MascaraMonetarios = .Fields("MascaraMonetarios")
    MascaraInventario = .Fields("MascaraInventario")
    MascaraCantidades = .Fields("MascaraCantidades")
    FactorRedondeoPrecios = .Fields("FactorRedondeoPrecios")
    DefaultImpuesto1 = .Fields("DefaultImpuesto1")
    DefaultImpuesto2 = .Fields("DefaultImpuesto2")
    PrecioIncluyeImpuesto1 = .Fields("PrecioIncluyeImpuesto1")
    PrecioIncluyeImpuesto2 = .Fields("PrecioIncluyeImpuesto2")
    CodigoClienteMostrador = stGetStringFromVariant(.Fields("CodigoClienteMostrador"))
    MesInicioAnho = .Fields("MesInicioAnho")
    AnhoActual = .Fields("AnhoActual")
    PeriodoActual = .Fields("PeriodoActual")
    FormatoCodigos = .Fields("FormatoCodigos")
    CuentaGanPer = .Fields("CuentaGanPer")
    Separador = .Fields("Separador")
    AcreditarComision = .Fields("AcreditarComision")
    PComisVenta1 = .Fields("PComisVenta1")
    PComisVenta2 = .Fields("PComisVenta2")
    PComisVenta3 = .Fields("PComisVenta3")
    PComisCobranza1 = .Fields("PComisCobranza1")
    PComisCobranza2 = .Fields("PComisCobranza2")
    PComisCobranza3 = .Fields("PComisCobranza3")
    indexarPrecios = .Fields("IndexarPrecios")
    valoracionInventario = .Fields("valoracionInventario")
    TitulosPrecio(1) = .Fields("TituloPrecio1")
    TitulosPrecio(2) = .Fields("TituloPrecio2")
    TitulosPrecio(3) = .Fields("TituloPrecio3")
    TitulosPrecio(4) = .Fields("TituloPrecio4")
    NombreImpuesto1 = .Fields("NombreImpuesto1")
    NombreImpuesto2 = .Fields("NombreImpuesto2")
    CuentaGeneralVentas = stGetStringFromVariant(.Fields("CuentaGeneralVentas"))
    CuentaGeneralInventario = stGetStringFromVariant(.Fields("CuentaGeneralInventario"))
    CuentaGeneralDeudas = stGetStringFromVariant(.Fields("CuentaGeneralDeudas"))
    CuentaGeneralAcreencias = stGetStringFromVariant(.Fields("CuentaGeneralAcreencias"))
    CuentaGeneralBancos = stGetStringFromVariant(.Fields("CuentaGeneralBancos"))
    CuentaGeneralCosto = stGetStringFromVariant(.Fields("CuentaGeneralCosto"))
    CuentaGeneralDevoluciones = stGetStringFromVariant(.Fields("CuentaGeneralDevoluciones"))
    CuentaPasivoComisiones = stGetStringFromVariant(.Fields("CuentaPasivoComisiones"))
    CuentaGastosComisiones = stGetStringFromVariant(.Fields("CuentaGastosComisiones"))
    CuentaImpuesto1 = stGetStringFromVariant(.Fields("CuentaImpuesto1"))
    CuentaImpuesto2 = stGetStringFromVariant(.Fields("CuentaImpuesto2"))
    CuentaCaja = stGetStringFromVariant(.Fields("CuentaCaja"))
    ProximaMaquina = .Fields("ProximaMaquina")
    InicioVigenciaIDB = .Fields("InicioVigenciaIDB")
    FinVigenciaIDB = .Fields("FinVigenciaIDB")
    PorcentajeIDB = .Fields("PorcentajeIDB")
    CuentaGastosIDB = stGetStringFromVariant(.Fields("CuentaGastosIDB"))
    CuentaISLRAnticipado = stGetStringFromVariant(.Fields("CuentaISLRAnticipado"))
    CuentaEgresosComisionTC = stGetStringFromVariant(.Fields("CuentaEgresosComisionTC"))
    TipoInventarioEnCurso = .Fields("TipoInventarioEnCurso")
    AlmacenInventarioFisico = stGetStringFromVariant(.Fields("AlmacenInventarioFisico"))
    CuentaDescuentosCobranza = stGetStringFromVariant(.Fields("CuentaDescuentosCobranza"))
    CuentaDescuentosPagos = stGetStringFromVariant(.Fields("CuentaDescuentosPagos"))
    CuentaMercanciaDanhada = stGetStringFromVariant(.Fields("CuentaMercanciaDanhada"))
    CuentaISLRRetenido = stGetStringFromVariant(.Fields("CuentaISLRRetenido"))
    Ciudad = stGetStringFromVariant(.Fields("Ciudad"))
    CuentaServicio = stGetStringFromVariant(.Fields("CuentaServicio"))
    ClaveActivacion = GetNumeroFromVariant(.Fields("ClaveActivacion"))
    TipoCambio = GetNumeroFromVariant(.Fields("TipoCambio"))
    CuentaMercanciaTransito = GetStringFromVariant(.Fields("CuentaMercanciaTransito"))
    If TipoCambio = 0 Then TipoCambio = 1
    On Error Resume Next
    Me.ContribuyenteEspecial = GetNumeroFromVariant(.Fields("Contribuyente"))
    If Err.Number Then Err.Clear
    Me.ValorActualUT = GetNumeroFromVariant(.Fields("ValorActualUT"))
    If Err.Number Then Err.Clear
    Me.PorcentajeRetencionIVACE = GetNumeroFromVariant(.Fields("PorcentajeRetencionIVACE"))
    If Err.Number Then Err.Clear
    End With
End Sub

Public Sub SetTipoCambio(vmNuevoTipo As Currency)
  TipoCambio = vmNuevoTipo
  dbHandle.Execute "UPDATE parametrosEmpresa SET TipoCambio = " & NumeroDB(mTipoCambio)
End Sub

Public Function ComisionCobranza(ndx As Integer) As Double
    
    Select Case ndx
    Case 1
        ComisionCobranza = Me.PComisCobranza1
    Case 2
        ComisionCobranza = Me.PComisCobranza2
    Case 3
        ComisionCobranza = Me.PComisCobranza3
    Case Else
        ComisionCobranza = 0
    End Select

End Function

' ------------------------------------------------------------------
' Funciones para la conversion de Fechas y Perodos en funcin de la
' empresa:

Public Function PeriodoCurso() As Long  ' Se usa para hacer comparaciones
Dim Anho As Long
    Anho = Me.AnhoActual
    PeriodoCurso = Anho * 100 + Me.PeriodoActual
End Function

Function refPeriodoActual() As Long
Dim Anho As Long
    Anho = Me.AnhoActual
    refPeriodoActual = (Anho * 100) + Me.PeriodoActual
End Function

Function Mes2Periodo(ByVal Mes As Integer) As Integer
Dim temp As Integer
    temp = Mes - Me.MesInicioAnho + 1
    If temp <= 0 Then temp = temp + 12
    Mes2Periodo = temp
End Function

Function Periodo2Mes(ByVal Periodo As Integer) As Integer
Dim p As Integer
    p = Periodo - 1
    p = p + Me.MesInicioAnho
    If p > 12 Then p = p - 12
    Periodo2Mes = p
End Function

Function MesActual() As Integer
    MesActual = Periodo2Mes(Me.PeriodoActual)
End Function

Public Function MesPeriodo(ByVal arg As Long) As Byte
    arg = arg Mod 100
    MesPeriodo = Me.Periodo2Mes(arg)
End Function

Function AnhoMes2Periodo(ByVal Anho As Integer, ByVal Mes As Integer) As Long
Dim nPer As Integer
    nPer = Me.Mes2Periodo(Mes)
    If (nPer > Mes) Then Anho = Anho - 1
    AnhoMes2Periodo = refPeriodo(Anho, nPer)
End Function

Function Fecha2RefPeriodo(Fecha As Date) As Long
Dim AnhoPer As Integer, Mes As Integer
    AnhoPer = Year(Fecha): Mes = Month(Fecha)
    Fecha2RefPeriodo = Me.AnhoMes2Periodo(AnhoPer, Mes)
End Function

Function AnhoCalendarioActual() As Integer
Dim Anho As Integer, Mes As Integer
    Anho = AnhoActual: Mes = PeriodoActual
    If (Mes + MesInicioAnho - 1) > 12 Then Anho = Anho + 1
    AnhoCalendarioActual = Anho
End Function

Function AnhoCalendarioFromPeriodo(refPeriodo As Long) As Integer
Dim Anho As Integer, Mes As Integer
    Anho = AnhoPeriodo(refPeriodo)
    Mes = PeriodoPeriodo(refPeriodo)
    If (Mes + MesInicioAnho - 1) > 12 Then Anho = Anho + 1
    AnhoCalendarioFromPeriodo = Anho
End Function

' ---------------------------------------------------------------
' Funciones para determinar si se ha "pasado" la frontera de un
' Cierre.
Public Function isAfterCierre(lPeriodo As Long) As Boolean  ' Determina si es el PRIMER periodo despues de un cierre
Dim Mes As Integer
    Mes = PeriodoPeriodo(lPeriodo)
    isAfterCierre = (Mes = 1)
End Function    ' Parece medio pajua

Public Function isBeforeCierre(lPeriodo As Long) As Boolean
    If (Me.AnhoActual > AnhoPeriodo(lPeriodo)) Then
        isBeforeCierre = True
        Exit Function
    End If
    isBeforeCierre = False
End Function

' --------------------------------------------------------------
' Actualizacion de perodos y cierres:
Private Function Cierre() As Boolean
Dim f As FProgresoCierre
Dim Anho As Integer, Anual As Boolean
Dim instCuenta As clsCuenta, Mes As Integer, dia As Integer
Dim isOk As Boolean
Dim colCuentas As Collection
Dim Saldo As Double, Acum As Double

    If Me.CuentaGanPer = "" Then
        Cierre = True
        Exit Function
    End If

    isOk = True
    Set instCuenta = New clsCuenta
    If Not instCuenta.Load(Me.CuentaGanPer) Then
        isOk = False
        mAdvertencia "La cuenta " & Me.CuentaGanPer & ", necesaria para ejecutar el cierre, no pudo ser encontrada."
    End If
    Set instCuenta = Nothing
        
    If Not isOk Then
        Cierre = False
        Exit Function
    End If
    
    Anho = Me.AnhoActual
    Mes = 12
    Set f = New FProgresoCierre
    f.Show 0
                                    ' Creacion de colCuentas
    StartTransaction
    Set colCuentas = New Collection
    AlmacenCuentas.LlenarColeccionCuentas colCuentas
    Acum = 0#
    For Each instCuenta In colCuentas
        If f.Abortar Then isOk = False
        If Not isOk Then Exit For
                
        f.SetCuenta instCuenta.Codigo
        If (instCuenta.Funcion = 4 Or instCuenta.Funcion = 5) And instCuenta.Status = 2 Then
            Saldo = instCuenta.SaldoPeriodo(Anho, Mes)
            Saldo = -Saldo
            instCuenta.RegistrarVariacion Saldo, nextPeriodo(refPeriodo(Empresa.AnhoActual, Mes)), False, True
            Acum = Acum - Saldo
        End If
    Next                            ' instCuenta
    Set colCuentas = Nothing        ' Destruccion de colCuentas
            
    If isOk Then
        Set instCuenta = New clsCuenta
        instCuenta.Load Me.CuentaGanPer
        instCuenta.RegistrarVariacion Acum, nextPeriodo(refPeriodo(Empresa.AnhoActual, Mes)), False, True
        Set instCuenta = Nothing
    End If
    f.Hide
    Unload f
    Set f = Nothing

    If isOk Then
        CommitTransaction
        Cierre = True
    Else
        AbortTransaction
        Cierre = False
    End If
End Function

Private Function VerificarFronteraCierre(ByVal lArg As Long) As Boolean
Dim nPeriodo As Integer, nAnho As Integer
Dim lPeriodo As Long
    Do
        nPeriodo = PeriodoPeriodo(lArg)
        nAnho = AnhoPeriodo(lArg)
        If nAnho > Me.AnhoActual Then
            If Not Cierre Then
                VerificarFronteraCierre = False
                Exit Function
            End If
            Me.AnhoActual = Me.AnhoActual + 1
            Me.PeriodoActual = 1
        End If
        Me.AnhoActual = nAnho
        Me.PeriodoActual = nPeriodo
    Loop While lArg < refPeriodo(Me.AnhoActual, Me.PeriodoActual)
    VerificarFronteraCierre = True
End Function

Public Function ActualizarUltimoPeriodo(ByVal nuevoPeriodo As Long) As Boolean
    If VerificarFronteraCierre(nuevoPeriodo) Then
        Me.AnhoActual = AnhoPeriodo(nuevoPeriodo)
        Me.PeriodoActual = PeriodoPeriodo(nuevoPeriodo)
        dbHandle.Execute "UPDATE ParametrosEmpresa SET AnhoActual = " & NumeroDB(AnhoActual) & ", PeriodoActual = " & NumeroDB(PeriodoActual)
        ActualizarUltimoPeriodo = True
    End If
End Function

Private Sub Class_Initialize()
  dblLimiteRedondeo = Val(GetSetting(AppName, "General", "RedondeoFacturacion", "0"))
  Abrir
  If Contadores Is Nothing Then Set Contadores = New CContadores
  isKeyOk = True
End Sub

Public Property Get TituloPrecio(i As Integer) As String
    If i < 1 Or 1 > 4 Then
        TituloPrecio = "ERR"
    Else
        TituloPrecio = TitulosPrecio(i)
    End If
End Property

Public Property Let TituloPrecio(i As Integer, s As String)
    TitulosPrecio(i) = s
End Property

Public Sub fillComboPrecios(cbx As ComboBox)
Dim orgText As String, i As Integer
    orgText = cbx.Text
    If IndicePrecio(orgText) = 0 Then
        orgText = TitulosPrecio(1)
    End If
    cbx.Clear
    For i = 1 To 4
        cbx.AddItem TitulosPrecio(i)
    Next
    cbx.Text = orgText
End Sub

Public Function IndicePrecio(starg As String)
Dim i As Integer
    For i = 1 To 4
        If StrComp(TitulosPrecio(i), starg, vbTextCompare) = 0 Then
            IndicePrecio = i
            Exit Function
        End If
    Next
    IndicePrecio = 0
End Function

Public Function RegistrarMaquina() As Long
Dim rs As Recordset, newID As Long, lNumeroMaquina As Long, lProximaFactura As Long
Dim isOk As Boolean

    On Error GoTo ErrHandler
    If VerificarUsuario("Registrar Equipo") >= 5 Then
        Do
            isOk = True
            lNumeroMaquina = Val(InputBox("Numero del Termina:", "Registro de nueva caja", Me.ProximaMaquina))
            If lNumeroMaquina > 0 Then
                Set rs = dbHandle.Execute("SELECT * FROM CorrelativosMaquina WHERE Maquina = " & NumeroDB(lNumeroMaquina))
                If Not rs.EOF Then
                    mAdvertencia "Ese nmero ya ha sido asignado"
                    isOk = False
                End If
                rs.Close
                Set rs = Nothing
            End If
        Loop While Not isOk
        
        If lNumeroMaquina <= 0 Then
            newID = 0
        Else
            lProximaFactura = Val(InputBox("Numero de la primera factura (POS) a emitir en esta caja:", "Registro de nueva caja", "1"))
            If (lProximaFactura <= 0) Then
                newID = 0
            Else
                If lNumeroMaquina >= Me.ProximaMaquina Then
                    dbHandle.Execute "UPDATE ParametrosEmpresa SET ProximaMaquina = " & NumeroDB(lNumeroMaquina + 1)
                End If
                newID = lNumeroMaquina
                dbHandle.Execute "INSERT INTO CorrelativosMaquina (Maquina, ProximaFactura) SELECT " & NumeroDB(newID) & " ," & NumeroDB(lProximaFactura)
                SaveSetting VSLIB.AppName, "General", "MachineID", newID
            End If
        End If
    Else
        newID = 0
    End If

ResumePoint:
    RegistrarMaquina = newID
    Exit Function

ErrHandler:
    ReportarError False, Err.Number, Err.Description, "ParametrosEmpresa.RegistrarMaquina"
    Err.Clear
    newID = 0
    Resume ResumePoint
End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean

    bRetVal = True

    Select Case Trim(UCase(sVarId))
    
    Case "NOMBRE_EMPRESA"
        sRetString = NombreEmpresa
        vRetBuffer = sRetString
    
    Case "RIF_EMPRESA"
        sRetString = RIF
        vRetBuffer = sRetString
    
    Case "NIT_EMPRESA"
        sRetString = NIT
        vRetBuffer = sRetString
    
    Case "DIRECCION_EMPRESA"
        sRetString = Direccion
        vRetBuffer = sRetString
    
    Case "TELEFONO_EMPRESA"
        sRetString = Telefono
        vRetBuffer = sRetString
    
    Case "OPERADOR"
        sRetString = UsuarioActivo.Codigo
        vRetBuffer = sRetString
        
    Case "CIUDAD"
        sRetString = Ciudad
        vRetBuffer = Ciudad

    Case "FECHA_IMPRESION"
        sRetString = Format(Now, "General Date")
        vRetBuffer = Now

    Case Else
        bRetVal = False

    End Select

    If Not bRetVal Then
        sRetString = Environ(sVarId)
        If sRetString <> "" Then
            bRetVal = True
            vRetBuffer = sRetString
        End If
    End If
        
    EvalVar = bRetVal

End Function

Public Function UsaContabilidad() As Boolean

    UsaContabilidad = (Me.CuentaGanPer <> "")

End Function

Public Function rwsDepositoMinimo() As Currency
Dim s As String, v As Currency

    s = GetSetting(AppName, "RWS", "DepositoMinimo", "0.0")
    v = Val(s)
    rwsDepositoMinimo = v

End Function

Public Function SerieDefault() As String
Dim s As String, rs As Recordset

    s = GetSetting(AppName, "General", "SerieDefault", "DIR")
    SerieDefault = s

    If s = "" Then
        Set rs = dbHandle.Execute("SELECT Codigo FROM Series")
        If Not rs.EOF Then
            s = stGetStringFromVariant(rs.Fields("Codigo"))
        End If
        Set rs = Nothing
        If s <> "" Then
            SaveSetting AppName, "General", "SerieDefault", s
        End If
    End If

    If s = "" Then
        mAdvertencia "Debe definir al menos una serie de facturas"
        s = "ERROR"
    End If

    SerieDefault = s

End Function

Public Function AjustarValor(ByVal inArg As Currency) As Currency
Dim posDec As Integer, dExponente As Double
  posDec = InStr(1, Me.MascaraMonetarios, ".")
  If posDec > 0 Then
    dExponente = Len(MascaraMonetarios) - posDec
    dExponente = 10 ^ dExponente
    inArg = Int(inArg * dExponente)
    inArg = inArg / dExponente
  End If
  AjustarValor = inArg
End Function
