VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDocumentosISPC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

' ADVERTENCIA: Se ha asumido (y tomado decisiones basadas en ello),
' que las propiedades Monto y Saldo pueden recibir asignaciones
' sin efectos secundarios ni alteraciones en la imagen persistente.

Public Numero As Long
Public TipoEntidad As String
Public CodigoEntidad As String
Public NumeroDocumento As Long
Public TipoDocumento As String
Public FechaDoc As Date
Public Monto As Currency
Public Saldo As Currency

' Se asume dentro de una transaccin...
Public Function CreateNewDoc(stTipoEntidad As String, _
                             stCodigoEntidad As String, _
                             lNumeroDocumento As Long, _
                             stTipoDocumento As String, _
                             dtFechaDoc As Date, _
                             vmMonto As Currency, _
                             stDescripcion As String, _
                             iComprobante As clsBufferComprobante) As Boolean
Dim isOk As Boolean, _
  instDetalle As clsDetalleCuentaEntidad, _
  instVencimiento As clsVencimientosISPC
  
  TipoEntidad = stTipoEntidad
  CodigoEntidad = stCodigoEntidad
  NumeroDocumento = lNumeroDocumento
  TipoDocumento = stTipoDocumento
  FechaDoc = dtFechaDoc
  Monto = vmMonto
  isOk = AlmacenDocumentosISPC.Add(Me)
  If isOk Then
    Set instVencimiento = New clsVencimientosISPC
    instVencimiento.Add Me.Numero, Me.FechaDoc, Me.Monto
    Set instVencimiento = Nothing
    Set instDetalle = New clsDetalleCuentaEntidad
    isOk = instDetalle.Add(Me.Numero, stCodigoEntidad, stTipoEntidad, dtFechaDoc, stDescripcion, vmMonto, iComprobante)
    Set instDetalle = Nothing
  End If
  CreateNewDoc = isOk
End Function

Public Function Load(Numero As Long) As Boolean
    Load = AlmacenDocumentosISPC.Load(Me, Numero)
End Function

Public Function NotificarDescuento(vmMonto As Currency, iComprobante As clsBufferComprobante, Optional ByVal dtFecha As Date = #1/1/1900#) As Boolean
Dim bRetVal As Boolean, pDoc As Object
    
    If Year(dtFecha) < 1980 Then
      dtFecha = Date
    End If
    On Error GoTo ErrHandler
    Set pDoc = Me.Documento
    If Not pDoc Is Nothing Then
        bRetVal = pDoc.NotificarDescuento(vmMonto, iComprobante, dtFecha)
    End If
    Set pDoc = Nothing

    NotificarDescuento = bRetVal
    Exit Function

ErrHandler:

    If Err.Number = 438 Then ' El documento no soporta "NotificarDescuento"
        bRetVal = True
        Resume Next
    End If

    ReportarError False, Err.Number, Err.Description, "DocumentosISPC.NotificarDescuento"
    Err.Clear
    NotificarDescuento = False

End Function

Public Function RegistrarVariacion(vmMonto As Currency, iComprobante As clsBufferComprobante) As Boolean
Dim bRetVal As Boolean, pDoc As Object
    
  bRetVal = AlmacenDocumentosISPC.RegistrarVariacion(Me, vmMonto)
  
  If bRetVal Then
    Set pDoc = Me.Documento
    If Not pDoc Is Nothing Then
      bRetVal = pDoc.RegistrarVariacion(vmMonto, iComprobante)
      If bRetVal Then
        If mScriptExecute.LoadScriptFile("RegistrarVariacion.vbs", pScript, False) Then
          pScript.AddObject "OwnerObject", Me
          pScript.AddObject "pComprobante", iComprobante
          pScript.ExecuteStatement "vmMonto = " & Trim(Str(vmMonto))
          pScript.Run "Main"
          pScript.Reset
        End If
      End If
    End If
    Set pDoc = Nothing
  End If
  
  RegistrarVariacion = bRetVal
End Function

Public Sub AplicarCondicion(CodigoCondicion As String)
Dim instCondicion As clsCondicion
Dim instVencimiento As clsVencimientosISPC
Dim instVencCondicion As clsVencimientoCondicion
  Set instCondicion = Condiciones.item(CodigoCondicion)
  If instCondicion Is Nothing Then
    Exit Sub
  End If
  
  AlmacenVencimientosISPC.EliminarVencimientosDocumento Me.Numero
  Set instVencimiento = New clsVencimientosISPC
  
  For Each instVencCondicion In instCondicion.Vencimientos
    instVencimiento.Add Me.Numero, Me.FechaDoc + instVencCondicion.Plazo, Me.Monto * instVencCondicion.Porcentaje / 100@
  Next
  
  Set instVencimiento = Nothing
  Set instCondicion = Nothing
End Sub

Public Function Vencimientos() As Collection

    Set Vencimientos = AlmacenVencimientosISPC.Vencimientos(Me.Numero)

End Function

Public Function SaldoVencido(dFecha As Date) As Currency
Dim vencs As Collection, montoVencido As Currency, MontoPagado As Currency
Dim instVencimiento As clsVencimientosISPC
    
    Set vencs = Vencimientos
    If vencs.Count = 0 Then
        montoVencido = Me.Monto
    Else
        montoVencido = 0@
        For Each instVencimiento In vencs
            If instVencimiento.FechaVencimiento <= dFecha Then
                montoVencido = montoVencido + instVencimiento.Monto
            End If
        Next
    End If
    Set vencs = Nothing

    MontoPagado = Me.Monto - Me.Saldo
    montoVencido = montoVencido - MontoPagado
    
'    If montoVencido < 0 Then montoVencido = 0
    
    SaldoVencido = montoVencido

End Function

Public Function Detalles() As Collection

    Set Detalles = AlmacenDetallesEntidad.DetallesDocumento(Me.Numero)

End Function

Public Function UltimoPago() As clsDetalleCuentaEntidad
Dim colDet As Collection, cDet As clsDetalleCuentaEntidad, pDet As clsDetalleCuentaEntidad
Dim detVal As Currency

    Set cDet = Nothing
    Set colDet = Detalles
    For Each pDet In colDet
        detVal = pDet.Debe - pDet.Haber
        If Sgn(detVal) <> Sgn(Me.Monto) Then Set cDet = pDet
    Next
    Set colDet = Nothing
    Set pDet = Nothing

    Set UltimoPago = cDet
End Function

Public Function FechaUltimoPago() As Date
Dim pDet As clsDetalleCuentaEntidad, retDate As Date

    Set pDet = UltimoPago
    
    If pDet Is Nothing Then
        retDate = BuildFecha(31, 12, 2029)
    Else
        retDate = pDet.Fecha
    End If
    
    FechaUltimoPago = retDate

End Function

Public Function LoadFromDocumento(sTipoDocumento As String, lNumeroDocumento As Long) As Boolean
  LoadFromDocumento = AlmacenDocumentosISPC.LoadFromDocumento(Me, sTipoDocumento, lNumeroDocumento)
End Function

Public Function Documento() As Object
Dim pInstancer As clsInstanciadorEntidad, pRetVal As Object

  Set pInstancer = New clsInstanciadorEntidad
  Set pRetVal = pInstancer.EntidadDOCUMENTO(Me.TipoDocumento, Me.NumeroDocumento)
  Set pInstancer = Nothing

  Set Documento = pRetVal

End Function

Public Function ReferenciaDocumento() As String
Dim sRetVal As String, pDoc As Object
  
  On Error GoTo ErrHandler
  Set pDoc = Me.Documento
  If pDoc Is Nothing Then
    sRetVal = Me.TipoDocumento & " Ref. " & Format(Me.NumeroDocumento, "0000000")
  Else
    sRetVal = pDoc.Referencia
  End If

ResumePoint:
  Set pDoc = Nothing
  ReferenciaDocumento = sRetVal
  Exit Function

ErrHandler:
  Err.Clear
  sRetVal = Me.TipoDocumento & " Ref. " & Format(Me.NumeroDocumento, "0000000")
  Resume ResumePoint
End Function

Public Function AplicarDocumento(pSource As clsDocumentosISPC, pComprobante As clsBufferComprobante) As Boolean
Dim pDet As clsDetalleCuentaEntidad, vmToApply As Currency

    If Abs(pSource.Saldo) > Abs(Me.Saldo) Then
        vmToApply = -Me.Saldo
    Else
        vmToApply = pSource.Saldo
    End If
                
    If Abs(vmToApply) > 0.01 Then
        Set pDet = New clsDetalleCuentaEntidad
        Dim RefDoc As String
        RefDoc = Me.ReferenciaDocumento
        Dim RefSourceDoc As String
        RefSourceDoc = pSource.ReferenciaDocumento
        pDet.Add Numero, CodigoEntidad, TipoEntidad, Date, "Aplicacin de " & RefSourceDoc, vmToApply, pComprobante
        pDet.Add pSource.Numero, pSource.CodigoEntidad, pSource.TipoEntidad, Date, "Aplicado a " & RefDoc, -vmToApply, pComprobante
        Set pDet = Nothing
    End If

    AplicarDocumento = True

End Function

' Autoaplicar: especialmente para Notas de Credito/Debito
Public Sub AutoAplicar(Fecha As Date, pComprobante As clsBufferComprobante)
Dim col As Collection, nDoc As clsDocumentosISPC, pDet As clsDetalleCuentaEntidad, vmSaldo As Currency, vmToApply As Currency

    Load Me.Numero

    Set col = AlmacenDocumentosISPC.DocumentosPendientes(TipoEntidad, CodigoEntidad)
    Set pDet = New clsDetalleCuentaEntidad
    vmSaldo = Me.Saldo
    
    For Each nDoc In col
    
        If nDoc.Numero <> Me.Numero Then
        
            If Sgn(nDoc.Saldo) <> Sgn(vmSaldo) And nDoc.FechaDoc <= Fecha Then
            
                If Abs(vmSaldo) > Abs(nDoc.Saldo) Then
                    vmToApply = -nDoc.Saldo
                Else
                    vmToApply = vmSaldo
                End If
                
                If Abs(vmToApply) > 0.1 Then
                    pDet.Add nDoc.Numero, nDoc.CodigoEntidad, nDoc.TipoEntidad, Fecha, "Aplicacin de " & Me.ReferenciaDocumento, vmToApply, pComprobante
                    pDet.Add Numero, CodigoEntidad, TipoEntidad, Fecha, "Aplicado a " & nDoc.ReferenciaDocumento, -vmToApply, pComprobante
                End If
                
                vmSaldo = vmSaldo - vmToApply
                
                If Abs(vmSaldo) < 0.1 Then Exit For
            
            End If

        End If
    
    Next
    
    Set pDet = Nothing
    Set col = Nothing

End Sub

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim pLastVenc As clsVencimientosISPC, colVencimientos As Collection
Dim sBuffer As String

    Select Case sVarId
    
    Case "NCUOTAS"
        
        vRetBuffer = Vencimientos.Count
        sRetString = Str(vRetBuffer)
    
    Case "FECHA_VENCIMIENTO"
        
        Set colVencimientos = Me.Vencimientos
        If colVencimientos.Count < 1 Then
            vRetBuffer = Me.FechaDoc
        Else
            Set pLastVenc = colVencimientos.item(colVencimientos.Count)
            vRetBuffer = pLastVenc.FechaVencimiento
        End If
        sRetString = Format(vRetBuffer, "Short Date")
    
    Case "VENCIMIENTOS"
        
        Set colVencimientos = Me.Vencimientos
        sBuffer = ""
        For Each pLastVenc In colVencimientos
            sBuffer = sBuffer & Format(pLastVenc.FechaVencimiento, "Short Date") & " "
            sBuffer = sBuffer & FormatNumero(pLastVenc.Monto, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
            sBuffer = sBuffer & vbCrLf
        Next
        vRetBuffer = sBuffer
        sRetString = sBuffer
    
    Case Else
        EvalVar = False
        Exit Function
    
    End Select
    
    EvalVar = True

End Function

' Maduracion: Coloca en vArray (un variant Dimensionado para contener
' 5 valores de tipo Currency, el saldo por vencer (0) y el saldo vencido
' a 1-30, 31-60, 61-90 y ms de 90 das.
' vmFactor se usa para ajustar los resultados a la "naturaleza" de las
' cuentas. Es igual al factor normal de la entidad correspodiente
' Es decir, 1 para las entidades deudoras (activo) y -1 para las entidades
' acreedoras (pasivos)
' ADVERTENCIA: Se asume que las propiedades clsVencimientoISPC.Monto,
' DocISPC.Monto y DocISPC.Saldo pueden recibir asignaciones sin efectos
' secundarios ni persistencia.
Public Sub Maduracion(dtFecha As Date, vmFactor As Currency, vArray As Variant)
Dim colVenc As Collection, DifDias As Long
Dim pVenc As clsVencimientosISPC
Dim vmSaldo As Currency, vmPagado As Currency
Dim vmVencido As Currency, vmVisto As Currency, i As Integer
Dim lFactor As Currency

    For i = LBound(vArray) To UBound(vArray)
        vArray(i) = 0@
    Next
    
    If Saldo = 0 Then Exit Sub  ' No hay vencido

    Set colVenc = Me.Vencimientos
    If colVenc.Count = 0 Then   ' Para un proceso standard...
        Set pVenc = New clsVencimientosISPC
        With pVenc
        .FechaVencimiento = Me.FechaDoc
        .Monto = Me.Monto
        .NumeroDocumento = Me.Numero
        End With
        colVenc.Add pVenc
        Set pVenc = Nothing
    End If

    lFactor = Sgn(Monto)
    Monto = Abs(Monto)
    Saldo = Abs(Saldo)
    vmPagado = Monto - Saldo

    For Each pVenc In colVenc
        
        pVenc.Monto = Abs(pVenc.Monto)
        
        If pVenc.Monto >= vmPagado Then    ' Hay un saldo a este pago...
            DifDias = dtFecha - pVenc.FechaVencimiento
            If DifDias <= 0 Then
                i = 0
            Else
                i = 1 + (DifDias - 1) / 30
            End If
            If i > UBound(vArray) Then i = UBound(vArray)
            vArray(i) = vArray(i) + (pVenc.Monto - IIf(vmPagado >= pVenc.Monto, pVenc.Monto, vmPagado)) * lFactor
        End If
        vmPagado = vmPagado - pVenc.Monto
        
        pVenc.Monto = pVenc.Monto * lFactor
        
        If vmPagado < 0 Then vmPagado = 0
    
    Next

    Monto = Monto * lFactor
    Saldo = Saldo * lFactor

    For i = LBound(vArray) To LBound(vArray): vArray(i) = vArray(i) * lFactor * vmFactor: Next

End Sub


