VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDevolucionVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public Serie As String
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public NumeroFactura As Long    ' Puede ser cero
Public CodigoCliente As String
Public NombreCliente As String
Public Valor As Currency
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Costo As Currency
Public Notas As String
Public CodigoVendedor As String
Public ComisionAnulada As Currency

Public pComprobante As clsBufferComprobante
Public Saldo As Currency

Private doRevertirComisiones As Boolean, isComisionManual As Boolean
Private stAlmacen As String
Public ProximoRenglon As Integer
Private colDetalles As Collection       ' Para las diferentes fases del proceso

Public TipoEntidad As String            ' Propiedad ISPC::ISDOC

Public Function ValorImpuesto(CodigoImpuesto) As Currency
Dim det As clsDetallesDevolucionVenta
Dim retVal As Currency, tasa As Double
  retVal = 0: tasa = TiposImpuesto.ValorActualImpuesto(CStr(CodigoImpuesto))
  For Each det In Detalles
    Dim Item As clsItemVenta
    Set Item = AlmacenItemsVenta.ItemVenta(det.CodigoItemVenta)
    If Not Item Is Nothing Then
      If Item.TipoImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.Valor * tasa / 100
      End If
    End If
  Next
  ValorImpuesto = retVal
End Function

Public Function BaseGravable(CodigoImpuesto) As Currency
Dim det As clsDetallesDevolucionVenta
Dim retVal As Currency
  retVal = 0
  For Each det In Detalles
    Dim Item As clsItemVenta
    Set Item = AlmacenItemsVenta.ItemVenta(det.CodigoItemVenta)
    If Not Item Is Nothing Then
      If Item.TipoImpuesto1 = CodigoImpuesto Then
        retVal = retVal + det.Valor
      End If
    End If
  Next
  BaseGravable = retVal
End Function

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Descripcion() As String
  Descripcion = Me.NombreCliente
End Function

Public Function Load(lNumero As Long) As Boolean
Dim rs As Recordset, bRetVal As Boolean

    Set rs = dbHandle.Execute("SELECT * FROM DevolucionesVenta WHERE Numero =" & Str(lNumero))
    If Not rs.EOF Then
        LoadInstance rs
        bRetVal = True
    Else
        bRetVal = False
    End If
    
    rs.Close
    Set rs = Nothing

    Load = bRetVal
    
End Function

Public Function Referencia() As String

    Referencia = "DVV" & Format(Me.Numero, "0000000")

End Function

Public Function Concepto() As String

    Concepto = "Devolucin de ventas No." & Str(Numero)

End Function

Public Function NombreArchivoFormato() As String

    NombreArchivoFormato = DeterminarFormato("FormatoDevVenta", "FormatosDevVenta", BuildDataPath("FormatoDevVenta.txt", AppName), Me)

End Function

Public Function Detalles() As Collection
Dim retCol As Collection, pDetDev As clsDetallesDevolucionVenta
Dim handle As Recordset, sQuery As String
  sQuery = "SELECT * FROM DetallesDevolucionVenta WHERE NumeroDevolucion =" & Str(Numero) & " ORDER BY NumeroRenglon"
  Set handle = dbHandle.Execute(sQuery)
  If handle.EOF Then
    Set retCol = Nothing
  Else
    Set retCol = New Collection
    Do
      Set pDetDev = New clsDetallesDevolucionVenta
      With pDetDev
      .NumeroDevolucion = handle.Fields("NumeroDevolucion")
      .NumeroRenglon = handle.Fields("NumeroRenglon")
      .CodigoItemVenta = handle.Fields("CodigoItemVenta")
      .CantidadDevuelta = handle.Fields("CantidadDevuelta")
      .Presentacion = handle.Fields("Presentacion")
      .FactorEmpaque = handle.Fields("FactorEmpaque")
      .DescripcionItem = handle.Fields("DescripcionItem")
      .Valor = handle.Fields("Valor")
      .Costo = handle.Fields("Costo")
      .Danhada = handle.Fields("Danhada")
      End With
      retCol.Add pDetDev
      handle.MoveNext
    Loop While Not handle.EOF
  End If
  handle.Close
  Set handle = Nothing
  Set Detalles = retCol
End Function

' ==================== Complementarias ==================
Public Function NombreVendedor() As String
Dim pVend As clsVendedores, sRetString As String
  Set pVend = New clsVendedores
  If pVend.Load(Me.CodigoVendedor) Then
    sRetString = pVend.Nombre
  Else
    sRetString = "nil"
  End If
  Set pVend = Nothing
  NombreVendedor = sRetString
End Function

Public Function ReferenciaFactura() As String
Dim pFact As clsFacturas, sRetString As String
  Set pFact = New clsFacturas
  If pFact.Load(Me.NumeroFactura) Then
    sRetString = pFact.Referencia
  Else
    sRetString = "nil"
  End If
  Set pFact = Nothing
  ReferenciaFactura = sRetString
End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

  bRetVal = mScriptExecute.ExtendEval(Me, "evDevolucionVenta.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean

  bRetVal = True
  
  Select Case sVarId
  
  Case "ALMACEN"
    Dim pComprobante As clsComprobanteAlmacen
    Set pComprobante = New clsComprobanteAlmacen
    If pComprobante.GetByDocumento(Me.TipoEntidad, Me.Numero) Then
      vRetBuffer = pComprobante.Almacen
      sRetString = pComprobante.Almacen
    Else
        bRetVal = False
    End If
    Set pComprobante = Nothing
  
  Case "CODCLI", "CODIGOCLIENTE"
    vRetBuffer = CodigoCliente
    sRetString = CodigoCliente
    
  Case "CODVEND", "CODIGOVENDEDOR"
    vRetBuffer = CodigoVendedor
    sRetString = CodigoVendedor
    
  Case "NOMBRECLI", "NOMBRECLIENTE"
    vRetBuffer = NombreCliente
    sRetString = NombreCliente
    
  Case "COMISANUL", "COMISIONANULADA", "ANULCOMIS"
    vRetBuffer = Me.ComisionAnulada
    sRetString = FormatNumero(ComisionAnulada, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
            
  Case "NOMBREVEND", "NOMBREVENDEDOR"
    sRetString = Me.NombreVendedor
    vRetBuffer = sRetString
  
  Case "COSTODEVUELTO", "COSTOMERCANCIA"
    vRetBuffer = Costo
    sRetString = FormatNumero(Costo, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case "DESCRIPCION"
    sRetString = Me.Descripcion
    vRetBuffer = sRetString
  
  Case "CONCEPTO"
    sRetString = Me.Concepto
    vRetBuffer = sRetString
        
  Case "FECHAREGISTRO"
    vRetBuffer = Me.FechaRegistro
    sRetString = Format(FechaRegistro, "Short Date")
        
  Case "FECHA", "FECHATRANSACCION"
    vRetBuffer = Me.FechaTransaccion
    sRetString = Format(FechaTransaccion, "Short Date")
    
  Case "IMPUESTO"
    vRetBuffer = Me.Impuesto1 + Me.Impuesto2
    sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
    
  Case "IMPUESTO1"
    vRetBuffer = Me.Impuesto1
    sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case "IMPUESTO2"
    vRetBuffer = Me.Impuesto2
    sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case "NOTAS"
    sRetString = Me.Notas
    vRetBuffer = Me.Notas
  
  Case "NUMERO"
    sRetString = Format(Me.Numero, "0000000")
    vRetBuffer = Me.Numero
  
  Case "FACTURA"
    sRetString = ReferenciaFactura
    vRetBuffer = sRetString
  
  Case "SERIE"
    sRetString = Me.Serie
    vRetBuffer = Me.Serie
        
  Case "MONTODEVUELTO", "MONTOANULACION"
    vRetBuffer = Me.Valor
    sRetString = FormatNumero(Me.Valor, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
  
  Case "REFERENCIA"
    sRetString = Me.Referencia
    vRetBuffer = sRetString
  
  Case "TOTAL"
    vRetBuffer = Me.Impuesto1 + Me.Impuesto2 + Me.Valor
    sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))
    
  Case Else
    
    bRetVal = False
  
  End Select
        
  If Not bRetVal Then
    Dim pCliente As clsClientes
    Set pCliente = AlmacenClientes.Cliente(Me.CodigoCliente)
    On Error Resume Next
    vRetBuffer = CallByName(pCliente, sVarId, VbGet)
    If Err.Number <> 0 Then
      Err.Clear
    Else
      sRetString = vRetBuffer
      If Err.Number <> 0 Then
        Err.Clear
      Else
        bRetVal = True
      End If
    End If
  End If
  
  If Not bRetVal Then bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
  If Not bRetVal Then bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
          
  EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long
  lNumero = Val(right(sRef, Len(sRef) - 3))
  LoadByReferenciaISDOC = Load(lNumero)
End Function

Public Sub Show()
Dim f As frmViewDevVenta
  Set f = New frmViewDevVenta
  f.SetDevolucion Me
  ShowNonModal f
  Unload f
  Set f = Nothing
End Sub

Public Sub UpdateNotas(istrNewText As String)
  If Me.Numero <> 0 Then
    Me.Notas = istrNewText
    dbHandle.Execute "UPDATE DevolucionesVenta SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
  End If
End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
  Set cFormato = New CFormatoDocumento
  cFormato.SetDocumento Me, Not AutoPrint
  Set cFormato = Nothing
End Sub

' ======================================================
' === End ISDOC
' ======================================================

Public Sub LoadInstance(rs As Recordset)
  Numero = rs!Numero
  Serie = rs!Serie
  FechaRegistro = rs!FechaRegistro
  FechaTransaccion = rs!FechaTransaccion
  Operador = rs!Operador
  NumeroFactura = rs!NumeroFactura
  CodigoCliente = rs!CodigoCliente
  NombreCliente = rs!NombreCliente
  Valor = rs!Valor
  Impuesto1 = rs!Impuesto1
  Impuesto2 = rs!Impuesto2
  Costo = rs!Costo
  Notas = rs!Notas
  CodigoVendedor = rs!CodigoVendedor
  ComisionAnulada = rs!ComisionAnulada
End Sub

Private Sub Class_Initialize()
  TipoEntidad = "DVV"
  Saldo = 0
End Sub

' -------------------------------------------
' PROCESO
' Interfaces con la aplicacion
' -------------------------------------------

Public Function StartProcess(ByVal RevertComision As Boolean, CodigoAlmacen As String, ByVal doAutoAppNC As Boolean) As Boolean
Dim rs As Recordset

  doRevertirComisiones = RevertComision
  isComisionManual = (ComisionAnulada > 0.01)
  stAlmacen = CodigoAlmacen

  Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
  Impuesto1 = 0: Impuesto2 = 0
  
  Dim sQuery As String
  sQuery = "INSERT INTO DevolucionesVenta (Numero, Serie, FechaRegistro, FechaTransaccion, Operador, NumeroFactura, CodigoCliente, NombreCliente, Valor, Impuesto1, Impuesto2, Costo, Notas, CodigoVendedor, ComisionAnulada) VALUES ("
  sQuery = sQuery & NumeroDB(Numero) & ", "
  sQuery = sQuery & StringDB(Serie) & ", "
  sQuery = sQuery & FechaDB(Date) & ", "
  sQuery = sQuery & FechaDB(FechaTransaccion) & ", "
  sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ", "
  sQuery = sQuery & NumeroDB(NumeroFactura) & ", "
  sQuery = sQuery & StringDB(CodigoCliente) & ", "
  sQuery = sQuery & StringDB(NombreCliente) & ", 0, 0, 0, 0, "
  sQuery = sQuery & StringDB(Notas) & ", "
  sQuery = sQuery & StringDB(CodigoVendedor) & ", "
  sQuery = sQuery & NumeroDB(ComisionAnulada) & ");"
  dbHandle.Execute sQuery

  ProximoRenglon = 1

  StartProcess = True

End Function

Public Function AddDetalle(stCodigoItem As String, _
        stDescripcion As String, _
        dblCantidadDevuelta As Double, _
        stUnidad As String, _
        isDanhada As Boolean, _
        vmPrecioDevolucion As Currency, _
        vmCosto As Currency, _
        stTipoImpuesto As String, _
        stTipoImpuesto2 As String, _
        lngNumeroDetalle As Long) As Boolean
Dim pItemVenta As clsItemVenta, pFactura As clsFacturas
Dim pDetalle As clsDetallesDevolucionVenta

  Set pItemVenta = New clsItemVenta
  If Not pItemVenta.Load(stCodigoItem) Then
    Err.Raise 10001, "clsDevolucionVenta:AddDetalle", "Producto " & stCodigoItem & " no localizado."
    Exit Function
  End If
  
  Set pDetalle = New clsDetallesDevolucionVenta
  pDetalle.NumeroDevolucion = Numero
  pDetalle.CodigoItemVenta = stCodigoItem
  pDetalle.CantidadDevuelta = dblCantidadDevuelta
  pDetalle.Presentacion = stUnidad
  pDetalle.FactorEmpaque = pItemVenta.FactorPresentacion(stUnidad)
  pDetalle.DescripcionItem = stDescripcion
  pDetalle.Valor = vmPrecioDevolucion * dblCantidadDevuelta
  pDetalle.Costo = vmCosto * dblCantidadDevuelta
  pDetalle.Danhada = isDanhada
  
  Dim sQuery As String
  sQuery = "INSERT INTO DetallesDevolucionVenta (NumeroDevolucion, NumeroRenglon, CodigoItemVenta, CantidadDevuelta, Presentacion, FactorEmpaque, DescripcionItem, Valor, Costo, Danhada) VALUES ("
  sQuery = sQuery & NumeroDB(Numero) & ", "
  sQuery = sQuery & NumeroDB(ProximoRenglon) & ", "
  sQuery = sQuery & StringDB(stCodigoItem) & ", "
  sQuery = sQuery & NumeroDB(dblCantidadDevuelta) & ", "
  sQuery = sQuery & StringDB(stUnidad) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.FactorEmpaque) & ", "
  sQuery = sQuery & StringDB(stDescripcion) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.Valor) & ", "
  sQuery = sQuery & NumeroDB(pDetalle.Costo) & ", "
  sQuery = sQuery & NumeroDB(isDanhada) & ");"

  dbHandle.Execute sQuery
  ProximoRenglon = ProximoRenglon + 1

  Set pDetalle = Nothing
  Set pItemVenta = Nothing

  Me.Valor = Me.Valor + vmPrecioDevolucion * dblCantidadDevuelta
  Me.Costo = Me.Costo + vmCosto * dblCantidadDevuelta
  Me.Impuesto1 = Me.Impuesto1 + vmPrecioDevolucion * dblCantidadDevuelta * TiposImpuesto.ValorActualImpuesto(stTipoImpuesto) / 100
  Me.Impuesto2 = Me.Impuesto2 + vmPrecioDevolucion * dblCantidadDevuelta * TiposImpuesto.ValorActualImpuesto(stTipoImpuesto2) / 100
  If Me.NumeroFactura Then
    Set pFactura = New clsFacturas
    If pFactura.Load(Me.NumeroFactura) Then
      pFactura.AnotarItemDevuelto lngNumeroDetalle, dblCantidadDevuelta
    End If
    Set pFactura = Nothing
  End If
  
  AddDetalle = True

End Function

Public Function CompletarProceso(f As lfProgresoOperacion, ipComprobante As clsBufferComprobante, Doc As CDocumentoFiscal) As Boolean
Dim sQuery As String, isOk As Boolean
Dim pCliente As clsClientes
Dim pItemVenta As clsItemVenta

  Set Me.pComprobante = ipComprobante
  isOk = True
  
  Set pCliente = AlmacenClientes.Cliente(CodigoCliente)
  If pCliente Is Nothing Then
    Err.Raise 10001, "DevolucionesVenta.CompletarProceso", "Cliente no localizado"
  End If

  Set colDetalles = Detalles
  sQuery = "UPDATE DevolucionesVenta SET Valor =" & NumeroDB(Valor) & ", Costo =" & NumeroDB(Costo) & ", Impuesto1 =" & NumeroDB(Me.Impuesto1) & ", Impuesto2 =" & NumeroDB(Me.Impuesto2) & " WHERE Numero =" & NumeroDB(Me.Numero)
  dbHandle.Execute sQuery
  CargarDevolucionVenta f, ipComprobante
  ActualizarEstadisticasVentas f
  ActualizarInventario f, pComprobante
  RevertirComisiones f, pComprobante
  NotificarFactura f, pComprobante
  If Not Doc Is Nothing Then
    Doc.NumeroDoc = Me.Numero
    Doc.Grabar New CFactoria
    Doc.FillComprobante Empresa, pComprobante
  End If
  Set colDetalles = Nothing

  CompletarProceso = isOk
End Function

Public Sub EndProcess()
  SubmitDoc Me
End Sub

Public Sub AbortProcess()
End Sub

' ------------------------------------------
' Proceso: Funciones privadas
' ------------------------------------------

Private Function CargarDevolucionVenta(f As lfProgresoOperacion, ipComprobante As clsBufferComprobante) As Boolean
Dim pItemVenta As clsItemVenta, pDetDev As clsDetallesDevolucionVenta, sCuenta As String
Dim pCliente As clsClientes

  f.Caption = "Actualizando cuentas de devolucion"
  f.Reset
  
  Set pItemVenta = New clsItemVenta
  Set pCliente = AlmacenClientes.Cliente(CodigoCliente)
  
  For Each pDetDev In colDetalles
    f.NextPoint
    If pItemVenta.Load(pDetDev.CodigoItemVenta) Then
      sCuenta = pItemVenta.CuentaDevolucion
      If sCuenta = "" Then sCuenta = Empresa.CuentaGeneralDevoluciones
      If sCuenta = "" Then sCuenta = pItemVenta.CuentaIngreso
      If sCuenta = "" Then sCuenta = pCliente.CuentaIngresos
      If sCuenta = "" Then sCuenta = Empresa.CuentaGeneralVentas
      If sCuenta = "" Then
          If Not ipComprobante.isError Then
              f.ShowException "Imposible encontrar cuenta para cargar devolucion de item " & pItemVenta.Codigo, False
              ipComprobante.SetError
          End If
      Else
          ipComprobante.AddDetalle sCuenta, "Devolucion de ventas No." & Str(Numero), pDetDev.Valor, 0
      End If
    End If
    If f.doBreak Then
      Err.Raise 10001, "CargarDevolucionVenta", "Operacion cancelada por el usuario"
    End If
  Next
  
  Set pCliente = Nothing
  Set pItemVenta = Nothing

End Function

Private Function ActualizarInventario(f As lfProgresoOperacion, ipComprobante As clsBufferComprobante) As Boolean
Dim pAlmacen As clsAlmacen, _
    pItemInv As clsItemInventario, _
    pItemVenta As clsItemVenta, _
    pDetDev As clsDetallesDevolucionVenta, _
    sCuenta As String

  f.Caption = "Actualizando el inventario"
  f.Reset
  
  Set pAlmacen = Almacenes.Item(stAlmacen)
  pAlmacen.StartComprobante FechaTransaccion, Me.TipoEntidad, Me.Numero, 0, Me.NombreCliente
  
  Set pItemInv = New clsItemInventario
  Set pItemVenta = New clsItemVenta
  
  For Each pDetDev In colDetalles
  
    f.NextPoint
  
    Dim pComponente As clsComponenteItemVenta
    Dim pCol As Collection
    
    If pItemVenta.Load(pDetDev.CodigoItemVenta) Then
      Set pCol = pItemVenta.Composicion
      For Each pComponente In pCol
        If Not pItemInv.Load(pComponente.CodigoItemInventario) Then
          pAlmacen.AbortarComprobante
          Err.Raise 10001, "DevolucionesVenta.ActualizarInventario", "Articulo de inventario no localizado: " & pComponente.CodigoItemInventario
        End If
        If Not pDetDev.Danhada Then
          pAlmacen.RegistrarMINV pComponente.CodigoItemInventario, pComponente.Cantidad * pDetDev.CantidadDevuelta * pDetDev.FactorEmpaque, 0
        Else
          ipComprobante.AddDetalle Empresa.CuentaMercanciaDanhada, "Devolucion de ventas No." & Str(Numero), pDetDev.CantidadDevuelta * pDetDev.FactorEmpaque * pComponente.Cantidad * pItemInv.CostoUnitario, 0
        End If
        sCuenta = pItemInv.CuentaCosto
        If sCuenta = "" Then sCuenta = Empresa.CuentaGeneralCosto
        ipComprobante.AddDetalle sCuenta, "Devolucion de ventas No." & Str(Numero), 0, pComponente.Cantidad * pDetDev.CantidadDevuelta * pDetDev.FactorEmpaque * pItemInv.CostoUnitario
      Next
    End If
  
    Set pCol = Nothing
    
    If f.doBreak Then
      pAlmacen.AbortarComprobante
      Err.Raise 10001, "clsDevolucionVenta:ActualizarInventario", "Cancelada por el usuario"
    End If
  Next
  
  pAlmacen.CerrarComprobante ipComprobante
  
  Set pItemVenta = Nothing
  Set pItemInv = Nothing
  Set pAlmacen = Nothing
  
  ActualizarInventario = True
  
End Function

Private Function ActualizarEstadisticasVentas(f As lfProgresoOperacion) As Boolean
Dim pDetalleIV As clsDetalleItemVenta, pDetDev As clsDetallesDevolucionVenta

  f.Caption = "Actualizando estadisticas por producto"
  f.Reset
  
  Set pDetalleIV = New clsDetalleItemVenta
  For Each pDetDev In colDetalles
    f.NextPoint
    If pDetDev.CodigoItemVenta <> "" Then
      With pDetalleIV
      .CodigoItem = pDetDev.CodigoItemVenta
      .Cantidad = -(pDetDev.CantidadDevuelta * pDetDev.FactorEmpaque)
      .CodigoCliente = Me.CodigoCliente
      .CodigoVendedor = Me.CodigoVendedor
      .FechaOperacion = Me.FechaTransaccion
      .NumeroDocumento = Me.Numero
      .TipoDocumento = Me.TipoEntidad
      .PrecioReferencia = pDetDev.ValorUnitario / pDetDev.FactorEmpaque
      .PrecioVenta = .PrecioReferencia
      .Serie = Me.Serie
      AlmacenDetallesItemVenta.Add pDetalleIV
      End With
    End If
  
    If f.doBreak Then
      Set pDetalleIV = Nothing
      ActualizarEstadisticasVentas = False
      Exit Function
    End If
  Next
  Set pDetalleIV = Nothing
  ActualizarEstadisticasVentas = True
End Function

Private Function RevertirComisiones(f As lfProgresoOperacion, ipComprobante As clsBufferComprobante) As Boolean
Dim sQuery As String
Dim pVendedor As clsVendedores
Dim vmComision As Currency
Dim pDetCuentaEnt As clsDetalleCuentaEntidad
Dim pItemVenta As clsItemVenta
Dim pDetDev As clsDetallesDevolucionVenta

  If Not doRevertirComisiones Then
    RevertirComisiones = True
    Exit Function
  End If

  f.Caption = "Revirtiendo comisiones"
  f.Reset
      
  Set pVendedor = New clsVendedores
  Set pItemVenta = New clsItemVenta
  
  If pVendedor.Load(Me.CodigoVendedor) Then
    If isComisionManual Then
      vmComision = ComisionAnulada
    Else
      For Each pDetDev In colDetalles
        f.NextPoint
        If pItemVenta.Load(pDetDev.CodigoItemVenta) Then
          Select Case pVendedor.TipoComisionVenta
          Case 1
            vmComision = vmComision + pDetDev.Valor * pItemVenta.PComis1 / 100
          Case 2
            vmComision = vmComision + pDetDev.Valor * pItemVenta.PComis2 / 100
          Case 3
            vmComision = vmComision + pDetDev.Valor * pItemVenta.PComis3 / 100
          End Select
        End If
        If f.doBreak Then
          Set pVendedor = Nothing
          Set pItemVenta = Nothing
          RevertirComisiones = False
          Exit Function
        End If
      Next
    End If
    ComisionAnulada = vmComision
    If ComisionAnulada > 0.01 Then
      Set pDetCuentaEnt = New clsDetalleCuentaEntidad
      pDetCuentaEnt.Add 0, pVendedor.Codigo, pVendedor.TipoEntidad, Me.FechaTransaccion, "Devolucion de ventas No." & Str(Numero), vmComision, pComprobante
      Set pDetCuentaEnt = Nothing
      ipComprobante.AddDetalle Empresa.CuentaGastosComisiones, "Devolucin de ventas No." & Str(Numero), 0, vmComision
    End If
  Else
    mAdvertencia "No se localiz el vendedor " & Me.CodigoVendedor
    ComisionAnulada = 0
  End If
  
  Set pItemVenta = Nothing
  Set pVendedor = Nothing

  sQuery = "UPDATE DevolucionesVenta SET ComisionAnulada =" & Str(ComisionAnulada) & " WHERE Numero =" & Str(Numero)
  dbHandle.Execute sQuery

  RevertirComisiones = True

End Function

Private Function NotificarFactura(f As lfProgresoOperacion, ipComprobante As clsBufferComprobante) As Boolean
Dim pDetDev As clsDetallesDevolucionVenta
Dim pFactura As clsFacturas

  If Me.NumeroFactura Then
    f.Caption = "Actualizando la factura original"
    f.Reset
    Set pFactura = New clsFacturas
    If pFactura.Load(NumeroFactura) Then
      pFactura.AddCostoDevuelto Me.Costo
      pFactura.AddPrecioDevuelto Me.Valor
      pFactura.AddImpuestosDevueltos Me.Impuesto1, Me.Impuesto2
    End If
    Set pFactura = Nothing
  End If
  NotificarFactura = True

End Function

