VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDevolucionCompra"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public Numero As Long
Public FechaRegistro As Date
Public FechaTransaccion As Date
Public Operador As String
Public CodigoProveedor As String
Public Factura As Long
Public ValorMercancia As Currency
Public Impuesto1 As Currency
Public Impuesto2 As Currency
Public Notas As String
Public RefProveedor As String
Public NumeroControl As Long

Private stAlmacen As String

Public ProximoRenglon As Integer
Private colDetalles As Collection       ' Para las diferentes fases del proceso

Public TipoEntidad As String            ' ISDOC
Public Saldo As Currency

Public pComprobante As clsBufferComprobante
Private TotalExento As Currency, TotalIV1 As Currency, TotalIV2 As Currency

Public Property Get Factoria() As CFactoria
  Set Factoria = New CFactoria
End Property

Public Function Descripcion() As String
Dim pProveedor As clsProveedores

    Set pProveedor = New clsProveedores
    If pProveedor.Load(Me.CodigoProveedor) Then
        Descripcion = pProveedor.Nombre
    Else
        Descripcion = Concepto
    End If
    Set pProveedor = Nothing

End Function

Public Function ValorImpuesto(CodigoImpuesto) As Currency
Dim det As clsDetallesDevolucionCompra
Dim retVal As Currency, tasa As Double
  retVal = 0: tasa = TiposImpuesto.ValorActualImpuesto(CStr(CodigoImpuesto))
  For Each det In Detalles
    Dim Item As clsItemInventario
    Set Item = AlmacenItemsInventario.itemInventario(det.CodigoItem)
    If Item.claseImpuesto1 = CodigoImpuesto Then
      retVal = retVal + (det.Costo * tasa / 100)
    End If
  Next
  ValorImpuesto = retVal
End Function

Public Function BaseGravable(CodigoImpuesto) As Currency
Dim det As clsDetallesDevolucionCompra
Dim retVal As Currency
  retVal = 0
  For Each det In Detalles
    Dim Item As clsItemInventario
    Set Item = AlmacenItemsInventario.itemInventario(det.CodigoItem)
    If Item.claseImpuesto1 = CodigoImpuesto Then
      retVal = retVal + det.Costo
    End If
  Next
  BaseGravable = retVal
End Function

Public Function Load(lNumero As Long) As Boolean
Dim bRetVal As Boolean, rs As Recordset

    Set rs = dbHandle.Execute("SELECT * FROM DevolucionesCompra WHERE Numero =" & Str(lNumero), , adCmdText)
    If Not rs.EOF Then
      LoadInstance rs
      bRetVal = True
    Else
      bRetVal = False
    End If

    rs.Close
    Set rs = Nothing

    Load = bRetVal

End Function

Public Function Referencia() As String

    Referencia = "DVC" & Format(Me.Numero, "0000000")

End Function

Public Function Concepto() As String

    Concepto = "Devolucin de compras No." & Str(Numero)

End Function

Public Function NombreArchivoFormato() As String

    NombreArchivoFormato = DeterminarFormato("FormatoDVC", "FormatosDVC", BuildDataPath("FormatoDVC.txt", AppName), Me)

End Function

Public Function Detalles() As Collection
Dim retCol As Collection, pDetDev As clsDetallesDevolucionCompra
Dim sQuery As String, handle As Recordset
Dim pSeriales As CSerialesRenglon
Dim vSeriales As Variant, i As Integer

    sQuery = "SELECT * FROM DetallesDevolucionCompra WHERE NumeroDevolucion =" & Str(Numero) & " ORDER BY NumeroRenglon"
    Set handle = dbHandle.Execute(sQuery)
    If handle.EOF Then
        Set retCol = Nothing
    Else
        Set retCol = New Collection
        Do
            Set pDetDev = New clsDetallesDevolucionCompra
            With pDetDev
            .NumeroDevolucion = handle.Fields("NumeroDevolucion")
            .NumeroRenglon = handle.Fields("NumeroRenglon")
            .CodigoItem = handle.Fields("CodigoItem")
            .CantidadDevuelta = handle.Fields("CantidadDevuelta")
            .Presentacion = handle.Fields("Presentacion")
            .FactorEmpaque = handle.Fields("FactorEmpaque")
            .DescripcionItem = handle.Fields("DescripcionItem")
            .Costo = handle.Fields("Costo")
            .Danhada = handle.Fields("Danhada")
            End With
            retCol.Add pDetDev

            Set pSeriales = New CSerialesRenglon
            pSeriales.Load Me.TipoEntidad, Me.Numero, pDetDev.NumeroRenglon
            If pSeriales.SerialesProducto.Count Then
                vSeriales = pSeriales.ToStrings(40)
                For i = 1 To UBound(vSeriales)
                    Set pDetDev = New clsDetallesDevolucionCompra
                    pDetDev.DescripcionItem = vSeriales(i)
                    pDetDev.NumeroRenglon = 1
                    pDetDev.FactorEmpaque = 1
                    retCol.Add pDetDev
                Next
            End If
            Set pSeriales = Nothing


            handle.MoveNext
        Loop While Not handle.EOF

    End If

    handle.Close
    Set handle = Nothing

    Set Detalles = retCol

End Function

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDevolucionCompra.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean
Dim pProveedor As clsProveedores

    bRetVal = True
    
    Select Case sVarId
    
    Case "ALMACEN"
        Dim pComprobante As clsComprobanteAlmacen
        Set pComprobante = New clsComprobanteAlmacen
        If pComprobante.GetByDocumento(Me.TipoEntidad, Me.Numero) Then
            vRetBuffer = pComprobante.Almacen
            sRetString = pComprobante.Almacen
        Else
            bRetVal = False
        End If
        Set pComprobante = Nothing

    Case "NUMERO"
        vRetBuffer = Numero
        sRetString = Format(Numero, "0000000")

    Case "REFERENCIA"
        vRetBuffer = Referencia
        sRetString = Referencia
    
    Case "FECHA", "FECHA_TRANSACCION"
        vRetBuffer = FechaTransaccion
        sRetString = Format(FechaTransaccion, "Short Date")

    Case "FECHAREGISTRO", "FECHA_REGISTRO"
        vRetBuffer = FechaRegistro
        sRetString = Format(FechaRegistro, "Short Date")
    
    Case "OPERADOR", "USUARIO"
        vRetBuffer = Operador
        sRetString = Operador

    Case "CODIGO_PROVEEDOR", "PROVEEDOR"
        vRetBuffer = CodigoProveedor
        sRetString = CodigoProveedor

    Case "NOMBREPROVEEDOR", "NOMBRE_PROVEEDOR"
        Set pProveedor = New clsProveedores
        If pProveedor.Load(Me.CodigoProveedor) Then
            sRetString = pProveedor.Nombre
        Else
            sRetString = "NO LOCALIZADO!!"
        End If
        Set pProveedor = Nothing
        vRetBuffer = sRetString

    Case "FACTURA", "NUMERO_FACTURA", "REF_FACTURA"
        Dim pRecMerc As clsReciboMercancia
        
        Set pRecMerc = New clsReciboMercancia
        If Not pRecMerc.Load(Me.Factura) Then
            vRetBuffer = "N/A"
        Else
            vRetBuffer = pRecMerc.Referencia
        End If
        Set pRecMerc = Nothing
        sRetString = vRetBuffer

    Case "MONTO", "VALOR", "VALOR_DEVUELTO"
        vRetBuffer = ValorMercancia
        sRetString = FormatNumero(ValorMercancia, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO", "IVA"
        vRetBuffer = Impuesto1 + Impuesto2
        sRetString = FormatNumero(Impuesto1 + Impuesto2, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "TOTAL"
        vRetBuffer = ValorMercancia + Impuesto1 + Impuesto2
        sRetString = FormatNumero(vRetBuffer, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO1"
        vRetBuffer = Impuesto1
        sRetString = FormatNumero(Impuesto1, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "IMPUESTO2"
        vRetBuffer = Impuesto2
        sRetString = FormatNumero(Impuesto2, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "NOTAS"
        vRetBuffer = Notas
        sRetString = Notas
    
    Case Else
    
        bRetVal = False
    
    End Select

    If Not bRetVal Then bRetVal = Empresa.EvalVar(sVarId, vRetBuffer, sRetString)
    
    If Not bRetVal Then bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)

    EvalVar = bRetVal

End Function

Public Function GetEvalVar(sVarId As String) As String
Dim bRetVal As Boolean, vBuf As Variant, sBuf As String

    bRetVal = EvalVar(sVarId, vBuf, sBuf)
    GetEvalVar = IIf(bRetVal, sBuf, "ERR:" & sVarId)
    
End Function

Public Function LoadByReferenciaISDOC(sRef As String) As Boolean
Dim lNumero As Long

    lNumero = Val(right(sRef, Len(sRef) - 3))
    
    LoadByReferenciaISDOC = Load(lNumero)

End Function

Public Sub Show()
Dim f As frmViewDevCompra

    Set f = New frmViewDevCompra
    
    f.SetDevolucion Me
    ShowNonModal f
    
    Unload f
    Set f = Nothing

End Sub

Public Sub ViewPrint(AutoPrint As Boolean)
Dim cFormato As CFormatoDocumento
    
    Set cFormato = New CFormatoDocumento
    cFormato.SetDocumento Me, Not AutoPrint
    Set cFormato = Nothing

End Sub

Public Sub UpdateNotas(istrNewText As String)

  If Me.Numero <> 0 Then
    Me.Notas = istrNewText
    dbHandle.Execute "UPDATE DevolucionesCompra SET Notas = " & StringDB(Me.Notas) & " WHERE Numero = " & NumeroDB(Me.Numero)
  End If

End Sub


' -------------------------------------------------
' ----------------- END ISDOC ---------------------
' -------------------------------------------------

Private Sub Class_Initialize()

    TipoEntidad = "DVC"

End Sub

Public Function NumeroUltimaDevolucion() As Long
Dim rs As Recordset, lFoundKey As Long

    Set rs = dbHandle.Execute("SELECT MAX(Numero) From DevolucionesCompra")
    
    If rs.EOF Then
        lFoundKey = 0
    Else
        lFoundKey = GetNumeroFromVariant(rs.Fields(0))
    End If
    
    rs.Close
    Set rs = Nothing

    NumeroUltimaDevolucion = lFoundKey

End Function

Public Function LoadInstance(rs As Recordset)

  Numero = GetNumeroFromVariant(rs!Numero)
  FechaRegistro = GetDateFromVariant(rs!FechaRegistro)
  FechaTransaccion = GetDateFromVariant(rs!FechaTransaccion)
  Operador = GetStringFromVariant(rs!Operador)
  CodigoProveedor = GetStringFromVariant(rs!CodigoProveedor)
  Factura = GetNumeroFromVariant(rs!Factura)
  ValorMercancia = GetNumeroFromVariant(rs!ValorMercancia)
  Impuesto1 = GetNumeroFromVariant(rs!Impuesto1)
  Impuesto2 = GetNumeroFromVariant(rs!Impuesto2)
  Notas = GetStringFromVariant(rs!Notas)
  RefProveedor = GetStringFromVariant(rs!RefProveedor)
  NumeroControl = GetNumeroFromVariant(rs!NumeroControl)
  Saldo = 0

End Function

' -------------------------------------------
' PROCESO
' Interfaces con la aplicacion
' -------------------------------------------

Public Function StartProcess(CodigoAlmacen As String) As Boolean
Dim pRecibo As clsReciboMercancia, ref As String
Dim lProveedor As clsProveedores
' ADVERTENCIA: Impuesto1 DEBE VENIR calculado de afuera (a causa de las frecuentes
' discrepancias entre los clculos realizados por el programa y los valores calculados
' por los proveedores).

  stAlmacen = CodigoAlmacen
  
  TotalExento = 0: TotalIV1 = 0: TotalIV2 = 0

  Numero = Contadores.NumeroProximoDocumento(Me.TipoEntidad, True)
  Dim sQuery As String
  ValorMercancia = 0
  Impuesto2 = 0
  sQuery = "INSERT INTO DevolucionesCompra (Numero, FechaRegistro, FechaTransaccion, Operador, CodigoProveedor, Factura, ValorMercancia, Impuesto1, Impuesto2, Notas, RefProveedor, NumeroControl) VALUES ("
  sQuery = sQuery & NumeroDB(Numero) & ", "
  sQuery = sQuery & TimeDateDB(Now) & ", "
  sQuery = sQuery & FechaDB(FechaTransaccion) & ", "
  sQuery = sQuery & StringDB(UsuarioActivo.Codigo) & ", "
  sQuery = sQuery & StringDB(CodigoProveedor) & ", "
  sQuery = sQuery & NumeroDB(Factura) & ", "
  sQuery = sQuery & NumeroDB(ValorMercancia) & ", "
  sQuery = sQuery & NumeroDB(Impuesto1) & ", "
  sQuery = sQuery & NumeroDB(Impuesto2) & ", "
  sQuery = sQuery & StringDB(Notas) & ", "
  sQuery = sQuery & StringDB(RefProveedor) & ", "
  sQuery = sQuery & NumeroDB(NumeroControl) & ");"
  dbHandle.Execute sQuery
  
  If Factura Then
    Set pRecibo = New clsReciboMercancia
    If pRecibo.Load(Factura) Then
      ref = pRecibo.RefProveedor
    Else
      ref = Me.Referencia
    End If
  Else
    ref = Me.Referencia
  End If
  
  Set lProveedor = New clsProveedores
  lProveedor.Load CodigoProveedor
  Set lProveedor = Nothing
  ProximoRenglon = 1
  
  StartProcess = True
  
End Function

Public Function AddDetalle(stCodigoItem As String, _
    stDescripcion As String, _
    dblCantidadDevuelta As Double, _
    stUnidad As String, _
    isDanhada As Boolean, _
    vmPrecioDevolucion As Currency, _
    stTipoImpuesto As String, _
    ByVal lRenglon As Long) As Boolean
Dim pItem As clsItemInventario, pFactura As clsReciboMercancia
Dim pDetalle As clsDetallesDevolucionCompra, sQuery As String

  Set pItem = New clsItemInventario
  If stCodigoItem <> "" Then
    If Not pItem.Load(stCodigoItem) Then
      Err.Raise 10001, "clsDevolucionCompra::AddDetalle", "Articulo " & stCodigoItem & " no localizado"
      AddDetalle = False
      Exit Function
    End If
  End If
  
  Select Case UCase(pItem.claseImpuesto1)
  Case "IV1"
    TotalIV1 = TotalIV1 + vmPrecioDevolucion * dblCantidadDevuelta
  Case "IV2"
    TotalIV2 = TotalIV2 + vmPrecioDevolucion * dblCantidadDevuelta
  Case Else
    TotalExento = TotalExento + vmPrecioDevolucion * dblCantidadDevuelta
  End Select
  
  sQuery = "INSERT INTO DetallesDevolucionCompra (NumeroDevolucion, NumeroRenglon, CodigoItem, CantidadDevuelta, Presentacion, FactorEmpaque, DescripcionItem, Costo, Danhada) VALUES ("
  sQuery = sQuery & NumeroDB(Numero) & ", "
  sQuery = sQuery & NumeroDB(ProximoRenglon) & ", "
  sQuery = sQuery & StringDB(stCodigoItem) & ", "
  sQuery = sQuery & NumeroDB(dblCantidadDevuelta) & ", "
  sQuery = sQuery & StringDB(stUnidad) & ", "
  sQuery = sQuery & NumeroDB(pItem.FactorPresentacion(stUnidad)) & ", "
  sQuery = sQuery & StringDB(stDescripcion) & ", "
  sQuery = sQuery & NumeroDB(vmPrecioDevolucion * dblCantidadDevuelta) & ", "
  sQuery = sQuery & NumeroDB(isDanhada) & ");"
  dbHandle.Execute sQuery
  
  Set pDetalle = New clsDetallesDevolucionCompra
  pDetalle.NumeroDevolucion = Numero
  pDetalle.NumeroRenglon = ProximoRenglon: ProximoRenglon = ProximoRenglon + 1
  pDetalle.CodigoItem = stCodigoItem
  pDetalle.CantidadDevuelta = dblCantidadDevuelta
  pDetalle.Presentacion = stUnidad
  pDetalle.FactorEmpaque = pItem.FactorPresentacion(stUnidad)
  pDetalle.DescripcionItem = stDescripcion
  pDetalle.Costo = vmPrecioDevolucion * dblCantidadDevuelta
  pDetalle.Danhada = isDanhada
  
  If stCodigoItem <> "" Then
    
    Me.ValorMercancia = Me.ValorMercancia + vmPrecioDevolucion * dblCantidadDevuelta
  '       Me.Impuesto1 = Me.Impuesto1 + vmPrecioDevolucion * dblCantidadDevuelta * TiposImpuesto.ValorActualImpuesto(stTipoImpuesto) / 100
  
    If Me.Factura Then
      Set pFactura = New clsReciboMercancia
      If pFactura.Load(Me.Factura) Then
        pFactura.AnotarItemDevuelto lRenglon, dblCantidadDevuelta
      End If
      Set pFactura = Nothing
    End If
  
  End If
  
  Set pDetalle = Nothing
  Set pItem = Nothing
  
  AddDetalle = True
  
End Function

Public Sub CompletarProceso(f As lfProgresoOperacion, doAutoApply As Boolean, Doc As CDocumentoFiscal)
Dim sQuery As String, isOk As Boolean
Dim pProveedor As clsProveedores
Dim NotaDebito As clsNotasDCCP
Dim pItemInv As clsItemInventario

  Set pProveedor = New clsProveedores
  If Not pProveedor.Load(Me.CodigoProveedor) Then
    Err.Raise 10001, "DevolucionesCompra.CompletarProceso", "El proveedor acaba de desaparecer"
  End If
  If Not Doc Is Nothing Then
    Doc.RifEntidad = pProveedor.RIF
    Doc.NumeroDoc = Me.Numero
  End If
  Set pProveedor = Nothing

  Set NotaDebito = New clsNotasDCCP

  ' Actualizar Valor y Costo...
  sQuery = "UPDATE DevolucionesCompra SET ValorMercancia =" & Str(ValorMercancia) & ", Impuesto1 =" & Str(Me.Impuesto1) & " WHERE Numero =" & Str(Me.Numero)
  dbHandle.Execute sQuery
  
  GenerarNota f, NotaDebito, doAutoApply, Doc
  ActualizarInventario f, NotaDebito
  If Not Doc Is Nothing Then
    Doc.NumeroDoc = Me.Numero
    Doc.Grabar New CFactoria
    Doc.FillComprobante Empresa, NotaDebito.pComprobante
  End If
  NotaDebito.EndProcess
  Set NotaDebito = Nothing
End Sub

Public Sub EndProcess()
  SubmitDoc Me
End Sub

Public Sub AbortProcess()
End Sub

' ------------------------------------------
' Proceso: Funciones privadas
' ------------------------------------------

Private Function GenerarNota(f As lfProgresoOperacion, NotaDebito As clsNotasDCCP, doAutoApply As Boolean, Doc As CDocumentoFiscal) As Boolean
Dim pRecibo As clsReciboMercancia, stDescripcion As String
Dim pDocFactura As clsDocumentosISPC, pDocNota As clsDocumentosISPC
Dim RifProveedor As String

  f.Caption = "Generando la nota de dbito"
  f.Reset

  Set pDocFactura = New clsDocumentosISPC
  stDescripcion = "Devolucion de compras No." & Str(Numero)
  If Factura Then
    Set pRecibo = New clsReciboMercancia
    If pRecibo.Load(Factura) Then
      stDescripcion = Trim(stFullLength("Factura " & pRecibo.Referencia & " Dev.Compra No." & Str(Numero), 40))
    End If
    If pDocFactura.LoadFromDocumento(pRecibo.TipoEntidad, pRecibo.Numero) Then
      If Abs(pDocFactura.Saldo) >= 1 Then
        doAutoApply = False
        ' cancela la aplicacion automatica, dado que el documento de origen esta pendiente
      End If
    End If
    Set pRecibo = Nothing
  End If

  If Not NotaDebito.StartProcess("PRV", Me.CodigoProveedor, Me.FechaTransaccion, stDescripcion, Me.ValorMercancia + Me.Impuesto1, doAutoApply) Then
    ReportarError False, 10001, "Imposible procesar nota de crdito", "DevolucionesVenta.GenerarNota"
    GenerarNota = False
    Exit Function
  End If
    
'  NotaDebito.pComprobante.AddDetalle Empresa.CuentaImpuesto1, stDescripcion, 0, Impuesto1
  Set pComprobante = NotaDebito.pComprobante
  
  If Not Doc Is Nothing Then
    If Doc.Retencion <> 0 Then
      Dim DocISPC As New clsDocumentosISPC, DetISPC As clsDetalleCuentaEntidad
      If DocISPC.LoadFromDocumento(NotaDebito.TipoEntidad, NotaDebito.Numero) Then
        Set DetISPC = New clsDetalleCuentaEntidad
        DetISPC.Add DocISPC.Numero, DocISPC.CodigoEntidad, DocISPC.TipoEntidad, DocISPC.FechaDoc, "Ajuste en retencion de IVA", Doc.CRRetencion - Doc.DBRetencion, NotaDebito.pComprobante
      End If
    End If
  End If
  
  If Not doAutoApply And Factura <> 0 And Abs(pDocFactura.Saldo) >= 1 Then
    Set pDocNota = New clsDocumentosISPC
    If pDocNota.LoadFromDocumento(NotaDebito.TipoEntidad, NotaDebito.Numero) Then
      pDocFactura.AplicarDocumento pDocNota, NotaDebito.pComprobante
    End If
    Set pDocNota = Nothing
  End If
  
  Set pDocFactura = Nothing
  
  GenerarNota = True

End Function

Private Function ActualizarInventario(f As lfProgresoOperacion, NotaDebito As clsNotasDCCP) As Boolean
Dim pAlmacen As clsAlmacen, _
    pItemInv As clsItemInventario, _
    pDetDev As clsDetallesDevolucionCompra, _
    sCuenta As String

  f.Caption = "Actualizando el inventario"
  f.Reset
  Set pAlmacen = Almacenes.Item(stAlmacen)
  pAlmacen.StartComprobante FechaTransaccion, Me.TipoEntidad, Me.Numero, 0, "Devolucion de compras No." & Str(Me.Numero)
  Set pItemInv = New clsItemInventario
  Set colDetalles = Me.Detalles
  For Each pDetDev In colDetalles
    f.NextPoint
    If pDetDev.CodigoItem <> "" Then
      If Not pItemInv.Load(pDetDev.CodigoItem) Then
        Err.Raise 10001, "clsDevolucionCompra.ActualizarInventario", "Articulo " & pDetDev.CodigoItem & " no localizado."
      End If
      If Not pDetDev.Danhada Then
        pAlmacen.RegistrarMINV pDetDev.CodigoItem, -(pDetDev.CantidadDevuelta * pDetDev.FactorEmpaque), pDetDev.CostoUnitario / pDetDev.FactorEmpaque
'        NotaDebito.pComprobante.AddDetalle pItemInv.CuentaActivo, "Devolucion de compras No." & Str(Numero), pDetDev.CantidadDevuelta * pDetDev.CostoUnitario, 0
      Else
        NotaDebito.pComprobante.AddDetalle Empresa.CuentaMercanciaDanhada, "Devolucion de compras No." & Str(Numero), 0, pDetDev.CantidadDevuelta * pDetDev.CostoUnitario
      End If
    End If
    If f.doBreak Then
      pAlmacen.AbortarComprobante
      Set pItemInv = Nothing
      Set pAlmacen = Nothing
      ActualizarInventario = False
      Exit Function
    End If
  Next
  Set colDetalles = Nothing
  pAlmacen.CerrarComprobante NotaDebito.pComprobante
  Set pItemInv = Nothing
  Set pAlmacen = Nothing
  
  ActualizarInventario = True
  
End Function

