VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetallesFactura"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public NumeroDocumento As Long
Public Renglon As Integer
Public CodigoItem As String
Public Descripcion As String
Public Presentacion As String
Public FactorEmpaque As Double
Public Cantidad As Double
Public PrecioLista As Currency
Public PrecioVenta As Currency
Public PrecioEfectivo As Currency
Public Impuesto1 As Double
Public Impuesto2 As Double
Public CostoUnitario As Double
Public Entregadas As Double
Public Asignadas As Double
Public Transito As Double
Public Devueltas As Double

' Acumuladores para los Detalles de Factura (u otros usos generales)
Public AcumPLista As Currency, _
        AcumPVenta As Currency, _
        AcumPFinal As Currency

' Estos campos solamente son accesibles cuando el registro se toma de la coleccion "Detalles"
' de una factura. Se usan para sub-totalizar a efectos de impresion

Public isSerial As Boolean
' Los seriales se muestran como lneas adicionales de descripcin.
' Los detalles generados para mostrar los seriales no deben ser tomados
' en cuenta a efectos de la carga de renglones para la modificacin de
' las facturas. La propiedad "isSerial" se agregar para permitir la
' discriminacin.

Public NumeroProducto As Long

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant

    bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleFactura.vbs", sVarId, vRetVal)
    If bRetVal Then
        vRetBuffer = vRetVal
        sRetString = vRetVal
    End If
    ExtendEval = bRetVal

End Function

Public Function EvalVar(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean
Dim pItemVenta As clsItemVenta

    bRetVal = True
    
    Select Case sVarId

    Case "SUBTOT_PLISTA"
        sRetString = FormatNumero(AcumPLista, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPLista

    Case "SUBTOT_PVENTA"
        sRetString = FormatNumero(AcumPVenta, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPVenta

    Case "SUBTOT_PFINAL"
        sRetString = FormatNumero(AcumPFinal, Empresa.MascaraMonetarios, Len(Empresa.MascaraPrecios))
        vRetBuffer = AcumPFinal

    Case "NITEM"
        sRetString = FormatNumero(NumeroProducto, "##0", 3)
        vRetBuffer = NumeroProducto

    Case "CODIGO", "CODIGO_PRODUCTO", "CODIGO_ITEM"
        sRetString = CodigoItem
        vRetBuffer = sRetString
    
    Case "DESCRIPCION"
        sRetString = Descripcion
        vRetBuffer = sRetString

    Case "PRESENTACION"
        sRetString = Presentacion
        vRetBuffer = sRetString

    Case "FACTOR_EMPAQUE"
        vRetBuffer = FactorEmpaque
        sRetString = Trim(FormatNumero(FactorEmpaque, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "CANTIDAD"
        vRetBuffer = Cantidad
        sRetString = Trim(FormatNumero(Cantidad, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades)))

    Case "PRECIO_LISTA"
        vRetBuffer = PrecioLista
        sRetString = Trim(FormatNumero(PrecioLista, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_LISTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioLista / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA"
        vRetBuffer = PrecioVenta
        sRetString = Trim(FormatNumero(PrecioVenta, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_VENTA_UNITARIO"
        If FactorEmpaque <> 0 Then
            vRetBuffer = PrecioVenta / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "PRECIO_EFECTIVO_UNITARIO"
        If Cantidad <> 0 Then
            vRetBuffer = PrecioEfectivo / Cantidad / FactorEmpaque
        Else
            vRetBuffer = 0
        End If
        sRetString = Trim(FormatNumero(vRetBuffer, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_RENGLON"
        vRetBuffer = PrecioEfectivo
        sRetString = Trim(FormatNumero(PrecioEfectivo, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))

    Case "TOTAL_PLISTA"
        vRetBuffer = PrecioLista * Cantidad
        sRetString = Trim(FormatNumero(PrecioLista * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case "TOTAL_PVENTA"
        vRetBuffer = PrecioVenta * Cantidad
        sRetString = Trim(FormatNumero(PrecioVenta * Cantidad, Empresa.MascaraPrecios, Len(Empresa.MascaraPrecios)))
    
    Case Else
        
        bRetVal = False
        Set pItemVenta = New clsItemVenta
        If pItemVenta.Load(Me.CodigoItem) Then
            bRetVal = pItemVenta.EvalVar(sVarId, vRetBuffer, sRetString)
        End If
        
        If bRetVal = False Then
            bRetVal = ExtendEval(sVarId, vRetBuffer, sRetString)
        End If
        Set pItemVenta = Nothing
    
    End Select
    
    EvalVar = bRetVal

End Function

Public Function Descuento() As Double
Dim dblTemp As Double
    If PrecioLista = 0 Then
        Descuento = 0
        Exit Function
    End If
    dblTemp = PrecioLista - PrecioVenta
    dblTemp = dblTemp / PrecioLista
    dblTemp = dblTemp * 100
    Descuento = dblTemp
End Function

Public Property Get PrecioTotal() As Double
    
    PrecioTotal = PrecioVenta * Cantidad

End Property

Public Function PrecioEfectivoUnitario() As Double
    
    If FactorEmpaque = 0 Then
        PrecioEfectivoUnitario = 0
    Else
        PrecioEfectivoUnitario = PrecioEfectivo / FactorEmpaque / Cantidad
    End If

End Function

Public Function CantidadEfectiva() As Double
    
    CantidadEfectiva = Cantidad * FactorEmpaque

End Function

Public Function Neto() As Double

    Neto = PrecioEfectivo / Cantidad

End Function

Public Function NetoUnitario() As Double

    NetoUnitario = PrecioEfectivo / Cantidad / FactorEmpaque

End Function
