VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDetallesDevolucionVenta"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Public NumeroDevolucion As Long
Public NumeroRenglon As Integer
Public CodigoItemVenta As String
Public CantidadDevuelta As Double
Public Presentacion As String
Public FactorEmpaque As Double
Public DescripcionItem As String
Public Valor As Currency            ' Valor TOTAL... el unitario se accede a travs de una propiedad
Public Costo As Currency            ' Costo TOTAL... idem
Public Danhada As Boolean           ' Si Danhada -> no se reintegra al inventario...

Public Property Get ValorUnitario() As Currency
  On Error GoTo ErrHandler
  ValorUnitario = Valor / CantidadDevuelta
  Exit Property

ErrHandler:
  Err.Clear
  ValorUnitario = 0
End Property

Public Property Get CostoUnitario() As Currency
  On Error GoTo ErrHandler
  CostoUnitario = Costo / CantidadDevuelta
  Exit Property
ErrHandler:
  Err.Clear
  CostoUnitario = 0
End Property

Public Function ExtendEval(sVarId, vRetBuffer, sRetString) As Boolean
Dim bRetVal As Boolean, vRetVal As Variant
  bRetVal = mScriptExecute.ExtendEval(Me, "evDetalleDVV.vbs", sVarId, vRetVal)
  If bRetVal Then
    vRetBuffer = vRetVal
    sRetString = vRetVal
  End If
  ExtendEval = bRetVal
End Function

Public Function EvalVar(sVarId, vRetBuf, sRetBuf) As Boolean
Dim bRetVal As Boolean

    bRetVal = True

    Select Case sVarId
    
    Case "CODIGO", "PRODUCTO"
        vRetBuf = CodigoItemVenta
        sRetBuf = CodigoItemVenta
    
    Case "CANTIDAD"
        vRetBuf = CantidadDevuelta
        sRetBuf = FormatNumero(CantidadDevuelta, Empresa.MascaraCantidades, Len(Empresa.MascaraCantidades))

    Case "PRESENTACION", "UNIDAD"
        vRetBuf = Presentacion
        sRetBuf = Presentacion

    Case "FACTOREMPAQUE"
        vRetBuf = FactorEmpaque
        sRetBuf = Format(FactorEmpaque, Empresa.MascaraCantidades)

    Case "DESCRIPCION"
        vRetBuf = DescripcionItem
        sRetBuf = DescripcionItem

    Case "VALORDEVUELTO"
        vRetBuf = Valor
        sRetBuf = FormatNumero(Valor, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "COSTODEVUELTO"
        vRetBuf = Costo
        sRetBuf = FormatNumero(Costo, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "DANHADO", "DANHADAS"
        sRetBuf = IIf(Danhada, "S", "No")
        vRetBuf = sRetBuf

    Case "ESTADO"
        sRetBuf = IIf(Danhada, "Daada", "Ok.")
        vRetBuf = sRetBuf

    Case "VALORUNITARIO"
        vRetBuf = ValorUnitario
        sRetBuf = FormatNumero(vRetBuf, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case "COSTOUNITARIO"
        vRetBuf = CostoUnitario
        sRetBuf = FormatNumero(vRetBuf, Empresa.MascaraMonetarios, Len(Empresa.MascaraMonetarios))

    Case Else
    
        bRetVal = ExtendEval(sVarId, vRetBuf, sRetBuf)

    End Select
    
    EvalVar = bRetVal

End Function
